window.onload = () => {
    document.getElementById('gostr').onclick = () => {
        init();
    }
}
var peer ;
var bytesRec = 0
    
async function init() {
     peer = createPeer();
    peer.addTransceiver("video", { direction: "recvonly" })
    peer.addTransceiver("audio", { direction: "recvonly" }) 
} 
function createPeer() { 
    document.getElementById('gostr').innerText= "connecting..."
     peer = new RTCPeerConnection({
        iceServers: [
            {
                urls: "stun:stun.stunprotocol.org"
            }
        ]
    });
    peer.ontrack = handleTrackEvent;
    peer.onnegotiationneeded = () => handleNegotiationNeededEvent(peer);

    try { 
   statsInterval = window.setInterval(getConnectionStats, 1000);
        /* add event handlers, etc */
      } catch(err) {
        console.error("getConnectionStats: " + err);
      }


    return peer;
} 
async function handleNegotiationNeededEvent(peer) {
    const offer = await peer.createOffer();
    await peer.setLocalDescription(offer);
    const payload = {
        sdp: peer.localDescription
    }; 
    const { data } = await axios.post('/consumer', payload);
    const desc = new RTCSessionDescription(data.sdp);
    peer.setRemoteDescription(desc).catch(e => console.log(e));
}
function stop_s(){
  bytesRec = 0
 peer.close();
 document.getElementById('gostr').innerText= "Watch"
}
function handleTrackEvent(e) {
    if (e.streams[0].active == true ) {
       document.getElementById('gostr').innerText= "Watching"
    } else {
        document.getElementById('gostr').innerText= "Failed!"
    } 
    document.getElementById("video").srcObject = e.streams[0];
};
 
function getConnectionStats() { 
    peer.getStats(null).then(stats => {
      let statsOutput = ""; 
      stats.forEach(report => {
        if (report.type === "inbound-rtp" && report.kind === "video") {
          Object.keys(report).forEach(statName => {
            statsOutput += `<strong>${statName}:</strong> ${report[statName]}<br>\n`; 
            if (statName == "bytesReceived") {
                //console.log(report[statName] , bytesRec , typeof(report[statName])   , typeof(bytesRec)) 
                if( parseFloat( bytesRec )== parseFloat(report[statName] ) ) { 
                    document.querySelector(".stats-of").innerHTML = "offline"}
                     else if ( parseFloat( report[statName])  > parseFloat(bytesRec) ) {
                    document.querySelector(".stats-of").innerHTML = "online"
                }
                bytesRec = parseFloat(report[statName] )
            }
            
          });
        }
      });
      
      //document.querySelector(".stats-b").innerHTML = statsOutput;
     
    });
  }