/*! twilio-video.js 1.20.1

The following license applies to all parts of this software except as
documented below.

    Copyright (c) 2015, Twilio, inc.
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are
    met:

      1. Redistributions of source code must retain the above copyright
         notice, this list of conditions and the following disclaimer.

      2. Redistributions in binary form must reproduce the above copyright
         notice, this list of conditions and the following disclaimer in
         the documentation and/or other materials provided with the
         distribution.

      3. Neither the name of Twilio nor the names of its contributors may
         be used to endorse or promote products derived from this software
         without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
    HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software includes SIP.js under the following license.

    Copyright (c) 2014 Junction Networks, Inc. <http://www.onsip.com>

    License: The MIT License

    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
    OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

SIP.js contains substantial portions of the JsSIP software under the following
license.

    Copyright (c) 2012-2013 JosÃ© Luis MillÃ¡n - Versatica <http://www.versatica.com>

    License: The MIT License

    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
    OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 */
(function(root){var bundle=function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r}()({1:[function(require,module,exports){"use strict";var CancelablePromise=require("./util/cancelablepromise");function createCancelableRoomPromise(getLocalTracks,createLocalParticipant,createRoomSignaling,createRoom){var cancelableRoomSignalingPromise=void 0;var cancelationError=new Error("Canceled");return new CancelablePromise(function onCreate(resolve,reject,isCanceled){var localParticipant=void 0;getLocalTracks(function getLocalTracksSucceeded(localTracks){if(isCanceled()){return CancelablePromise.reject(cancelationError)}localParticipant=createLocalParticipant(localTracks);return createRoomSignaling(localParticipant).then(function createRoomSignalingSucceeded(getCancelableRoomSignalingPromise){if(isCanceled()){throw cancelationError}cancelableRoomSignalingPromise=getCancelableRoomSignalingPromise();return cancelableRoomSignalingPromise})}).then(function roomSignalingConnected(roomSignaling){if(isCanceled()){roomSignaling.disconnect();throw cancelationError}resolve(createRoom(localParticipant,roomSignaling))}).catch(function onError(error){reject(error)})},function onCancel(){if(cancelableRoomSignalingPromise){cancelableRoomSignalingPromise.cancel()}})}module.exports=createCancelableRoomPromise},{"./util/cancelablepromise":106}],2:[function(require,module,exports){"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _require=require("@twilio/webrtc/lib/util"),guessBrowser=_require.guessBrowser;var CancelablePromise=require("./util/cancelablepromise");var createCancelableRoomPromise=require("./cancelableroompromise");var createLocalTracks=require("./createlocaltracks");var ConstantIceServerSource=require("./iceserversource/constant");var constants=require("./util/constants");var Room=require("./room");var E=require("./util/constants").typeErrors;var EncodingParametersImpl=require("./encodingparameters");var LocalAudioTrack=require("./media/track/es5/localaudiotrack");var LocalDataTrack=require("./media/track/es5/localdatatrack");var LocalParticipant=require("./localparticipant");var LocalVideoTrack=require("./media/track/es5/localvideotrack");var Log=require("./util/log");var MediaStreamTrack=require("@twilio/webrtc").MediaStreamTrack;var NTSIceServerSource=require("./iceserversource/nts");var SignalingV2=require("./signaling/v2");var util=require("./util");var NetworkQualityConfigurationImpl=require("./networkqualityconfiguration");var connectCalls=0;var didPrintSafariWarning=false;function connect(token,options){if(typeof options==="undefined"){options={}}if((typeof options==="undefined"?"undefined":_typeof(options))!=="object"||Array.isArray(options)){return CancelablePromise.reject(E.INVALID_TYPE("options","object"))}options=Object.assign({abortOnIceServersTimeout:false,createLocalTracks:createLocalTracks,dominantSpeaker:false,dscpTagging:false,environment:constants.DEFAULT_ENVIRONMENT,iceServersTimeout:constants.ICE_SERVERS_TIMEOUT_MS,insights:true,LocalAudioTrack:LocalAudioTrack,LocalDataTrack:LocalDataTrack,LocalParticipant:LocalParticipant,LocalVideoTrack:LocalVideoTrack,MediaStreamTrack:MediaStreamTrack,logLevel:constants.DEFAULT_LOG_LEVEL,maxAudioBitrate:null,maxVideoBitrate:null,name:null,networkQuality:false,preferredAudioCodecs:[],preferredVideoCodecs:[],realm:constants.DEFAULT_REALM,signaling:SignalingV2},util.filterObject(options));options=Object.assign({wsServer:constants.WS_SERVER(options.environment,options.realm)},options);var logLevels=util.buildLogLevels(options.logLevel);var logComponentName="[connect #"+ ++connectCalls+"]";var log=void 0;try{log=new Log("default",logComponentName,logLevels)}catch(error){return CancelablePromise.reject(error)}options.log=log;if(guessBrowser()==="safari"&&!didPrintSafariWarning&&log.logLevel!=="error"&&log.logLevel!=="off"){didPrintSafariWarning=true;log.warn(["This release of twilio-video.js includes experimental support for",'Safari 11 and newer. Support for Safari is "experimental" because,',"at the time of writing, Safari does not support VP8. This means you","may experience codec issues in Group Rooms. You may also experience","codec issues in Peer-to-Peer (P2P) Rooms containing Android- or","iOS-based Participants who do not support H.264. However, P2P Rooms","with browser-based Participants should work. Please test this release","and report any issues to https://github.com/twilio/twilio-video.js"].join(" "))}if(typeof token!=="string"){return CancelablePromise.reject(E.INVALID_TYPE("token","string"))}var localTrackOptions=Object.assign({},options);delete localTrackOptions.name;if("tracks"in options){if(!Array.isArray(options.tracks)){return CancelablePromise.reject(E.INVALID_TYPE("options.tracks","Array of LocalAudioTrack, LocalVideoTrack or MediaStreamTrack"))}try{options.tracks=options.tracks.map(function(track){return util.asLocalTrack(track,localTrackOptions)})}catch(error){return CancelablePromise.reject(error)}}var Signaling=options.signaling;var signaling=new Signaling(options.wsServer,options);log.info("Connecting to a Room");log.debug("Options:",options);var encodingParameters=new EncodingParametersImpl({maxAudioBitrate:options.maxAudioBitrate,maxVideoBitrate:options.maxVideoBitrate});var ntsIceServerSourceOptions=Object.assign({},options,{abortOnTimeout:options.abortOnIceServersTimeout,timeout:options.iceServersTimeout});var iceServerSource=Array.isArray(options.iceServers)?new ConstantIceServerSource(options.iceServers):_typeof(options.iceServers)==="object"?options.iceServers:new NTSIceServerSource(token,ntsIceServerSourceOptions);var preferredCodecs={audio:options.preferredAudioCodecs,video:options.preferredVideoCodecs.map(normalizeVideoCodecSettings)};var networkQualityConfiguration=new NetworkQualityConfigurationImpl(_typeof(options.networkQuality)==="object"?options.networkQuality:{});options.networkQuality=_typeof(options.networkQuality)==="object"||options.networkQuality;var cancelableRoomPromise=createCancelableRoomPromise(getLocalTracks.bind(null,options),createLocalParticipant.bind(null,signaling,log,encodingParameters,networkQualityConfiguration,options),createRoomSignaling.bind(null,token,options,signaling,iceServerSource,encodingParameters,preferredCodecs),createRoom.bind(null,options));cancelableRoomPromise.then(function(room){log.info("Connected to Room:",room.toString());log.info("Room name:",room.name);log.debug("Room:",room);return room},function(error){if(iceServerSource.isStarted){iceServerSource.stop()}if(cancelableRoomPromise._isCanceled){log.info("Attempt to connect to a Room was canceled")}else{log.info("Error while connecting to a Room:",error)}});return cancelableRoomPromise}var AudioCodec={isac:"isac",opus:"opus",PCMA:"PCMA",PCMU:"PCMU"};var VideoCodec={H264:"H264",VP8:"VP8",VP9:"VP9"};var LogLevel={debug:"debug",info:"info",warn:"warn",error:"error",off:"off"};var NetworkQualityVerbosity={none:0,minimal:1,moderate:2,detailed:3};function createLocalParticipant(signaling,log,encodingParameters,networkQualityConfiguration,options,localTracks){var localParticipantSignaling=signaling.createLocalParticipantSignaling(encodingParameters,networkQualityConfiguration);log.debug("Creating a new LocalParticipant:",localParticipantSignaling);return new options.LocalParticipant(localParticipantSignaling,localTracks,options)}function createRoom(options,localParticipant,roomSignaling){var room=new Room(localParticipant,roomSignaling,options);var log=options.log;log.debug("Creating a new Room:",room);roomSignaling.on("stateChanged",function stateChanged(){log.info("Disconnected from Room:",room.toString());roomSignaling.removeListener("stateChanged",stateChanged)});return room}function createRoomSignaling(token,options,signaling,iceServerSource,encodingParameters,preferredCodecs,localParticipant){var log=options.log;log.info("Getting ICE servers");log.debug("Options:",options);return iceServerSource.start().then(function(iceServers){var roomSignalingParams={token:token};log.info("Got ICE servers");log.debug("ICE servers:",iceServers);options.iceServers=iceServers;log.debug("Creating a new RoomSignaling");log.debug("RoomSignaling params:",roomSignalingParams);return signaling.connect(localParticipant._signaling,token,iceServerSource,encodingParameters,preferredCodecs,options)})}function getLocalTracks(options,handleLocalTracks){var log=options.log;options.shouldStopLocalTracks=!options.tracks;if(options.shouldStopLocalTracks){log.info("LocalTracks were not provided, so they will be acquired "+"automatically before connecting to the Room. LocalTracks will "+"be released if connecting to the Room fails or if the Room "+"is disconnected")}else{log.info("Getting LocalTracks");log.debug("Options:",options)}return options.createLocalTracks(options).then(function getLocalTracksSucceeded(localTracks){var promise=handleLocalTracks(localTracks);promise.catch(function handleLocalTracksFailed(){if(options.shouldStopLocalTracks){log.info("The automatically acquired LocalTracks will now be stopped");localTracks.forEach(function(track){track.stop()})}});return promise})}function normalizeVideoCodecSettings(nameOrSettings){var settings=typeof nameOrSettings==="string"?{codec:nameOrSettings}:nameOrSettings;switch(settings.codec.toLowerCase()){case"vp8":{return Object.assign({simulcast:false},settings)}default:{return settings}}}module.exports=connect},{"./cancelableroompromise":1,"./createlocaltracks":4,"./encodingparameters":10,"./iceserversource/constant":11,"./iceserversource/nts":12,"./localparticipant":14,"./media/track/es5/localaudiotrack":16,"./media/track/es5/localdatatrack":17,"./media/track/es5/localvideotrack":18,"./networkqualityconfiguration":42,"./room":47,"./signaling/v2":59,"./util":109,"./util/cancelablepromise":106,"./util/constants":107,"./util/log":112,"@twilio/webrtc":162,"@twilio/webrtc/lib/util":175}],3:[function(require,module,exports){"use strict";var defaultCreateLocalTracks=require("./createlocaltracks");var DEFAULT_LOG_LEVEL=require("./util/constants").DEFAULT_LOG_LEVEL;function createLocalTrack(kind,options){options=Object.assign({createLocalTracks:defaultCreateLocalTracks,logLevel:DEFAULT_LOG_LEVEL},options);var createOptions={};createOptions.logLevel=options.logLevel;delete options.logLevel;var createLocalTracks=options.createLocalTracks;delete options.createLocalTracks;createOptions[kind]=Object.keys(options).length>0?options:true;return createLocalTracks(createOptions).then(function(localTracks){return localTracks[0]})}function createLocalAudioTrack(options){return createLocalTrack("audio",options)}function createLocalVideoTrack(options){return createLocalTrack("video",options)}module.exports={audio:createLocalAudioTrack,video:createLocalVideoTrack}},{"./createlocaltracks":4,"./util/constants":107}],4:[function(require,module,exports){"use strict";var asLocalTrack=require("./util").asLocalTrack;var buildLogLevels=require("./util").buildLogLevels;var getUserMedia=require("@twilio/webrtc").getUserMedia;var LocalAudioTrack=require("./media/track/es5/localaudiotrack");var LocalDataTrack=require("./media/track/es5/localdatatrack");var LocalVideoTrack=require("./media/track/es5/localvideotrack");var MediaStreamTrack=require("@twilio/webrtc").MediaStreamTrack;var Log=require("./util/log");var DEFAULT_LOG_LEVEL=require("./util/constants").DEFAULT_LOG_LEVEL;var workaround180748=require("./webaudio/workaround180748");var createLocalTrackCalls=0;function createLocalTracks(options){var isAudioVideoAbsent=!(options&&("audio"in options||"video"in options));options=Object.assign({audio:isAudioVideoAbsent,getUserMedia:getUserMedia,logLevel:DEFAULT_LOG_LEVEL,LocalAudioTrack:LocalAudioTrack,LocalDataTrack:LocalDataTrack,LocalVideoTrack:LocalVideoTrack,MediaStreamTrack:MediaStreamTrack,Log:Log,video:isAudioVideoAbsent},options);var logComponentName="[createLocalTracks #"+ ++createLocalTrackCalls+"]";var logLevels=buildLogLevels(options.logLevel);var log=new options.Log("default",logComponentName,logLevels);var localTrackOptions=Object.assign({log:log},options);delete localTrackOptions.name;if(options.audio===false&&options.video===false){log.info("Neither audio nor video requested, so returning empty LocalTracks");return Promise.resolve([])}if(options.tracks){log.info("Adding user-provided LocalTracks");log.debug("LocalTracks:",options.tracks);return Promise.resolve(options.tracks)}var localTrackNameOptions={audio:options.audio&&options.audio.name?{name:options.audio.name}:{},video:options.video&&options.video.name?{name:options.video.name}:{}};if(options.audio){delete options.audio.name}if(options.video){delete options.video.name}var mediaStreamConstraints={audio:options.audio,video:options.video};var workaroundWebKitBug180748=options.audio&&options.audio.workaroundWebKitBug180748;var mediaStreamPromise=workaroundWebKitBug180748?workaround180748(log,options.getUserMedia,mediaStreamConstraints):options.getUserMedia(mediaStreamConstraints);return mediaStreamPromise.then(function(mediaStream){var mediaStreamTracks=mediaStream.getAudioTracks().concat(mediaStream.getVideoTracks());log.info("Call to getUserMedia successful; got MediaStreamTracks:",mediaStreamTracks);return mediaStreamTracks.map(function(mediaStreamTrack){return asLocalTrack(mediaStreamTrack,Object.assign(localTrackNameOptions[mediaStreamTrack.kind],localTrackOptions))})},function(error){log.warn("Call to getUserMedia failed:",error);throw error})}module.exports=createLocalTracks},{"./media/track/es5/localaudiotrack":16,"./media/track/es5/localdatatrack":17,"./media/track/es5/localvideotrack":18,"./util":109,"./util/constants":107,"./util/log":112,"./webaudio/workaround180748":125,"@twilio/webrtc":162}],5:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var DataTrackTransceiver=require("./transceiver");var DataTransport=require("./transport");var DataTrackReceiver=function(_DataTrackTransceiver){_inherits(DataTrackReceiver,_DataTrackTransceiver);function DataTrackReceiver(dataChannel){_classCallCheck(this,DataTrackReceiver);var _this=_possibleConstructorReturn(this,(DataTrackReceiver.__proto__||Object.getPrototypeOf(DataTrackReceiver)).call(this,dataChannel.label,dataChannel.maxPacketLifeTime,dataChannel.maxRetransmits,dataChannel.ordered));Object.defineProperties(_this,{_dataChannel:{value:dataChannel}});dataChannel.binaryType="arraybuffer";dataChannel.addEventListener("message",function(event){_this.emit("message",event.data)});dataChannel.addEventListener("close",function(){_this.emit("close")});return _this}_createClass(DataTrackReceiver,[{key:"toDataTransport",value:function toDataTransport(){return new DataTransport(this._dataChannel)}}]);return DataTrackReceiver}(DataTrackTransceiver);module.exports=DataTrackReceiver},{"./transceiver":7,"./transport":8}],6:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var DataTrackTransceiver=require("./transceiver");var makeUUID=require("../util").makeUUID;var DataTrackSender=function(_DataTrackTransceiver){_inherits(DataTrackSender,_DataTrackTransceiver);function DataTrackSender(maxPacketLifeTime,maxRetransmtis,ordered){_classCallCheck(this,DataTrackSender);var _this=_possibleConstructorReturn(this,(DataTrackSender.__proto__||Object.getPrototypeOf(DataTrackSender)).call(this,makeUUID(),maxPacketLifeTime,maxRetransmtis,ordered));Object.defineProperties(_this,{_dataChannels:{value:new Set}});return _this}_createClass(DataTrackSender,[{key:"addDataChannel",value:function addDataChannel(dataChannel){this._dataChannels.add(dataChannel);return this}},{key:"removeDataChannel",value:function removeDataChannel(dataChannel){this._dataChannels.delete(dataChannel);return this}},{key:"send",value:function send(data){this._dataChannels.forEach(function(dataChannel){try{dataChannel.send(data)}catch(error){}});return this}}]);return DataTrackSender}(DataTrackTransceiver);module.exports=DataTrackSender},{"../util":109,"./transceiver":7}],7:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TrackTransceiver=require("../transceiver");var DataTrackTransceiver=function(_TrackTransceiver){_inherits(DataTrackTransceiver,_TrackTransceiver);function DataTrackTransceiver(id,maxPacketLifeTime,maxRetransmits,ordered){_classCallCheck(this,DataTrackTransceiver);var _this=_possibleConstructorReturn(this,(DataTrackTransceiver.__proto__||Object.getPrototypeOf(DataTrackTransceiver)).call(this,id,"data"));Object.defineProperties(_this,{maxPacketLifeTime:{enumerable:true,value:maxPacketLifeTime},maxRetransmits:{enumerable:true,value:maxRetransmits},ordered:{enumerable:true,value:ordered}});return _this}return DataTrackTransceiver}(TrackTransceiver);module.exports=DataTrackTransceiver},{"../transceiver":104}],8:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("events"),EventEmitter=_require.EventEmitter;var DataTransport=function(_EventEmitter){_inherits(DataTransport,_EventEmitter);function DataTransport(dataChannel){_classCallCheck(this,DataTransport);var _this=_possibleConstructorReturn(this,(DataTransport.__proto__||Object.getPrototypeOf(DataTransport)).call(this));Object.defineProperties(_this,{_dataChannel:{value:dataChannel},_messageQueue:{value:[]}});dataChannel.addEventListener("open",function(){_this._messageQueue.splice(0).forEach(function(message){return _this._publish(message)})});dataChannel.addEventListener("message",function(_ref){var data=_ref.data;try{var message=JSON.parse(data);_this.emit("message",message)}catch(error){}});_this.publish({type:"ready"});return _this}_createClass(DataTransport,[{key:"_publish",value:function _publish(message){var data=JSON.stringify(message);try{this._dataChannel.send(data)}catch(error){}}},{key:"publish",value:function publish(message){var dataChannel=this._dataChannel;if(dataChannel.readyState==="closing"||dataChannel.readyState==="closed"){return false}if(dataChannel.readyState==="connecting"){this._messageQueue.push(message);return true}this._publish(message);return true}}]);return DataTransport}(EventEmitter);module.exports=DataTransport},{events:179}],9:[function(require,module,exports){"use strict";var request=require("./request");var createTwilioError=require("./util/twilio-video-errors").createTwilioError;var ConfigurationAcquireFailedError=require("./util/twilio-video-errors").ConfigurationAcquireFailedError;var CONFIG_URL="https://ecs.us1.twilio.com/v1/Configuration";function getConfiguration(token,options){if(!token){throw new Error("<String>token is a required argument.")}options=Object.assign({configUrl:CONFIG_URL},options);var postData={url:options.configUrl,headers:{"X-Twilio-Token":token,"Content-Type":"application/x-www-form-urlencoded"}};if(options.body){postData.body=toQueryString(options.body)}return request.post(postData).then(function(responseText){return parseJsonTextFromECS(responseText)},function(errorText){var error=parseJsonTextFromECS(errorText);throw createTwilioError(error.code,error.message)})}function parseJsonTextFromECS(jsonText){var json=null;try{json=JSON.parse(jsonText)}catch(error){throw new ConfigurationAcquireFailedError}return json}function toQueryString(params){return Object.keys(params||{}).map(function(key){return encodeURIComponent(key)+"="+encodeURIComponent(params[key])}).join("&")}module.exports.getConfiguration=getConfiguration},{"./request":46,"./util/twilio-video-errors":121}],10:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var EncodingParametersImpl=function(_EventEmitter){_inherits(EncodingParametersImpl,_EventEmitter);function EncodingParametersImpl(encodingParameters){_classCallCheck(this,EncodingParametersImpl);var _this=_possibleConstructorReturn(this,(EncodingParametersImpl.__proto__||Object.getPrototypeOf(EncodingParametersImpl)).call(this));encodingParameters=Object.assign({maxAudioBitrate:null,maxVideoBitrate:null},encodingParameters);Object.defineProperties(_this,{maxAudioBitrate:{value:encodingParameters.maxAudioBitrate,writable:true},maxVideoBitrate:{value:encodingParameters.maxVideoBitrate,writable:true}});return _this}_createClass(EncodingParametersImpl,[{key:"toJSON",value:function toJSON(){return{maxAudioBitrate:this.maxAudioBitrate,maxVideoBitrate:this.maxVideoBitrate}}},{key:"update",value:function update(encodingParameters){var _this2=this;encodingParameters=Object.assign({maxAudioBitrate:this.maxAudioBitrate,maxVideoBitrate:this.maxVideoBitrate},encodingParameters);var shouldEmitChanged=["maxAudioBitrate","maxVideoBitrate"].reduce(function(shouldEmitChanged,maxKindBitrate){if(_this2[maxKindBitrate]!==encodingParameters[maxKindBitrate]){_this2[maxKindBitrate]=encodingParameters[maxKindBitrate];shouldEmitChanged=true}return shouldEmitChanged},false);if(shouldEmitChanged){this.emit("changed")}}}]);return EncodingParametersImpl}(EventEmitter);module.exports=EncodingParametersImpl},{events:179}],11:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var instances=0;var ConstantIceServerSource=function(_EventEmitter){_inherits(ConstantIceServerSource,_EventEmitter);function ConstantIceServerSource(iceServers){_classCallCheck(this,ConstantIceServerSource);var _this=_possibleConstructorReturn(this,(ConstantIceServerSource.__proto__||Object.getPrototypeOf(ConstantIceServerSource)).call(this));Object.defineProperties(_this,{_instance:{value:++instances},_iceServers:{enumerable:true,value:iceServers,writable:true},_isStarted:{value:false,writable:true},isStarted:{enumerable:true,get:function get(){return this._isStarted}},status:{enumerable:true,value:"overrode"}});return _this}_createClass(ConstantIceServerSource,[{key:"start",value:function start(){this._isStarted=true;return Promise.resolve(this._iceServers)}},{key:"stop",value:function stop(){this._isStarted=false}},{key:"toString",value:function toString(){return"[ConstantIceServerSource #"+this._instance+"]"}}]);return ConstantIceServerSource}(EventEmitter);module.exports=ConstantIceServerSource},{events:179}],12:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var constants=require("../util/constants");var ECS=require("../ecs");var EventEmitter=require("events").EventEmitter;var Log=require("../util/log");var TimeoutPromise=require("../util/timeoutpromise");var util=require("../util");var _require=require("../util/twilio-video-errors"),ConfigurationAcquireFailedError=_require.ConfigurationAcquireFailedError;var version=require("../../package.json").version;var instances=0;var NTSIceServerSource=function(_EventEmitter){_inherits(NTSIceServerSource,_EventEmitter);function NTSIceServerSource(token,options){_classCallCheck(this,NTSIceServerSource)
    ;var _this=_possibleConstructorReturn(this,(NTSIceServerSource.__proto__||Object.getPrototypeOf(NTSIceServerSource)).call(this));options=Object.assign({abortOnTimeout:false,defaultTTL:constants.ICE_SERVERS_DEFAULT_TTL,environment:constants.DEFAULT_ENVIRONMENT,getConfiguration:ECS.getConfiguration,realm:constants.DEFAULT_REALM,timeout:constants.ICE_SERVERS_TIMEOUT_MS},options);var defaultIceServers=constants.DEFAULT_ICE_SERVERS(options.environment);var ecsServer=options.ecsServer||constants.ECS_SERVER(options.environment,options.realm);var log=options.log?options.log.createLog("default",_this):new Log("default",_this,util.buildLogLevels("off"));Object.defineProperties(_this,{_abortOnTimeout:{value:options.abortOnTimeout},_currentPoll:{value:null,writable:true},_defaultIceServers:{value:defaultIceServers},_defaultTTL:{value:options.defaultTTL},_ecsServer:{value:ecsServer},_getConfiguration:{value:options.getConfiguration},_instance:{value:++instances},_nextPoll:{value:null,writable:true},_log:{value:log},_status:{value:null,writable:true},_stopped:{value:util.defer(),writable:true},_timeout:{value:options.timeout},_token:{value:token}});_this._log.info("Created a new NTSIceServerSource");_this._log.debug("ECS server:",_this._ecsServer);return _this}_createClass(NTSIceServerSource,[{key:"start",value:function start(){if(!this.isStarted){this._log.info("Starting");this._currentPoll=poll(this)}else{this._log.warn("Already started")}return this._currentPoll}},{key:"stop",value:function stop(){if(!this.isStarted){this._log.warn("Already stopped");return}this._log.info("Stopping");this._currentPoll=null;clearTimeout(this._nextPoll);this._stopped.resolve();this._stopped=util.defer();this._log.debug("Stopped")}},{key:"toString",value:function toString(){return"[NTSIceServerSource #"+this._instance+"]"}},{key:"isStarted",get:function get(){return!!this._currentPoll}},{key:"status",get:function get(){return this._status}}]);return NTSIceServerSource}(EventEmitter);function parseECSConfig(client,config){var nts=util.getOrNull(config,"video.network_traversal_service");if(!nts){throw new Error("network_traversal_service not available")}else if(nts.warning){client._log.warn(nts.warning)}var iceServers=nts.ice_servers;if(!iceServers){throw new Error("ice_servers not available")}client._log.info("Got ICE servers: "+JSON.stringify(iceServers));var ttl=nts.ttl||client._defaultTTL;return[iceServers,ttl]}function poll(client){client._log.debug("Getting ECS configuration");var options={configUrl:client._ecsServer+"/v2/Configuration",body:{service:"video",sdk_version:version}};var alreadyStopped=new Error("Already stopped");var config=client._getConfiguration(client._token,options);var configWithTimeout=new TimeoutPromise(config,client._timeout);return Promise.race([configWithTimeout,client._stopped.promise]).then(function(config){if(!config){throw alreadyStopped}var iceServersAndTTL=parseECSConfig(client,config);client._status="success";return iceServersAndTTL}).catch(function(error){client._status="failure";if(!client.isStarted){throw alreadyStopped}else if(configWithTimeout.isTimedOut){if(client._abortOnTimeout){client._log.warn("Getting ICE servers took too long");throw new ConfigurationAcquireFailedError}client._log.warn("Getting ICE servers took too long (using defaults)")}else{if(error.code&&Math.floor(error.code/1e4)===2){client.stop()}client._log.warn("Failed to get ICE servers (using defaults):",error)}return[client._defaultIceServers,client._defaultTTL]}).then(function(iceServersAndTTL){var iceServers=iceServersAndTTL[0];var ttl=iceServersAndTTL[1];if(client.isStarted){client._log.info("Getting ICE servers again in "+ttl+" seconds");client._nextPoll=setTimeout(function nextPoll(){if(client.isStarted){client._currentPoll=poll(client)}},(ttl-constants.ECS_TIMEOUT)*1e3)}client._iceServers=iceServers;try{client.emit("iceServers",iceServers)}catch(error){}return iceServers})}module.exports=NTSIceServerSource},{"../../package.json":184,"../ecs":9,"../util":109,"../util/constants":107,"../util/log":112,"../util/timeoutpromise":120,"../util/twilio-video-errors":121,events:179}],13:[function(require,module,exports){"use strict";var version=require("../package.json").version;var Video={};Object.defineProperties(Video,{connect:{enumerable:true,value:require("./connect")},createLocalAudioTrack:{enumerable:true,value:require("./createlocaltrack").audio},createLocalTracks:{enumerable:true,value:require("./createlocaltracks")},createLocalVideoTrack:{enumerable:true,value:require("./createlocaltrack").video},isSupported:{enumerable:true,value:require("./util/support")()},LocalAudioTrack:{enumerable:true,value:require("./media/track/es5/localaudiotrack")},LocalDataTrack:{enumerable:true,value:require("./media/track/es5/localdatatrack")},LocalVideoTrack:{enumerable:true,value:require("./media/track/es5/localvideotrack")},version:{enumerable:true,value:version}});module.exports=Video},{"../package.json":184,"./connect":2,"./createlocaltrack":3,"./createlocaltracks":4,"./media/track/es5/localaudiotrack":16,"./media/track/es5/localdatatrack":17,"./media/track/es5/localvideotrack":18,"./util/support":119}],14:[function(require,module,exports){"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var util=require("./util");var E=require("./util/constants").typeErrors;var LocalAudioTrack=require("./media/track/es5/localaudiotrack");var LocalDataTrack=require("./media/track/es5/localdatatrack");var LocalVideoTrack=require("./media/track/es5/localvideotrack");var MediaStreamTrack=require("@twilio/webrtc").MediaStreamTrack;var Participant=require("./participant");var LocalAudioTrackPublication=require("./media/track/localaudiotrackpublication");var LocalDataTrackPublication=require("./media/track/localdatatrackpublication");var LocalVideoTrackPublication=require("./media/track/localvideotrackpublication");var LocalParticipant=function(_Participant){_inherits(LocalParticipant,_Participant);function LocalParticipant(signaling,localTracks,options){_classCallCheck(this,LocalParticipant);options=Object.assign({LocalAudioTrack:LocalAudioTrack,LocalVideoTrack:LocalVideoTrack,LocalDataTrack:LocalDataTrack,MediaStreamTrack:MediaStreamTrack,LocalAudioTrackPublication:LocalAudioTrackPublication,LocalVideoTrackPublication:LocalVideoTrackPublication,LocalDataTrackPublication:LocalDataTrackPublication,shouldStopLocalTracks:false,tracks:localTracks},options);var tracksToStop=options.shouldStopLocalTracks?new Set(localTracks.filter(function(localTrack){return localTrack.kind!=="data"})):new Set;var _this=_possibleConstructorReturn(this,(LocalParticipant.__proto__||Object.getPrototypeOf(LocalParticipant)).call(this,signaling,options));Object.defineProperties(_this,{_LocalAudioTrack:{value:options.LocalAudioTrack},_LocalDataTrack:{value:options.LocalDataTrack},_LocalVideoTrack:{value:options.LocalVideoTrack},_MediaStreamTrack:{value:options.MediaStreamTrack},_LocalAudioTrackPublication:{value:options.LocalAudioTrackPublication},_LocalDataTrackPublication:{value:options.LocalDataTrackPublication},_LocalVideoTrackPublication:{value:options.LocalVideoTrackPublication},_tracksToStop:{value:tracksToStop}});_this._handleTrackSignalingEvents();util.deprecateEvents("LocalParticipant",_this,new Map([["trackAdded",null],["trackRemoved",null]]),_this._log);return _this}_createClass(LocalParticipant,[{key:"_addTrack",value:function _addTrack(track){var addedTrack=_get(LocalParticipant.prototype.__proto__||Object.getPrototypeOf(LocalParticipant.prototype),"_addTrack",this).call(this,track);if(addedTrack&&this.state!=="disconnected"){this._addLocalTrack(track)}return addedTrack}},{key:"_addLocalTrack",value:function _addLocalTrack(track){this._signaling.addTrack(track._trackSender,track.name);this._log.info("Added a new "+util.trackClass(track,true)+":",track.id);this._log.debug(util.trackClass(track,true)+":",track)}},{key:"_removeTrack",value:function _removeTrack(track){var removedTrack=_get(LocalParticipant.prototype.__proto__||Object.getPrototypeOf(LocalParticipant.prototype),"_removeTrack",this).call(this,track);if(removedTrack&&this.state!=="disconnected"){this._signaling.removeTrack(track._trackSender);this._log.info("Removed a "+util.trackClass(track,true)+":",track.id);this._log.debug(util.trackClass(track,true)+":",track)}return removedTrack}},{key:"_getTrackEvents",value:function _getTrackEvents(){return _get(LocalParticipant.prototype.__proto__||Object.getPrototypeOf(LocalParticipant.prototype),"_getTrackEvents",this).call(this).concat([["stopped","trackStopped"]])}},{key:"toString",value:function toString(){return"[LocalParticipant #"+this._instanceId+(this.sid?": "+this.sid:"")+"]"}},{key:"_handleTrackSignalingEvents",value:function _handleTrackSignalingEvents(){var _this2=this;var log=this._log;if(this.state==="disconnected"){return}var signaling=this._signaling;function localTrackDisabled(localTrack){var trackSignaling=signaling.tracks.get(localTrack.id);if(trackSignaling){trackSignaling.disable();log.debug("Disabled the "+util.trackClass(localTrack,true)+":",localTrack.id)}}function localTrackEnabled(localTrack){var trackSignaling=signaling.tracks.get(localTrack.id);if(trackSignaling){trackSignaling.enable();log.debug("Enabled the "+util.trackClass(localTrack,true)+":",localTrack.id)}}this.on("trackDisabled",localTrackDisabled);this.on("trackEnabled",localTrackEnabled);this.tracks.forEach(function(track){_this2._addLocalTrack(track);_this2._getOrCreateLocalTrackPublication(track).catch(function(){})});var self=this;signaling.on("stateChanged",function stateChanged(state){log.debug("Transitioned to state:",state);if(state==="disconnected"){log.debug("Removing LocalTrack event listeners");signaling.removeListener("stateChanged",stateChanged);self.removeListener("trackDisabled",localTrackDisabled);self.removeListener("trackEnabled",localTrackEnabled);log.info("LocalParticipant disconnected. Stopping "+self._tracksToStop.size+" automatically-acquired LocalTracks");self._tracksToStop.forEach(function(track){track.stop()})}})}},{key:"_getOrCreateLocalTrackPublication",value:function _getOrCreateLocalTrackPublication(localTrack){var localTrackPublication=getTrackPublication(this.trackPublications,localTrack);if(localTrackPublication){return localTrackPublication}var log=this._log;var self=this;var trackSignaling=this._signaling.tracks.get(localTrack.id);if(!trackSignaling){return Promise.reject(new Error("Unexpected error: The "+localTrack+" cannot be published"))}function unpublish(publication){self.unpublishTrack(publication.track)}return new Promise(function(resolve,reject){function updated(){var error=trackSignaling.error;if(error){trackSignaling.removeListener("updated",updated);log.warn("Failed to publish the "+util.trackClass(localTrack,true)+": "+error.message);self._removeTrack(localTrack);setTimeout(function(){self.emit("trackPublicationFailed",error,localTrack)});reject(error);return}if(!self.tracks.has(localTrack.id)){trackSignaling.removeListener("updated",updated);reject(new Error("The "+localTrack+" was unpublished"));return}var sid=trackSignaling.sid;if(!sid){return}trackSignaling.removeListener("updated",updated);var options={log:log,LocalAudioTrackPublication:self._LocalAudioTrackPublication,LocalDataTrackPublication:self._LocalDataTrackPublication,LocalVideoTrackPublication:self._LocalVideoTrackPublication};localTrackPublication=getTrackPublication(self.trackPublications,localTrack);if(!localTrackPublication){localTrackPublication=util.asLocalTrackPublication(localTrack,sid,unpublish,options);self._addTrackPublication(localTrackPublication)}if(self._signaling.state==="connected"){setTimeout(function(){self.emit("trackPublished",localTrackPublication)})}resolve(localTrackPublication)}trackSignaling.on("updated",updated)})}},{key:"addTrack",value:function addTrack(track){this._log.deprecated("LocalParticipant#addTrack has been deprecated. "+"Use LocalParticipant#publishTrack instead.");util.validateLocalTrack(track,{LocalAudioTrack:this._LocalAudioTrack,LocalDataTrack:this._LocalDataTrack,LocalVideoTrack:this._LocalVideoTrack,MediaStreamTrack:this._MediaStreamTrack});if(this.tracks.has(track.id)){return null}this.publishTrack(track).catch(function(){});return this.tracks.get(track.id)}},{key:"addTracks",value:function addTracks(tracks){this._log.deprecated("LocalParticipant#addTracks has been deprecated. "+"Use LocalParticipant#publishTracks instead.");if(!Array.isArray(tracks)){throw E.INVALID_TYPE("tracks","Array of LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack")}tracks=tracks.filter(function(track){return!this.tracks.has(track.id)},this);this.publishTracks(tracks).catch(function(){});return tracks.map(function(track){return this.tracks.get(track.id)},this)}},{key:"publishTrack",value:function publishTrack(localTrackOrMediaStreamTrack,options){var trackPublication=getTrackPublication(this.trackPublications,localTrackOrMediaStreamTrack);if(trackPublication){return Promise.resolve(trackPublication)}options=Object.assign({log:this._log,LocalAudioTrack:this._LocalAudioTrack,LocalDataTrack:this._LocalDataTrack,LocalVideoTrack:this._LocalVideoTrack,MediaStreamTrack:this._MediaStreamTrack},options);var localTrack=void 0;try{localTrack=util.asLocalTrack(localTrackOrMediaStreamTrack,options)}catch(error){return Promise.reject(error)}localTrack=this._addTrack(localTrack)||this.tracks.get(localTrack.id);return this._getOrCreateLocalTrackPublication(localTrack)}},{key:"publishTracks",value:function publishTracks(tracks){if(!Array.isArray(tracks)){throw E.INVALID_TYPE("tracks","Array of LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack")}return Promise.all(tracks.map(this.publishTrack,this))}},{key:"removeTrack",value:function removeTrack(track,stop){this._log.deprecated("LocalParticipant#removeTrack has been deprecated. "+"Use LocalParticipant#unpublishTrack instead.");var publication=this.unpublishTrack(track);track=publication&&publication.track;stop=typeof stop==="boolean"?stop:true;if(track&&stop&&track.kind!=="data"){track.stop();this._log.info("Stopped LocalTrack:",track)}return track}},{key:"removeTracks",value:function removeTracks(tracks,stop){this._log.deprecated("LocalParticipant#removeTracks has been deprecated. "+"Use LocalParticipant#unpublishTracks instead.");stop=typeof stop==="boolean"?stop:true;return this.unpublishTracks(tracks).map(function(publication){var track=publication.track;if(stop&&track.kind!=="data"){track.stop()}return track})}},{key:"setNetworkQualityConfiguration",value:function setNetworkQualityConfiguration(networkQualityConfiguration){if((typeof networkQualityConfiguration==="undefined"?"undefined":_typeof(networkQualityConfiguration))!=="object"||networkQualityConfiguration===null){throw E.INVALID_TYPE("networkQualityConfiguration","NetworkQualityConfiguration")}["local","remote"].forEach(function(prop){if(prop in networkQualityConfiguration&&typeof networkQualityConfiguration[prop]!=="number"){throw E.INVALID_TYPE("networkQualityConfiguration."+prop,"number")}});this._signaling.setNetworkQualityConfiguration(networkQualityConfiguration);return this}},{key:"setParameters",value:function setParameters(encodingParameters){if(typeof encodingParameters!=="undefined"&&(typeof encodingParameters==="undefined"?"undefined":_typeof(encodingParameters))!=="object"){throw E.INVALID_TYPE("encodingParameters","EncodingParameters, null or undefined")}if(encodingParameters){["maxAudioBitrate","maxVideoBitrate"].forEach(function(prop){if(typeof encodingParameters[prop]!=="undefined"&&typeof encodingParameters[prop]!=="number"&&encodingParameters[prop]!==null){throw E.INVALID_TYPE("encodingParameters."+prop,"number, null or undefined")}})}else if(encodingParameters===null){encodingParameters={maxAudioBitrate:null,maxVideoBitrate:null}}this._signaling.setParameters(encodingParameters);return this}},{key:"unpublishTrack",value:function unpublishTrack(track){util.validateLocalTrack(track,{LocalAudioTrack:this._LocalAudioTrack,LocalDataTrack:this._LocalDataTrack,LocalVideoTrack:this._LocalVideoTrack,MediaStreamTrack:this._MediaStreamTrack});var localTrack=this.tracks.get(track.id);if(!localTrack){return null}var trackSignaling=this._signaling.tracks.get(localTrack.id);trackSignaling.publishFailed(new Error("The "+localTrack+" was unpublished"));var localTrackPublication=getTrackPublication(this.trackPublications,localTrack);this._removeTrack(localTrack);if(localTrackPublication){this._removeTrackPublication(localTrackPublication)}return localTrackPublication}},{key:"unpublishTracks",value:function unpublishTracks(tracks){var _this3=this;if(!Array.isArray(tracks)){throw E.INVALID_TYPE("tracks","Array of LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack")}return tracks.reduce(function(unpublishedTracks,track){var unpublishedTrack=_this3.unpublishTrack(track);return unpublishedTrack?unpublishedTracks.concat(unpublishedTrack):unpublishedTracks},[])}}]);return LocalParticipant}(Participant);function getTrackPublication(trackPublications,track){return Array.from(trackPublications.values()).find(function(trackPublication){return trackPublication.track===track||trackPublication.track.mediaStreamTrack===track})||null}module.exports=LocalParticipant},{"./media/track/es5/localaudiotrack":16,"./media/track/es5/localdatatrack":17,"./media/track/es5/localvideotrack":18,"./media/track/localaudiotrackpublication":21,"./media/track/localdatatrackpublication":23,"./media/track/localvideotrackpublication":27,"./participant":43,"./util":109,"./util/constants":107,"@twilio/webrtc":162}],15:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MediaTrack=require("./mediatrack");var AudioTrack=function(_MediaTrack){_inherits(AudioTrack,_MediaTrack);function AudioTrack(mediaTrackTransceiver,options){_classCallCheck(this,AudioTrack);return _possibleConstructorReturn(this,(AudioTrack.__proto__||Object.getPrototypeOf(AudioTrack)).call(this,mediaTrackTransceiver,options))}_createClass(AudioTrack,[{key:"_start",value:function _start(){_get(AudioTrack.prototype.__proto__||Object.getPrototypeOf(AudioTrack.prototype),"_start",this).call(this);if(this._dummyEl){this._detachElement(this._dummyEl)}}},{key:"attach",value:function attach(){return _get(AudioTrack.prototype.__proto__||Object.getPrototypeOf(AudioTrack.prototype),"attach",this).apply(this,arguments)}},{key:"detach",value:function detach(){return _get(AudioTrack.prototype.__proto__||Object.getPrototypeOf(AudioTrack.prototype),"detach",this).apply(this,arguments)}}]);return AudioTrack}(MediaTrack);module.exports=AudioTrack},{"./mediatrack":28}],16:[function(require,module,exports){"use strict";var _require=require("util"),inherits=_require.inherits;var LocalAudioTrackClass=require("../localaudiotrack");function LocalAudioTrack(mediaStreamTrack,options){var track=new LocalAudioTrackClass(mediaStreamTrack,options);Object.setPrototypeOf(track,LocalAudioTrack.prototype);return track}inherits(LocalAudioTrack,LocalAudioTrackClass);module.exports=LocalAudioTrack},{"../localaudiotrack":20,util:183}],17:[function(require,module,exports){"use strict";var _require=require("util"),inherits=_require.inherits;var LocalDataTrackClass=require("../localdatatrack");function LocalDataTrack(options){var track=new LocalDataTrackClass(options);Object.setPrototypeOf(track,LocalDataTrack.prototype);return track}inherits(LocalDataTrack,LocalDataTrackClass);module.exports=LocalDataTrack},{"../localdatatrack":22,util:183}],18:[function(require,module,exports){"use strict";var _require=require("util"),inherits=_require.inherits;var LocalVideoTrackClass=require("../localvideotrack");function LocalVideoTrack(mediaStreamTrack,options){var track=new LocalVideoTrackClass(mediaStreamTrack,options);Object.setPrototypeOf(track,LocalVideoTrack.prototype);return track}inherits(LocalVideoTrack,LocalVideoTrackClass);module.exports=LocalVideoTrack},{"../localvideotrack":26,util:183}],19:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var buildLogLevels=require("../../util").buildLogLevels;var DEFAULT_LOG_LEVEL=require("../../util/constants").DEFAULT_LOG_LEVEL;var Log=require("../../util/log");var nInstances=0;var Track=function(_EventEmitter){_inherits(Track,_EventEmitter);function Track(id,kind,options){_classCallCheck(this,Track);options=Object.assign({name:id,log:null,logLevel:DEFAULT_LOG_LEVEL},options);var _this=_possibleConstructorReturn(this,(Track.__proto__||Object.getPrototypeOf(Track)).call(this));var name=String(options.name);var logLevels=buildLogLevels(options.logLevel);var log=options.log?options.log.createLog("media",_this):new Log("media",_this,logLevels);Object.defineProperties(_this,{_id:{value:id},_instanceId:{value:++nInstances},_log:{value:log},kind:{enumerable:true,value:kind},name:{enumerable:true,value:name}});return _this}_createClass(Track,[{key:"id",get:function get(){return this._id}}]);return Track}(EventEmitter);module.exports=Track},{"../../util":109,"../../util/constants":107,"../../util/log":112,events:179}],20:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var AudioTrack=require("./audiotrack");var mixinLocalMediaTrack=require("./localmediatrack");var LocalMediaAudioTrack=mixinLocalMediaTrack(AudioTrack);var LocalAudioTrack=function(_LocalMediaAudioTrack){_inherits(LocalAudioTrack,_LocalMediaAudioTrack);function LocalAudioTrack(mediaStreamTrack,options){_classCallCheck(this,LocalAudioTrack);return _possibleConstructorReturn(this,(LocalAudioTrack.__proto__||Object.getPrototypeOf(LocalAudioTrack)).call(this,mediaStreamTrack,options))}_createClass(LocalAudioTrack,[{key:"toString",value:function toString(){return"[LocalAudioTrack #"+this._instanceId+": "+this.id+"]"}},{key:"attach",value:function attach(el){el=_get(LocalAudioTrack.prototype.__proto__||Object.getPrototypeOf(LocalAudioTrack.prototype),"attach",this).call(this,el);el.muted=true;return el}},{key:"_end",value:function _end(){return _get(LocalAudioTrack.prototype.__proto__||Object.getPrototypeOf(LocalAudioTrack.prototype),"_end",this).apply(this,arguments)}},{key:"disable",value:function disable(){return _get(LocalAudioTrack.prototype.__proto__||Object.getPrototypeOf(LocalAudioTrack.prototype),"disable",this).apply(this,arguments)}},{key:"enable",value:function enable(){return _get(LocalAudioTrack.prototype.__proto__||Object.getPrototypeOf(LocalAudioTrack.prototype),"enable",this).apply(this,arguments)}},{key:"stop",value:function stop(){return _get(LocalAudioTrack.prototype.__proto__||Object.getPrototypeOf(LocalAudioTrack.prototype),"stop",this).apply(this,arguments)}}]);return LocalAudioTrack}(LocalMediaAudioTrack);module.exports=LocalAudioTrack},{"./audiotrack":15,"./localmediatrack":24}],21:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var LocalTrackPublication=require("./localtrackpublication");var LocalAudioTrackPublication=function(_LocalTrackPublicatio){_inherits(LocalAudioTrackPublication,_LocalTrackPublicatio);function LocalAudioTrackPublication(trackSid,track,unpublish,options){_classCallCheck(this,LocalAudioTrackPublication);return _possibleConstructorReturn(this,(LocalAudioTrackPublication.__proto__||Object.getPrototypeOf(LocalAudioTrackPublication)).call(this,trackSid,track,unpublish,options))}_createClass(LocalAudioTrackPublication,[{key:"toString",value:function toString(){return"[LocalAudioTrackPublication #"+this._instanceId+": "+this.trackSid+"]"}}]);return LocalAudioTrackPublication}(LocalTrackPublication);module.exports=LocalAudioTrackPublication},{"./localtrackpublication":25}],22:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true
    ;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var Track=require("./");var DefaultDataTrackSender=require("../../data/sender");var LocalDataTrack=function(_Track){_inherits(LocalDataTrack,_Track);function LocalDataTrack(options){_classCallCheck(this,LocalDataTrack);options=Object.assign({DataTrackSender:DefaultDataTrackSender,maxPacketLifeTime:null,maxRetransmits:null,ordered:true},options);var DataTrackSender=options.DataTrackSender;var dataTrackSender=new DataTrackSender(options.maxPacketLifeTime,options.maxRetransmits,options.ordered);var _this=_possibleConstructorReturn(this,(LocalDataTrack.__proto__||Object.getPrototypeOf(LocalDataTrack)).call(this,dataTrackSender.id,"data",options));Object.defineProperties(_this,{_trackSender:{value:dataTrackSender},maxPacketLifeTime:{enumerable:true,value:options.maxPacketLifeTime},maxRetransmits:{enumerable:true,value:options.maxRetransmits},ordered:{enumerable:true,value:options.ordered},reliable:{enumerable:true,value:options.maxPacketLifeTime===null&&options.maxRetransmits===null}});return _this}_createClass(LocalDataTrack,[{key:"send",value:function send(data){this._trackSender.send(data)}}]);return LocalDataTrack}(Track);module.exports=LocalDataTrack},{"../../data/sender":6,"./":19}],23:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var LocalTrackPublication=require("./localtrackpublication");var LocalDataTrackPublication=function(_LocalTrackPublicatio){_inherits(LocalDataTrackPublication,_LocalTrackPublicatio);function LocalDataTrackPublication(trackSid,track,unpublish,options){_classCallCheck(this,LocalDataTrackPublication);return _possibleConstructorReturn(this,(LocalDataTrackPublication.__proto__||Object.getPrototypeOf(LocalDataTrackPublication)).call(this,trackSid,track,unpublish,options))}_createClass(LocalDataTrackPublication,[{key:"toString",value:function toString(){return"[LocalDataTrackPublication #"+this._instanceId+": "+this.trackSid+"]"}}]);return LocalDataTrackPublication}(LocalTrackPublication);module.exports=LocalDataTrackPublication},{"./localtrackpublication":25}],24:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MediaTrackSender=require("./sender");function mixinLocalMediaTrack(AudioOrVideoTrack){return function(_AudioOrVideoTrack){_inherits(LocalMediaTrack,_AudioOrVideoTrack);function LocalMediaTrack(mediaStreamTrack,options){_classCallCheck(this,LocalMediaTrack);options=Object.assign({},options);var mediaTrackSender=new MediaTrackSender(mediaStreamTrack);var _this=_possibleConstructorReturn(this,(LocalMediaTrack.__proto__||Object.getPrototypeOf(LocalMediaTrack)).call(this,mediaTrackSender,options));Object.defineProperties(_this,{_didCallEnd:{value:false,writable:true},_trackSender:{value:mediaTrackSender},isEnabled:{enumerable:true,get:function get(){return mediaStreamTrack.enabled}},isStopped:{get:function get(){return mediaStreamTrack.readyState==="ended"}}});return _this}_createClass(LocalMediaTrack,[{key:"_end",value:function _end(){if(this._didCallEnd){return}_get(LocalMediaTrack.prototype.__proto__||Object.getPrototypeOf(LocalMediaTrack.prototype),"_end",this).call(this);this._didCallEnd=true;this.emit("stopped",this)}},{key:"enable",value:function enable(enabled){enabled=typeof enabled==="boolean"?enabled:true;if(enabled!==this.mediaStreamTrack.enabled){this._log.info((enabled?"En":"Dis")+"abling");this.mediaStreamTrack.enabled=enabled;this.emit(enabled?"enabled":"disabled",this)}return this}},{key:"disable",value:function disable(){return this.enable(false)}},{key:"stop",value:function stop(){this._log.info("Stopping");this.mediaStreamTrack.stop();this._end();return this}}]);return LocalMediaTrack}(AudioOrVideoTrack)}module.exports=mixinLocalMediaTrack},{"./sender":38}],25:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TrackPublication=require("./trackpublication");var LocalTrackPublication=function(_TrackPublication){_inherits(LocalTrackPublication,_TrackPublication);function LocalTrackPublication(trackSid,track,unpublish,options){_classCallCheck(this,LocalTrackPublication);var _this=_possibleConstructorReturn(this,(LocalTrackPublication.__proto__||Object.getPrototypeOf(LocalTrackPublication)).call(this,track.name,trackSid,options));Object.defineProperties(_this,{_reemitTrackEvent:{value:function value(){return _this.emit(_this.isTrackEnabled?"trackEnabled":"trackDisabled")}},_unpublish:{value:unpublish},kind:{enumerable:true,value:track.kind},track:{enumerable:true,value:track}});track.on("disabled",_this._reemitTrackEvent);track.on("enabled",_this._reemitTrackEvent);return _this}_createClass(LocalTrackPublication,[{key:"toString",value:function toString(){return"[LocalTrackPublication #"+this._instanceId+": "+this.trackSid+"]"}},{key:"unpublish",value:function unpublish(){this.track.removeListener("disabled",this._reemitTrackEvent);this.track.removeListener("enabled",this._reemitTrackEvent);this._unpublish(this);return this}},{key:"isTrackEnabled",get:function get(){return this.track.kind==="data"?true:this.track.isEnabled}}]);return LocalTrackPublication}(TrackPublication);module.exports=LocalTrackPublication},{"./trackpublication":39}],26:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var mixinLocalMediaTrack=require("./localmediatrack");var VideoTrack=require("./videotrack");var LocalMediaVideoTrack=mixinLocalMediaTrack(VideoTrack);var LocalVideoTrack=function(_LocalMediaVideoTrack){_inherits(LocalVideoTrack,_LocalMediaVideoTrack);function LocalVideoTrack(mediaStreamTrack,options){_classCallCheck(this,LocalVideoTrack);return _possibleConstructorReturn(this,(LocalVideoTrack.__proto__||Object.getPrototypeOf(LocalVideoTrack)).call(this,mediaStreamTrack,options))}_createClass(LocalVideoTrack,[{key:"toString",value:function toString(){return"[LocalVideoTrack #"+this._instanceId+": "+this.id+"]"}},{key:"_end",value:function _end(){return _get(LocalVideoTrack.prototype.__proto__||Object.getPrototypeOf(LocalVideoTrack.prototype),"_end",this).apply(this,arguments)}},{key:"disable",value:function disable(){return _get(LocalVideoTrack.prototype.__proto__||Object.getPrototypeOf(LocalVideoTrack.prototype),"disable",this).apply(this,arguments)}},{key:"enable",value:function enable(){return _get(LocalVideoTrack.prototype.__proto__||Object.getPrototypeOf(LocalVideoTrack.prototype),"enable",this).apply(this,arguments)}},{key:"stop",value:function stop(){return _get(LocalVideoTrack.prototype.__proto__||Object.getPrototypeOf(LocalVideoTrack.prototype),"stop",this).apply(this,arguments)}}]);return LocalVideoTrack}(LocalMediaVideoTrack);module.exports=LocalVideoTrack},{"./localmediatrack":24,"./videotrack":41}],27:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var LocalTrackPublication=require("./localtrackpublication");var LocalVideoTrackPublication=function(_LocalTrackPublicatio){_inherits(LocalVideoTrackPublication,_LocalTrackPublicatio);function LocalVideoTrackPublication(trackSid,track,unpublish,options){_classCallCheck(this,LocalVideoTrackPublication);return _possibleConstructorReturn(this,(LocalVideoTrackPublication.__proto__||Object.getPrototypeOf(LocalVideoTrackPublication)).call(this,trackSid,track,unpublish,options))}_createClass(LocalVideoTrackPublication,[{key:"toString",value:function toString(){return"[LocalVideoTrackPublication #"+this._instanceId+": "+this.trackSid+"]"}}]);return LocalVideoTrackPublication}(LocalTrackPublication);module.exports=LocalVideoTrackPublication},{"./localtrackpublication":25}],28:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MediaStream=require("@twilio/webrtc").MediaStream;var Track=require("./");var MediaTrack=function(_Track){_inherits(MediaTrack,_Track);function MediaTrack(mediaTrackTransceiver,options){_classCallCheck(this,MediaTrack);var _this=_possibleConstructorReturn(this,(MediaTrack.__proto__||Object.getPrototypeOf(MediaTrack)).call(this,mediaTrackTransceiver.id,mediaTrackTransceiver.kind,options));var isStarted=false;options=Object.assign({MediaStream:MediaStream},options);Object.defineProperties(_this,{_attachments:{value:new Set},_isStarted:{get:function get(){return isStarted},set:function set(_isStarted){isStarted=_isStarted}},_MediaStream:{value:options.MediaStream},isStarted:{get:function get(){return isStarted}},mediaStreamTrack:{enumerable:true,value:mediaTrackTransceiver.track}});_this._initialize();return _this}_createClass(MediaTrack,[{key:"_start",value:function _start(){this._log.debug("Started");this._isStarted=true;if(this._dummyEl){this._dummyEl.oncanplay=null}this.emit("started",this)}},{key:"_initialize",value:function _initialize(){var self=this;this._log.debug("Initializing");this._dummyEl=this._createElement();this.mediaStreamTrack.addEventListener("ended",function onended(){self._end();self.mediaStreamTrack.removeEventListener("ended",onended)});if(this._dummyEl){this._dummyEl.muted=true;this._dummyEl.oncanplay=this._start.bind(this,this._dummyEl);this._attach(this._dummyEl);this._attachments.delete(this._dummyEl)}}},{key:"_end",value:function _end(){this._log.debug("Ended");if(this._dummyEl){this._detachElement(this._dummyEl);this._dummyEl.oncanplay=null}}},{key:"attach",value:function attach(el){if(typeof el==="string"){el=this._selectElement(el)}else if(!el){el=this._createElement()}this._log.debug("Attempting to attach to element:",el);el=this._attach(el);return el}},{key:"_attach",value:function _attach(el){var mediaStream=el.srcObject;if(!(mediaStream instanceof this._MediaStream)){mediaStream=new this._MediaStream}var getTracks=this.mediaStreamTrack.kind==="audio"?"getAudioTracks":"getVideoTracks";mediaStream[getTracks]().forEach(function(mediaStreamTrack){mediaStream.removeTrack(mediaStreamTrack)});mediaStream.addTrack(this.mediaStreamTrack);el.srcObject=mediaStream;el.autoplay=true;el.playsInline=true;if(!this._attachments.has(el)){this._attachments.add(el)}return el}},{key:"_selectElement",value:function _selectElement(selector){var el=document.querySelector(selector);if(!el){throw new Error("Selector matched no element: "+selector)}return el}},{key:"_createElement",value:function _createElement(){return typeof document!=="undefined"?document.createElement(this.kind):null}},{key:"detach",value:function detach(el){var els=void 0;if(typeof el==="string"){els=[this._selectElement(el)]}else if(!el){els=this._getAllAttachedElements()}else{els=[el]}this._log.debug("Attempting to detach from elements:",els);this._detachElements(els);return el?els[0]:els}},{key:"_detachElements",value:function _detachElements(elements){return elements.map(this._detachElement.bind(this))}},{key:"_detachElement",value:function _detachElement(el){if(!this._attachments.has(el)){return el}var mediaStream=el.srcObject;if(mediaStream instanceof this._MediaStream){mediaStream.removeTrack(this.mediaStreamTrack);el.srcObject=mediaStream}this._attachments.delete(el);return el}},{key:"_getAllAttachedElements",value:function _getAllAttachedElements(){var els=[];this._attachments.forEach(function(el){els.push(el)});return els}}]);return MediaTrack}(Track);module.exports=MediaTrack},{"./":19,"@twilio/webrtc":162}],29:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MediaTrackTransceiver=require("./transceiver");var MediaTrackReceiver=function(_MediaTrackTransceive){_inherits(MediaTrackReceiver,_MediaTrackTransceive);function MediaTrackReceiver(id,mediaStreamTrack){_classCallCheck(this,MediaTrackReceiver);return _possibleConstructorReturn(this,(MediaTrackReceiver.__proto__||Object.getPrototypeOf(MediaTrackReceiver)).call(this,id,mediaStreamTrack))}return MediaTrackReceiver}(MediaTrackTransceiver);module.exports=MediaTrackReceiver},{"./transceiver":40}],30:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var AudioTrack=require("./audiotrack");var mixinRemoteMediaTrack=require("./remotemediatrack");var RemoteMediaAudioTrack=mixinRemoteMediaTrack(AudioTrack);var RemoteAudioTrack=function(_RemoteMediaAudioTrac){_inherits(RemoteAudioTrack,_RemoteMediaAudioTrac);function RemoteAudioTrack(mediaTrackReceiver,isEnabled,options){_classCallCheck(this,RemoteAudioTrack);return _possibleConstructorReturn(this,(RemoteAudioTrack.__proto__||Object.getPrototypeOf(RemoteAudioTrack)).call(this,mediaTrackReceiver,isEnabled,options))}_createClass(RemoteAudioTrack,[{key:"toString",value:function toString(){return"[RemoteAudioTrack #"+this._instanceId+": "+this.sid+"]"}}]);return RemoteAudioTrack}(RemoteMediaAudioTrack);module.exports=RemoteAudioTrack},{"./audiotrack":15,"./remotemediatrack":34}],31:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RemoteTrackPublication=require("./remotetrackpublication");var RemoteAudioTrackPublication=function(_RemoteTrackPublicati){_inherits(RemoteAudioTrackPublication,_RemoteTrackPublicati);function RemoteAudioTrackPublication(signaling,options){_classCallCheck(this,RemoteAudioTrackPublication);return _possibleConstructorReturn(this,(RemoteAudioTrackPublication.__proto__||Object.getPrototypeOf(RemoteAudioTrackPublication)).call(this,signaling,options))}_createClass(RemoteAudioTrackPublication,[{key:"toString",value:function toString(){return"[RemoteAudioTrackPublication #"+this._instanceId+": "+this.trackSid+"]"}}]);return RemoteAudioTrackPublication}(RemoteTrackPublication);module.exports=RemoteAudioTrackPublication},{"./remotetrackpublication":35}],32:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("../../util"),deprecateEvents=_require.deprecateEvents;var Track=require("./");var RemoteDataTrack=function(_Track){_inherits(RemoteDataTrack,_Track);function RemoteDataTrack(dataTrackReceiver,options){_classCallCheck(this,RemoteDataTrack);var _this=_possibleConstructorReturn(this,(RemoteDataTrack.__proto__||Object.getPrototypeOf(RemoteDataTrack)).call(this,dataTrackReceiver.id,"data",options));Object.defineProperties(_this,{_isSubscribed:{value:true,writable:true},_sid:{value:null,writable:true},isEnabled:{enumerable:true,value:true},maxPacketLifeTime:{enumerable:true,value:dataTrackReceiver.maxPacketLifeTime},maxRetransmits:{enumerable:true,value:dataTrackReceiver.maxRetransmits},ordered:{enumerable:true,value:dataTrackReceiver.ordered},reliable:{enumerable:true,value:dataTrackReceiver.maxPacketLifeTime===null&&dataTrackReceiver.maxRetransmits===null}});deprecateEvents("RemoteDataTrack",_this,new Map([["unsubscribed",null]]),_this._log);dataTrackReceiver.on("message",function(data){_this.emit("message",data,_this)});return _this}_createClass(RemoteDataTrack,[{key:"_setEnabled",value:function _setEnabled(){}},{key:"_setSid",value:function _setSid(sid){if(!this._sid){this._sid=sid}}},{key:"_unsubscribe",value:function _unsubscribe(){if(this._isSubscribed){this._isSubscribed=false;this.emit("unsubscribed",this)}}},{key:"id",get:function get(){this._log.deprecated("RemoteDataTrack#id has been deprecated and is "+"scheduled for removal in twilio-video.js@2.0.0. Use the parent "+"RemoteTrackPublication's .trackName or .trackSid instead.");return this._id}},{key:"isSubscribed",get:function get(){this._log.deprecated("RemoteDataTrack#isSubscribed has been deprecated and is "+"scheduled for removal in twilio-video.js@2.0.0. Use the "+"parent RemoteTrackPublication's .isSubscribed instead.");return this._isSubscribed}},{key:"sid",get:function get(){return this._sid}}]);return RemoteDataTrack}(Track);module.exports=RemoteDataTrack},{"../../util":109,"./":19}],33:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RemoteTrackPublication=require("./remotetrackpublication");var RemoteDataTrackPublication=function(_RemoteTrackPublicati){_inherits(RemoteDataTrackPublication,_RemoteTrackPublicati);function RemoteDataTrackPublication(signaling,options){_classCallCheck(this,RemoteDataTrackPublication);return _possibleConstructorReturn(this,(RemoteDataTrackPublication.__proto__||Object.getPrototypeOf(RemoteDataTrackPublication)).call(this,signaling,options))}_createClass(RemoteDataTrackPublication,[{key:"toString",value:function toString(){return"[RemoteDataTrackPublication #"+this._instanceId+": "+this.trackSid+"]"}}]);return RemoteDataTrackPublication}(RemoteTrackPublication);module.exports=RemoteDataTrackPublication},{"./remotetrackpublication":35}],34:[function(require,module,exports){"use strict"
    ;var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("../../util"),deprecateEvents=_require.deprecateEvents;function mixinRemoteMediaTrack(AudioOrVideoTrack){return function(_AudioOrVideoTrack){_inherits(RemoteMediaTrack,_AudioOrVideoTrack);function RemoteMediaTrack(mediaTrackReceiver,isEnabled,options){_classCallCheck(this,RemoteMediaTrack);var _this=_possibleConstructorReturn(this,(RemoteMediaTrack.__proto__||Object.getPrototypeOf(RemoteMediaTrack)).call(this,mediaTrackReceiver,options));Object.defineProperties(_this,{_isEnabled:{value:isEnabled,writable:true},_isSubscribed:{value:true,writable:true},_sid:{value:null,writable:true}});deprecateEvents("RemoteMediaTrack",_this,new Map([["unsubscribed",null]]),_this._log);return _this}_createClass(RemoteMediaTrack,[{key:"_setEnabled",value:function _setEnabled(isEnabled){if(this._isEnabled!==isEnabled){this._isEnabled=isEnabled;this.emit(this._isEnabled?"enabled":"disabled",this)}}},{key:"_setSid",value:function _setSid(sid){if(!this._sid){this._sid=sid}}},{key:"_unsubscribe",value:function _unsubscribe(){if(this._isSubscribed){this._isSubscribed=false;this.emit("unsubscribed",this)}}},{key:"id",get:function get(){this._log.deprecated("RemoteMediaTrack#id has been deprecated and is "+"scheduled for removal in twilio-video.js@2.0.0. Use the parent "+"RemoteTrackPublication's .trackName or .trackSid instead.");return this._id}},{key:"isEnabled",get:function get(){return this._isEnabled}},{key:"isSubscribed",get:function get(){this._log.deprecated("RemoteMediaTrack#isSubscribed has been deprecated and is "+"scheduled for removal in twilio-video.js@2.0.0. Use the "+"parent RemoteTrackPublication's .isSubscribed instead.");return this._isSubscribed}},{key:"sid",get:function get(){return this._sid}}]);return RemoteMediaTrack}(AudioOrVideoTrack)}module.exports=mixinRemoteMediaTrack},{"../../util":109}],35:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TrackPublication=require("./trackpublication");var RemoteTrackPublication=function(_TrackPublication){_inherits(RemoteTrackPublication,_TrackPublication);function RemoteTrackPublication(signaling,options){_classCallCheck(this,RemoteTrackPublication);var _this=_possibleConstructorReturn(this,(RemoteTrackPublication.__proto__||Object.getPrototypeOf(RemoteTrackPublication)).call(this,signaling.name,signaling.sid,options));Object.defineProperties(_this,{_signaling:{value:signaling},_track:{value:null,writable:true},kind:{enumerable:true,value:signaling.kind}});signaling.on("updated",function(){if(signaling.error){_this.emit("subscriptionFailed",signaling.error);return}if(_this.track){_this.track._setEnabled(signaling.isEnabled)}_this.emit(signaling.isEnabled?"trackEnabled":"trackDisabled")});return _this}_createClass(RemoteTrackPublication,[{key:"toString",value:function toString(){return"[RemoteTrackPublication #"+this._instanceId+": "+this.trackSid+"]"}},{key:"_subscribed",value:function _subscribed(track){if(!this._track&&track){this._track=track;this.emit("subscribed",track)}}},{key:"_unsubscribe",value:function _unsubscribe(){if(this._track){var track=this._track;this._track=null;track._unsubscribe();this.emit("unsubscribed",track)}}},{key:"isSubscribed",get:function get(){return!!this._track}},{key:"isTrackEnabled",get:function get(){return this._signaling.isEnabled}},{key:"track",get:function get(){return this._track}}]);return RemoteTrackPublication}(TrackPublication);module.exports=RemoteTrackPublication},{"./trackpublication":39}],36:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var mixinRemoteMediaTrack=require("./remotemediatrack");var VideoTrack=require("./videotrack");var RemoteMediaVideoTrack=mixinRemoteMediaTrack(VideoTrack);var RemoteVideoTrack=function(_RemoteMediaVideoTrac){_inherits(RemoteVideoTrack,_RemoteMediaVideoTrac);function RemoteVideoTrack(mediaTrackReceiver,isEnabled,options){_classCallCheck(this,RemoteVideoTrack);return _possibleConstructorReturn(this,(RemoteVideoTrack.__proto__||Object.getPrototypeOf(RemoteVideoTrack)).call(this,mediaTrackReceiver,isEnabled,options))}_createClass(RemoteVideoTrack,[{key:"toString",value:function toString(){return"[RemoteVideoTrack #"+this._instanceId+": "+this.sid+"]"}}]);return RemoteVideoTrack}(RemoteMediaVideoTrack);module.exports=RemoteVideoTrack},{"./remotemediatrack":34,"./videotrack":41}],37:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RemoteTrackPublication=require("./remotetrackpublication");var RemoteVideoTrackPublication=function(_RemoteTrackPublicati){_inherits(RemoteVideoTrackPublication,_RemoteTrackPublicati);function RemoteVideoTrackPublication(signaling,options){_classCallCheck(this,RemoteVideoTrackPublication);return _possibleConstructorReturn(this,(RemoteVideoTrackPublication.__proto__||Object.getPrototypeOf(RemoteVideoTrackPublication)).call(this,signaling,options))}_createClass(RemoteVideoTrackPublication,[{key:"toString",value:function toString(){return"[RemoteVideoTrackPublication #"+this._instanceId+": "+this.trackSid+"]"}}]);return RemoteVideoTrackPublication}(RemoteTrackPublication);module.exports=RemoteVideoTrackPublication},{"./remotetrackpublication":35}],38:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MediaTrackTransceiver=require("./transceiver");var MediaTrackSender=function(_MediaTrackTransceive){_inherits(MediaTrackSender,_MediaTrackTransceive);function MediaTrackSender(mediaStreamTrack){_classCallCheck(this,MediaTrackSender);var _this=_possibleConstructorReturn(this,(MediaTrackSender.__proto__||Object.getPrototypeOf(MediaTrackSender)).call(this,mediaStreamTrack.id,mediaStreamTrack));Object.defineProperties(_this,{_senders:{value:new Set}});return _this}_createClass(MediaTrackSender,[{key:"addSender",value:function addSender(sender){this._senders.add(sender);return this}},{key:"removeSender",value:function removeSender(sender){this._senders.delete(sender);return this}}]);return MediaTrackSender}(MediaTrackTransceiver);module.exports=MediaTrackSender},{"./transceiver":40}],39:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("events"),EventEmitter=_require.EventEmitter;var _require2=require("../../util"),buildLogLevels=_require2.buildLogLevels;var _require3=require("../../util/constants"),DEFAULT_LOG_LEVEL=_require3.DEFAULT_LOG_LEVEL;var Log=require("../../util/log");var nInstances=0;var TrackPublication=function(_EventEmitter){_inherits(TrackPublication,_EventEmitter);function TrackPublication(trackName,trackSid,options){_classCallCheck(this,TrackPublication);var _this=_possibleConstructorReturn(this,(TrackPublication.__proto__||Object.getPrototypeOf(TrackPublication)).call(this));options=Object.assign({logLevel:DEFAULT_LOG_LEVEL},options);var logLevels=buildLogLevels(options.logLevel);Object.defineProperties(_this,{_instanceId:{value:nInstances++},_log:{value:options.log||new Log("default",_this,logLevels)},trackName:{value:trackName},trackSid:{value:trackSid}});return _this}_createClass(TrackPublication,[{key:"toString",value:function toString(){return"[TrackPublication #"+this._instanceId+": "+this.trackSid+"]"}}]);return TrackPublication}(EventEmitter);module.exports=TrackPublication},{"../../util":109,"../../util/constants":107,"../../util/log":112,events:179}],40:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TrackTransceiver=require("../../transceiver");var MediaTrackTransceiver=function(_TrackTransceiver){_inherits(MediaTrackTransceiver,_TrackTransceiver);function MediaTrackTransceiver(id,mediaStreamTrack){_classCallCheck(this,MediaTrackTransceiver);var _this=_possibleConstructorReturn(this,(MediaTrackTransceiver.__proto__||Object.getPrototypeOf(MediaTrackTransceiver)).call(this,id,mediaStreamTrack.kind));Object.defineProperties(_this,{readyState:{enumerable:true,get:function get(){return mediaStreamTrack.readyState}},track:{enumerable:true,value:mediaStreamTrack}});return _this}return MediaTrackTransceiver}(TrackTransceiver);module.exports=MediaTrackTransceiver},{"../../transceiver":104}],41:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MediaTrack=require("./mediatrack");var VideoTrack=function(_MediaTrack){_inherits(VideoTrack,_MediaTrack);function VideoTrack(mediaTrackTransceiver,options){var _ret;_classCallCheck(this,VideoTrack);var _this=_possibleConstructorReturn(this,(VideoTrack.__proto__||Object.getPrototypeOf(VideoTrack)).call(this,mediaTrackTransceiver,options));Object.defineProperties(_this,{dimensions:{enumerable:true,value:{width:null,height:null}}});return _ret=_this,_possibleConstructorReturn(_this,_ret)}_createClass(VideoTrack,[{key:"_initialize",value:function _initialize(){var _this2=this;_get(VideoTrack.prototype.__proto__||Object.getPrototypeOf(VideoTrack.prototype),"_initialize",this).call(this);if(this._dummyEl){this._dummyEl.onloadedmetadata=function(){if(dimensionsChanged(_this2,_this2._dummyEl)){_this2.dimensions.width=_this2._dummyEl.videoWidth;_this2.dimensions.height=_this2._dummyEl.videoHeight}};this._dummyEl.onresize=function(){if(dimensionsChanged(_this2,_this2._dummyEl)){_this2.dimensions.width=_this2._dummyEl.videoWidth;_this2.dimensions.height=_this2._dummyEl.videoHeight;if(_this2.isStarted){_this2._log.debug("Dimensions changed:",_this2.dimensions);_this2.emit(VideoTrack.DIMENSIONS_CHANGED,_this2)}}}}}},{key:"_start",value:function _start(dummyEl){this.dimensions.width=dummyEl.videoWidth;this.dimensions.height=dummyEl.videoHeight;this._log.debug("Dimensions:",this.dimensions);return _get(VideoTrack.prototype.__proto__||Object.getPrototypeOf(VideoTrack.prototype),"_start",this).call(this,dummyEl)}},{key:"attach",value:function attach(){return _get(VideoTrack.prototype.__proto__||Object.getPrototypeOf(VideoTrack.prototype),"attach",this).apply(this,arguments)}},{key:"detach",value:function detach(){return _get(VideoTrack.prototype.__proto__||Object.getPrototypeOf(VideoTrack.prototype),"detach",this).apply(this,arguments)}}]);return VideoTrack}(MediaTrack);VideoTrack.DIMENSIONS_CHANGED="dimensionsChanged";function dimensionsChanged(track,elem){return track.dimensions.width!==elem.videoWidth||track.dimensions.height!==elem.videoHeight}module.exports=VideoTrack},{"./mediatrack":28}],42:[function(require,module,exports){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("events"),EventEmitter=_require.EventEmitter;var _require2=require("./util/constants"),DEFAULT_NQ_LEVEL_LOCAL=_require2.DEFAULT_NQ_LEVEL_LOCAL,DEFAULT_NQ_LEVEL_REMOTE=_require2.DEFAULT_NQ_LEVEL_REMOTE,MAX_NQ_LEVEL=_require2.MAX_NQ_LEVEL;var _require3=require("./util"),inRange=_require3.inRange;var NetworkQualityConfigurationImpl=function(_EventEmitter){_inherits(NetworkQualityConfigurationImpl,_EventEmitter);function NetworkQualityConfigurationImpl(networkQualityConfiguration){_classCallCheck(this,NetworkQualityConfigurationImpl);var _this=_possibleConstructorReturn(this,(NetworkQualityConfigurationImpl.__proto__||Object.getPrototypeOf(NetworkQualityConfigurationImpl)).call(this));networkQualityConfiguration=Object.assign({local:DEFAULT_NQ_LEVEL_LOCAL,remote:DEFAULT_NQ_LEVEL_REMOTE},networkQualityConfiguration);Object.defineProperties(_this,{local:{value:inRange(networkQualityConfiguration.local,DEFAULT_NQ_LEVEL_LOCAL,MAX_NQ_LEVEL)?networkQualityConfiguration.local:DEFAULT_NQ_LEVEL_LOCAL,writable:true},remote:{value:inRange(networkQualityConfiguration.remote,DEFAULT_NQ_LEVEL_REMOTE,MAX_NQ_LEVEL)?networkQualityConfiguration.remote:DEFAULT_NQ_LEVEL_REMOTE,writable:true}});return _this}_createClass(NetworkQualityConfigurationImpl,[{key:"update",value:function update(networkQualityConfiguration){var _this2=this;networkQualityConfiguration=Object.assign({local:this.local,remote:this.remote},networkQualityConfiguration);[["local",DEFAULT_NQ_LEVEL_LOCAL,3],["remote",DEFAULT_NQ_LEVEL_REMOTE,3]].forEach(function(_ref){var _ref2=_slicedToArray(_ref,3),localOrRemote=_ref2[0],min=_ref2[1],max=_ref2[2];_this2[localOrRemote]=typeof networkQualityConfiguration[localOrRemote]==="number"&&inRange(networkQualityConfiguration[localOrRemote],min,max)?networkQualityConfiguration[localOrRemote]:min})}}]);return NetworkQualityConfigurationImpl}(EventEmitter);module.exports=NetworkQualityConfigurationImpl},{"./util":109,"./util/constants":107,events:179}],43:[function(require,module,exports){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RemoteAudioTrack=require("./media/track/remoteaudiotrack");var RemoteAudioTrackPublication=require("./media/track/remoteaudiotrackpublication");var RemoteDataTrack=require("./media/track/remotedatatrack");var RemoteDataTrackPublication=require("./media/track/remotedatatrackpublication");var RemoteVideoTrack=require("./media/track/remotevideotrack");var RemoteVideoTrackPublication=require("./media/track/remotevideotrackpublication");var EventEmitter=require("events").EventEmitter;var util=require("./util");var nInstances=0;var Participant=function(_EventEmitter){_inherits(Participant,_EventEmitter);function Participant(signaling,options){_classCallCheck(this,Participant);var _this=_possibleConstructorReturn(this,(Participant.__proto__||Object.getPrototypeOf(Participant)).call(this));options=Object.assign({RemoteAudioTrack:RemoteAudioTrack,RemoteAudioTrackPublication:RemoteAudioTrackPublication,RemoteDataTrack:RemoteDataTrack,RemoteDataTrackPublication:RemoteDataTrackPublication,RemoteVideoTrack:RemoteVideoTrack,RemoteVideoTrackPublication:RemoteVideoTrackPublication,tracks:[]},options);var indexed=indexTracksById(options.tracks);var log=options.log.createLog("default",_this);var audioTracks=new Map(indexed.audioTracks);var dataTracks=new Map(indexed.dataTracks);var tracks=new Map(indexed.tracks);var videoTracks=new Map(indexed.videoTracks);Object.defineProperties(_this,{_RemoteAudioTrack:{value:options.RemoteAudioTrack},_RemoteAudioTrackPublication:{value:options.RemoteAudioTrackPublication},_RemoteDataTrack:{value:options.RemoteDataTrack},_RemoteDataTrackPublication:{value:options.RemoteDataTrackPublication},_RemoteVideoTrack:{value:options.RemoteVideoTrack},_RemoteVideoTrackPublication:{value:options.RemoteVideoTrackPublication},_instanceId:{value:++nInstances},_log:{value:log},_signaling:{value:signaling},_trackEventReemitters:{value:new Map},_trackPublicationEventReemitters:{value:new Map},_trackSignalingUpdatedEventCallbacks:{value:new Map},audioTracks:{enumerable:true,value:audioTracks},audioTrackPublications:{enumerable:true,value:new Map},dataTracks:{enumerable:true,value:dataTracks},dataTrackPublications:{enumerable:true,value:new Map},identity:{enumerable:true,get:function get(){return signaling.identity}},networkQualityLevel:{enumerable:true,get:function get(){return signaling.networkQualityLevel}},networkQualityStats:{enumerable:true,get:function get(){return signaling.networkQualityStats}},sid:{enumerable:true,get:function get(){return signaling.sid}},state:{enumerable:true,get:function get(){return signaling.state}},tracks:{enumerable:true,value:tracks},trackPublications:{enumerable:true,value:new Map},videoTracks:{enumerable:true,value:videoTracks},videoTrackPublications:{enumerable:true,value:new Map}});_this.tracks.forEach(reemitTrackEvents.bind(null,_this));signaling.on("networkQualityLevelChanged",function(){return _this.emit("networkQualityLevelChanged",_this.networkQualityLevel,_this.networkQualityStats&&(_this.networkQualityStats.audio||_this.networkQualityStats.video)?_this.networkQualityStats:null)});reemitSignalingStateChangedEvents(_this,signaling);log.info("Created a new Participant"+(_this.identity?": "+_this.identity:""));return _this}_createClass(Participant,[{key:"_getTrackEvents",value:function _getTrackEvents(){return[["dimensionsChanged","trackDimensionsChanged"],["disabled","trackDisabled"],["enabled","trackEnabled"],["message","trackMessage"],["started","trackStarted"]]}},{key:"_getTrackPublicationEvents",value:function _getTrackPublicationEvents(){return[]}},{key:"toString",value:function toString(){return"[Participant #"+this._instanceId+": "+this.sid+"]"}},{key:"_addTrack",value:function _addTrack(track){var log=this._log;if(this.tracks.has(track._id)){return null}this.tracks.set(track._id,track);var tracksByKind={audio:this.audioTracks,video:this.videoTracks,data:this.dataTracks}[track.kind];tracksByKind.set(track._id,track);reemitTrackEvents(this,track);log.info("Added a new "+util.trackClass(track)+":",track._id);log.debug(util.trackClass(track)+":",track);this.emit("trackAdded",track);return track}},{key:"_addTrackPublication",value:function _addTrackPublication(publication){var log=this._log;if(this.trackPublications.has(publication.trackSid)){return null}this.trackPublications.set(publication.trackSid,publication);var trackPublicationsByKind={audio:this.audioTrackPublications,data:this.dataTrackPublications,video:this.videoTrackPublications}[publication.kind];trackPublicationsByKind.set(publication.trackSid,publication);reemitTrackPublicationEvents(this,publication);log.info("Added a new "+util.trackPublicationClass(publication)+":",publication.trackSid);log.debug(util.trackPublicationClass(publication)+":",publication);return publication}},{key:"_handleTrackSignalingEvents",value:function _handleTrackSignalingEvents(){var log=this._log;var self=this;if(this.state==="disconnected"){return}var RemoteAudioTrack=this._RemoteAudioTrack;var RemoteAudioTrackPublication=this._RemoteAudioTrackPublication;var RemoteVideoTrack=this._RemoteVideoTrack;var RemoteVideoTrackPublication=this._RemoteVideoTrackPublication;var RemoteDataTrack=this._RemoteDataTrack;var RemoteDataTrackPublication=this._RemoteDataTrackPublication;var signaling=this._signaling;function trackSignalingAdded(signaling){var RemoteTrackPublication={audio:RemoteAudioTrackPublication,data:RemoteDataTrackPublication,
            video:RemoteVideoTrackPublication}[signaling.kind];var publication=new RemoteTrackPublication(signaling,{log:log});self._addTrackPublication(publication);var isSubscribed=signaling.isSubscribed;if(isSubscribed){trackSignalingSubscribed(signaling)}self._trackSignalingUpdatedEventCallbacks.set(signaling.sid,function(){if(isSubscribed!==signaling.isSubscribed){isSubscribed=signaling.isSubscribed;if(isSubscribed){trackSignalingSubscribed(signaling);return}trackSignalingUnsubscribed(signaling)}});signaling.on("updated",self._trackSignalingUpdatedEventCallbacks.get(signaling.sid))}function trackSignalingRemoved(signaling){if(signaling.isSubscribed){signaling.setTrackTransceiver(null)}var updated=self._trackSignalingUpdatedEventCallbacks.get(signaling.sid);if(updated){signaling.removeListener("updated",updated);self._trackSignalingUpdatedEventCallbacks.delete(signaling.id)}var publication=self.trackPublications.get(signaling.sid);if(publication){self._removeTrackPublication(publication)}}function trackSignalingSubscribed(signaling){var RemoteTrack={audio:RemoteAudioTrack,video:RemoteVideoTrack,data:RemoteDataTrack}[signaling.kind];var publication=self.trackPublications.get(signaling.sid);var trackReceiver=signaling.trackTransceiver;if(!RemoteTrack||signaling.kind!==trackReceiver.kind){return}var track=signaling.kind==="data"?new RemoteTrack(trackReceiver,{log:log,name:signaling.name}):new RemoteTrack(trackReceiver,signaling.isEnabled,{log:log,name:signaling.name});self._addTrack(track,publication)}function trackSignalingUnsubscribed(signaling){var track=util.flatMap(self.tracks).find(function(track){return track.sid===signaling.sid});var publication=self.trackPublications.get(signaling.sid);if(track){self._removeTrack(track,publication)}}signaling.on("trackAdded",trackSignalingAdded);signaling.on("trackRemoved",trackSignalingRemoved);signaling.tracks.forEach(trackSignalingAdded);signaling.on("stateChanged",function stateChanged(state){if(state==="disconnected"){log.debug("Removing event listeners");signaling.removeListener("stateChanged",stateChanged);signaling.removeListener("trackAdded",trackSignalingAdded);signaling.removeListener("trackRemoved",trackSignalingRemoved)}})}},{key:"_deleteTrack",value:function _deleteTrack(track){this.tracks.delete(track._id);var tracksByKind={audio:this.audioTracks,video:this.videoTracks,data:this.dataTracks}[track.kind];tracksByKind.delete(track._id);var reemitters=this._trackEventReemitters.get(track._id)||new Map;reemitters.forEach(function(reemitter,event){track.removeListener(event,reemitter)});var log=this._log;log.info("Removed a "+util.trackClass(track)+":",track._id);log.debug(util.trackClass(track)+":",track)}},{key:"_removeTrack",value:function _removeTrack(track){if(!this.tracks.has(track._id)){return null}track=this.tracks.get(track._id);this._deleteTrack(track);this.emit("trackRemoved",track);return track}},{key:"_removeTrackPublication",value:function _removeTrackPublication(publication){publication=this.trackPublications.get(publication.trackSid);if(!publication){return null}this.trackPublications.delete(publication.trackSid);var trackPublicationsByKind={audio:this.audioTrackPublications,data:this.dataTrackPublications,video:this.videoTrackPublications}[publication.kind];trackPublicationsByKind.delete(publication.trackSid);var reemitters=this._trackPublicationEventReemitters.get(publication.trackSid)||new Map;reemitters.forEach(function(reemitter,event){publication.removeListener(event,reemitter)});var log=this._log;log.info("Removed a "+util.trackPublicationClass(publication)+":",publication.trackSid);log.debug(util.trackPublicationClass(publication)+":",publication);return publication}}]);return Participant}(EventEmitter);function indexTracksById(tracks){var indexedTracks=tracks.map(function(track){return[track._id,track]});var indexedAudioTracks=indexedTracks.filter(function(keyValue){return keyValue[1].kind==="audio"});var indexedVideoTracks=indexedTracks.filter(function(keyValue){return keyValue[1].kind==="video"});var indexedDataTracks=indexedTracks.filter(function(keyValue){return keyValue[1].kind==="data"});return{audioTracks:indexedAudioTracks,dataTracks:indexedDataTracks,tracks:indexedTracks,videoTracks:indexedVideoTracks}}function reemitSignalingStateChangedEvents(participant,signaling){var log=participant._log;if(participant.state==="disconnected"){return}signaling.on("stateChanged",function stateChanged(state){log.debug("Transitioned to state:",state);participant.emit(state,participant);if(state==="disconnected"){log.debug("Removing Track event reemitters");signaling.removeListener("stateChanged",stateChanged);participant.tracks.forEach(function(track){participant._trackEventReemitters.get(track._id).forEach(function(reemitter,event){track.removeListener(event,reemitter)})});participant._trackEventReemitters.clear();participant.trackPublications.forEach(function(publication){participant._trackPublicationEventReemitters.get(publication.trackSid).forEach(function(reemitter,event){publication.removeListener(event,reemitter)})});participant._trackPublicationEventReemitters.clear()}})}function reemitTrackEvents(participant,track){var trackEventReemitters=new Map;if(participant.state==="disconnected"){return}participant._getTrackEvents().forEach(function(eventPair){var trackEvent=eventPair[0];var participantEvent=eventPair[1];trackEventReemitters.set(trackEvent,function(){var args=[participantEvent].concat([].slice.call(arguments));return participant.emit.apply(participant,_toConsumableArray(args))});track.on(trackEvent,trackEventReemitters.get(trackEvent))});participant._trackEventReemitters.set(track._id,trackEventReemitters)}function reemitTrackPublicationEvents(participant,publication){var publicationEventReemitters=new Map;if(participant.state==="disconnected"){return}participant._getTrackPublicationEvents().forEach(function(_ref){var _ref2=_slicedToArray(_ref,2),publicationEvent=_ref2[0],participantEvent=_ref2[1];publicationEventReemitters.set(publicationEvent,function(){for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}participant.emit.apply(participant,[participantEvent].concat(args,[publication]))});publication.on(publicationEvent,publicationEventReemitters.get(publicationEvent))});participant._trackPublicationEventReemitters.set(publication.trackSid,publicationEventReemitters)}module.exports=Participant},{"./media/track/remoteaudiotrack":30,"./media/track/remoteaudiotrackpublication":31,"./media/track/remotedatatrack":32,"./media/track/remotedatatrackpublication":33,"./media/track/remotevideotrack":36,"./media/track/remotevideotrackpublication":37,"./util":109,events:179}],44:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var QueueingEventEmitter=function(_EventEmitter){_inherits(QueueingEventEmitter,_EventEmitter);function QueueingEventEmitter(){_classCallCheck(this,QueueingEventEmitter);var _this=_possibleConstructorReturn(this,(QueueingEventEmitter.__proto__||Object.getPrototypeOf(QueueingEventEmitter)).call(this));Object.defineProperties(_this,{_queuedEvents:{value:new Map}});return _this}_createClass(QueueingEventEmitter,[{key:"dequeue",value:function dequeue(event){var _this2=this;var result=true;if(!event){this._queuedEvents.forEach(function(_,queuedEvent){result=this.dequeue(queuedEvent)&&result},this);return result}var queue=this._queuedEvents.get(event)||[];this._queuedEvents.delete(event);return queue.reduce(function(result,args){return _this2.emit.apply(_this2,_toConsumableArray([event].concat(args)))&&result},result)}},{key:"queue",value:function queue(){var args=[].slice.call(arguments);if(this.emit.apply(this,_toConsumableArray(args))){return true}var event=args[0];if(!this._queuedEvents.has(event)){this._queuedEvents.set(event,[])}this._queuedEvents.get(event).push(args.slice(1));return false}}]);return QueueingEventEmitter}(EventEmitter);module.exports=QueueingEventEmitter},{events:179}],45:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var Participant=require("./participant");var _require=require("./util"),deprecateEvents=_require.deprecateEvents;var RemoteParticipant=function(_Participant){_inherits(RemoteParticipant,_Participant);function RemoteParticipant(signaling,options){_classCallCheck(this,RemoteParticipant);var _this=_possibleConstructorReturn(this,(RemoteParticipant.__proto__||Object.getPrototypeOf(RemoteParticipant)).call(this,signaling,options));deprecateEvents("RemoteParticipant",_this,new Map([["trackAdded","trackSubscribed"],["trackRemoved","trackUnsubscribed"]]),_this._log);_this._handleTrackSignalingEvents();_this.once("disconnected",_this._unsubscribeTracks.bind(_this));return _this}_createClass(RemoteParticipant,[{key:"toString",value:function toString(){return"[RemoteParticipant #"+this._instanceId+(this.sid?": "+this.sid:"")+"]"}},{key:"_addTrack",value:function _addTrack(remoteTrack,publication){remoteTrack._setSid(publication.trackSid);if(!_get(RemoteParticipant.prototype.__proto__||Object.getPrototypeOf(RemoteParticipant.prototype),"_addTrack",this).call(this,remoteTrack)){return null}publication._subscribed(remoteTrack);this.emit("trackSubscribed",remoteTrack);return remoteTrack}},{key:"_addTrackPublication",value:function _addTrackPublication(publication){var addedPublication=_get(RemoteParticipant.prototype.__proto__||Object.getPrototypeOf(RemoteParticipant.prototype),"_addTrackPublication",this).call(this,publication);if(!addedPublication){return null}this.emit("trackPublished",addedPublication);return addedPublication}},{key:"_getTrackPublicationEvents",value:function _getTrackPublicationEvents(){return[].concat(_toConsumableArray(_get(RemoteParticipant.prototype.__proto__||Object.getPrototypeOf(RemoteParticipant.prototype),"_getTrackPublicationEvents",this).call(this)),[["subscriptionFailed","trackSubscriptionFailed"]])}},{key:"_unsubscribeTracks",value:function _unsubscribeTracks(){var _this2=this;this.trackPublications.forEach(function(publication){if(publication.isSubscribed){var track=publication.track;publication._unsubscribe();_this2.emit("trackUnsubscribed",track)}})}},{key:"_removeTrack",value:function _removeTrack(remoteTrack,publication){var unsubscribedTrack=this.tracks.get(remoteTrack._id);if(!unsubscribedTrack){return null}this._deleteTrack(unsubscribedTrack);publication._unsubscribe();this.emit("trackUnsubscribed",unsubscribedTrack);this.emit("trackRemoved",unsubscribedTrack);return unsubscribedTrack}},{key:"_removeTrackPublication",value:function _removeTrackPublication(publication){var removedPublication=_get(RemoteParticipant.prototype.__proto__||Object.getPrototypeOf(RemoteParticipant.prototype),"_removeTrackPublication",this).call(this,publication);if(!removedPublication){return null}this.emit("trackUnpublished",removedPublication);return removedPublication}}]);return RemoteParticipant}(Participant);module.exports=RemoteParticipant},{"./participant":43,"./util":109}],46:[function(require,module,exports){"use strict";var XHR=require("xmlhttprequest").XMLHttpRequest;function request(method,params){return new Promise(function(resolve,reject){if(typeof method!=="string"||!params){throw new Error("<String>method and <Object>params are required args.")}var xhr=new XHR;xhr.open(method.toUpperCase(),params.url,true);xhr.withCredentials=!!params.withCredentials;xhr.onreadystatechange=function onreadystatechange(){if(xhr.readyState!==4){return}if(200<=xhr.status&&xhr.status<300){resolve(xhr.responseText)}else{reject(xhr.responseText)}};for(var headerName in params.headers){xhr.setRequestHeader(headerName,params.headers[headerName])}xhr.send(params.body)})}request.get=request.bind(null,"GET");request.post=request.bind(null,"POST");module.exports=request},{xmlhttprequest:186}],47:[function(require,module,exports){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var RemoteParticipant=require("./remoteparticipant");var StatsReport=require("./stats/statsreport");var _require=require("./util"),deprecateEvents=_require.deprecateEvents;var _require2=require("./util/twilio-video-errors"),MediaConnectionError=_require2.MediaConnectionError;var nInstances=0;var Room=function(_EventEmitter){_inherits(Room,_EventEmitter);function Room(localParticipant,signaling,options){_classCallCheck(this,Room);var _this=_possibleConstructorReturn(this,(Room.__proto__||Object.getPrototypeOf(Room)).call(this));var log=options.log.createLog("default",_this);var participants=new Map;Object.defineProperties(_this,{_log:{value:log},_instanceId:{value:++nInstances},_options:{value:options},_participants:{value:participants},_signaling:{value:signaling},dominantSpeaker:{enumerable:true,get:function get(){return this.participants.get(signaling.dominantSpeakerSid)||null}},isRecording:{enumerable:true,get:function get(){return signaling.recording.isEnabled||false}},localParticipant:{enumerable:true,value:localParticipant},name:{enumerable:true,value:signaling.name},participants:{enumerable:true,value:participants},sid:{enumerable:true,value:signaling.sid},state:{enumerable:true,get:function get(){return signaling.state}}});deprecateEvents("Room",_this,new Map([["trackAdded","trackSubscribed"],["trackRemoved","trackUnsubscribed"]]),log);handleRecordingEvents(_this,signaling.recording);handleSignalingEvents(_this,signaling);log.info("Created a new Room:",_this.name);log.debug("Initial RemoteParticipants:",Array.from(_this._participants.values()));return _this}_createClass(Room,[{key:"toString",value:function toString(){return"[Room #"+this._instanceId+": "+this.sid+"]"}},{key:"disconnect",value:function disconnect(){this._log.info("Disconnecting");this._signaling.disconnect();return this}},{key:"getStats",value:function getStats(){return this._signaling.getStats().then(function(responses){return Array.from(responses).map(function(_ref){var _ref2=_slicedToArray(_ref,2),id=_ref2[0],response=_ref2[1];return new StatsReport(id,response)})})}}]);return Room}(EventEmitter);function connectParticipant(room,participantSignaling){var log=room._log;var participant=new RemoteParticipant(participantSignaling,{log:log});log.info("A new RemoteParticipant connected:",participant);room._participants.set(participant.sid,participant);room.emit("participantConnected",participant);var eventListeners=[["trackSubscribed","trackAdded"],"trackDimensionsChanged","trackDisabled","trackEnabled","trackMessage","trackPublished",["trackUnsubscribed","trackRemoved"],"trackStarted","trackSubscribed","trackSubscriptionFailed","trackUnpublished","trackUnsubscribed"].map(function(eventOrEventPair){var participantEvent=typeof eventOrEventPair==="string"?eventOrEventPair:eventOrEventPair[0];var roomEvent=typeof eventOrEventPair==="string"?eventOrEventPair:eventOrEventPair[1];function reemit(){var args=[].slice.call(arguments);args.unshift(roomEvent);args.push(participant);room.emit.apply(room,_toConsumableArray(args))}participant.on(participantEvent,reemit);return[participantEvent,reemit]});participant.once("disconnected",function participantDisconnected(){var dominantSpeaker=room.dominantSpeaker;log.info("RemoteParticipant disconnected:",participant);room._participants.delete(participant.sid);eventListeners.forEach(function(args){participant.removeListener(args[0],args[1])});room.emit("participantDisconnected",participant);if(participant===dominantSpeaker){room.emit("dominantSpeakerChanged",room.dominantSpeaker)}})}function handleRecordingEvents(room,recording){recording.on("updated",function updated(){var started=recording.isEnabled;room._log.info("Recording "+(started?"started":"stopped"));room.emit("recording"+(started?"Started":"Stopped"))})}function handleSignalingEvents(room,signaling){var log=room._log;log.debug("Creating a new RemoteParticipant for each ParticipantSignaling "+"in the RoomSignaling");signaling.participants.forEach(connectParticipant.bind(null,room));log.debug("Setting up RemoteParticipant creation for all subsequent "+"ParticipantSignalings that connect to the RoomSignaling");signaling.on("participantConnected",connectParticipant.bind(null,room));signaling.on("dominantSpeakerChanged",function(){return room.emit("dominantSpeakerChanged",room.dominantSpeaker)});signaling.on("stateChanged",function stateChanged(state,error){log.info("Transitioned to state:",state);switch(state){case"disconnected":room.participants.forEach(function(participant){participant._unsubscribeTracks()});room.emit(state,room,error);signaling.removeListener("stateChanged",stateChanged);break;case"reconnecting":room.emit("reconnecting",new MediaConnectionError);break;default:room.emit("reconnected")}})}module.exports=Room},{"./remoteparticipant":45,"./stats/statsreport":101,"./util":109,"./util/twilio-video-errors":121,events:179}],48:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var ParticipantSignaling=require("./participant");var RoomSignaling=require("./room");var StateMachine=require("../statemachine");var states={closed:["opening"],opening:["closed","open"],open:["closed","closing"],closing:["closed","open"]};var Signaling=function(_StateMachine){_inherits(Signaling,_StateMachine);function Signaling(){_classCallCheck(this,Signaling);return _possibleConstructorReturn(this,(Signaling.__proto__||Object.getPrototypeOf(Signaling)).call(this,"closed",states))}_createClass(Signaling,[{key:"_close",value:function _close(key){this.transition("closing",key);this.transition("closed",key);return Promise.resolve(this)}},{key:"_connect",value:function _connect(localParticipant,token,iceServerSource,encodingParameters,preferredCodecs,options){localParticipant.connect("PA00000000000000000000000000000000","test");var sid="RM00000000000000000000000000000000";var promise=Promise.resolve(new RoomSignaling(localParticipant,sid,options));promise.cancel=function cancel(){};return promise}},{key:"_open",value:function _open(key){this.transition("opening",key);this.transition("open",key);return Promise.resolve(this)}},{key:"close",value:function close(){var _this2=this;return this.bracket("close",function(key){switch(_this2.state){case"closed":return _this2;case"open":return _this2._close(key);default:throw new Error('Unexpected Signaling state "'+_this2.state+'"')}})}},{key:"connect",value:function connect(localParticipant,token,iceServerSource,encodingParameters,preferredCodecs,options){var self=this;return this.bracket("connect",function transition(key){switch(self.state){case"closed":return self._open(key).then(transition.bind(null,key));case"open":self.releaseLockCompletely(key);return self._connect(localParticipant,token,iceServerSource,encodingParameters,preferredCodecs,options);default:throw new Error('Unexpected Signaling state "'+self.state+'"')}})}},{key:"createLocalParticipantSignaling",value:function createLocalParticipantSignaling(){return new ParticipantSignaling}},{key:"open",value:function open(){var _this3=this;return this.bracket("open",function(key){switch(_this3.state){case"closed":return _this3._open(key);case"open":return _this3;default:throw new Error('Unexpected Signaling state "'+_this3.state+'"')}})}}]);return Signaling}(StateMachine);module.exports=Signaling},{"../statemachine":73,"./participant":50,"./room":54}],49:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TrackSignaling=require("./track");var LocalTrackPublicationSignaling=function(_TrackSignaling){_inherits(LocalTrackPublicationSignaling,_TrackSignaling);function LocalTrackPublicationSignaling(trackSender,name){_classCallCheck(this,LocalTrackPublicationSignaling);var enabled=trackSender.kind==="data"?true:trackSender.track.enabled;var _this=_possibleConstructorReturn(this,(LocalTrackPublicationSignaling.__proto__||Object.getPrototypeOf(LocalTrackPublicationSignaling)).call(this,name,trackSender.kind,enabled));_this.setTrackTransceiver(trackSender);Object.defineProperties(_this,{_error:{value:null,writable:true},error:{enumerable:true,get:function get(){return this._error}},id:{enumerable:true,value:trackSender.id}});return _this}_createClass(LocalTrackPublicationSignaling,[{key:"publishFailed",value:function publishFailed(error){if(setError(this,error)){this.emit("updated")}return this}},{key:"setSid",value:function setSid(sid){if(this._error){return this}return _get(LocalTrackPublicationSignaling.prototype.__proto__||Object.getPrototypeOf(LocalTrackPublicationSignaling.prototype),"setSid",this).call(this,sid)}}]);return LocalTrackPublicationSignaling}(TrackSignaling);function setError(publication,error){if(publication._sid!==null||publication._error){return false}publication._error=error;return true}module.exports=LocalTrackPublicationSignaling},{"./track":55}],50:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var StateMachine=require("../statemachine");var NetworkQualityStats=require("../stats/networkqualitystats");var states={connecting:["connected"],connected:["disconnected"],disconnected:[]};var ParticipantSignaling=function(_StateMachine){_inherits(ParticipantSignaling,_StateMachine);function ParticipantSignaling(){_classCallCheck(this,ParticipantSignaling);var _this=_possibleConstructorReturn(this,(ParticipantSignaling.__proto__||Object.getPrototypeOf(ParticipantSignaling)).call(this,"connecting",states));Object.defineProperties(_this,{_identity:{writable:true,value:null},_networkQualityLevel:{value:null,writable:true},_networkQualityStats:{value:null,writable:true},_sid:{writable:true,value:null},identity:{enumerable:true,get:function get(){return this._identity}},sid:{enumerable:true,get:function get(){return this._sid}},tracks:{enumerable:true,value:new Map}});return _this}_createClass(ParticipantSignaling,[{key:"addTrack",value:function addTrack(track){this.tracks.set(track.id||track.sid,track);this.emit("trackAdded",track);return this}},{key:"disconnect",value:function disconnect(){if(this.state!=="disconnected"){this.preempt("disconnected");return true}return false}},{key:"removeTrack",value:function removeTrack(track){var didDelete=this.tracks.delete(track.id||track.sid);if(didDelete){this.emit("trackRemoved",track)}return didDelete}},{key:"setNetworkQualityLevel",
        value:function setNetworkQualityLevel(networkQualityLevel,networkQualityLevels){if(this._networkQualityLevel!==networkQualityLevel){this._networkQualityLevel=networkQualityLevel;this._networkQualityStats=networkQualityLevels&&(networkQualityLevels.audio||networkQualityLevels.video)?new NetworkQualityStats(networkQualityLevels):null;this.emit("networkQualityLevelChanged")}}},{key:"connect",value:function connect(sid,identity){if(this.state==="connecting"){this._sid=sid;this._identity=identity;this.preempt("connected");return true}return false}},{key:"networkQualityLevel",get:function get(){return this._networkQualityLevel}},{key:"networkQualityStats",get:function get(){return this._networkQualityStats}}]);return ParticipantSignaling}(StateMachine);module.exports=ParticipantSignaling},{"../statemachine":73,"../stats/networkqualitystats":88}],51:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var RecordingSignaling=function(_EventEmitter){_inherits(RecordingSignaling,_EventEmitter);function RecordingSignaling(){_classCallCheck(this,RecordingSignaling);var _this=_possibleConstructorReturn(this,(RecordingSignaling.__proto__||Object.getPrototypeOf(RecordingSignaling)).call(this));Object.defineProperties(_this,{_isEnabled:{value:null,writable:true},isEnabled:{enumerable:true,get:function get(){return this._isEnabled}}});return _this}_createClass(RecordingSignaling,[{key:"disable",value:function disable(){return this.enable(false)}},{key:"enable",value:function enable(enabled){enabled=typeof enabled==="boolean"?enabled:true;if(this.isEnabled!==enabled){this._isEnabled=enabled;this.emit("updated")}return this}}]);return RecordingSignaling}(EventEmitter);module.exports=RecordingSignaling},{events:179}],52:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var ParticipantSignaling=require("./participant");var RemoteParticipantSignaling=function(_ParticipantSignaling){_inherits(RemoteParticipantSignaling,_ParticipantSignaling);function RemoteParticipantSignaling(sid,identity){_classCallCheck(this,RemoteParticipantSignaling);var _this=_possibleConstructorReturn(this,(RemoteParticipantSignaling.__proto__||Object.getPrototypeOf(RemoteParticipantSignaling)).call(this));_this.connect(sid,identity);return _this}return RemoteParticipantSignaling}(ParticipantSignaling);module.exports=RemoteParticipantSignaling},{"./participant":50}],53:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TrackSignaling=require("./track");var RemoteTrackPublicationSignaling=function(_TrackSignaling){_inherits(RemoteTrackPublicationSignaling,_TrackSignaling);function RemoteTrackPublicationSignaling(sid,name,kind,isEnabled){_classCallCheck(this,RemoteTrackPublicationSignaling);var _this=_possibleConstructorReturn(this,(RemoteTrackPublicationSignaling.__proto__||Object.getPrototypeOf(RemoteTrackPublicationSignaling)).call(this,name,kind,isEnabled));Object.defineProperties(_this,{_error:{value:null,writable:true}});_this.setSid(sid);return _this}_createClass(RemoteTrackPublicationSignaling,[{key:"subscribeFailed",value:function subscribeFailed(error){if(!this.error){this._error=error;this.emit("updated")}return this}},{key:"error",get:function get(){return this._error}},{key:"isSubscribed",get:function get(){return!!this.trackTransceiver}}]);return RemoteTrackPublicationSignaling}(TrackSignaling);module.exports=RemoteTrackPublicationSignaling},{"./track":55}],54:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var DefaultRecordingSignaling=require("./recording");var StateMachine=require("../statemachine");var states={connected:["reconnecting","disconnected"],reconnecting:["connected","disconnected"],disconnected:[]};var RoomSignaling=function(_StateMachine){_inherits(RoomSignaling,_StateMachine);function RoomSignaling(localParticipant,sid,name,options){_classCallCheck(this,RoomSignaling);options=Object.assign({RecordingSignaling:DefaultRecordingSignaling},options);var _this=_possibleConstructorReturn(this,(RoomSignaling.__proto__||Object.getPrototypeOf(RoomSignaling)).call(this,"connected",states));var RecordingSignaling=options.RecordingSignaling;Object.defineProperties(_this,{_mediaConnectionIsReconnecting:{writable:true,value:false},_options:{value:options},dominantSpeakerSid:{enumerable:true,value:null,writable:true},localParticipant:{enumerable:true,value:localParticipant},name:{enumerable:true,value:name},participants:{enumerable:true,value:new Map},recording:{enumerable:true,value:new RecordingSignaling},sid:{enumerable:true,value:sid}});_this.on("mediaConnectionStateChanged",function(){return maybeUpdateState(_this)});_this.on("signalingConnectionStateChanged",function(){return maybeUpdateState(_this)});return _this}_createClass(RoomSignaling,[{key:"_disconnect",value:function _disconnect(error){if(this.state!=="disconnected"){this.preempt("disconnected",null,[error]);return true}return false}},{key:"connectParticipant",value:function connectParticipant(participant){var self=this;if(participant.state==="disconnected"){return false}if(this.participants.has(participant.sid)){return false}this.participants.set(participant.sid,participant);participant.on("stateChanged",function stateChanged(state){if(state==="disconnected"){participant.removeListener("stateChanged",stateChanged);self.participants.delete(participant.sid);self.emit("participantDisconnected",participant)}});this.emit("participantConnected",participant);return true}},{key:"disconnect",value:function disconnect(){return this._disconnect()}},{key:"setDominantSpeaker",value:function setDominantSpeaker(dominantSpeakerSid){this.dominantSpeakerSid=dominantSpeakerSid;this.emit("dominantSpeakerChanged")}}]);return RoomSignaling}(StateMachine);function maybeUpdateState(roomSignaling){if(roomSignaling.state==="disconnected"||roomSignaling.signalingConnectionState==="disconnected"){return}var newState=void 0;if(roomSignaling.signalingConnectionState==="reconnecting"){newState=roomSignaling.signalingConnectionState}else if(roomSignaling.mediaConnectionState==="failed"){roomSignaling._mediaConnectionIsReconnecting=true;newState="reconnecting"}else if(roomSignaling.mediaConnectionState==="new"||roomSignaling.mediaConnectionState==="checking"){newState=roomSignaling._mediaConnectionIsReconnecting?"reconnecting":"connected"}else{roomSignaling._mediaConnectionIsReconnecting=false;newState="connected"}if(newState===roomSignaling.state){return}roomSignaling.preempt(newState)}module.exports=RoomSignaling},{"../statemachine":73,"./recording":51}],55:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("events"),EventEmitter=_require.EventEmitter;var TrackSignaling=function(_EventEmitter){_inherits(TrackSignaling,_EventEmitter);function TrackSignaling(name,kind,isEnabled){_classCallCheck(this,TrackSignaling);var _this=_possibleConstructorReturn(this,(TrackSignaling.__proto__||Object.getPrototypeOf(TrackSignaling)).call(this));var sid=null;Object.defineProperties(_this,{_isEnabled:{value:isEnabled,writable:true},_trackTransceiver:{value:null,writable:true},_sid:{get:function get(){return sid},set:function set(_sid){if(sid===null){sid=_sid}}},kind:{enumerable:true,value:kind},name:{enumerable:true,value:name}});return _this}_createClass(TrackSignaling,[{key:"disable",value:function disable(){return this.enable(false)}},{key:"enable",value:function enable(enabled){enabled=typeof enabled==="boolean"?enabled:true;if(this.isEnabled!==enabled){this._isEnabled=enabled;this.emit("updated")}return this}},{key:"setTrackTransceiver",value:function setTrackTransceiver(trackTransceiver){trackTransceiver=trackTransceiver||null;if(this.trackTransceiver!==trackTransceiver){this._trackTransceiver=trackTransceiver;this.emit("updated")}return this}},{key:"setSid",value:function setSid(sid){if(this.sid===null){this._sid=sid;this.emit("updated")}return this}},{key:"isEnabled",get:function get(){return this._isEnabled}},{key:"sid",get:function get(){return this._sid}},{key:"trackTransceiver",get:function get(){return this._trackTransceiver}}]);return TrackSignaling}(EventEmitter);module.exports=TrackSignaling},{events:179}],56:[function(require,module,exports){"use strict";var CancelablePromise=require("../../util/cancelablepromise");var DefaultPeerConnectionManager=require("./peerconnectionmanager");var DefaultRoomV2=require("./room");var DefaultTransport=require("./transport");var SignalingConnectionDisconnectedError=require("../../util/twilio-video-errors").SignalingConnectionDisconnectedError;var SignalingIncomingMessageInvalidError=require("../../util/twilio-video-errors").SignalingIncomingMessageInvalidError;var flatMap=require("../../util").flatMap;function createCancelableRoomSignalingPromise(token,ua,localParticipant,iceServerSource,encodingParameters,preferredCodecs,options){options=Object.assign({PeerConnectionManager:DefaultPeerConnectionManager,RoomV2:DefaultRoomV2,Transport:DefaultTransport},options);var transport=void 0;var PeerConnectionManager=options.PeerConnectionManager;var RoomV2=options.RoomV2;var peerConnectionManager=new PeerConnectionManager(iceServerSource,encodingParameters,preferredCodecs,options);var trackSenders=flatMap(localParticipant.tracks,function(trackV2){return[trackV2.trackTransceiver]});peerConnectionManager.setConfiguration(options);peerConnectionManager.setTrackSenders(trackSenders);var cancelationError=new Error("Canceled");return new CancelablePromise(function onCreate(resolve,reject,isCanceled){peerConnectionManager.createAndOffer().then(function createAndOfferSucceeded(){peerConnectionManager.dequeue("description");return new Promise(function(resolve,reject){if(isCanceled()){reject(cancelationError);return}var transportOptions=typeof options.wsServerInsights==="string"?{wsServerInsights:options.wsServerInsights}:{};if(options.InsightsPublisher){transportOptions.InsightsPublisher=options.InsightsPublisher}if(options.NullInsightsPublisher){transportOptions.NullInsightsPublisher=options.NullInsightsPublisher}transportOptions=Object.assign({dominantSpeaker:options.dominantSpeaker,environment:options.environment,networkQuality:options.networkQuality,iceServerSourceStatus:iceServerSource.status,insights:options.insights,realm:options.realm},transportOptions);var Transport=options.Transport;transport=new Transport(options.name,token,localParticipant,peerConnectionManager,ua,transportOptions);transport.once("connected",function connected(initialState){if(isCanceled()){reject(cancelationError);return}var localParticipantState=initialState.participant;if(!localParticipantState){reject(new SignalingIncomingMessageInvalidError);return}resolve(new RoomV2(localParticipant,initialState,transport,peerConnectionManager,options))});transport.once("stateChanged",function stateChanged(state,error){if(state==="disconnected"){error=error||new SignalingConnectionDisconnectedError;transport=null;reject(error)}})})}).then(function createRoomSignalingSucceeded(roomSignaling){if(isCanceled()){peerConnectionManager.close();roomSignaling.disconnect();reject(cancelationError);return}resolve(roomSignaling)}).catch(function onError(error){if(transport){transport.disconnect();transport=null}peerConnectionManager.close();reject(error)})},function onCancel(){if(transport){transport.disconnect();transport=null}})}module.exports=createCancelableRoomSignalingPromise},{"../../util":109,"../../util/cancelablepromise":106,"../../util/twilio-video-errors":121,"./peerconnectionmanager":65,"./room":69,"./transport":71}],57:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("events"),EventEmitter=_require.EventEmitter;var DominantSpeakerSignaling=function(_EventEmitter){_inherits(DominantSpeakerSignaling,_EventEmitter);function DominantSpeakerSignaling(mediaSignalingTransport){_classCallCheck(this,DominantSpeakerSignaling);var _this=_possibleConstructorReturn(this,(DominantSpeakerSignaling.__proto__||Object.getPrototypeOf(DominantSpeakerSignaling)).call(this));Object.defineProperties(_this,{_loudestParticipantSid:{value:null,writable:true}});mediaSignalingTransport.on("message",function(message){switch(message.type){case"active_speaker":_this._setLoudestParticipantSid(message.participant);break;default:break}});return _this}_createClass(DominantSpeakerSignaling,[{key:"_setLoudestParticipantSid",value:function _setLoudestParticipantSid(loudestParticipantSid){if(this.loudestParticipantSid===loudestParticipantSid){return}this._loudestParticipantSid=loudestParticipantSid;this.emit("updated")}},{key:"loudestParticipantSid",get:function get(){return this._loudestParticipantSid}}]);return DominantSpeakerSignaling}(EventEmitter);module.exports=DominantSpeakerSignaling},{events:179}],58:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var Filter=require("../../util/filter");var IceBox=function(){function IceBox(){_classCallCheck(this,IceBox);Object.defineProperties(this,{_filter:{value:new Filter({getKey:function getKey(iceState){return iceState.ufrag},isLessThanOrEqualTo:function isLessThanOrEqualTo(a,b){return a.revision<=b.revision}})},_ufrag:{writable:true,value:null},ufrag:{enumerable:true,get:function get(){return this._ufrag}}})}_createClass(IceBox,[{key:"setUfrag",value:function setUfrag(ufrag){this._ufrag=ufrag;var ice=this._filter.toMap().get(ufrag);return ice?ice.candidates:[]}},{key:"update",value:function update(iceState){iceState.candidates=iceState.candidates||[];var oldIceState=this._filter.toMap().get(iceState.ufrag);var oldCandidates=oldIceState?oldIceState.candidates:[];return this._filter.update(iceState)&&this._ufrag===iceState.ufrag?iceState.candidates.slice(oldCandidates.length):[]}}]);return IceBox}();module.exports=IceBox},{"../../util/filter":108}],59:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var constants=require("../../util/constants");var defaultCreateCancelableRoomSignalingPromise=require("./cancelableroomsignalingpromise");var LocalParticipantV2=require("./localparticipant");var Signaling=require("../");var SIP=require("../../sip");var SIPJSMediaHandler=require("./sipjsmediahandler");var util=require("../../util");var SignalingV2=function(_Signaling){_inherits(SignalingV2,_Signaling);function SignalingV2(wsServer,options){_classCallCheck(this,SignalingV2);var uri=util.makeClientSIPURI();options=Object.assign({createCancelableRoomSignalingPromise:defaultCreateCancelableRoomSignalingPromise,registrarServer:constants.REGISTRAR_SERVER,UA:SIP.UA},options);var debug=options.logLevel==="debug";var useWssHack=wsServer.startsWith("wss://");var UA=options.UA;var ua=new UA({autostart:false,log:{builtinEnabled:debug},extraSupported:["room-signaling","timer"],hackAllowUnregisteredOptionTags:true,keepAliveInterval:30,mediaHandlerFactory:SIPJSMediaHandler.defaultFactory,register:false,registrarServer:options.registrarServer,traceSip:debug,uri:uri,wsServers:wsServer,hackWssInTransport:useWssHack});var _this=_possibleConstructorReturn(this,(SignalingV2.__proto__||Object.getPrototypeOf(SignalingV2)).call(this));Object.defineProperties(_this,{_createCancelableRoomSignalingPromise:{value:options.createCancelableRoomSignalingPromise},_options:{value:options},_ua:{value:ua}});return _this}_createClass(SignalingV2,[{key:"_close",value:function _close(key){this.transition("closing",key);this._ua.stop();this._ua.transport.disconnect();this.transition("closed",key);return Promise.resolve(this)}},{key:"_open",value:function _open(key){var _this2=this;var ua=this._ua;function startUA(){ua.start()}this.transition("opening",key);return util.promiseFromEvents(startUA,ua,"connected","disconnected").then(function(){_this2.transition("open",key);return _this2},function(){_this2.transition("closed",key);throw new Error("Open failed")})}},{key:"_connect",value:function _connect(localParticipant,token,iceServerSource,encodingParameters,preferredCodecs,options){options=Object.assign({},this._options,options);var ua=this._ua;return this._createCancelableRoomSignalingPromise.bind(null,token,ua,localParticipant,iceServerSource,encodingParameters,preferredCodecs,options)}},{key:"createLocalParticipantSignaling",value:function createLocalParticipantSignaling(encodingParameters,networkQualityConfiguration){return new LocalParticipantV2(encodingParameters,networkQualityConfiguration)}}]);return SignalingV2}(Signaling);module.exports=SignalingV2},{"../":48,"../../sip":72,"../../util":109,"../../util/constants":107,"./cancelableroomsignalingpromise":56,"./localparticipant":60,"./sipjsmediahandler":70}],60:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var ParticipantSignaling=require("../participant");var LocalTrackPublicationV2=require("./localtrackpublication");var LocalParticipantV2=function(_ParticipantSignaling){_inherits(LocalParticipantV2,_ParticipantSignaling);function LocalParticipantV2(encodingParameters,networkQualityConfiguration,options){_classCallCheck(this,LocalParticipantV2);options=Object.assign({LocalTrackPublicationV2:LocalTrackPublicationV2},options);var _this=_possibleConstructorReturn(this,(LocalParticipantV2.__proto__||Object.getPrototypeOf(LocalParticipantV2)).call(this));Object.defineProperties(_this,{_encodingParameters:{value:encodingParameters},_removeListeners:{value:new Map},_LocalTrackPublicationV2:{value:options.LocalTrackPublicationV2},_publishedRevision:{writable:true,value:0},_revision:{writable:true,value:1},networkQualityConfiguration:{enumerable:true,value:networkQualityConfiguration},revision:{enumerable:true,get:function get(){return this._revision}}});return _this}_createClass(LocalParticipantV2,[{key:"setParameters",value:function setParameters(encodingParameters){this._encodingParameters.update(encodingParameters);return this}},{key:"update",value:function update(published){if(this._publishedRevision>=published.revision){return this}this._publishedRevision=published.revision;published.tracks.forEach(function(publicationState){var localTrackPublicationV2=this.tracks.get(publicationState.id);if(localTrackPublicationV2){localTrackPublicationV2.update(publicationState)}},this);return this}},{key:"addTrack",value:function addTrack(trackSender,name){var _this2=this;var publication=new this._LocalTrackPublicationV2(trackSender,name);_get(LocalParticipantV2.prototype.__proto__||Object.getPrototypeOf(LocalParticipantV2.prototype),"addTrack",this).call(this,publication);var sid=publication.sid;var updated=function updated(){if(sid===publication.sid){_this2.didUpdate();return}sid=publication.sid};publication.on("updated",updated);this._removeListener(publication);this._removeListeners.set(publication,function(){return publication.removeListener("updated",updated)});this.didUpdate();return this}},{key:"_removeListener",value:function _removeListener(publication){var removeListener=this._removeListeners.get(publication);if(removeListener){removeListener()}}},{key:"getState",value:function getState(){return{revision:this.revision,tracks:Array.from(this.tracks.values()).map(function(track){return track.getState()})}}},{key:"didUpdate",value:function didUpdate(){this._revision++;this.emit("updated")}},{key:"removeTrack",value:function removeTrack(trackSender){var publication=this.tracks.get(trackSender.id);if(!publication){return false}var didDelete=_get(LocalParticipantV2.prototype.__proto__||Object.getPrototypeOf(LocalParticipantV2.prototype),"removeTrack",this).call(this,publication);if(didDelete){this._removeListener(publication);this.didUpdate()}return didDelete}},{key:"setNetworkQualityConfiguration",value:function setNetworkQualityConfiguration(networkQualityConfiguration){this.networkQualityConfiguration.update(networkQualityConfiguration)}}]);return LocalParticipantV2}(ParticipantSignaling);module.exports=LocalParticipantV2},{"../participant":50,"./localtrackpublication":61}],61:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{
        constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var LocalTrackPublicationSignaling=require("../localtrackpublication");var createTwilioError=require("../../util/twilio-video-errors").createTwilioError;var LocalTrackPublicationV2=function(_LocalTrackPublicatio){_inherits(LocalTrackPublicationV2,_LocalTrackPublicatio);function LocalTrackPublicationV2(trackSender,name){_classCallCheck(this,LocalTrackPublicationV2);return _possibleConstructorReturn(this,(LocalTrackPublicationV2.__proto__||Object.getPrototypeOf(LocalTrackPublicationV2)).call(this,trackSender,name))}_createClass(LocalTrackPublicationV2,[{key:"getState",value:function getState(){return{enabled:this.isEnabled,id:this.id,kind:this.kind,name:this.name}}},{key:"update",value:function update(track){switch(track.state){case"ready":this.setSid(track.sid);break;case"failed":{var error=track.error;this.publishFailed(createTwilioError(error.code,error.message));break}default:break}return this}}]);return LocalTrackPublicationV2}(LocalTrackPublicationSignaling);module.exports=LocalTrackPublicationV2},{"../../util/twilio-video-errors":121,"../localtrackpublication":49}],62:[function(require,module,exports){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events");var PeerConnectionReportFactory=require("../../stats/peerconnectionreportfactory");var NetworkQualityMonitor=function(_EventEmitter){_inherits(NetworkQualityMonitor,_EventEmitter);function NetworkQualityMonitor(manager,signaling){_classCallCheck(this,NetworkQualityMonitor);var _this=_possibleConstructorReturn(this,(NetworkQualityMonitor.__proto__||Object.getPrototypeOf(NetworkQualityMonitor)).call(this));Object.defineProperties(_this,{_factories:{value:new WeakMap},_manager:{value:manager},_signaling:{value:signaling}});signaling.on("updated",function(){return _this.emit("updated")});return _this}_createClass(NetworkQualityMonitor,[{key:"start",value:function start(){var _this2=this;this.stop();var timeout=setTimeout(function(){if(_this2._timeout!==timeout){return}next(_this2).then(function(reports){if(_this2._timeout!==timeout){return}if(reports.length){var _reports=_slicedToArray(reports,1),report=_reports[0];_this2._signaling.put(report)}_this2.start()})},200);this._timeout=timeout}},{key:"stop",value:function stop(){clearTimeout(this._timeout);this._timeout=null}},{key:"level",get:function get(){return this._signaling.level}},{key:"levels",get:function get(){return this._signaling.levels}},{key:"remoteLevels",get:function get(){return this._signaling.remoteLevels}}]);return NetworkQualityMonitor}(EventEmitter);function next(monitor){var pcv2s=monitor._manager._peerConnections?Array.from(monitor._manager._peerConnections.values()):[];var pcs=pcv2s.map(function(pcv2){return pcv2._peerConnection}).filter(function(pc){return pc.signalingState!=="closed"});var factories=pcs.map(function(pc){if(monitor._factories.has(pc)){return monitor._factories.get(pc)}var factory=new PeerConnectionReportFactory(pc);monitor._factories.set(pc,factory);return factory});var reportsOrNullPromises=factories.map(function(factory){return factory.next().catch(function(){return null})});return Promise.all(reportsOrNullPromises).then(function(reportsOrNull){return reportsOrNull.filter(function(reportOrNull){return reportOrNull}).map(function(report){return report.summarize()})})}module.exports=NetworkQualityMonitor},{"../../stats/peerconnectionreportfactory":91,events:179}],63:[function(require,module,exports){"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("events"),EventEmitter=_require.EventEmitter;var AsyncVar=require("../../util/asyncvar");var NetworkQualitySignaling=function(_EventEmitter){_inherits(NetworkQualitySignaling,_EventEmitter);function NetworkQualitySignaling(mediaSignalingTransport,networkQualityConfiguration){_classCallCheck(this,NetworkQualitySignaling);var _this=_possibleConstructorReturn(this,(NetworkQualitySignaling.__proto__||Object.getPrototypeOf(NetworkQualitySignaling)).call(this));Object.defineProperties(_this,{_level:{value:null,writable:true},_levels:{value:null,writable:true},_remoteLevels:{value:new Map,writable:true},_mediaSignalingTransport:{value:mediaSignalingTransport},_networkQualityInputs:{value:new AsyncVar},_networkQualityReportLevels:{get:function get(){return{reportLevel:networkQualityConfiguration.local,remoteReportLevel:networkQualityConfiguration.remote}}}});mediaSignalingTransport.on("message",function(message){switch(message.type){case"network_quality":_this._handleNetworkQualityMessage(message);break;default:break}});_this._sendNetworkQualityInputs();return _this}_createClass(NetworkQualitySignaling,[{key:"_handleNetworkQualityMessage",value:function _handleNetworkQualityMessage(message){var _this2=this;var updated=false;var level=null;var local=message?message.local:null;if(typeof local==="number"){level=local;this._levels=null}else if((typeof local==="undefined"?"undefined":_typeof(local))==="object"&&local){this._levels=local;level=typeof local.level==="number"?local.level:Math.min(local.audio.send,local.audio.recv,local.video.send,local.video.recv)}if(level!==null&&this.level!==level){this._level=level;updated=true}this._remoteLevels=message&&message.remotes?message.remotes.reduce(function(levels,obj){var oldObj=_this2._remoteLevels.get(obj.sid)||{};if(oldObj.level!==obj.level){updated=true}return levels.set(obj.sid,obj)},new Map):this._remoteLevels;if(updated){this.emit("updated")}setTimeout(function(){return _this2._sendNetworkQualityInputs()},1e3)}},{key:"_sendNetworkQualityInputs",value:function _sendNetworkQualityInputs(){var _this3=this;return this._networkQualityInputs.take().then(function(networkQualityInputs){_this3._mediaSignalingTransport.publish(createNetworkQualityInputsMessage(networkQualityInputs,_this3._networkQualityReportLevels))})}},{key:"put",value:function put(networkQualityInputs){this._networkQualityInputs.put(networkQualityInputs)}},{key:"level",get:function get(){return this._level}},{key:"levels",get:function get(){return this._levels}},{key:"remoteLevels",get:function get(){return this._remoteLevels}}]);return NetworkQualitySignaling}(EventEmitter);function createNetworkQualityInputsMessage(networkQualityInputs,networkQualityReportLevels){return Object.assign({type:"network_quality"},networkQualityInputs,networkQualityReportLevels)}module.exports=NetworkQualitySignaling},{"../../util/asyncvar":105,events:179}],64:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("@twilio/webrtc"),DefaultMediaStream=_require.MediaStream,DefaultRTCIceCandidate=_require.RTCIceCandidate,DefaultRTCPeerConnection=_require.RTCPeerConnection,DefaultRTCSessionDescription=_require.RTCSessionDescription,getStatistics=_require.getStats;var _require2=require("@twilio/webrtc/lib/util"),guessBrowser=_require2.guessBrowser;var _require3=require("@twilio/webrtc/lib/util/sdp"),getSdpFormat=_require3.getSdpFormat;var _require4=require("../../util/constants"),DEFAULT_LOG_LEVEL=_require4.DEFAULT_LOG_LEVEL;var _require5=require("../../util/sdp"),createCodecMapForMediaSection=_require5.createCodecMapForMediaSection,getMediaSections=_require5.getMediaSections,setBitrateParameters=_require5.setBitrateParameters,setCodecPreferences=_require5.setCodecPreferences,setSimulcast=_require5.setSimulcast,unifiedPlanAddOrRewriteNewTrackIds=_require5.unifiedPlanAddOrRewriteNewTrackIds,unifiedPlanAddOrRewriteTrackIds=_require5.unifiedPlanAddOrRewriteTrackIds,unifiedPlanFilterLocalCodecs=_require5.unifiedPlanFilterLocalCodecs;var _require6=require("../../util/twilio-video-errors"),MediaClientLocalDescFailedError=_require6.MediaClientLocalDescFailedError,MediaClientRemoteDescFailedError=_require6.MediaClientRemoteDescFailedError;var _require7=require("../../util"),buildLogLevels=_require7.buildLogLevels,makeUUID=_require7.makeUUID,oncePerTick=_require7.oncePerTick;var IceBox=require("./icebox");var DataTrackReceiver=require("../../data/receiver");var MediaTrackReceiver=require("../../media/track/receiver");var StateMachine=require("../../statemachine");var Log=require("../../util/log");var IdentityTrackMatcher=require("../../util/sdp/trackmatcher/identity");var OrderedTrackMatcher=require("../../util/sdp/trackmatcher/ordered");var MIDTrackMatcher=require("../../util/sdp/trackmatcher/mid");var workaroundIssue8329=require("../../util/sdp/issue8329");var guess=guessBrowser();var isChrome=guess==="chrome";var isFirefox=guess==="firefox";var isSafari=guess==="safari";var sdpFormat=getSdpFormat();var isUnifiedPlan=sdpFormat==="unified";var firefoxMajorVersion=isFirefox?parseInt(navigator.userAgent.match(/Firefox\/(\d+)/)[1],10):null;var isRTCRtpSenderParamsSupported=typeof RTCRtpSender!=="undefined"&&typeof RTCRtpSender.prototype.getParameters==="function"&&typeof RTCRtpSender.prototype.setParameters==="function";var nInstances=0;var states={open:["closed","updating"],updating:["closed","open"],closed:[]};var PeerConnectionV2=function(_StateMachine){_inherits(PeerConnectionV2,_StateMachine);function PeerConnectionV2(id,encodingParameters,preferredCodecs,options){_classCallCheck(this,PeerConnectionV2);var _this=_possibleConstructorReturn(this,(PeerConnectionV2.__proto__||Object.getPrototypeOf(PeerConnectionV2)).call(this,"open",states));options=Object.assign({dscpTagging:false,dummyAudioMediaStreamTrack:null,iceServers:[],isRTCRtpSenderParamsSupported:isRTCRtpSenderParamsSupported,logLevel:DEFAULT_LOG_LEVEL,offerOptions:{},setBitrateParameters:setBitrateParameters,setCodecPreferences:setCodecPreferences,setSimulcast:setSimulcast,MediaStream:DefaultMediaStream,RTCIceCandidate:DefaultRTCIceCandidate,RTCPeerConnection:DefaultRTCPeerConnection,RTCSessionDescription:DefaultRTCSessionDescription},options);var configuration=getConfiguration(options);var logLevels=buildLogLevels(options.logLevel);var RTCPeerConnection=options.RTCPeerConnection;if(options.dscpTagging===true){options.chromeSpecificConstraints=options.chromeSpecificConstraints||{};options.chromeSpecificConstraints.optional=options.chromeSpecificConstraints.optional||[];options.chromeSpecificConstraints.optional.push({googDscp:true})}var peerConnection=new RTCPeerConnection(configuration,options.chromeSpecificConstraints);var localMediaStream=isUnifiedPlan&&RTCPeerConnection.prototype.addTransceiver?null:new options.MediaStream;if(options.dummyAudioMediaStreamTrack){peerConnection.addTrack(options.dummyAudioMediaStreamTrack,localMediaStream||new options.MediaStream)}if(isFirefox&&firefoxMajorVersion<65){peerConnection.createDataChannel(makeUUID())}Object.defineProperties(_this,{_dataChannels:{value:new Map},_dataTrackReceivers:{value:new Set},_descriptionRevision:{writable:true,value:0},_dscpTagging:{value:options.dscpTagging},_encodingParameters:{value:encodingParameters},_instanceId:{value:++nInstances},_isRestartingIce:{writable:true,value:false},_isRTCRtpSenderParamsSupported:{value:options.isRTCRtpSenderParamsSupported},_lastIceConnectionState:{writable:true,value:null},_lastStableDescriptionRevision:{writable:true,value:0},_localCandidates:{writable:true,value:[]},_localCodecs:{value:new Set},_localCandidatesRevision:{writable:true,value:1},_localDescription:{writable:true,value:null},_localMediaStream:{value:localMediaStream},_localUfrag:{writable:true,value:null},_log:{value:options.log?options.log.createLog("signaling",_this):new Log("webrtc",_this,logLevels)},_remoteCodecMaps:{value:new Map},_rtpSenders:{value:new Map},_mediaTrackReceivers:{value:new Set},_needsAnswer:{writable:true,value:false},_negotiationRole:{writable:true,value:null},_offerOptions:{writable:true,value:options.offerOptions},_peerConnection:{value:peerConnection},_preferredAudioCodecs:{value:preferredCodecs.audio},_preferredVideoCodecs:{value:preferredCodecs.video},_queuedDescription:{writable:true,value:null},_recycledTransceivers:{value:{audio:[],video:[]}},_replaceTrackPromises:{value:[]},_remoteCandidates:{writable:true,value:new IceBox},_setBitrateParameters:{value:options.setBitrateParameters},_setCodecPreferences:{value:options.setCodecPreferences},_setSimulcast:{value:options.setSimulcast},_RTCIceCandidate:{value:options.RTCIceCandidate},_RTCPeerConnection:{value:options.RTCPeerConnection},_RTCSessionDescription:{value:options.RTCSessionDescription},_shouldOffer:{writable:true,value:false},_shouldRestartIce:{writable:true,value:false},_trackIdsToAttributes:{value:new Map},_trackMatcher:{writable:true,value:null},id:{enumerable:true,value:id}});encodingParameters.on("changed",oncePerTick(function(){if(_this._isRTCRtpSenderParamsSupported){if(!_this._needsAnswer){updateEncodingParameters(_this)}return}_this.offer()}));peerConnection.addEventListener("datachannel",_this._handleDataChannelEvent.bind(_this));peerConnection.addEventListener("icecandidate",_this._handleIceCandidateEvent.bind(_this));peerConnection.addEventListener("iceconnectionstatechange",_this._handleIceConnectionStateChange.bind(_this));peerConnection.addEventListener("track",_this._handleTrackEvent.bind(_this));var self=_this;_this.on("stateChanged",function stateChanged(state){if(state!=="closed"){return}self.removeListener("stateChanged",stateChanged);self._dataChannels.forEach(function(dataChannel,dataTrackSender){self.removeDataTrackSender(dataTrackSender)})});return _this}_createClass(PeerConnectionV2,[{key:"toString",value:function toString(){return"[PeerConnectionV2 #"+this._instanceId+": "+this.id+"]"}},{key:"_addIceCandidate",value:function _addIceCandidate(candidate){var _this2=this;return Promise.resolve().then(function(){candidate=new _this2._RTCIceCandidate(candidate);return _this2._peerConnection.addIceCandidate(candidate)}).catch(function(error){_this2._log.warn("Failed to add RTCIceCandidate "+(candidate?'"'+candidate.candidate+'"':"null")+": "+error.message)})}},{key:"_addIceCandidates",value:function _addIceCandidates(candidates){return Promise.all(candidates.map(this._addIceCandidate,this)).then(function(){})}},{key:"_addOrUpdateTransceiver",value:function _addOrUpdateTransceiver(track){var transceiver=takeRecycledTransceiver(this,track.kind);if(transceiver&&transceiver.sender){this._replaceTrackPromises.push(transceiver.sender.replaceTrack(track).then(function(){transceiver.direction="sendrecv"},function(){}));return transceiver}return this._peerConnection.addTransceiver(track)}},{key:"_checkIceBox",value:function _checkIceBox(description){var ufrag=getUfrag(description);if(!ufrag){return Promise.resolve()}var candidates=this._remoteCandidates.setUfrag(ufrag);return this._addIceCandidates(candidates)}},{key:"_answer",value:function _answer(offer){var _this3=this;return Promise.resolve().then(function(){if(!_this3._negotiationRole){_this3._negotiationRole="answerer"}return _this3._setRemoteDescription(offer)}).catch(function(){throw new MediaClientRemoteDescFailedError}).then(function(){return _this3._peerConnection.createAnswer()}).then(function(answer){if(!isFirefox){answer=workaroundIssue8329(answer)}return _this3._setLocalDescription(answer)}).then(function(){return _this3._checkIceBox(offer)}).then(function(){return _this3._queuedDescription&&_this3._updateDescription(_this3._queuedDescription)}).then(function(){_this3._queuedDescription=null;return _this3._maybeReoffer(_this3._peerConnection.localDescription)}).catch(function(error){throw error instanceof MediaClientRemoteDescFailedError?error:new MediaClientLocalDescFailedError})}},{key:"_close",value:function _close(){if(this._peerConnection.signalingState!=="closed"){this._peerConnection.close();this.preempt("closed");return true}return false}},{key:"_handleDataChannelEvent",value:function _handleDataChannelEvent(event){var _this4=this;var dataChannel=event.channel;var dataTrackReceiver=new DataTrackReceiver(dataChannel);this._dataTrackReceivers.add(dataTrackReceiver);dataChannel.addEventListener("close",function(){_this4._dataTrackReceivers.delete(dataTrackReceiver)});this.emit("trackAdded",dataTrackReceiver)}},{key:"_handleGlare",value:function _handleGlare(offer){var _this5=this;this._log.debug("Glare detected; rolling back");if(this._isRestartingIce){this._log.debug("An ICE restart was in progress; we'll need to restart ICE again after rolling back");this._isRestartingIce=false;this._shouldRestartIce=true}return Promise.resolve().then(function(){return _this5._setLocalDescription({type:"rollback"})}).then(function(){_this5._needsAnswer=false;return _this5._answer(offer)}).then(function(didReoffer){return didReoffer?Promise.resolve():_this5._offer()})}},{key:"_handleIceCandidateEvent",value:function _handleIceCandidateEvent(event){if(event.candidate){this._localCandidates.push(event.candidate)}var peerConnectionState={ice:{candidates:this._localCandidates.slice(),revision:this._localCandidatesRevision++,ufrag:this._localUfrag},id:this.id};if(!event.candidate){peerConnectionState.ice.complete=true}this.emit("candidates",peerConnectionState)}},{key:"_handleIceConnectionStateChange",value:function _handleIceConnectionStateChange(){var iceConnectionState=this._peerConnection.iceConnectionState;this._log.debug('ICE connection state is "'+iceConnectionState+'"');if(this._lastIceConnectionState!=="failed"&&iceConnectionState==="failed"&&!this._shouldRestartIce&&!this._isRestartingIce){this._log.warn("ICE failed; attempting to restart ICE");this._shouldRestartIce=true;this.offer()}else if(this._lastIceConnectionState==="failed"&&(iceConnectionState==="connected"||iceConnectionState==="completed")){this._log.info("ICE reconnected")}this._lastIceConnectionState=iceConnectionState;this.emit("iceConnectionStateChanged")}},{key:"_handleTrackEvent",value:function _handleTrackEvent(event){var _this6=this;var sdp=this._peerConnection.remoteDescription?this._peerConnection.remoteDescription.sdp:null;if(!this._trackMatcher){this._trackMatcher=event.transceiver&&event.transceiver.mid?new MIDTrackMatcher:isSafari||isUnifiedPlan?new OrderedTrackMatcher:new IdentityTrackMatcher}this._trackMatcher.update(sdp);var mediaStreamTrack=event.track;var signaledTrackId=this._trackMatcher.match(event)||mediaStreamTrack.id;var mediaTrackReceiver=new MediaTrackReceiver(signaledTrackId,mediaStreamTrack);this._mediaTrackReceivers.forEach(function(trackReceiver){if(trackReceiver.track.id===mediaTrackReceiver.track.id){_this6._mediaTrackReceivers.delete(trackReceiver)}});this._mediaTrackReceivers.add(mediaTrackReceiver);mediaStreamTrack.addEventListener("ended",function(){return _this6._mediaTrackReceivers.delete(mediaTrackReceiver)});this.emit("trackAdded",mediaTrackReceiver)}},{key:"_maybeReoffer",value:function _maybeReoffer(localDescription){var shouldReoffer=this._shouldOffer;if(localDescription&&localDescription.sdp){if(isUnifiedPlan&&localDescription.type==="answer"){var senders=this._peerConnection.getSenders().filter(function(sender){return sender.track});shouldReoffer=["audio","video"].reduce(function(shouldOffer,kind){var mediaSections=getMediaSections(localDescription.sdp,kind,"(sendrecv|sendonly)");var sendersOfKind=senders.filter(isSenderOfKind.bind(null,kind));return shouldOffer||mediaSections.length<sendersOfKind.length},shouldReoffer)}var hasDataTrack=this._dataChannels.size>0;var hasApplicationMediaSection=getMediaSections(localDescription.sdp,"application").length>0;var needsApplicationMediaSection=hasDataTrack&&!hasApplicationMediaSection;shouldReoffer=shouldReoffer||needsApplicationMediaSection}var promise=shouldReoffer?this._offer():Promise.resolve();return promise.then(function(){return shouldReoffer})}},{key:"_offer",value:function _offer(){var _this7=this;var offerOptions=Object.assign({},this._offerOptions);this._needsAnswer=true;if(this._shouldRestartIce){this._shouldRestartIce=false;this._isRestartingIce=true;offerOptions.iceRestart=true}return Promise.all(this._replaceTrackPromises.splice(0)).then(function(){return _this7._peerConnection.createOffer(offerOptions)}).catch(function(){throw new MediaClientLocalDescFailedError}).then(function(offer){if(!isFirefox){offer=workaroundIssue8329(offer)}var sdp=isUnifiedPlan&&_this7._peerConnection.remoteDescription?unifiedPlanFilterLocalCodecs(offer.sdp,_this7._peerConnection.remoteDescription.sdp):offer.sdp;var updatedSdp=_this7._setCodecPreferences(sdp,_this7._preferredAudioCodecs,_this7._preferredVideoCodecs);_this7._shouldOffer=false;if(!_this7._negotiationRole){_this7._negotiationRole="offerer"}return _this7._setLocalDescription({type:"offer",sdp:updatedSdp})})}},{key:"_addOrRewriteLocalTrackIds",value:function _addOrRewriteLocalTrackIds(description){var transceivers=this._peerConnection.getTransceivers();var activeTransceivers=transceivers.filter(function(_ref){var sender=_ref.sender,stopped=_ref.stopped;return!stopped&&sender&&sender.track});var assignedTransceivers=activeTransceivers.filter(function(_ref2){var mid=_ref2.mid;return mid});var midsToTrackIds=new Map(assignedTransceivers.map(function(_ref3){var mid=_ref3.mid,sender=_ref3.sender;return[mid,sender.track.id]}));var sdp1=unifiedPlanAddOrRewriteTrackIds(description.sdp,midsToTrackIds);var unassignedTransceivers=activeTransceivers.filter(function(_ref4){var mid=_ref4.mid;return!mid});var newTrackIdsByKind=new Map(["audio","video"].map(function(kind){return[kind,unassignedTransceivers.filter(function(_ref5){var sender=_ref5.sender;return sender.track.kind===kind}).map(function(_ref6){var sender=_ref6.sender;return sender.track.id})]}));var sdp2=unifiedPlanAddOrRewriteNewTrackIds(sdp1,midsToTrackIds,newTrackIdsByKind);return new this._RTCSessionDescription({sdp:sdp2,type:description.type})}},{key:"_setLocalDescription",value:function _setLocalDescription(description){var _this8=this;var vp8SimulcastRequested=this._preferredVideoCodecs.some(function(codecSettings){return codecSettings.codec.toLowerCase()==="vp8"&&codecSettings.simulcast});return Promise.resolve().then(function(){if(description.sdp){description={type:description.type,sdp:(isChrome||isSafari)&&vp8SimulcastRequested?_this8._setSimulcast(description.sdp,sdpFormat,_this8._trackIdsToAttributes):description.sdp}}description=new _this8._RTCSessionDescription(description);return _this8._peerConnection.setLocalDescription(description)}).catch(function(error){_this8._log.warn('Calling setLocalDescription with an RTCSessionDescription of type "'+description.type+'" failed with the error "'+error.message+'".');if(description.sdp){_this8._log.warn("The SDP was "+description.sdp)}throw new MediaClientLocalDescFailedError}).then(function(){if(description.type!=="rollback"){_this8._localDescription=isUnifiedPlan?_this8._addOrRewriteLocalTrackIds(description):description;_this8._localCandidates=[];if(description.type==="offer"){_this8._descriptionRevision++}else if(description.type==="answer"){_this8._lastStableDescriptionRevision=_this8._descriptionRevision;negotiationCompleted(_this8)}_this8._localUfrag=getUfrag(description);_this8.emit("description",_this8.getState())}})}},{key:"_setRemoteDescription",value:function _setRemoteDescription(description){var _this9=this;if(description.sdp){if(!this._isRTCRtpSenderParamsSupported){description.sdp=this._setBitrateParameters(description.sdp,isFirefox?"TIAS":"AS",this._encodingParameters.maxAudioBitrate,this._encodingParameters.maxVideoBitrate)}description.sdp=this._setCodecPreferences(description.sdp,this._preferredAudioCodecs,this._preferredVideoCodecs);if(isFirefox){description.sdp=filterOutMediaStreamIds(description.sdp)}}description=new this._RTCSessionDescription(description);return this._peerConnection.setRemoteDescription(description).then(function(){if(description.type==="answer"){if(_this9._isRestartingIce){_this9._log.debug("An ICE restart was in-progress and is now completed");_this9._isRestartingIce=false}negotiationCompleted(_this9)}},function(error){_this9._log.warn('Calling setRemoteDescription with an RTCSessionDescription of type "'+description.type+'" failed with the error "'+error.message+'".');if(description.sdp){_this9._log.warn("The SDP was "+description.sdp)}throw error})}},{key:"_updateDescription",value:function _updateDescription(description){var _this10=this;switch(description.type){case"answer":case"pranswer":if(description.revision!==this._descriptionRevision||this._peerConnection.signalingState!=="have-local-offer"){return Promise.resolve()}this._descriptionRevision=description.revision;break;case"close":return this._close();case"create-offer":if(description.revision<=this._lastStableDescriptionRevision){return Promise.resolve()}else if(this._needsAnswer){this._queuedDescription=description;return Promise.resolve()}this._descriptionRevision=description.revision;return this._offer();case"offer":if(description.revision<=this._lastStableDescriptionRevision||this._peerConnection.signalingState==="closed"){return Promise.resolve()}if(this._peerConnection.signalingState==="have-local-offer"){if(this._needsAnswer&&this._descriptionRevision===1){this._queuedDescription=description;return Promise.resolve()}this._descriptionRevision=description.revision;return this._handleGlare(description)}this._descriptionRevision=description.revision;return this._answer(description).then(function(){});default:}var revision=description.revision;return Promise.resolve().then(function(){return _this10._setRemoteDescription(description)}).catch(function(){throw new MediaClientRemoteDescFailedError}).then(function(){_this10._lastStableDescriptionRevision=revision;_this10._needsAnswer=false;return _this10._checkIceBox(description)}).then(function(){return _this10._queuedDescription&&_this10._updateDescription(_this10._queuedDescription)}).then(function(){_this10._queuedDescription=null;return _this10._maybeReoffer(_this10._peerConnection.localDescription).then(function(){})})}},{key:"_updateIce",value:function _updateIce(iceState){var candidates=this._remoteCandidates.update(iceState);return this._addIceCandidates(candidates)}},{key:"addDataTrackSender",value:function addDataTrackSender(dataTrackSender){if(this._dataChannels.has(dataTrackSender)){return}try{var dataChannelDict={ordered:dataTrackSender.ordered};if(dataTrackSender.maxPacketLifeTime!==null){dataChannelDict.maxPacketLifeTime=dataTrackSender.maxPacketLifeTime}if(dataTrackSender.maxRetransmits!==null){dataChannelDict.maxRetransmits=dataTrackSender.maxRetransmits}var dataChannel=this._peerConnection.createDataChannel(dataTrackSender.id,dataChannelDict);dataTrackSender.addDataChannel(dataChannel);this._dataChannels.set(dataTrackSender,dataChannel)}catch(error){}}},{key:"addMediaTrackSender",value:function addMediaTrackSender(mediaTrackSender){if(this._peerConnection.signalingState==="closed"||this._rtpSenders.has(mediaTrackSender)){return}var sender=void 0;if(this._localMediaStream){this._localMediaStream.addTrack(mediaTrackSender.track);sender=this._peerConnection.addTrack(mediaTrackSender.track,this._localMediaStream)}else{var transceiver=this._addOrUpdateTransceiver(mediaTrackSender.track);sender=transceiver.sender}mediaTrackSender.addSender(sender);this._rtpSenders.set(mediaTrackSender,sender)}},{
        key:"close",value:function close(){if(this._close()){this._descriptionRevision++;this._localDescription={type:"close"};this.emit("description",this.getState())}}},{key:"getTrackReceivers",value:function getTrackReceivers(){return Array.from(this._dataTrackReceivers).concat(Array.from(this._mediaTrackReceivers))}},{key:"getState",value:function getState(){if(!this._localDescription){return null}var localDescription={type:this._localDescription.type,revision:this._descriptionRevision};if(this._localDescription.sdp){localDescription.sdp=this._localDescription.sdp}return{description:localDescription,id:this.id}}},{key:"offer",value:function offer(){var _this11=this;if(this._needsAnswer||this._isRestartingIce){this._shouldOffer=true;return Promise.resolve()}return this.bracket("offering",function(key){_this11.transition("updating",key);var promise=_this11._needsAnswer||_this11._isRestartingIce?Promise.resolve():_this11._offer();return promise.then(function(){_this11.tryTransition("open",key)},function(error){_this11.tryTransition("open",key);throw error})})}},{key:"removeDataTrackSender",value:function removeDataTrackSender(dataTrackSender){var dataChannel=this._dataChannels.get(dataTrackSender);if(dataChannel){dataTrackSender.removeDataChannel(dataChannel);this._dataChannels.delete(dataTrackSender);dataChannel.close()}}},{key:"removeMediaTrackSender",value:function removeMediaTrackSender(mediaTrackSender){if(this._peerConnection.signalingState==="closed"||!this._rtpSenders.has(mediaTrackSender)){return}var sender=this._rtpSenders.get(mediaTrackSender);this._peerConnection.removeTrack(sender);if(this._localMediaStream){this._localMediaStream.removeTrack(mediaTrackSender.track)}mediaTrackSender.removeSender(sender);this._rtpSenders.delete(mediaTrackSender)}},{key:"setConfiguration",value:function setConfiguration(configuration){if(typeof this._peerConnection.setConfiguration==="function"){this._peerConnection.setConfiguration(getConfiguration(configuration))}}},{key:"update",value:function update(peerConnectionState){var _this12=this;return this.bracket("updating",function(key){if(_this12.state==="closed"){return Promise.resolve()}_this12.transition("updating",key);var updates=[];if(peerConnectionState.ice){updates.push(_this12._updateIce(peerConnectionState.ice))}if(peerConnectionState.description){updates.push(_this12._updateDescription(peerConnectionState.description))}return Promise.all(updates).then(function(){_this12.tryTransition("open",key)},function(error){_this12.tryTransition("open",key);throw error})})}},{key:"getStats",value:function getStats(){var _this13=this;return getStatistics(this._peerConnection).then(function(response){return rewriteTrackIds(_this13,response)})}},{key:"iceConnectionState",get:function get(){return this._peerConnection.iceConnectionState}}]);return PeerConnectionV2}(StateMachine);function rewriteTrackId(pcv2,stats){var receiver=[].concat(_toConsumableArray(pcv2._mediaTrackReceivers)).find(function(receiver){return receiver.track.id===stats.trackId});var trackId=receiver?receiver.id:null;return Object.assign(stats,{trackId:trackId})}function rewriteTrackIds(pcv2,response){return Object.assign(response,{remoteAudioTrackStats:response.remoteAudioTrackStats.map(function(stats){return rewriteTrackId(pcv2,stats)}),remoteVideoTrackStats:response.remoteVideoTrackStats.map(function(stats){return rewriteTrackId(pcv2,stats)})})}function getUfrag(description){if(description.sdp){var match=description.sdp.match(/^a=ice-ufrag:([a-zA-Z0-9+\/]+)/m);if(match){return match[1]}}return null}function getConfiguration(configuration){return Object.assign({bundlePolicy:"max-bundle",rtcpMuxPolicy:"require"},configuration)}function isSenderOfKind(kind,sender){var track=sender.track;return track&&track.kind===kind&&track.readyState!=="ended"}function filterOutMediaStreamIds(sdp){return sdp.replace(/a=msid:[^ ]+ /g,"a=msid:- ")}function shouldRecycleTransceiver(transceiver){return!transceiver.stopped&&(transceiver.currentDirection==="inactive"||transceiver.currentDirection==="recvonly"||transceiver.direction==="recvonly")}function takeRecycledTransceiver(pcv2,kind){var preferredCodecs={audio:pcv2._preferredAudioCodecs.map(function(codec){return codec.toLowerCase()}),video:pcv2._preferredVideoCodecs.map(function(_ref7){var codec=_ref7.codec;return codec.toLowerCase()})}[kind];var recycledTransceivers=pcv2._recycledTransceivers[kind];var localCodec=preferredCodecs.find(function(codec){return pcv2._localCodecs.has(codec)});if(!localCodec){return recycledTransceivers.shift()}var transceiver=recycledTransceivers.find(function(transceiver){var remoteCodecMap=pcv2._remoteCodecMaps.get(transceiver.mid);return remoteCodecMap&&remoteCodecMap.has(localCodec)});if(transceiver){recycledTransceivers.splice(recycledTransceivers.indexOf(transceiver),1)}return transceiver}function updateLocalCodecs(pcv2){var description=pcv2._peerConnection.localDescription;if(!description){return}getMediaSections(description.sdp).forEach(function(section){var codecMap=createCodecMapForMediaSection(section);codecMap.forEach(function(pts,codec){return pcv2._localCodecs.add(codec)})})}function updateRemoteCodecMaps(pcv2){var description=pcv2._peerConnection.remoteDescription;if(!description){return}getMediaSections(description.sdp).forEach(function(section){var mid=section.match(/^a=mid:(.+)$/m)[1];var codecMap=createCodecMapForMediaSection(section);pcv2._remoteCodecMaps.set(mid,codecMap)})}function updateRecycledTransceivers(pcv2){pcv2._recycledTransceivers.audio=[];pcv2._recycledTransceivers.video=[];pcv2._peerConnection.getTransceivers().forEach(function(transceiver){if(shouldRecycleTransceiver(transceiver)){var track=transceiver.receiver.track;pcv2._recycledTransceivers[track.kind].push(transceiver)}})}function negotiationCompleted(pcv2){if(isUnifiedPlan){updateRecycledTransceivers(pcv2);updateLocalCodecs(pcv2);updateRemoteCodecMaps(pcv2)}if(pcv2._isRTCRtpSenderParamsSupported){updateEncodingParameters(pcv2)}}function updateEncodingParameters(pcv2){var _pcv2$_encodingParame=pcv2._encodingParameters,maxAudioBitrate=_pcv2$_encodingParame.maxAudioBitrate,maxVideoBitrate=_pcv2$_encodingParame.maxVideoBitrate;var maxBitrates=new Map([["audio",maxAudioBitrate||0],["video",maxVideoBitrate||0]]);pcv2._peerConnection.getSenders().filter(function(sender){return sender.track}).forEach(function(sender){var maxBitrate=maxBitrates.get(sender.track.kind);var params=sender.getParameters();if(maxBitrate===null||maxBitrate===0){removeMaxBitrate(params)}else{setMaxBitrate(params,maxBitrate)}if(!isFirefox&&pcv2._dscpTagging&&params.encodings.length>0){params.encodings[0].networkPriority="high"}sender.setParameters(params).catch(function(error){pcv2._log.warn("Error while setting encodings parameters for "+sender.track.kind+" Track "+sender.track.id+": "+(error.message||error.name))})})}function removeMaxBitrate(params){if(Array.isArray(params.encodings)){params.encodings.forEach(function(encoding){return delete encoding.maxBitrate})}}function setMaxBitrate(params,maxBitrate){if(isFirefox){params.encodings=[{maxBitrate:maxBitrate}]}else{params.encodings.forEach(function(encoding){encoding.maxBitrate=maxBitrate})}}module.exports=PeerConnectionV2},{"../../data/receiver":5,"../../media/track/receiver":29,"../../statemachine":73,"../../util":109,"../../util/constants":107,"../../util/log":112,"../../util/sdp":113,"../../util/sdp/issue8329":114,"../../util/sdp/trackmatcher/identity":116,"../../util/sdp/trackmatcher/mid":117,"../../util/sdp/trackmatcher/ordered":118,"../../util/twilio-video-errors":121,"./icebox":58,"@twilio/webrtc":162,"@twilio/webrtc/lib/util":175,"@twilio/webrtc/lib/util/sdp":177}],65:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("@twilio/webrtc/lib/util"),guessBrowser=_require.guessBrowser;var PeerConnectionV2=require("./peerconnection");var MediaTrackSender=require("../../media/track/sender");var QueueingEventEmitter=require("../../queueingeventemitter");var util=require("../../util");var _require2=require("../../util/twilio-video-errors"),MediaConnectionError=_require2.MediaConnectionError;var isFirefox=guessBrowser()==="firefox";var PeerConnectionManager=function(_QueueingEventEmitter){_inherits(PeerConnectionManager,_QueueingEventEmitter);function PeerConnectionManager(iceServerSource,encodingParameters,preferredCodecs,options){_classCallCheck(this,PeerConnectionManager);var _this=_possibleConstructorReturn(this,(PeerConnectionManager.__proto__||Object.getPrototypeOf(PeerConnectionManager)).call(this));options=Object.assign({audioContextFactory:isFirefox?require("../../webaudio/audiocontext"):null,PeerConnectionV2:PeerConnectionV2},options);var audioContext=options.audioContextFactory?options.audioContextFactory.getOrCreate(_this):null;var offerOptions=audioContext?{offerToReceiveVideo:true}:{offerToReceiveAudio:true,offerToReceiveVideo:true};Object.defineProperties(_this,{_audioContextFactory:{value:options.audioContextFactory},_closedPeerConnectionIds:{value:new Set},_configuration:{writable:true,value:null},_configurationDeferred:{writable:true,value:util.defer()},_dummyAudioTrackSender:{value:audioContext?new MediaTrackSender(createDummyAudioMediaStreamTrack(audioContext)):null},_encodingParameters:{value:encodingParameters},_iceConnectionState:{writable:true,value:"new"},_iceServerSource:{value:iceServerSource},_dataTrackSenders:{writable:true,value:new Set},_lastIceConnectionState:{writable:true,value:"new"},_mediaTrackSenders:{writable:true,value:new Set},_offerOptions:{value:offerOptions},_peerConnections:{value:new Map},_preferredCodecs:{value:preferredCodecs},_PeerConnectionV2:{value:options.PeerConnectionV2}});return _this}_createClass(PeerConnectionManager,[{key:"_getConfiguration",value:function _getConfiguration(){return this._configurationDeferred.promise}},{key:"_getOrCreate",value:function _getOrCreate(id,configuration){var _this2=this;var self=this;var peerConnection=this._peerConnections.get(id);if(!peerConnection){var _PeerConnectionV=this._PeerConnectionV2;var options=Object.assign({dummyAudioMediaStreamTrack:this._dummyAudioTrackSender?this._dummyAudioTrackSender.track:null,offerOptions:this._offerOptions},configuration);try{peerConnection=new _PeerConnectionV(id,this._encodingParameters,this._preferredCodecs,options)}catch(e){throw new MediaConnectionError}this._peerConnections.set(peerConnection.id,peerConnection);peerConnection.on("candidates",this.queue.bind(this,"candidates"));peerConnection.on("description",this.queue.bind(this,"description"));peerConnection.on("trackAdded",this.queue.bind(this,"trackAdded"));peerConnection.on("stateChanged",function stateChanged(state){if(state==="closed"){peerConnection.removeListener("stateChanged",stateChanged);self._peerConnections.delete(peerConnection.id);self._closedPeerConnectionIds.add(peerConnection.id);updateIceConnectionState(self)}});peerConnection.on("iceConnectionStateChanged",function(){return updateIceConnectionState(_this2)});this._dataTrackSenders.forEach(peerConnection.addDataTrackSender,peerConnection);this._mediaTrackSenders.forEach(peerConnection.addMediaTrackSender,peerConnection);updateIceConnectionState(this)}return peerConnection}},{key:"close",value:function close(){if(this._iceServerSource.isStarted){this._iceServerSource.stop()}this._peerConnections.forEach(function(peerConnection){peerConnection.close()});if(this._dummyAudioTrackSender){this._dummyAudioTrackSender.track.stop()}if(this._audioContextFactory){this._audioContextFactory.release(this)}updateIceConnectionState(this);return this}},{key:"createAndOffer",value:function createAndOffer(){var _this3=this;return this._getConfiguration().then(function(configuration){var id=void 0;do{id=util.makeUUID()}while(_this3._peerConnections.has(id));return _this3._getOrCreate(id,configuration)}).then(function(peerConnection){return peerConnection.offer()}).then(function(){return _this3})}},{key:"getTrackReceivers",value:function getTrackReceivers(){return util.flatMap(this._peerConnections,function(peerConnection){return peerConnection.getTrackReceivers()})}},{key:"getStates",value:function getStates(){var peerConnectionStates=[];this._peerConnections.forEach(function(peerConnection){var peerConnectionState=peerConnection.getState();if(peerConnectionState){peerConnectionStates.push(peerConnectionState)}});return peerConnectionStates}},{key:"setConfiguration",value:function setConfiguration(configuration){if(this._configuration){this._configurationDeferred=util.defer();this._peerConnections.forEach(function(peerConnection){peerConnection.setConfiguration(configuration)})}this._configuration=configuration;this._configurationDeferred.resolve(configuration);return this}},{key:"setTrackSenders",value:function setTrackSenders(trackSenders){var dataTrackSenders=new Set(trackSenders.filter(function(trackSender){return trackSender.kind==="data"}));var mediaTrackSenders=new Set(trackSenders.filter(function(trackSender){return trackSender&&(trackSender.kind==="audio"||trackSender.kind==="video")}));var changes=getTrackSenderChanges(this,dataTrackSenders,mediaTrackSenders);this._dataTrackSenders=dataTrackSenders;this._mediaTrackSenders=mediaTrackSenders;applyTrackSenderChanges(this,changes);return this}},{key:"update",value:function update(peerConnectionStates){var _this4=this;return this._getConfiguration().then(function(configuration){return Promise.all(peerConnectionStates.map(function(peerConnectionState){if(_this4._closedPeerConnectionIds.has(peerConnectionState.id)){return null}var peerConnection=_this4._getOrCreate(peerConnectionState.id,configuration);return peerConnection.update(peerConnectionState)}))}).then(function(){return _this4})}},{key:"getStats",value:function getStats(){var peerConnections=Array.from(this._peerConnections.values());return Promise.all(peerConnections.map(function(peerConnection){return peerConnection.getStats().then(function(response){return[peerConnection.id,response]})})).then(function(responses){return new Map(responses)})}},{key:"iceConnectionState",get:function get(){return this._iceConnectionState}}]);return PeerConnectionManager}(QueueingEventEmitter);function createDummyAudioMediaStreamTrack(audioContext){var mediaStreamDestination=audioContext.createMediaStreamDestination();return mediaStreamDestination.stream.getAudioTracks()[0]}function applyTrackSenderChanges(peerConnectionManager,changes){if(changes.data.add.size||changes.data.remove.size||changes.media.add.size||changes.media.remove.size){peerConnectionManager._peerConnections.forEach(function(peerConnection){changes.data.remove.forEach(peerConnection.removeDataTrackSender,peerConnection);changes.media.remove.forEach(peerConnection.removeMediaTrackSender,peerConnection);changes.data.add.forEach(peerConnection.addDataTrackSender,peerConnection);changes.media.add.forEach(peerConnection.addMediaTrackSender,peerConnection);peerConnection.offer()})}}function getDataTrackSenderChanges(peerConnectionManager,dataTrackSenders){var dataTrackSendersToAdd=util.difference(dataTrackSenders,peerConnectionManager._dataTrackSenders);var dataTrackSendersToRemove=util.difference(peerConnectionManager._dataTrackSenders,dataTrackSenders);return{add:dataTrackSendersToAdd,remove:dataTrackSendersToRemove}}function getTrackSenderChanges(peerConnectionManager,dataTrackSenders,mediaTrackSenders){return{data:getDataTrackSenderChanges(peerConnectionManager,dataTrackSenders),media:getMediaTrackSenderChanges(peerConnectionManager,mediaTrackSenders)}}function getMediaTrackSenderChanges(peerConnectionManager,mediaTrackSenders){var mediaTrackSendersToAdd=util.difference(mediaTrackSenders,peerConnectionManager._mediaTrackSenders);var mediaTrackSendersToRemove=util.difference(peerConnectionManager._mediaTrackSenders,mediaTrackSenders);return{add:mediaTrackSendersToAdd,remove:mediaTrackSendersToRemove}}var toRank={new:0,checking:1,connected:2,completed:3,disconnected:-1,failed:-2,closed:-3};var fromRank=void 0;function createFromRank(){return Object.keys(toRank).reduce(function(fromRank,state){return Object.assign(fromRank,_defineProperty({},toRank[state],state))},{})}function summarizeIceConnectionStates(states){if(!states.length){return"new"}fromRank=fromRank||createFromRank();return states.reduce(function(state1,state2){return fromRank[Math.max(toRank[state1],toRank[state2])]})}function updateIceConnectionState(pcm){pcm._lastIceConnectionState=pcm.iceConnectionState;pcm._iceConnectionState=summarizeIceConnectionStates([].concat(_toConsumableArray(pcm._peerConnections.values())).map(function(pcv2){return pcv2.iceConnectionState}));if(pcm.iceConnectionState!==pcm._lastIceConnectionState){pcm.emit("iceConnectionStateChanged")}}module.exports=PeerConnectionManager},{"../../media/track/sender":38,"../../queueingeventemitter":44,"../../util":109,"../../util/twilio-video-errors":121,"../../webaudio/audiocontext":123,"./peerconnection":64,"@twilio/webrtc/lib/util":175}],66:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RecordingSignaling=require("../recording");var RecordingV2=function(_RecordingSignaling){_inherits(RecordingV2,_RecordingSignaling);function RecordingV2(){_classCallCheck(this,RecordingV2);var _this=_possibleConstructorReturn(this,(RecordingV2.__proto__||Object.getPrototypeOf(RecordingV2)).call(this));Object.defineProperties(_this,{_revision:{value:1,writable:true}});return _this}_createClass(RecordingV2,[{key:"update",value:function update(recording){if(recording.revision<this._revision){return this}this._revision=recording.revision;return this.enable(recording.enabled)}}]);return RecordingV2}(RecordingSignaling);module.exports=RecordingV2},{"../recording":51}],67:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RemoteParticipantSignaling=require("../remoteparticipant");var RemoteTrackPublicationV2=require("./remotetrackpublication");var RemoteParticipantV2=function(_RemoteParticipantSig){_inherits(RemoteParticipantV2,_RemoteParticipantSig);function RemoteParticipantV2(participantState,getTrackReceiver,options){var _ret;_classCallCheck(this,RemoteParticipantV2);var _this=_possibleConstructorReturn(this,(RemoteParticipantV2.__proto__||Object.getPrototypeOf(RemoteParticipantV2)).call(this,participantState.sid,participantState.identity));options=Object.assign({RemoteTrackPublicationV2:RemoteTrackPublicationV2},options);Object.defineProperties(_this,{_revision:{writable:true,value:null},_RemoteTrackPublicationV2:{value:options.RemoteTrackPublicationV2},_getTrackReceiver:{value:getTrackReceiver},revision:{enumerable:true,get:function get(){return this._revision}}});return _ret=_this.update(participantState),_possibleConstructorReturn(_this,_ret)}_createClass(RemoteParticipantV2,[{key:"_getOrCreateTrack",value:function _getOrCreateTrack(trackState){var RemoteTrackPublicationV2=this._RemoteTrackPublicationV2;var track=this.tracks.get(trackState.sid);if(!track){track=new RemoteTrackPublicationV2(trackState);this.addTrack(track)}return track}},{key:"update",value:function update(participantState){var _this2=this;if(this.revision!==null&&participantState.revision<=this.revision){return this}this._revision=participantState.revision;var tracksToKeep=new Set;participantState.tracks.forEach(function(trackState){var track=_this2._getOrCreateTrack(trackState);track.update(trackState);tracksToKeep.add(track)});this.tracks.forEach(function(track){if(!tracksToKeep.has(track)){_this2.removeTrack(track)}});if(participantState.state==="disconnected"&&this.state==="connected"){this.preempt("disconnected")}return this}}]);return RemoteParticipantV2}(RemoteParticipantSignaling);module.exports=RemoteParticipantV2},{"../remoteparticipant":52,"./remotetrackpublication":68}],68:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RemoteTrackPublicationSignaling=require("../remotetrackpublication");var RemoteTrackPublicationV2=function(_RemoteTrackPublicati){_inherits(RemoteTrackPublicationV2,_RemoteTrackPublicati);function RemoteTrackPublicationV2(track){_classCallCheck(this,RemoteTrackPublicationV2);return _possibleConstructorReturn(this,(RemoteTrackPublicationV2.__proto__||Object.getPrototypeOf(RemoteTrackPublicationV2)).call(this,track.sid,track.name,track.kind,track.enabled))}_createClass(RemoteTrackPublicationV2,[{key:"update",value:function update(track){this.enable(track.enabled);return this}}]);return RemoteTrackPublicationV2}(RemoteTrackPublicationSignaling);module.exports=RemoteTrackPublicationV2},{"../remotetrackpublication":53}],69:[function(require,module,exports){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _get=function get(object,property,receiver){if(object===null)object=Function.prototype;var desc=Object.getOwnPropertyDescriptor(object,property);if(desc===undefined){var parent=Object.getPrototypeOf(object);if(parent===null){return undefined}else{return get(parent,property,receiver)}}else if("value"in desc){return desc.value}else{var getter=desc.get;if(getter===undefined){return undefined}return getter.call(receiver)}};function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var DominantSpeakerSignaling=require("./dominantspeakersignaling");var NetworkQualityMonitor=require("./networkqualitymonitor");var NetworkQualitySignaling=require("./networkqualitysignaling");var RecordingV2=require("./recording");var RoomSignaling=require("../room");var RemoteParticipantV2=require("./remoteparticipant");var StatsReport=require("../../stats/statsreport");var util=require("../../util");var createTwilioError=require("../../util/twilio-video-errors").createTwilioError;var STATS_PUBLISH_INTERVAL_MS=1e3;var RoomV2=function(_RoomSignaling){_inherits(RoomV2,_RoomSignaling);function RoomV2(localParticipant,initialState,transport,peerConnectionManager,options){_classCallCheck(this,RoomV2);options=Object.assign({DominantSpeakerSignaling:DominantSpeakerSignaling,NetworkQualityMonitor:NetworkQualityMonitor,NetworkQualitySignaling:NetworkQualitySignaling,RecordingSignaling:RecordingV2,RemoteParticipantV2:RemoteParticipantV2,statsPublishIntervalMs:STATS_PUBLISH_INTERVAL_MS},options);var _this=_possibleConstructorReturn(this,(RoomV2.__proto__||Object.getPrototypeOf(RoomV2)).call(this,localParticipant,initialState.sid,initialState.name,options));Object.defineProperties(_this,{_dominantSpeakerSignaling:{value:null,writable:true},_DominantSpeakerSignaling:{value:options.DominantSpeakerSignaling},_dominantSpeakerSignalingPromise:{value:null,writable:true},_disconnectedParticipantSids:{value:new Set},_NetworkQualityMonitor:{value:options.NetworkQualityMonitor},_NetworkQualitySignaling:{value:options.NetworkQualitySignaling},_networkQualityMonitor:{value:null,writable:true},_networkQualityMonitorPromise:{value:null,writable:true},_networkQualityConfiguration:{value:localParticipant.networkQualityConfiguration},_peerConnectionManager:{value:peerConnectionManager},_published:{value:new Map},_publishedRevision:{value:0,writable:true},_RemoteParticipantV2:{value:options.RemoteParticipantV2},_subscribed:{value:new Map},_subscribedRevision:{value:0,writable:true},_subscriptionFailures:{value:new Map},_transport:{value:transport},_trackReceiverDeferreds:{value:new Map}});handleLocalParticipantEvents(_this,localParticipant);handlePeerConnectionEvents(_this,peerConnectionManager);handleTransportEvents(_this,transport);periodicallyPublishStats(_this,transport,options.statsPublishIntervalMs);_this._update(initialState);return _this}_createClass(RoomV2,[{key:"_deleteTrackReceiverDeferred",value:function _deleteTrackReceiverDeferred(id){return this._trackReceiverDeferreds.delete(id)}},{key:"_getOrCreateTrackReceiverDeferred",value:function _getOrCreateTrackReceiverDeferred(id){var deferred=this._trackReceiverDeferreds.get(id)||util.defer();var trackReceivers=this._peerConnectionManager.getTrackReceivers();var trackReceiver=trackReceivers.find(function(trackReceiver){return trackReceiver.id===id&&trackReceiver.readyState!=="ended"});if(trackReceiver){deferred.resolve(trackReceiver)}else{this._trackReceiverDeferreds.set(id,deferred)}return deferred}},{key:"_addTrackReceiver",value:function _addTrackReceiver(trackReceiver){var deferred=this._getOrCreateTrackReceiverDeferred(trackReceiver.id);deferred.resolve(trackReceiver);return this}},{key:"_disconnect",value:function _disconnect(error){var didDisconnect=_get(RoomV2.prototype.__proto__||Object.getPrototypeOf(RoomV2.prototype),"_disconnect",this).call(this,error);if(didDisconnect){this._teardownDominantSpeakerSignaling();this._teardownNetworkQualityMonitor();this._transport.disconnect();this._peerConnectionManager.close()}
            this.localParticipant.tracks.forEach(function(track){track.publishFailed(error||new Error("LocalParticipant disconnected"))});return didDisconnect}},{key:"_getTrackReceiver",value:function _getTrackReceiver(id){var _this2=this;return this._getOrCreateTrackReceiverDeferred(id).promise.then(function(trackReceiver){_this2._deleteTrackReceiverDeferred(id);return trackReceiver})}},{key:"_getOrCreateRemoteParticipant",value:function _getOrCreateRemoteParticipant(participantState){var RemoteParticipantV2=this._RemoteParticipantV2;var participant=this.participants.get(participantState.sid);var self=this;if(!participant){participant=new RemoteParticipantV2(participantState,this._getTrackReceiver.bind(this));participant.on("stateChanged",function stateChanged(state){if(state==="disconnected"){participant.removeListener("stateChanged",stateChanged);self.participants.delete(participant.sid);self._disconnectedParticipantSids.add(participant.sid)}});this.connectParticipant(participant)}return participant}},{key:"_getState",value:function _getState(){return{participant:this.localParticipant.getState()}}},{key:"_publishNewLocalParticipantState",value:function _publishNewLocalParticipantState(){this._transport.publish(this._getState())}},{key:"_publishPeerConnectionState",value:function _publishPeerConnectionState(peerConnectionState){this._transport.publish(Object.assign({peer_connections:[peerConnectionState]},this._getState()))}},{key:"_update",value:function _update(roomState){var _this3=this;var participantsToKeep=new Set;if(roomState.subscribed&&roomState.subscribed.revision>this._subscribedRevision){this._subscribedRevision=roomState.subscribed.revision;roomState.subscribed.tracks.forEach(function(trackState){if(trackState.id){this._subscriptionFailures.delete(trackState.sid);this._subscribed.set(trackState.sid,trackState.id)}else if(trackState.error&&!this._subscriptionFailures.has(trackState.sid)){this._subscriptionFailures.set(trackState.sid,trackState.error)}},this);var subscribedTrackSids=new Set(roomState.subscribed.tracks.filter(function(trackState){return!!trackState.id}).map(function(trackState){return trackState.sid}));this._subscribed.forEach(function(trackId,trackSid){if(!subscribedTrackSids.has(trackSid)){_this3._subscribed.delete(trackSid)}})}(roomState.participants||[]).forEach(function(participantState){if(participantState.sid===_this3.localParticipant.sid||_this3._disconnectedParticipantSids.has(participantState.sid)){return}var participant=_this3._getOrCreateRemoteParticipant(participantState);participant.update(participantState);participantsToKeep.add(participant)});handleSubscriptions(this);if(roomState.peer_connections){this._peerConnectionManager.update(roomState.peer_connections)}if(roomState.recording){this.recording.update(roomState.recording)}if(roomState.published&&roomState.published.revision>this._publishedRevision){this._publishedRevision=roomState.published.revision;roomState.published.tracks.forEach(function(track){if(track.sid){this._published.set(track.id,track.sid)}},this);this.localParticipant.update(roomState.published)}if(roomState.participant){this.localParticipant.connect(roomState.participant.sid,roomState.participant.identity)}if(!this._dominantSpeakerSignalingPromise&&roomState.media_signaling&&roomState.media_signaling.active_speaker&&roomState.media_signaling.active_speaker.transport&&roomState.media_signaling.active_speaker.transport.type==="data-channel"){this._setupDataTransportBackedDominantSpeakerSignaling(roomState.media_signaling.active_speaker.transport.label)}if(!this._networkQualityMonitorPromise&&roomState.media_signaling&&roomState.media_signaling.network_quality&&roomState.media_signaling.network_quality.transport&&roomState.media_signaling.network_quality.transport.type==="data-channel"){this._setupDataTransportBackedNetworkQualityMonitor(roomState.media_signaling.network_quality.transport.label)}return this}},{key:"_setupDataTransportBackedDominantSpeakerSignaling",value:function _setupDataTransportBackedDominantSpeakerSignaling(id){var _this4=this;this._teardownDominantSpeakerSignaling();var dominantSpeakerSignalingPromise=this._getTrackReceiver(id).then(function(receiver){if(receiver.kind!=="data"){throw new Error("Expected a DataTrackReceiver")}if(_this4._dominantSpeakerSignalingPromise!==dominantSpeakerSignalingPromise){return}receiver.once("close",function(){return _this4._teardownDominantSpeakerSignaling()});var dominantSpeakerSignaling=new _this4._DominantSpeakerSignaling(receiver.toDataTransport());_this4._setDominantSpeakerSignaling(dominantSpeakerSignaling)});this._dominantSpeakerSignalingPromise=dominantSpeakerSignalingPromise}},{key:"_setupDataTransportBackedNetworkQualityMonitor",value:function _setupDataTransportBackedNetworkQualityMonitor(id){var _this5=this;var self=this;this._teardownNetworkQualityMonitor();var networkQualityMonitorPromise=this._getTrackReceiver(id).then(function(receiver){if(receiver.kind!=="data"){throw new Error("Expected a DataTrackReceiver")}if(_this5._networkQualityMonitorPromise!==networkQualityMonitorPromise){return}receiver.once("close",function(){return _this5._teardownNetworkQualityMonitor()});var networkQualitySignaling=new _this5._NetworkQualitySignaling(receiver.toDataTransport(),self._networkQualityConfiguration);var networkQualityMonitor=new _this5._NetworkQualityMonitor(_this5._peerConnectionManager,networkQualitySignaling);_this5._setNetworkQualityMonitor(networkQualityMonitor)});this._networkQualityMonitorPromise=networkQualityMonitorPromise}},{key:"_setDominantSpeakerSignaling",value:function _setDominantSpeakerSignaling(dominantSpeakerSignaling){var _this6=this;this._dominantSpeakerSignaling=dominantSpeakerSignaling;dominantSpeakerSignaling.on("updated",function(){return _this6.setDominantSpeaker(dominantSpeakerSignaling.loudestParticipantSid)})}},{key:"_setNetworkQualityMonitor",value:function _setNetworkQualityMonitor(networkQualityMonitor){var _this7=this;this._networkQualityMonitor=networkQualityMonitor;networkQualityMonitor.on("updated",function(){if(_this7.mediaConnectionState==="failed"){return}_this7.localParticipant.setNetworkQualityLevel(networkQualityMonitor.level,networkQualityMonitor.levels);_this7.participants.forEach(function(participant){var levels=networkQualityMonitor.remoteLevels.get(participant.sid);if(levels){participant.setNetworkQualityLevel(levels.level,levels)}})});networkQualityMonitor.start()}},{key:"_teardownDominantSpeakerSignaling",value:function _teardownDominantSpeakerSignaling(){this._dominantSpeakerSignalingPromise=null;this._dominantSpeakerSignaling=null}},{key:"_teardownNetworkQualityMonitor",value:function _teardownNetworkQualityMonitor(){this._networkQualityMonitorPromise=null;if(this._networkQualityMonitor){this._networkQualityMonitor.stop();this._networkQualityMonitor=null}}},{key:"getStats",value:function getStats(){var _this8=this;return this._peerConnectionManager.getStats().then(function(responses){return new Map(Array.from(responses).map(function(_ref){var _ref2=_slicedToArray(_ref,2),id=_ref2[0],response=_ref2[1];return[id,Object.assign({},response,{localAudioTrackStats:filterAndAddLocalTrackSids(_this8,response.localAudioTrackStats),localVideoTrackStats:filterAndAddLocalTrackSids(_this8,response.localVideoTrackStats),remoteAudioTrackStats:filterAndAddRemoteTrackSids(_this8,response.remoteAudioTrackStats),remoteVideoTrackStats:filterAndAddRemoteTrackSids(_this8,response.remoteVideoTrackStats)})]}))})}},{key:"signalingConnectionState",get:function get(){return this._transport.state==="syncing"?"reconnecting":this._transport.state}},{key:"mediaConnectionState",get:function get(){return this._peerConnectionManager.iceConnectionState}}]);return RoomV2}(RoomSignaling);function filterAndAddTrackSids(idToSid,trackStats){return trackStats.reduce(function(trackStats,trackStat){var trackSid=idToSid.get(trackStat.trackId);return trackSid?[Object.assign({},trackStat,{trackSid:trackSid})].concat(trackStats):trackStats},[])}function filterAndAddLocalTrackSids(roomV2,localTrackStats){return filterAndAddTrackSids(roomV2._published,localTrackStats)}function filterAndAddRemoteTrackSids(roomV2,remoteTrackStats){var idToSid=new Map(Array.from(roomV2._subscribed.entries()).map(function(_ref3){var _ref4=_slicedToArray(_ref3,2),sid=_ref4[0],id=_ref4[1];return[id,sid]}));return filterAndAddTrackSids(idToSid,remoteTrackStats)}function handleLocalParticipantEvents(roomV2,localParticipant){var renegotiate=util.oncePerTick(function(){var trackSenders=util.flatMap(localParticipant.tracks,function(trackV2){return trackV2.trackTransceiver});roomV2._peerConnectionManager.setTrackSenders(trackSenders)});var localParticipantUpdated=util.oncePerTick(function(){roomV2._publishNewLocalParticipantState()});localParticipant.on("trackAdded",renegotiate);localParticipant.on("trackRemoved",renegotiate);localParticipant.on("updated",localParticipantUpdated);roomV2.on("stateChanged",function stateChanged(state){if(state==="disconnected"){localParticipant.removeListener("trackAdded",renegotiate);localParticipant.removeListener("trackRemoved",renegotiate);localParticipant.removeListener("updated",localParticipantUpdated);roomV2.removeListener("stateChanged",stateChanged);localParticipant.disconnect()}})}function handlePeerConnectionEvents(roomV2,peerConnectionManager){peerConnectionManager.on("description",function onDescription(description){roomV2._publishPeerConnectionState(description)});peerConnectionManager.dequeue("description");peerConnectionManager.on("candidates",function onCandidates(candidates){roomV2._publishPeerConnectionState(candidates)});peerConnectionManager.dequeue("candidates");peerConnectionManager.on("trackAdded",roomV2._addTrackReceiver.bind(roomV2));peerConnectionManager.dequeue("trackAdded");peerConnectionManager.getTrackReceivers().forEach(roomV2._addTrackReceiver,roomV2);peerConnectionManager.on("iceConnectionStateChanged",function(){roomV2.emit("mediaConnectionStateChanged");if(roomV2.mediaConnectionState==="failed"){if(roomV2.localParticipant.networkQualityLevel!==null){roomV2.localParticipant.setNetworkQualityLevel(0)}roomV2.participants.forEach(function(participant){if(participant.networkQualityLevel!==null){participant.setNetworkQualityLevel(0)}})}})}function handleTransportEvents(roomV2,transport){transport.on("message",roomV2._update.bind(roomV2));transport.on("stateChanged",function stateChanged(state,error){if(state==="disconnected"){if(roomV2.state!=="disconnected"){roomV2._disconnect(error)}transport.removeListener("stateChanged",stateChanged)}roomV2.emit("signalingConnectionStateChanged")})}function periodicallyPublishStats(roomV2,transport,intervalMs){var interval=setInterval(function(){roomV2.getStats().then(function(stats){stats.forEach(function(response,id){var report=new StatsReport(id,response);transport.publishEvent("quality","stats-report",{audioTrackStats:report.remoteAudioTrackStats,localAudioTrackStats:report.localAudioTrackStats,localVideoTrackStats:report.localVideoTrackStats,peerConnectionId:report.peerConnectionId,videoTrackStats:report.remoteVideoTrackStats});var activeIceCandidatePair=replaceNullsWithDefaults(response.activeIceCandidatePair,report.peerConnectionId);transport.publishEvent("quality","active-ice-candidate-pair",activeIceCandidatePair)})},function(){})},intervalMs);roomV2.on("stateChanged",function onStateChanged(state){if(state==="disconnected"){clearInterval(interval);roomV2.removeListener("stateChanged",onStateChanged)}})}function handleSubscriptions(room){var trackSignalings=new Map(util.flatMap(room.participants,function(participant){return Array.from(participant.tracks.values()).map(function(track){return[track.sid,track]})}));room._subscriptionFailures.forEach(function(error,trackSid){var trackSignaling=trackSignalings.get(trackSid);if(trackSignaling){room._subscriptionFailures.delete(trackSid);trackSignaling.subscribeFailed(createTwilioError(error.code,error.message))}});trackSignalings.forEach(function(trackSignaling){var trackId=room._subscribed.get(trackSignaling.sid);if(!trackId||trackSignaling.isSubscribed&&trackSignaling.trackTransceiver.id!==trackId){trackSignaling.setTrackTransceiver(null)}if(trackId){room._getTrackReceiver(trackId).then(function(trackReceiver){return trackSignaling.setTrackTransceiver(trackReceiver)})}})}function replaceNullsWithDefaults(activeIceCandidatePair,peerConnectionId){activeIceCandidatePair=Object.assign({availableIncomingBitrate:0,availableOutgoingBitrate:0,bytesReceived:0,bytesSent:0,consentRequestsSent:0,currentRoundTripTime:0,lastPacketReceivedTimestamp:0,lastPacketSentTimestamp:0,nominated:false,peerConnectionId:peerConnectionId,priority:0,readable:false,requestsReceived:0,requestsSent:0,responsesReceived:0,responsesSent:0,retransmissionsReceived:0,retransmissionsSent:0,state:"failed",totalRoundTripTime:0,transportId:"",writable:false},util.filterObject(activeIceCandidatePair||{},null));activeIceCandidatePair.localCandidate=Object.assign({candidateType:"host",deleted:false,ip:"",port:0,priority:0,protocol:"udp",relayProtocol:"udp",url:""},util.filterObject(activeIceCandidatePair.localCandidate||{},null));activeIceCandidatePair.remoteCandidate=Object.assign({candidateType:"host",ip:"",port:0,priority:0,protocol:"udp",url:""},util.filterObject(activeIceCandidatePair.remoteCandidate||{},null));return activeIceCandidatePair}module.exports=RoomV2},{"../../stats/statsreport":101,"../../util":109,"../../util/twilio-video-errors":121,"../room":54,"./dominantspeakersignaling":57,"./networkqualitymonitor":62,"./networkqualitysignaling":63,"./recording":66,"./remoteparticipant":67}],70:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var SIP=require("../../sip");var SIPJSMediaHandler=function(){function SIPJSMediaHandler(peerConnectionManager,createMessage){_classCallCheck(this,SIPJSMediaHandler);Object.defineProperties(this,{createMessage:{enumerable:true,value:createMessage},peerConnectionManager:{enumerable:true,value:peerConnectionManager}})}_createClass(SIPJSMediaHandler,[{key:"close",value:function close(){this.peerConnectionManager.close()}},{key:"getDescription",value:function getDescription(){var connectMessage=Object.assign({peer_connections:this.peerConnectionManager.getStates()},this.createMessage());return Promise.resolve({body:JSON.stringify(connectMessage),contentType:"application/room-signaling+json"})}},{key:"hasDescription",value:function hasDescription(){return true}},{key:"hold",value:function hold(){}},{key:"isReady",value:function isReady(){return true}},{key:"isMuted",value:function isMuted(){return{audio:false,video:false}}},{key:"mute",value:function mute(){}},{key:"render",value:function render(){}},{key:"setDescription",value:function setDescription(message){var roomState=getRoomState(message);if(roomState){var peerConnectionStates=roomState.peer_connections;if(peerConnectionStates){return this.peerConnectionManager.update(peerConnectionStates)}}return Promise.resolve()}},{key:"unhold",value:function unhold(){}},{key:"unmute",value:function unmute(){}},{key:"updateIceServers",value:function updateIceServers(){}}],[{key:"defaultFactory",value:function defaultFactory(){}}]);return SIPJSMediaHandler}();SIPJSMediaHandler.defaultFactory.isSupported=function isSupported(){return SIP.WebRTC.isSupported()};function getRoomState(message){try{return JSON.parse(message.body)}catch(error){return null}}module.exports=SIPJSMediaHandler},{"../../sip":72}],71:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var _require=require("@twilio/webrtc/lib/util/sdp"),getSdpFormat=_require.getSdpFormat;var constants=require("../../util/constants");var packageInfo=require("../../../package.json");var InsightsPublisher=require("../../util/insightspublisher");var NullInsightsPublisher=require("../../util/insightspublisher/null");var SIP=require("../../sip");var DefaultSIPJSMediaHandler=require("./sipjsmediahandler");var StateMachine=require("../../statemachine");var util=require("../../util");var _require2=require("../../util/twilio-video-errors"),RoomCompletedError=_require2.RoomCompletedError;var _require3=require("../../util/twilio-video-errors"),SignalingConnectionDisconnectedError=_require3.SignalingConnectionDisconnectedError,SignalingConnectionError=_require3.SignalingConnectionError,SignalingConnectionTimeoutError=_require3.SignalingConnectionTimeoutError,SignalingIncomingMessageInvalidError=_require3.SignalingIncomingMessageInvalidError,createTwilioError=_require3.createTwilioError;var RSP_VERSION=2;var SDK_NAME=packageInfo.name+".js";var SDK_VERSION=packageInfo.version;var states={connecting:["connected","disconnected"],connected:["disconnected","syncing"],syncing:["connected","disconnected"],disconnected:[]};var Transport=function(_StateMachine){_inherits(Transport,_StateMachine);function Transport(name,accessToken,localParticipant,peerConnectionManager,ua,options){_classCallCheck(this,Transport);options=Object.assign({InsightsPublisher:InsightsPublisher,NullInsightsPublisher:NullInsightsPublisher,SIPJSMediaHandler:DefaultSIPJSMediaHandler,sdpFormat:getSdpFormat(),userAgent:util.getUserAgent()},options);var _this=_possibleConstructorReturn(this,(Transport.__proto__||Object.getPrototypeOf(Transport)).call(this,"connecting",states));var eventPublisherOptions={};if(options.wsServerInsights){eventPublisherOptions.gateway=options.wsServerInsights}var EventPublisher=options.insights?options.InsightsPublisher:options.NullInsightsPublisher;Object.defineProperties(_this,{_eventPublisher:{value:new EventPublisher(accessToken,SDK_NAME,SDK_VERSION,options.environment,options.realm,eventPublisherOptions)},_sdpFormat:{value:options.sdpFormat},_updatesReceived:{value:[]},_updatesToSend:{value:[]},_userAgent:{value:options.userAgent}});Object.defineProperties(_this,{_session:{value:createSession(_this,name,accessToken,localParticipant,peerConnectionManager,ua,options.SIPJSMediaHandler,options.iceServerSourceStatus,options.dominantSpeaker,options.networkQuality)}});setupEventListeners(_this,_this._session,ua);_this.once("connected",function(_ref){var sid=_ref.sid,participant=_ref.participant;_this._eventPublisher.connect(sid,participant.sid)});return _this}_createClass(Transport,[{key:"disconnect",value:function disconnect(error){if(this.state!=="disconnected"){this.preempt("disconnected",null,[error]);this._session.terminate({body:JSON.stringify({type:"disconnect",version:RSP_VERSION}),extraHeaders:["Content-Type: application/room-signaling+json"]});this._eventPublisher.disconnect();return true}return false}},{key:"publish",value:function publish(update){update=Object.assign({type:"update",version:RSP_VERSION},update);switch(this.state){case"connected":publishWithRetries(this,this._session,update);return true;case"connecting":case"syncing":this._updatesToSend.push(update);return true;case"disconnected":default:return false}}},{key:"publishEvent",value:function publishEvent(groupName,eventName,payload){return this._eventPublisher.publish(groupName,eventName,payload)}},{key:"sync",value:function sync(){if(this.state==="connected"){this.preempt("syncing");this._session.sendReinvite();return true}return false}}]);return Transport}(StateMachine);function createSession(transport,name,accessToken,localParticipant,peerConnectionManager,ua,SIPJSMediaHandler,iceServerSourceStatus,dominantSpeaker,networkQuality){var target="sip:"+util.makeServerSIPURI();return ua.invite(target,{extraHeaders:[constants.headers.X_TWILIO_ACCESSTOKEN+": "+accessToken,"Session-Expires: 120"],media:{stream:{}},mediaHandlerFactory:function mediaHandlerFactory(){return new SIPJSMediaHandler(peerConnectionManager,function createMessage(){if(transport.state==="disconnected"){return{type:"disconnect",version:RSP_VERSION}}var type={connecting:"connect",syncing:"sync"}[transport.state]||"update";var message={name:name,participant:localParticipant.getState(),type:type,version:RSP_VERSION};if(message.type==="connect"){message.ice_servers=iceServerSourceStatus;message.publisher={name:SDK_NAME,sdk_version:SDK_VERSION,user_agent:transport._userAgent};message.media_signaling={};if(networkQuality){message.media_signaling.network_quality={transports:[{type:"data-channel"}]}}if(dominantSpeaker){message.media_signaling.active_speaker={transports:[{type:"data-channel"}]}}}var sdpFormat=transport._sdpFormat;if(type==="connect"&&sdpFormat){message.format=sdpFormat}return message})},onInfo:function onInfo(request){this.emit("info",request);request.reply(200)}})}function withJitter(value,jitter){var rand=Math.random();return value-jitter+Math.floor(2*jitter*rand+.5)}function publishWithRetries(transport,session,payload,attempts){attempts=attempts||0;return new Promise(function(resolve,reject){function receiveResponse(response){switch(Math.floor(response.status_code/100)){case 2:resolve();break;case 5:if(attempts<constants.PUBLISH_MAX_ATTEMPTS){resolve(publishWithRetries(transport,session,payload,++attempts))}else{reject(new Error("Transport failed to send a message even after "+constants.PUBLISH_MAX_ATTEMPTS+" attempts"))}break;default:reject(response)}}function sendRequest(){if(transport.state==="disconnected"){return}session.sendRequest("INFO",{body:JSON.stringify(payload),extraHeaders:["Content-Type: application/room-signaling+json","Event: room-signaling","Info-Package: room-signaling"],receiveResponse:receiveResponse})}if(attempts===0){sendRequest();return}var backOffMs=(1<<attempts-1)*constants.PUBLISH_BACKOFF_MS;setTimeout(sendRequest,withJitter(backOffMs,constants.PUBLISH_BACKOFF_JITTER))})}function reducePeerConnections(peerConnections){return Array.from(peerConnections.reduce(function(peerConnectionsById,update){var reduced=peerConnectionsById.get(update.id)||update;if(!reduced.description&&update.description){reduced.description=update.description}else if(reduced.description&&update.description){if(update.description.revision>reduced.description.revision){reduced.description=update.description}}if(!reduced.ice&&update.ice){reduced.ice=update.ice}else if(reduced.ice&&update.ice){if(update.ice.revision>reduced.ice.revision){reduced.ice=update.ice}}peerConnectionsById.set(reduced.id,reduced);return peerConnectionsById},new Map).values())}function reduceUpdates(updates){return updates.reduce(function(reduced,update){if(!reduced.participant&&update.participant){reduced.participant=update.participant}else if(reduced.participant&&update.participant){if(update.participant.revision>reduced.participant.revision){reduced.participant=update.participant}}if(!reduced.peer_connections&&update.peer_connections){reduced.peer_connections=reducePeerConnections(update.peer_connections)}else if(reduced.peer_connections&&update.peer_connections){reduced.peer_connections=reducePeerConnections(reduced.peer_connections.concat(update.peer_connections))}return reduced},{type:"update",version:RSP_VERSION})}function parseRequestOrResponseBody(requestOrResponse){if(requestOrResponse.body){try{return JSON.parse(requestOrResponse.body)}catch(e){throw new SignalingIncomingMessageInvalidError}}return null}function getTwilioErrorFromRequestOrResponseBody(requestOrResponse){try{var message=parseRequestOrResponseBody(requestOrResponse);if(message){switch(message.type){case"disconnected":if(message.status==="completed"){return new RoomCompletedError}break;case"error":return createTwilioError(message.code,message.message);default:break}}return null}catch(error){return error}}function getTwilioErrorFromRequestOrResponseHeaders(requestOrResponse){var headers=requestOrResponse.headers;if(headers&&headers["X-Twilio-Error"]){var twilioErrorHeader=headers["X-Twilio-Error"][0].raw.split(" ");var code=parseInt(twilioErrorHeader[0],10);var message=twilioErrorHeader.slice(1).join(" ");return createTwilioError(code,message)}return null}function getTwilioErrorFromRequestOrResponse(requestOrResponse){return getTwilioErrorFromRequestOrResponseHeaders(requestOrResponse)||getTwilioErrorFromRequestOrResponseBody(requestOrResponse)}function setupEventListeners(transport,session,ua){function disconnect(requestOrResponse,cause){var twilioError=void 0;if(requestOrResponse&&!(requestOrResponse instanceof SIP.OutgoingRequest)){twilioError=getTwilioErrorFromRequestOrResponse(requestOrResponse)}if(!twilioError){switch(cause){case SIP.C.causes.REQUEST_TIMEOUT:twilioError=new SignalingConnectionTimeoutError;break;case SIP.C.causes.CONNECTION_ERROR:twilioError=new SignalingConnectionError;break;default:twilioError=new SignalingConnectionDisconnectedError}}transport.disconnect(twilioError)}function handleRequestOrResponse(requestOrResponse){if(requestOrResponse instanceof SIP.OutgoingRequest){return}var error=void 0;try{error=getTwilioErrorFromRequestOrResponse(requestOrResponse)}catch(e){if(e instanceof SignalingIncomingMessageInvalidError){return}error=e}if(error){transport.disconnect(error);return}var message=void 0;try{message=parseRequestOrResponseBody(requestOrResponse)}catch(e){}if(!message){return}switch(transport.state){case"connected":switch(message.type){case"connected":case"synced":case"update":transport.emit("message",message);return;case"disconnected":transport.disconnect(message.status==="completed"?new RoomCompletedError:null);return;default:return}case"connecting":switch(message.type){case"connected":transport.emit("connected",message);transport.preempt("connected");return;case"synced":case"update":transport._updatesReceived.push(message);return;case"disconnected":transport.disconnect(message.status==="completed"?new RoomCompletedError:null);return;default:return}case"disconnected":return;case"syncing":switch(message.type){case"connected":case"update":transport._updatesReceived.push(message);return;case"synced":transport.emit("message",message);transport.preempt("connected");return;case"disconnected":transport.disconnect(message.status==="completed"?new RoomCompletedError:null);return;default:return}default:return}}session.on("info",handleRequestOrResponse);session.once("bye",disconnect);session.once("accepted",handleRequestOrResponse);session.once("failed",disconnect);transport.on("stateChanged",function stateChanged(state){switch(state){case"connected":{session.removeListener("accepted",handleRequestOrResponse);session.removeListener("failed",disconnect);var updates=transport._updatesToSend.splice(0);if(updates.length){transport.publish(reduceUpdates(updates))}transport._updatesReceived.splice(0).forEach(transport.emit.bind(transport,"message"));return}case"disconnected":session.removeListener("accepted",handleRequestOrResponse);session.removeListener("failed",disconnect);session.removeListener("info",handleRequestOrResponse);session.removeListener("bye",disconnect);transport.removeListener("stateChanged",stateChanged);ua.stop();return;case"syncing":return;default:return}});ua.once("disconnected",disconnect);ua.once("keepAliveTimeout",function(){return transport.disconnect(new SignalingConnectionTimeoutError)})}module.exports=Transport},{"../../../package.json":184,"../../sip":72,"../../statemachine":73,"../../util":109,"../../util/constants":107,"../../util/insightspublisher":110,"../../util/insightspublisher/null":111,"../../util/twilio-video-errors":121,"./sipjsmediahandler":70,"@twilio/webrtc/lib/util/sdp":177}],72:[function(require,module,exports){(function(global){"use strict";var toplevel=global.window||global;var Transport=require("@twilio/sip.js/src/Transport");var WebSocket=toplevel.WebSocket?toplevel.WebSocket:require("ws");var addEventListener=toplevel.addEventListener?toplevel.addEventListener.bind(toplevel):null;module.exports=require("@twilio/sip.js/src/SIP")({addEventListener:addEventListener,console:toplevel.console,Promise:toplevel.Promise,WebSocket:WebSocket,timers:toplevel,Transport:Transport})}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"@twilio/sip.js/src/SIP":144,"@twilio/sip.js/src/Transport":153,ws:185}],73:[function(require,module,exports){"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var util=require("./util");var StateMachine=function(_EventEmitter){_inherits(StateMachine,_EventEmitter);function StateMachine(initialState,states){_classCallCheck(this,StateMachine)
    ;var _this=_possibleConstructorReturn(this,(StateMachine.__proto__||Object.getPrototypeOf(StateMachine)).call(this));var lock=null;var state=initialState;states=transformStates(states);Object.defineProperties(_this,{_lock:{get:function get(){return lock},set:function set(_lock){lock=_lock}},_reachableStates:{value:reachable(states)},_state:{get:function get(){return state},set:function set(_state){state=_state}},_states:{value:states},_whenDeferreds:{value:new Set},isLocked:{enumerable:true,get:function get(){return lock!==null}},state:{enumerable:true,get:function get(){return state}}});_this.on("stateChanged",function(state){_this._whenDeferreds.forEach(function(deferred){deferred.when(state,deferred.resolve,deferred.reject)})});return _this}_createClass(StateMachine,[{key:"_whenPromise",value:function _whenPromise(when){var _this2=this;if(typeof when!=="function"){return Promise.reject(new Error("when() executor must be a function"))}var deferred=util.defer();deferred.when=when;this._whenDeferreds.add(deferred);return deferred.promise.then(function(payload){_this2._whenDeferreds.delete(deferred);return payload},function(error){_this2._whenDeferreds.delete(deferred);throw error})}},{key:"bracket",value:function bracket(name,transitionFunction){var key=void 0;var self=this;function releaseLock(error){if(self.hasLock(key)){self.releaseLockCompletely(key)}if(error){throw error}}return this.takeLock(name).then(function gotKey(_key){key=_key;return transitionFunction(key)}).then(function success(result){releaseLock();return result},releaseLock)}},{key:"hasLock",value:function hasLock(key){return this._lock===key}},{key:"preempt",value:function preempt(newState,name,payload){if(!isValidTransition(this._states,this.state,newState)){throw new Error('Cannot transition from "'+this.state+'" to "'+newState+'"')}var oldLock=void 0;if(this.isLocked){oldLock=this._lock;this._lock=null}var key=null;if(name){key=this.takeLockSync(name)}var preemptionKey=key?null:this.takeLockSync("preemption");this.transition(newState,key||preemptionKey,payload);if(oldLock){oldLock.resolve()}if(preemptionKey){this.releaseLock(preemptionKey)}return key}},{key:"releaseLock",value:function releaseLock(key){if(!this.isLocked){throw new Error("Could not release the lock for "+key.name+" because the StateMachine is not locked")}else if(!this.hasLock(key)){throw new Error("Could not release the lock for "+key.name+" because "+this._lock.name+" has the lock")}if(key.depth===0){this._lock=null;key.resolve()}else{key.depth--}}},{key:"releaseLockCompletely",value:function releaseLockCompletely(key){if(!this.isLocked){throw new Error("Could not release the lock for "+key.name+" because the StateMachine is not locked")}else if(!this.hasLock(key)){throw new Error("Could not release the lock for "+key.name+" because "+this._lock.name+" has the lock")}key.depth=0;this._lock=null;key.resolve()}},{key:"takeLock",value:function takeLock(nameOrKey){var _this3=this;if((typeof nameOrKey==="undefined"?"undefined":_typeof(nameOrKey))==="object"){var key=nameOrKey;return new Promise(function(resolve){resolve(_this3.takeLockSync(key))})}var name=nameOrKey;if(this.isLocked){var takeLock=this.takeLock.bind(this,name);return this._lock.promise.then(takeLock)}return Promise.resolve(this.takeLockSync(name))}},{key:"takeLockSync",value:function takeLockSync(nameOrKey){var key=typeof nameOrKey==="string"?null:nameOrKey;var name=key?key.name:nameOrKey;if(key&&!this.hasLock(key)||!key&&this.isLocked){throw new Error("Could not take the lock for "+name+" because the lock for "+this._lock.name+" was not released")}if(key){key.depth++;return key}var lock=makeLock(name);this._lock=lock;return lock}},{key:"transition",value:function transition(newState,key,payload){payload=payload||[];if(this.isLocked){if(!key){throw new Error("You must provide the key in order to "+"transition")}else if(!this.hasLock(key)){throw new Error("Could not transition using the key for "+key.name+" because "+this._lock.name+" has the lock")}}else if(key){throw new Error("Key provided for "+key.name+", but the StateMachine was not locked (possibly due to preemption)")}if(!isValidTransition(this._states,this.state,newState)){throw new Error('Cannot transition from "'+this.state+'" to "'+newState+'"')}this._state=newState;this.emit.apply(this,_toConsumableArray(["stateChanged",newState].concat(payload)))}},{key:"tryTransition",value:function tryTransition(newState,key,payload){try{this.transition(newState,key,payload)}catch(error){return false}return true}},{key:"when",value:function when(state){var _this4=this;if(this.state===state){return Promise.resolve(this)}else if(!isValidTransition(this._reachableStates,this.state,state)){return Promise.reject(createUnreachableError(this.state,state))}return this._whenPromise(function(newState,resolve,reject){if(newState===state){resolve(_this4)}else if(!isValidTransition(_this4._reachableStates,newState,state)){reject(createUnreachableError(newState,state))}})}}]);return StateMachine}(EventEmitter);function isValidTransition(graph,from,to){return graph.get(from).has(to)}function makeLock(name){var lock=util.defer();lock.name=name;lock.depth=0;return lock}function reachable(graph){return Array.from(graph.keys()).reduce(function(newGraph,from){return newGraph.set(from,reachableFrom(graph,from))},new Map)}function reachableFrom(graph,from,to){to=to||new Set;graph.get(from).forEach(function(node){if(!to.has(node)){to.add(node);reachableFrom(graph,node,to).forEach(to.add,to)}});return to}function transformStates(states){var newStates=new Map;for(var key in states){newStates.set(key,new Set(states[key]))}return newStates}function createUnreachableError(here,there){return new Error('"'+there+'" cannot be reached from "'+here+'"')}module.exports=StateMachine},{"./util":109,events:179}],74:[function(require,module,exports){"use strict";function average(xs){xs=xs.filter(function(x){return typeof x==="number"});return xs.length<1?undefined:xs.reduce(function(y,x){return x+y})/xs.length}module.exports=average},{}],75:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var IceReport=function(){function IceReport(send,recv,availableSend,rtt){_classCallCheck(this,IceReport);Object.defineProperties(this,{availableSend:{enumerable:true,value:availableSend},recv:{enumerable:true,value:recv},rtt:{enumerable:true,value:rtt},send:{enumerable:true,value:send}})}_createClass(IceReport,null,[{key:"of",value:function of(olderStats,newerStats){var secondsElapsed=(newerStats.timestamp-olderStats.timestamp)/1e3;var deltaBytesSent=newerStats.bytesSent-olderStats.bytesSent;var deltaBytesReceived=newerStats.bytesReceived-olderStats.bytesReceived;var send=secondsElapsed>0?deltaBytesSent/secondsElapsed*8:0;var recv=secondsElapsed>0?deltaBytesReceived/secondsElapsed*8:0;var availableSend=newerStats.availableOutgoingBitrate,rtt=newerStats.currentRoundTripTime;return new IceReport(send,recv,availableSend,rtt)}}]);return IceReport}();module.exports=IceReport},{}],76:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var IceReport=require("./icereport");var IceReportFactory=function(){function IceReportFactory(){_classCallCheck(this,IceReportFactory);Object.defineProperties(this,{lastReport:{enumerable:true,value:new IceReport(0,0),writable:true},lastStats:{enumerable:true,value:null,writable:true}})}_createClass(IceReportFactory,[{key:"next",value:function next(newerStats){var olderStats=this.lastStats;this.lastStats=newerStats;if(olderStats){var report=olderStats.id===newerStats.id?IceReport.of(olderStats,newerStats):new IceReport(0,0);this.lastReport=report}return this.lastReport}}]);return IceReportFactory}();module.exports=IceReportFactory},{"./icereport":75}],77:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var LocalTrackStats=require("./localtrackstats");var LocalAudioTrackStats=function(_LocalTrackStats){_inherits(LocalAudioTrackStats,_LocalTrackStats);function LocalAudioTrackStats(trackId,statsReport){_classCallCheck(this,LocalAudioTrackStats);var _this=_possibleConstructorReturn(this,(LocalAudioTrackStats.__proto__||Object.getPrototypeOf(LocalAudioTrackStats)).call(this,trackId,statsReport));Object.defineProperties(_this,{audioLevel:{value:typeof statsReport.audioInputLevel==="number"?statsReport.audioInputLevel:null,enumerable:true},jitter:{value:typeof statsReport.jitter==="number"?statsReport.jitter:null,enumerable:true}});return _this}return LocalAudioTrackStats}(LocalTrackStats);module.exports=LocalAudioTrackStats},{"./localtrackstats":78}],78:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TrackStats=require("./trackstats");var LocalTrackStats=function(_TrackStats){_inherits(LocalTrackStats,_TrackStats);function LocalTrackStats(trackId,statsReport){_classCallCheck(this,LocalTrackStats);var _this=_possibleConstructorReturn(this,(LocalTrackStats.__proto__||Object.getPrototypeOf(LocalTrackStats)).call(this,trackId,statsReport));Object.defineProperties(_this,{bytesSent:{value:typeof statsReport.bytesSent==="number"?statsReport.bytesSent:null,enumerable:true},packetsSent:{value:typeof statsReport.packetsSent==="number"?statsReport.packetsSent:null,enumerable:true},roundTripTime:{value:typeof statsReport.roundTripTime==="number"?statsReport.roundTripTime:null,enumerable:true}});return _this}return LocalTrackStats}(TrackStats);module.exports=LocalTrackStats},{"./trackstats":103}],79:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var LocalTrackStats=require("./localtrackstats");var LocalVideoTrackStats=function(_LocalTrackStats){_inherits(LocalVideoTrackStats,_LocalTrackStats);function LocalVideoTrackStats(trackId,statsReport){_classCallCheck(this,LocalVideoTrackStats);var _this=_possibleConstructorReturn(this,(LocalVideoTrackStats.__proto__||Object.getPrototypeOf(LocalVideoTrackStats)).call(this,trackId,statsReport));var captureDimensions=null;if(typeof statsReport.frameWidthInput==="number"&&typeof statsReport.frameHeightInput==="number"){captureDimensions={};Object.defineProperties(captureDimensions,{width:{value:statsReport.frameWidthInput,enumerable:true},height:{value:statsReport.frameHeightInput,enumerable:true}})}var dimensions=null;if(typeof statsReport.frameWidthSent==="number"&&typeof statsReport.frameHeightSent==="number"){dimensions={};Object.defineProperties(dimensions,{width:{value:statsReport.frameWidthSent,enumerable:true},height:{value:statsReport.frameHeightSent,enumerable:true}})}Object.defineProperties(_this,{captureDimensions:{value:captureDimensions,enumerable:true},dimensions:{value:dimensions,enumerable:true},captureFrameRate:{value:typeof statsReport.frameRateInput==="number"?statsReport.frameRateInput:null,enumerable:true},frameRate:{value:typeof statsReport.frameRateSent==="number"?statsReport.frameRateSent:null,enumerable:true}});return _this}return LocalVideoTrackStats}(LocalTrackStats);module.exports=LocalVideoTrackStats},{"./localtrackstats":78}],80:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var NetworkQualityMediaStats=require("./networkqualitymediastats");var NetworkQualityAudioStats=function(_NetworkQualityMediaS){_inherits(NetworkQualityAudioStats,_NetworkQualityMediaS);function NetworkQualityAudioStats(mediaLevels){_classCallCheck(this,NetworkQualityAudioStats);return _possibleConstructorReturn(this,(NetworkQualityAudioStats.__proto__||Object.getPrototypeOf(NetworkQualityAudioStats)).call(this,mediaLevels))}return NetworkQualityAudioStats}(NetworkQualityMediaStats);module.exports=NetworkQualityAudioStats},{"./networkqualitymediastats":84}],81:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var NetworkQualityBandwidthStats=function NetworkQualityBandwidthStats(_ref){var _ref$actual=_ref.actual,actual=_ref$actual===undefined?null:_ref$actual,_ref$available=_ref.available,available=_ref$available===undefined?null:_ref$available,_ref$level=_ref.level,level=_ref$level===undefined?null:_ref$level;_classCallCheck(this,NetworkQualityBandwidthStats);Object.defineProperties(this,{actual:{value:actual,enumerable:true},available:{value:available,enumerable:true},level:{value:level,enumerable:true}})};module.exports=NetworkQualityBandwidthStats},{}],82:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var NetworkQualityFractionLostStats=function NetworkQualityFractionLostStats(_ref){var _ref$fractionLost=_ref.fractionLost,fractionLost=_ref$fractionLost===undefined?null:_ref$fractionLost,_ref$level=_ref.level,level=_ref$level===undefined?null:_ref$level;_classCallCheck(this,NetworkQualityFractionLostStats);Object.defineProperties(this,{fractionLost:{value:fractionLost,enumerable:true},level:{value:level,enumerable:true}})};module.exports=NetworkQualityFractionLostStats},{}],83:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var NetworkQualityLatencyStats=function NetworkQualityLatencyStats(_ref){var _ref$jitter=_ref.jitter,jitter=_ref$jitter===undefined?null:_ref$jitter,_ref$rtt=_ref.rtt,rtt=_ref$rtt===undefined?null:_ref$rtt,_ref$level=_ref.level,level=_ref$level===undefined?null:_ref$level;_classCallCheck(this,NetworkQualityLatencyStats);Object.defineProperties(this,{jitter:{value:jitter,enumerable:true},rtt:{value:rtt,enumerable:true},level:{value:level,enumerable:true}})};module.exports=NetworkQualityLatencyStats},{}],84:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var NetworkQualitySendStats=require("./networkqualitysendstats");var NetworkQualityRecvStats=require("./networkqualityrecvstats");var NetworkQualityMediaStats=function NetworkQualityMediaStats(_ref){var send=_ref.send,recv=_ref.recv,_ref$sendStats=_ref.sendStats,sendStats=_ref$sendStats===undefined?null:_ref$sendStats,_ref$recvStats=_ref.recvStats,recvStats=_ref$recvStats===undefined?null:_ref$recvStats;_classCallCheck(this,NetworkQualityMediaStats);Object.defineProperties(this,{send:{value:send,enumerable:true},recv:{value:recv,enumerable:true},sendStats:{value:sendStats?new NetworkQualitySendStats(sendStats):null,enumerable:true},recvStats:{value:recvStats?new NetworkQualityRecvStats(recvStats):null,enumerable:true}})};module.exports=NetworkQualityMediaStats},{"./networkqualityrecvstats":85,"./networkqualitysendstats":87}],85:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var NetworkQualitySendOrRecvStats=require("./networkqualitysendorrecvstats");var NetworkQualityRecvStats=function(_NetworkQualitySendOr){_inherits(NetworkQualityRecvStats,_NetworkQualitySendOr);function NetworkQualityRecvStats(sendOrRecvStats){_classCallCheck(this,NetworkQualityRecvStats);return _possibleConstructorReturn(this,(NetworkQualityRecvStats.__proto__||Object.getPrototypeOf(NetworkQualityRecvStats)).call(this,sendOrRecvStats))}return NetworkQualityRecvStats}(NetworkQualitySendOrRecvStats);module.exports=NetworkQualityRecvStats},{"./networkqualitysendorrecvstats":86}],86:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var NetworkQualityBandwidthStats=require("./networkqualitybandwidthstats");var NetworkQualityFractionLostStats=require("./networkqualityfractionloststats");var NetworkQualityLatencyStats=require("./networkqualitylatencystats");var NetworkQualitySendOrRecvStats=function NetworkQualitySendOrRecvStats(_ref){var _ref$bandwidth=_ref.bandwidth,bandwidth=_ref$bandwidth===undefined?null:_ref$bandwidth,_ref$fractionLost=_ref.fractionLost,fractionLost=_ref$fractionLost===undefined?null:_ref$fractionLost,_ref$latency=_ref.latency,latency=_ref$latency===undefined?null:_ref$latency;_classCallCheck(this,NetworkQualitySendOrRecvStats);Object.defineProperties(this,{bandwidth:{value:bandwidth?new NetworkQualityBandwidthStats(bandwidth):null,enumerable:true},fractionLost:{value:fractionLost?new NetworkQualityFractionLostStats(fractionLost):null,enumerable:true},latency:{value:latency?new NetworkQualityLatencyStats(latency):null,enumerable:true}})};module.exports=NetworkQualitySendOrRecvStats},{"./networkqualitybandwidthstats":81,"./networkqualityfractionloststats":82,"./networkqualitylatencystats":83}],87:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var NetworkQualitySendOrRecvStats=require("./networkqualitysendorrecvstats");var NetworkQualitySendStats=function(_NetworkQualitySendOr){_inherits(NetworkQualitySendStats,_NetworkQualitySendOr);function NetworkQualitySendStats(sendOrRecvStats){_classCallCheck(this,NetworkQualitySendStats);return _possibleConstructorReturn(this,(NetworkQualitySendStats.__proto__||Object.getPrototypeOf(NetworkQualitySendStats)).call(this,sendOrRecvStats))}return NetworkQualitySendStats}(NetworkQualitySendOrRecvStats);module.exports=NetworkQualitySendStats},{"./networkqualitysendorrecvstats":86}],88:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var NetworkQualityAudioStats=require("./networkqualityaudiostats");var NetworkQualityVideoStats=require("./networkqualityvideostats");var NetworkQualityStats=function NetworkQualityStats(_ref){var level=_ref.level,audio=_ref.audio,video=_ref.video;_classCallCheck(this,NetworkQualityStats);Object.defineProperties(this,{level:{value:level,enumerable:true},audio:{value:audio?new NetworkQualityAudioStats(audio):null,enumerable:true},video:{value:video?new NetworkQualityVideoStats(video):null,enumerable:true}})};module.exports=NetworkQualityStats},{"./networkqualityaudiostats":80,"./networkqualityvideostats":89}],89:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var NetworkQualityMediaStats=require("./networkqualitymediastats");var NetworkQualityVideoStats=function(_NetworkQualityMediaS){_inherits(NetworkQualityVideoStats,_NetworkQualityMediaS);function NetworkQualityVideoStats(mediaLevels){_classCallCheck(this,NetworkQualityVideoStats);return _possibleConstructorReturn(this,(NetworkQualityVideoStats.__proto__||Object.getPrototypeOf(NetworkQualityVideoStats)).call(this,mediaLevels))}return NetworkQualityVideoStats}(NetworkQualityMediaStats);module.exports=NetworkQualityVideoStats},{"./networkqualitymediastats":84}],90:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var ReceiverReport=require("./receiverreport");var SenderReport=require("./senderreport");var PeerConnectionReport=function(){function PeerConnectionReport(ice,audio,video){_classCallCheck(this,PeerConnectionReport);Object.defineProperties(this,{ice:{enumerable:true,value:ice},audio:{enumerable:true,value:audio},video:{enumerable:true,value:video}})}_createClass(PeerConnectionReport,[{key:"summarize",value:function summarize(){var senderReports=this.audio.send.concat(this.video.send);var send=SenderReport.summarize(senderReports);var receiverReports=this.audio.recv.concat(this.video.recv);var recv=ReceiverReport.summarize(receiverReports);return{ice:this.ice,send:send,recv:recv,audio:{send:SenderReport.summarize(this.audio.send),recv:ReceiverReport.summarize(this.audio.recv)},video:{send:SenderReport.summarize(this.video.send),recv:ReceiverReport.summarize(this.video.recv)}}}}]);return PeerConnectionReport}();module.exports=PeerConnectionReport},{"./receiverreport":92,"./senderreport":99}],91:[function(require,module,exports){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var IceReportFactory=require("./icereportfactory");var PeerConnectionReport=require("./peerconnectionreport");var ReceiverReportFactory=require("./receiverreportfactory");var SenderReportFactory=require("./senderreportfactory");var PeerConnectionReportFactory=function(){function PeerConnectionReportFactory(pc){_classCallCheck(this,PeerConnectionReportFactory);Object.defineProperties(this,{pc:{enumerable:true,value:pc},ice:{enumerable:true,value:new IceReportFactory},audio:{enumerable:true,value:{send:new Map,recv:new Map}},video:{enumerable:true,value:{send:new Map,recv:new Map}},lastReport:{enumerable:true,value:null,writable:true}})}_createClass(PeerConnectionReportFactory,[{key:"next",value:function next(){var _this=this;var updatePromise=typeof mozRTCPeerConnection!=="undefined"?updateFirefox(this):updateChrome(this);return updatePromise.then(function(){var audioSenderReportFactories=[].concat(_toConsumableArray(_this.audio.send.values()));var videoSenderReportFactories=[].concat(_toConsumableArray(_this.video.send.values()));var audioReceiverReportFactories=[].concat(_toConsumableArray(_this.audio.recv.values()));var videoReceiverReportFactories=[].concat(_toConsumableArray(_this.video.recv.values()));var report=new PeerConnectionReport(_this.ice.lastReport,{send:audioSenderReportFactories.map(function(factory){return factory.lastReport}).filter(function(report){return report}),recv:audioReceiverReportFactories.map(function(factory){return factory.lastReport}).filter(function(report){return report})},{send:videoSenderReportFactories.map(function(factory){return factory.lastReport}).filter(function(report){return report}),recv:videoReceiverReportFactories.map(function(factory){return factory.lastReport}).filter(function(report){return report})});_this.lastReport=report;return report})}}]);return PeerConnectionReportFactory}();function getSenderOrReceiverReports(sendersOrReceivers){return Promise.all(sendersOrReceivers.map(function(senderOrReceiver){var trackId=senderOrReceiver.track.id;return senderOrReceiver.getStats().then(function(report){var _iteratorNormalCompletion=true;var _didIteratorError=false;var _iteratorError=undefined;try{for(var _iterator=report.values()[Symbol.iterator](),_step;!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=true){var stats=_step.value;if(stats.type==="inbound-rtp"){stats.id=trackId+"-"+stats.id}}}catch(err){_didIteratorError=true;_iteratorError=err}finally{try{if(!_iteratorNormalCompletion&&_iterator.return){_iterator.return()}}finally{if(_didIteratorError){throw _iteratorError}}}return[trackId,report]})})).then(function(pairs){return new Map(pairs)})}function getOrCreateSenderOrReceiverReportFactory(SenderOrReceiverReportFactory,sendersOrReceiversByMediaType,report,stats,trackId){var sendersOrReceivers=sendersOrReceiversByMediaType[stats.mediaType];if(!trackId){var trackStats=report.get(stats.trackId);if(trackStats){trackId=trackStats.trackIdentifier}}if(sendersOrReceivers&&trackId){if(sendersOrReceivers.has(stats.id)){return sendersOrReceivers.get(stats.id)}var senderOrReceiverFactory=new SenderOrReceiverReportFactory(trackId,stats);sendersOrReceivers.set(stats.id,senderOrReceiverFactory)}return null}
        function getSenderReportFactoriesByMediaType(factory){return{audio:factory.audio.send,video:factory.video.send}}function getReceiverReportFactoriesByMediaType(factory){return{audio:factory.audio.recv,video:factory.video.recv}}function getOrCreateSenderReportFactory(factory,report,stats,trackId){return getOrCreateSenderOrReceiverReportFactory(SenderReportFactory,getSenderReportFactoriesByMediaType(factory),report,stats,trackId)}function getOrCreateReceiverReportFactory(factory,report,stats,trackId){return getOrCreateSenderOrReceiverReportFactory(ReceiverReportFactory,getReceiverReportFactoriesByMediaType(factory),report,stats,trackId)}function getSenderReportFactoryIdsByMediaType(factory){return{audio:new Set(factory.audio.send.keys()),video:new Set(factory.video.send.keys())}}function getReceiverReportFactoryIdsByMediaType(factory){return{audio:new Set(factory.audio.recv.keys()),video:new Set(factory.video.recv.keys())}}function updateSenderReports(factory,report,senderReportFactoryIdsToDeleteByMediaType,trackId){var _iteratorNormalCompletion2=true;var _didIteratorError2=false;var _iteratorError2=undefined;try{for(var _iterator2=report.values()[Symbol.iterator](),_step2;!(_iteratorNormalCompletion2=(_step2=_iterator2.next()).done);_iteratorNormalCompletion2=true){var stats=_step2.value;if(stats.type==="outbound-rtp"&&!stats.isRemote){if(typeof mozRTCPeerConnection==="undefined"&&!stats.trackId){continue}var senderReportFactoryIdsToDelete=senderReportFactoryIdsToDeleteByMediaType[stats.mediaType];if(senderReportFactoryIdsToDelete){senderReportFactoryIdsToDelete.delete(stats.id)}var senderReportFactory=getOrCreateSenderReportFactory(factory,report,stats,trackId);if(senderReportFactory){var remoteInboundStats=report.get(stats.remoteId);senderReportFactory.next(trackId||senderReportFactory.trackId,stats,remoteInboundStats)}}}}catch(err){_didIteratorError2=true;_iteratorError2=err}finally{try{if(!_iteratorNormalCompletion2&&_iterator2.return){_iterator2.return()}}finally{if(_didIteratorError2){throw _iteratorError2}}}}function updateReceiverReports(factory,report,receiverReportFactoryIdsToDeleteByMediaType,trackId){var _iteratorNormalCompletion3=true;var _didIteratorError3=false;var _iteratorError3=undefined;try{for(var _iterator3=report.values()[Symbol.iterator](),_step3;!(_iteratorNormalCompletion3=(_step3=_iterator3.next()).done);_iteratorNormalCompletion3=true){var stats=_step3.value;if(stats.type==="inbound-rtp"&&!stats.isRemote){var receiverReportFactoryIdsToDelete=receiverReportFactoryIdsToDeleteByMediaType[stats.mediaType];if(receiverReportFactoryIdsToDelete){receiverReportFactoryIdsToDelete.delete(stats.id)}var receiverReportFactory=getOrCreateReceiverReportFactory(factory,report,stats,trackId);if(receiverReportFactory){receiverReportFactory.next(trackId||receiverReportFactory.trackId,stats)}}}}catch(err){_didIteratorError3=true;_iteratorError3=err}finally{try{if(!_iteratorNormalCompletion3&&_iterator3.return){_iterator3.return()}}finally{if(_didIteratorError3){throw _iteratorError3}}}}function deleteSenderOrReceiverReportFactories(senderOrReceiverReportFactoriesByMediaType,senderOrReceiverReportFactoryIdsByMediaType){var _loop=function _loop(mediaType){var senderOrReceiverReportFactories=senderOrReceiverReportFactoriesByMediaType[mediaType];var senderOrReceiverReportFactoryIds=senderOrReceiverReportFactoryIdsByMediaType[mediaType];senderOrReceiverReportFactoryIds.forEach(function(senderOrReceiverReportFactoryId){return senderOrReceiverReportFactories.delete(senderOrReceiverReportFactoryId)})};for(var mediaType in senderOrReceiverReportFactoryIdsByMediaType){_loop(mediaType)}}function updateIceReport(ice,report){var selectedCandidatePair=void 0;var _iteratorNormalCompletion4=true;var _didIteratorError4=false;var _iteratorError4=undefined;try{for(var _iterator4=report.values()[Symbol.iterator](),_step4;!(_iteratorNormalCompletion4=(_step4=_iterator4.next()).done);_iteratorNormalCompletion4=true){var stats=_step4.value;if(stats.type==="transport"){selectedCandidatePair=report.get(stats.selectedCandidatePairId)}}}catch(err){_didIteratorError4=true;_iteratorError4=err}finally{try{if(!_iteratorNormalCompletion4&&_iterator4.return){_iterator4.return()}}finally{if(_didIteratorError4){throw _iteratorError4}}}if(selectedCandidatePair){ice.next(selectedCandidatePair);return}var _iteratorNormalCompletion5=true;var _didIteratorError5=false;var _iteratorError5=undefined;try{for(var _iterator5=report.values()[Symbol.iterator](),_step5;!(_iteratorNormalCompletion5=(_step5=_iterator5.next()).done);_iteratorNormalCompletion5=true){var _stats=_step5.value;if(_stats.type==="candidate-pair"&&_stats.nominated&&("selected"in _stats?_stats.selected:true)){ice.next(_stats)}}}catch(err){_didIteratorError5=true;_iteratorError5=err}finally{try{if(!_iteratorNormalCompletion5&&_iterator5.return){_iterator5.return()}}finally{if(_didIteratorError5){throw _iteratorError5}}}}function updateFirefox(factory){var senders=factory.pc.getTransceivers().filter(function(transceiver){return transceiver.currentDirection&&transceiver.currentDirection.match(/send/)&&transceiver.sender.track}).map(function(transceiver){return transceiver.sender});var receivers=factory.pc.getTransceivers().filter(function(transceiver){return transceiver.currentDirection&&transceiver.currentDirection.match(/recv/)}).map(function(transceiver){return transceiver.receiver});return Promise.all([getSenderOrReceiverReports(senders),getSenderOrReceiverReports(receivers),factory.pc.getStats()]).then(function(_ref){var _ref2=_slicedToArray(_ref,3),senderReports=_ref2[0],receiverReports=_ref2[1],pcReport=_ref2[2];var senderReportFactoriesByMediaType=getSenderReportFactoriesByMediaType(factory);var senderReportFactoryIdsToDeleteByMediaType=getSenderReportFactoryIdsByMediaType(factory);senderReports.forEach(function(report,trackId){return updateSenderReports(factory,report,senderReportFactoryIdsToDeleteByMediaType,trackId)});deleteSenderOrReceiverReportFactories(senderReportFactoriesByMediaType,senderReportFactoryIdsToDeleteByMediaType);var receiverReportFactoriesByMediaType=getReceiverReportFactoriesByMediaType(factory);var receiverReportFactoryIdsToDeleteByMediaType=getReceiverReportFactoryIdsByMediaType(factory);receiverReports.forEach(function(report,trackId){return updateReceiverReports(factory,report,receiverReportFactoryIdsToDeleteByMediaType,trackId)});deleteSenderOrReceiverReportFactories(receiverReportFactoriesByMediaType,receiverReportFactoryIdsToDeleteByMediaType);updateIceReport(factory.ice,pcReport)})}function updateChrome(factory){return factory.pc.getStats().then(function(report){var senderReportFactoriesByMediaType=getSenderReportFactoriesByMediaType(factory);var senderReportFactoryIdsToDeleteByMediaType=getSenderReportFactoryIdsByMediaType(factory);updateSenderReports(factory,report,senderReportFactoryIdsToDeleteByMediaType);deleteSenderOrReceiverReportFactories(senderReportFactoriesByMediaType,senderReportFactoryIdsToDeleteByMediaType);var receiverReportFactoriesByMediaType=getReceiverReportFactoriesByMediaType(factory);var receiverReportFactoryIdsToDeleteByMediaType=getReceiverReportFactoryIdsByMediaType(factory);updateReceiverReports(factory,report,receiverReportFactoryIdsToDeleteByMediaType);deleteSenderOrReceiverReportFactories(receiverReportFactoriesByMediaType,receiverReportFactoryIdsToDeleteByMediaType);updateIceReport(factory.ice,report)})}module.exports=PeerConnectionReportFactory},{"./icereportfactory":76,"./peerconnectionreport":90,"./receiverreportfactory":93,"./senderreportfactory":100}],92:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var average=require("./average");var SenderOrReceiverReport=require("./senderorreceiverreport");var sum=require("./sum");var ReceiverReport=function(_SenderOrReceiverRepo){_inherits(ReceiverReport,_SenderOrReceiverRepo);function ReceiverReport(id,trackId,bitrate,deltaPacketsLost,deltaPacketsReceived,fractionLost,jitter){_classCallCheck(this,ReceiverReport);var _this=_possibleConstructorReturn(this,(ReceiverReport.__proto__||Object.getPrototypeOf(ReceiverReport)).call(this,id,trackId,bitrate));var phonyFractionLost=deltaPacketsReceived>0?deltaPacketsLost/deltaPacketsReceived:0;Object.defineProperties(_this,{deltaPacketsLost:{enumerable:true,value:deltaPacketsLost},deltaPacketsReceived:{enumerable:true,value:deltaPacketsReceived},fractionLost:{enumerable:true,value:fractionLost},jitter:{enumerable:true,value:jitter},phonyFractionLost:{enumerable:true,value:phonyFractionLost}});return _this}_createClass(ReceiverReport,[{key:"summarize",value:function summarize(){return{bitrate:this.bitrate,fractionLost:typeof this.fractionLost==="number"?this.fractionLost:this.phonyFractionLost,jitter:this.jitter}}}],[{key:"of",value:function of(trackId,olderStats,newerStats){if(olderStats.id!==newerStats.id){throw new Error("RTCStats IDs must match")}var secondsElapsed=(newerStats.timestamp-olderStats.timestamp)/1e3;var deltaBytesReceived=newerStats.bytesReceived-olderStats.bytesReceived;var bitrate=secondsElapsed>0?deltaBytesReceived/secondsElapsed*8:0;var deltaPacketsLost=Math.max(newerStats.packetsLost-olderStats.packetsLost,0);var deltaPacketsReceived=newerStats.packetsReceived-olderStats.packetsReceived;var fractionLost=newerStats.fractionLost,jitter=newerStats.jitter;return new ReceiverReport(olderStats.id,trackId,bitrate,deltaPacketsLost,deltaPacketsReceived,fractionLost,jitter)}},{key:"summarize",value:function summarize(reports){var summaries=reports.map(function(report){return report.summarize()});var bitrate=sum(summaries.map(function(summary){return summary.bitrate}));var fractionLost=average(summaries.map(function(summary){return summary.fractionLost}));var jitter=average(summaries.map(function(summary){return summary.jitter}));return{bitrate:bitrate,fractionLost:fractionLost,jitter:jitter}}}]);return ReceiverReport}(SenderOrReceiverReport);module.exports=ReceiverReport},{"./average":74,"./senderorreceiverreport":97,"./sum":102}],93:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var ReceiverReport=require("./receiverreport");var SenderOrReceiverReportFactory=require("./senderorreceiverreportfactory");var ReceiverReportFactory=function(_SenderOrReceiverRepo){_inherits(ReceiverReportFactory,_SenderOrReceiverRepo);function ReceiverReportFactory(trackId,initialStats){_classCallCheck(this,ReceiverReportFactory);var _this=_possibleConstructorReturn(this,(ReceiverReportFactory.__proto__||Object.getPrototypeOf(ReceiverReportFactory)).call(this,initialStats.id,trackId,initialStats));Object.defineProperties(_this,{lastReport:{enumerable:true,value:null,writable:true}});return _this}_createClass(ReceiverReportFactory,[{key:"next",value:function next(trackId,newerStats){var olderStats=this.lastStats;this.lastStats=newerStats;this.trackId=trackId;var report=ReceiverReport.of(trackId,olderStats,newerStats);this.lastReport=report;return report}}]);return ReceiverReportFactory}(SenderOrReceiverReportFactory);module.exports=ReceiverReportFactory},{"./receiverreport":92,"./senderorreceiverreportfactory":98}],94:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RemoteTrackStats=require("./remotetrackstats");var RemoteAudioTrackStats=function(_RemoteTrackStats){_inherits(RemoteAudioTrackStats,_RemoteTrackStats);function RemoteAudioTrackStats(trackId,statsReport){_classCallCheck(this,RemoteAudioTrackStats);var _this=_possibleConstructorReturn(this,(RemoteAudioTrackStats.__proto__||Object.getPrototypeOf(RemoteAudioTrackStats)).call(this,trackId,statsReport));Object.defineProperties(_this,{audioLevel:{value:typeof statsReport.audioOutputLevel==="number"?statsReport.audioOutputLevel:null,enumerable:true},jitter:{value:typeof statsReport.jitter==="number"?statsReport.jitter:null,enumerable:true}});return _this}return RemoteAudioTrackStats}(RemoteTrackStats);module.exports=RemoteAudioTrackStats},{"./remotetrackstats":95}],95:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TrackStats=require("./trackstats");var RemoteTrackStats=function(_TrackStats){_inherits(RemoteTrackStats,_TrackStats);function RemoteTrackStats(trackId,statsReport){_classCallCheck(this,RemoteTrackStats);var _this=_possibleConstructorReturn(this,(RemoteTrackStats.__proto__||Object.getPrototypeOf(RemoteTrackStats)).call(this,trackId,statsReport));Object.defineProperties(_this,{bytesReceived:{value:typeof statsReport.bytesReceived==="number"?statsReport.bytesReceived:null,enumerable:true},packetsReceived:{value:typeof statsReport.packetsReceived==="number"?statsReport.packetsReceived:null,enumerable:true}});return _this}return RemoteTrackStats}(TrackStats);module.exports=RemoteTrackStats},{"./trackstats":103}],96:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var RemoteTrackStats=require("./remotetrackstats");var RemoteVideoTrackStats=function(_RemoteTrackStats){_inherits(RemoteVideoTrackStats,_RemoteTrackStats);function RemoteVideoTrackStats(trackId,statsReport){_classCallCheck(this,RemoteVideoTrackStats);var _this=_possibleConstructorReturn(this,(RemoteVideoTrackStats.__proto__||Object.getPrototypeOf(RemoteVideoTrackStats)).call(this,trackId,statsReport));var dimensions=null;if(typeof statsReport.frameWidthReceived==="number"&&typeof statsReport.frameHeightReceived==="number"){dimensions={};Object.defineProperties(dimensions,{width:{value:statsReport.frameWidthReceived,enumerable:true},height:{value:statsReport.frameHeightReceived,enumerable:true}})}Object.defineProperties(_this,{dimensions:{value:dimensions,enumerable:true},frameRate:{value:typeof statsReport.frameRateReceived==="number"?statsReport.frameRateReceived:null,enumerable:true}});return _this}return RemoteVideoTrackStats}(RemoteTrackStats);module.exports=RemoteVideoTrackStats},{"./remotetrackstats":95}],97:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var SenderOrReceiverReport=function SenderOrReceiverReport(id,trackId,bitrate){_classCallCheck(this,SenderOrReceiverReport);Object.defineProperties(this,{id:{enumerable:true,value:id},trackId:{enumerable:true,value:trackId},bitrate:{enumerable:true,value:bitrate}})};module.exports=SenderOrReceiverReport},{}],98:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var SenderOrReceiverReportFactory=function SenderOrReceiverReportFactory(id,trackId,initialStats){_classCallCheck(this,SenderOrReceiverReportFactory);Object.defineProperties(this,{id:{enumerable:true,value:id,writable:true},trackId:{enumerable:true,value:trackId,writable:true},lastStats:{enumerable:true,value:initialStats,writable:true}})};module.exports=SenderOrReceiverReportFactory},{}],99:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var average=require("./average");var SenderOrReceiverReport=require("./senderorreceiverreport");var sum=require("./sum");var SenderReport=function(_SenderOrReceiverRepo){_inherits(SenderReport,_SenderOrReceiverRepo);function SenderReport(id,trackId,bitrate,rtt){_classCallCheck(this,SenderReport);var _this=_possibleConstructorReturn(this,(SenderReport.__proto__||Object.getPrototypeOf(SenderReport)).call(this,id,trackId,bitrate));Object.defineProperties(_this,{rtt:{enumerable:true,value:rtt}});return _this}_createClass(SenderReport,null,[{key:"of",value:function of(trackId,olderStats,newerStats,newerRemoteStats){if(olderStats.id!==newerStats.id){throw new Error("RTCStats IDs must match")}var secondsElapsed=(newerStats.timestamp-olderStats.timestamp)/1e3;var deltaBytesSent=newerStats.bytesSent-olderStats.bytesSent;var bitrate=secondsElapsed>0?deltaBytesSent/secondsElapsed*8:0;var rtt=newerRemoteStats&&typeof newerRemoteStats.roundTripTime==="number"?newerRemoteStats.roundTripTime/1e3:undefined;return new SenderReport(olderStats.id,trackId,bitrate,rtt)}},{key:"summarize",value:function summarize(reports){var bitrate=sum(reports.map(function(report){return report.bitrate}));var rtt=average(reports.map(function(report){return report.rtt}));return{bitrate:bitrate,rtt:rtt}}}]);return SenderReport}(SenderOrReceiverReport);module.exports=SenderReport},{"./average":74,"./senderorreceiverreport":97,"./sum":102}],100:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var SenderOrReceiverReportFactory=require("./senderorreceiverreportfactory");var SenderReport=require("./senderreport");var SenderReportFactory=function(_SenderOrReceiverRepo){_inherits(SenderReportFactory,_SenderOrReceiverRepo);function SenderReportFactory(trackId,initialStats){_classCallCheck(this,SenderReportFactory);var _this=_possibleConstructorReturn(this,(SenderReportFactory.__proto__||Object.getPrototypeOf(SenderReportFactory)).call(this,initialStats.id,trackId,initialStats));Object.defineProperties(_this,{lastReport:{enumerable:true,value:null,writable:true}});return _this}_createClass(SenderReportFactory,[{key:"next",value:function next(trackId,newerStats,newerRemoteStats){var olderStats=this.lastStats;this.lastStats=newerStats;this.trackId=trackId;var report=SenderReport.of(trackId,olderStats,newerStats,newerRemoteStats);this.lastReport=report;return report}}]);return SenderReportFactory}(SenderOrReceiverReportFactory);module.exports=SenderReportFactory},{"./senderorreceiverreportfactory":98,"./senderreport":99}],101:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var LocalAudioTrackStats=require("./localaudiotrackstats");var LocalVideoTrackStats=require("./localvideotrackstats");var RemoteAudioTrackStats=require("./remoteaudiotrackstats");var RemoteVideoTrackStats=require("./remotevideotrackstats");var StatsReport=function StatsReport(peerConnectionId,statsResponse){_classCallCheck(this,StatsReport);if(typeof peerConnectionId!=="string"){throw new Error("RTCPeerConnection id must be a string")}Object.defineProperties(this,{peerConnectionId:{value:peerConnectionId,enumerable:true},localAudioTrackStats:{value:statsResponse.localAudioTrackStats.map(function(report){return new LocalAudioTrackStats(report.trackId,report)}),enumerable:true},localVideoTrackStats:{value:statsResponse.localVideoTrackStats.map(function(report){return new LocalVideoTrackStats(report.trackId,report)}),enumerable:true},remoteAudioTrackStats:{value:statsResponse.remoteAudioTrackStats.map(function(report){return new RemoteAudioTrackStats(report.trackId,report)}),enumerable:true},remoteVideoTrackStats:{value:statsResponse.remoteVideoTrackStats.map(function(report){return new RemoteVideoTrackStats(report.trackId,report)}),enumerable:true}})};module.exports=StatsReport},{"./localaudiotrackstats":77,"./localvideotrackstats":79,"./remoteaudiotrackstats":94,"./remotevideotrackstats":96}],102:[function(require,module,exports){"use strict";function sum(xs){return xs.reduce(function(y,x){return typeof x==="number"?x+y:y},0)}module.exports=sum},{}],103:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var TrackStats=function TrackStats(trackId,statsReport){_classCallCheck(this,TrackStats);if(typeof trackId!=="string"){throw new Error("Track id must be a string")}Object.defineProperties(this,{trackId:{value:trackId,enumerable:true},trackSid:{value:statsReport.trackSid,enumerable:true},timestamp:{value:statsReport.timestamp,enumerable:true},ssrc:{value:statsReport.ssrc,enumerable:true},packetsLost:{value:typeof statsReport.packetsLost==="number"?statsReport.packetsLost:null,enumerable:true},codec:{value:typeof statsReport.codecName==="string"?statsReport.codecName:null,enumerable:true}})};module.exports=TrackStats},{}],104:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var TrackTransceiver=function(_EventEmitter){_inherits(TrackTransceiver,_EventEmitter);function TrackTransceiver(id,kind){_classCallCheck(this,TrackTransceiver);var _this=_possibleConstructorReturn(this,(TrackTransceiver.__proto__||Object.getPrototypeOf(TrackTransceiver)).call(this));Object.defineProperties(_this,{id:{enumerable:true,value:id},kind:{enumerable:true,value:kind}});return _this}return TrackTransceiver}(EventEmitter);module.exports=TrackTransceiver},{events:179}],105:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var _require=require("./"),defer=_require.defer;var AsyncVar=function(){function AsyncVar(){_classCallCheck(this,AsyncVar);Object.defineProperties(this,{_deferreds:{value:[]},_hasValue:{value:false,writable:true},_value:{value:null,writable:true}})}_createClass(AsyncVar,[{key:"put",value:function put(value){this._hasValue=true;this._value=value;var deferred=this._deferreds.shift();if(deferred){deferred.resolve(value)}return this}},{key:"take",value:function take(){var _this=this;if(this._hasValue&&!this._deferreds.length){this._hasValue=false;return Promise.resolve(this._value)}var deferred=defer();this._deferreds.push(deferred);return deferred.promise.then(function(value){_this._hasValue=false;return value})}}]);return AsyncVar}();module.exports=AsyncVar},{"./":109}],106:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var CancelablePromise=function(){function CancelablePromise(onCreate,onCancel){var _this=this;_classCallCheck(this,CancelablePromise);Object.defineProperties(this,{_isCancelable:{writable:true,value:true},_isCanceled:{writable:true,value:false},_onCancel:{value:onCancel}});Object.defineProperty(this,"_promise",{value:new Promise(function(resolve,reject){onCreate(function(value){_this._isCancelable=false;resolve(value)},function(reason){_this._isCancelable=false;reject(reason)},function(){return _this._isCanceled})})})}_createClass(CancelablePromise,[{key:"cancel",value:function cancel(){if(this._isCancelable){this._isCanceled=true;this._onCancel()}
            return this}},{key:"catch",value:function _catch(){var args=[].slice.call(arguments);var promise=this._promise;return new CancelablePromise(function onCreate(resolve,reject){promise.catch.apply(promise,_toConsumableArray(args)).then(resolve,reject)},this._onCancel)}},{key:"then",value:function then(){var args=[].slice.call(arguments);var promise=this._promise;return new CancelablePromise(function onCreate(resolve,reject){promise.then.apply(promise,_toConsumableArray(args)).then(resolve,reject)},this._onCancel)}}],[{key:"reject",value:function reject(reason){return new CancelablePromise(function rejected(resolve,reject){reject(reason)},function onCancel(){})}},{key:"resolve",value:function resolve(result){return new CancelablePromise(function resolved(resolve){resolve(result)},function onCancel(){})}}]);return CancelablePromise}();module.exports=CancelablePromise},{}],107:[function(require,module,exports){"use strict";module.exports.DEFAULT_ENVIRONMENT="prod";module.exports.DEFAULT_REALM="us1";module.exports.DEFAULT_LOG_LEVEL="warn";module.exports.REGISTRAR_SERVER="endpoint.twilio.com";module.exports.WS_SERVER=function(environment,realm){switch(environment){case"prod":switch(realm){case"us1":return"wss://endpoint.twilio.com";default:return"wss://endpoint."+realm+".twilio.com"}default:return"wss://endpoint."+environment+"-"+realm+".twilio.com"}};module.exports.ECS_SERVER=function(environment,realm){switch(environment){case"prod":return"https://ecs."+realm+".twilio.com";default:return"https://ecs."+environment+"-"+realm+".twilio.com"}};module.exports.ECS_TIMEOUT=60;module.exports.PUBLISH_MAX_ATTEMPTS=5;module.exports.PUBLISH_BACKOFF_JITTER=10;module.exports.PUBLISH_BACKOFF_MS=20;module.exports.ICE_SERVERS_TIMEOUT_MS=3e3;module.exports.ICE_SERVERS_DEFAULT_TTL=3600;module.exports.DEFAULT_ICE_SERVERS=function(environment){switch(environment){case"prod":return[{urls:"stun:global.stun.twilio.com:3478?transport=udp"}];default:return[{urls:"stun:global.stun."+environment+".twilio.com:3478?transport=udp"}]}};module.exports.headers={X_TWILIO_ACCESSTOKEN:"X-Twilio-AccessToken"};function article(word){return["a","e","i","o","u"].includes(word.toLowerCase()[0])?"an":"a"}module.exports.typeErrors={INVALID_TYPE:function INVALID_TYPE(name,type){return new TypeError(name+" must be "+article(type)+" "+type)},INVALID_VALUE:function INVALID_VALUE(name,values){return new RangeError(name+" must be one of ",values.join(", "))},REQUIRED_ARGUMENT:function REQUIRED_ARGUMENT(name){return new TypeError(name+" must be specified")}};module.exports.DEFAULT_NQ_LEVEL_LOCAL=1;module.exports.DEFAULT_NQ_LEVEL_REMOTE=0;module.exports.MAX_NQ_LEVEL=3},{}],108:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var Filter=function(){function Filter(options){_classCallCheck(this,Filter);options=Object.assign({getKey:function defaultGetKey(a){return a},getValue:function defaultGetValue(a){return a},isLessThanOrEqualTo:function defaultIsLessThanOrEqualTo(a,b){return a<=b}},options);Object.defineProperties(this,{_getKey:{value:options.getKey},_getValue:{value:options.getValue},_isLessThanOrEqualTo:{value:options.isLessThanOrEqualTo},_map:{value:new Map}})}_createClass(Filter,[{key:"toMap",value:function toMap(){return new Map(this._map)}},{key:"updateAndFilter",value:function updateAndFilter(entries){return entries.filter(this.update,this)}},{key:"update",value:function update(entry){var key=this._getKey(entry);var value=this._getValue(entry);if(this._map.has(key)&&this._isLessThanOrEqualTo(value,this._map.get(key))){return false}this._map.set(key,value);return true}}]);return Filter}();module.exports=Filter},{}],109:[function(require,module,exports){"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}var constants=require("./constants");function asLocalTrack(track,options){if(track instanceof options.LocalAudioTrack||track instanceof options.LocalVideoTrack||track instanceof options.LocalDataTrack){return track}if(track instanceof options.MediaStreamTrack){return track.kind==="audio"?new options.LocalAudioTrack(track,options):new options.LocalVideoTrack(track,options)}throw constants.typeErrors.INVALID_TYPE("track","LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack")}function asLocalTrackPublication(track,sid,unpublish,options){var LocalTrackPublication={audio:options.LocalAudioTrackPublication,video:options.LocalVideoTrackPublication,data:options.LocalDataTrackPublication}[track.kind];return new LocalTrackPublication(sid,track,unpublish,options)}function capitalize(word){return word[0].toUpperCase()+word.slice(1)}function deprecateEvents(name,emitter,events,log){var warningsShown=new Set;emitter.on("newListener",function newListener(event){if(events.has(event)&&!warningsShown.has(event)){log.deprecated(name+"#"+event+" has been deprecated and scheduled for removal in twilio-video.js@2.0.0."+(events.get(event)?" Use "+name+"#"+events.get(event)+" instead.":""));warningsShown.add(event)}if(warningsShown.size>=events.size){emitter.removeListener("newListener",newListener)}})}function difference(list1,list2){list1=Array.isArray(list1)?new Set(list1):new Set(list1.values());list2=Array.isArray(list2)?new Set(list2):new Set(list2.values());var difference=new Set;list1.forEach(function(item){if(!list2.has(item)){difference.add(item)}});return difference}function filterObject(object,filterValue){return Object.keys(object).reduce(function(filtered,key){if(object[key]!==filterValue){filtered[key]=object[key]}return filtered},{})}function flatMap(list,mapFn){var listArray=list instanceof Map||list instanceof Set?Array.from(list.values()):list;mapFn=mapFn||function mapFn(item){return item};return listArray.reduce(function(flattened,item){var mapped=mapFn(item);return flattened.concat(mapped)},[])}function getUserAgent(){return typeof navigator!=="undefined"&&navigator.userAgent?navigator.userAgent:"Unknown"}function makeClientSIPURI(){return makeUUID()+"@"+constants.REGISTRAR_SERVER}function makeServerSIPURI(){return"orchestrator@"+constants.REGISTRAR_SERVER}function makeUUID(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r=Math.random()*16|0;var v=c==="x"?r:r&3|8;return v.toString(16)})}function oncePerTick(fn){var timeout=null;function nextTick(){timeout=null;fn()}return function scheduleNextTick(){if(timeout){clearTimeout(timeout)}timeout=setTimeout(nextTick)}}function promiseFromEvents(operation,eventEmitter,successEvent,failureEvent){return new Promise(function(resolve,reject){function onSuccess(){var args=[].slice.call(arguments);if(failureEvent){eventEmitter.removeListener(failureEvent,onFailure)}resolve.apply(undefined,_toConsumableArray(args))}function onFailure(){var args=[].slice.call(arguments);eventEmitter.removeListener(successEvent,onSuccess);reject.apply(undefined,_toConsumableArray(args))}eventEmitter.once(successEvent,onSuccess);if(failureEvent){eventEmitter.once(failureEvent,onFailure)}operation()})}function getOrNull(obj,path){return path.split(".").reduce(function(output,step){if(!output){return null}return output[step]},obj)}function defer(){var deferred={};deferred.promise=new Promise(function(resolve,reject){deferred.resolve=resolve;deferred.reject=reject});return deferred}function delegateMethod(source,wrapper,target,methodName){if(methodName in wrapper){return}else if(methodName.match(/^on[a-z]+$/)){return}var type=void 0;try{type=_typeof(source[methodName])}catch(error){}if(type!=="function"){return}wrapper[methodName]=function(){var _target;return(_target=this[target])[methodName].apply(_target,arguments)}}function delegateMethods(source,wrapper,target){for(var methodName in source){delegateMethod(source,wrapper,target,methodName)}}function proxyProperties(source,wrapper,target){Object.getOwnPropertyNames(source).forEach(function(propertyName){proxyProperty(source,wrapper,target,propertyName)})}function proxyProperty(source,wrapper,target,propertyName){if(propertyName in wrapper){return}else if(propertyName.match(/^on[a-z]+$/)){Object.defineProperty(wrapper,propertyName,{value:null,writable:true});target.addEventListener(propertyName.slice(2),function(){wrapper.dispatchEvent.apply(wrapper,arguments)});return}Object.defineProperty(wrapper,propertyName,{enumerable:true,get:function get(){return target[propertyName]}})}function legacyPromise(promise,onSuccess,onFailure){if(onSuccess){return promise.then(function(result){onSuccess(result)},function(error){onFailure(error)})}return promise}function buildLogLevels(logLevel){if(typeof logLevel==="string"){return{default:logLevel,media:logLevel,signaling:logLevel,webrtc:logLevel}}return logLevel}function trackClass(track,local){local=local?"Local":"";return local+(track.kind||"").replace(/\w{1}/,function(m){return m.toUpperCase()})+"Track"}function trackPublicationClass(publication,local){local=local?"Local":"";return local+(publication.kind||"").replace(/\w{1}/,function(m){return m.toUpperCase()})+"TrackPublication"}function validateLocalTrack(track,options){if(!(track instanceof options.LocalAudioTrack||track instanceof options.LocalDataTrack||track instanceof options.LocalVideoTrack||track instanceof options.MediaStreamTrack)){throw constants.typeErrors.INVALID_TYPE("track","LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack")}}function inRange(num,min,max){return min<=num&&num<=max}exports.constants=constants;exports.asLocalTrack=asLocalTrack;exports.asLocalTrackPublication=asLocalTrackPublication;exports.capitalize=capitalize;exports.deprecateEvents=deprecateEvents;exports.difference=difference;exports.filterObject=filterObject;exports.flatMap=flatMap;exports.getUserAgent=getUserAgent;exports.inRange=inRange;exports.makeClientSIPURI=makeClientSIPURI;exports.makeServerSIPURI=makeServerSIPURI;exports.makeUUID=makeUUID;exports.oncePerTick=oncePerTick;exports.promiseFromEvents=promiseFromEvents;exports.getOrNull=getOrNull;exports.defer=defer;exports.delegateMethods=delegateMethods;exports.proxyProperties=proxyProperties;exports.legacyPromise=legacyPromise;exports.buildLogLevels=buildLogLevels;exports.trackClass=trackClass;exports.trackPublicationClass=trackPublicationClass;exports.validateLocalTrack=validateLocalTrack},{"./constants":107}],110:[function(require,module,exports){(function(global){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var _require=require(".."),getUserAgent=_require.getUserAgent;var MAX_RECONNECT_ATTEMPTS=5;var RECONNECT_INTERVAL_MS=50;var WS_CLOSE_NORMAL=1e3;var toplevel=global.window||global;var WebSocket=toplevel.WebSocket?toplevel.WebSocket:require("ws");var util=require("../../util");var InsightsPublisher=function(_EventEmitter){_inherits(InsightsPublisher,_EventEmitter);function InsightsPublisher(token,sdkName,sdkVersion,environment,realm,options){_classCallCheck(this,InsightsPublisher);var _this=_possibleConstructorReturn(this,(InsightsPublisher.__proto__||Object.getPrototypeOf(InsightsPublisher)).call(this));options=Object.assign({gateway:createGateway(environment,realm)+"/v1/VideoEvents",maxReconnectAttempts:MAX_RECONNECT_ATTEMPTS,reconnectIntervalMs:RECONNECT_INTERVAL_MS,userAgent:getUserAgent(),WebSocket:WebSocket},options);Object.defineProperties(_this,{_connectTimestamp:{value:0,writable:true},_eventQueue:{value:[]},_readyToConnect:{value:util.defer()},_reconnectAttemptsLeft:{value:options.maxReconnectAttempts,writable:true},_ws:{value:null,writable:true},_WebSocket:{value:options.WebSocket}});_this._readyToConnect.promise.then(function(_ref){var roomSid=_ref.roomSid,participantSid=_ref.participantSid;var self=_this;_this.on("disconnected",function maybeReconnect(error){self._session=null;if(error&&self._reconnectAttemptsLeft>0){self.emit("reconnecting");reconnect(self,token,sdkName,sdkVersion,roomSid,participantSid,options);return}self.removeListener("disconnected",maybeReconnect)});connect(_this,token,sdkName,sdkVersion,roomSid,participantSid,options)}).catch(function(){});return _this}_createClass(InsightsPublisher,[{key:"connect",value:function connect(roomSid,participantSid){this._readyToConnect.resolve({roomSid:roomSid,participantSid:participantSid})}},{key:"_publish",value:function _publish(event){event.session=this._session;this._ws.send(JSON.stringify(event))}},{key:"disconnect",value:function disconnect(){if(this._ws===null||this._ws.readyState===this._WebSocket.CLOSING||this._ws.readyState===this._WebSocket.CLOSED){return false}try{this._ws.close()}catch(error){}this.emit("disconnected");return true}},{key:"publish",value:function publish(groupName,eventName,payload){if(this._ws!==null&&(this._ws.readyState===this._WebSocket.CLOSING||this._ws.readyState===this._WebSocket.CLOSED)){return false}var publishOrEnqueue=typeof this._session==="string"?this._publish.bind(this):this._eventQueue.push.bind(this._eventQueue);publishOrEnqueue({group:groupName,name:eventName,payload:payload,timestamp:Date.now(),type:"event",version:1});return true}}]);return InsightsPublisher}(EventEmitter);function connect(publisher,token,sdkName,sdkVersion,roomSid,participantSid,options){publisher._connectTimestamp=Date.now();publisher._reconnectAttemptsLeft--;publisher._ws=new options.WebSocket(options.gateway);var ws=publisher._ws;ws.addEventListener("close",function(event){if(event.code===WS_CLOSE_NORMAL){publisher.emit("disconnected");return}publisher.emit("disconnected",new Error("WebSocket Error "+event.code+": "+event.reason))});ws.addEventListener("message",function(message){handleConnectResponse(publisher,JSON.parse(message.data),options)});ws.addEventListener("open",function(){var connectRequest={type:"connect",token:token,version:1};connectRequest.publisher={name:sdkName,sdkVersion:sdkVersion,userAgent:options.userAgent,participantSid:participantSid,roomSid:roomSid};ws.send(JSON.stringify(connectRequest))})}function createGateway(environment,realm){return environment==="prod"?"wss://sdkgw."+realm+".twilio.com":"wss://sdkgw."+environment+"-"+realm+".twilio.com"}function handleConnectResponse(publisher,response,options){switch(response.type){case"connected":publisher._session=response.session;publisher._reconnectAttemptsLeft=options.maxReconnectAttempts;publisher._eventQueue.splice(0).forEach(publisher._publish,publisher);publisher.emit("connected");break;case"error":publisher._ws.close();publisher.emit("disconnected",new Error(response.message));break}}function reconnect(publisher,token,sdkName,sdkVersion,roomSid,participantSid,options){var connectInterval=Date.now()-publisher._connectTimestamp;var timeToWait=options.reconnectIntervalMs-connectInterval;if(timeToWait>0){setTimeout(function(){connect(publisher,token,sdkName,sdkVersion,roomSid,participantSid,options)},timeToWait);return}connect(publisher,token,sdkName,sdkVersion,roomSid,participantSid,options)}module.exports=InsightsPublisher}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"..":109,"../../util":109,events:179,ws:185}],111:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var InsightsPublisher=function(){function InsightsPublisher(){_classCallCheck(this,InsightsPublisher);Object.defineProperties(this,{_connected:{writable:true,value:true}})}_createClass(InsightsPublisher,[{key:"connect",value:function connect(){}},{key:"disconnect",value:function disconnect(){if(this._connected){this._connected=false;return true}return false}},{key:"publish",value:function publish(){return this._connected}}]);return InsightsPublisher}();module.exports=InsightsPublisher},{}],112:[function(require,module,exports){"use strict";var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var constants=require("./constants");var DEFAULT_LOG_LEVEL=constants.DEFAULT_LOG_LEVEL;var E=require("./constants").typeErrors;var deprecationWarningsByComponentConstructor=void 0;function getDeprecationWarnings(componentConstructor){deprecationWarningsByComponentConstructor=deprecationWarningsByComponentConstructor||new Map;if(deprecationWarningsByComponentConstructor.has(componentConstructor)){return deprecationWarningsByComponentConstructor.get(componentConstructor)}var deprecationWarnings=new Set;deprecationWarningsByComponentConstructor.set(componentConstructor,deprecationWarnings);return deprecationWarnings}var Log=function(){function Log(moduleName,component,logLevels){_classCallCheck(this,Log);if(typeof moduleName!=="string"){throw E.INVALID_TYPE("moduleName","string")}if(!component){throw E.REQUIRED_ARGUMENT("component")}if((typeof logLevels==="undefined"?"undefined":_typeof(logLevels))!=="object"){logLevels={}}validateLogLevels(logLevels);Object.defineProperties(this,{_component:{value:component},_logLevels:{value:logLevels},_warnings:{value:new Set},logLevel:{get:function get(){return Log.getLevelByName(logLevels[moduleName]||DEFAULT_LOG_LEVEL)}},name:{get:component.toString.bind(component)}})}_createClass(Log,[{key:"createLog",value:function createLog(moduleName,component){return new Log(moduleName,component,this._logLevels)}},{key:"setLevels",value:function setLevels(levels){validateLogLevels(levels);Object.assign(this._logLevels,levels);return this}},{key:"log",value:function log(logLevel,message){var logSpec=Log._levels[logLevel];if(!logSpec){throw E.INVALID_VALUE("logLevel",LOG_LEVEL_VALUES)}if(this.logLevel<=logLevel){var levelName=logSpec.name;var prefix=(new Date).toISOString().split("T").concat(["|",levelName,"in",this.name+":"]);logSpec.logFn.apply(console,prefix.concat(message))}return this}},{key:"debug",value:function debug(){return this.log(Log.DEBUG,[].slice.call(arguments))}},{key:"deprecated",value:function deprecated(deprecationWarning){var deprecationWarnings=getDeprecationWarnings(this._component.constructor);if(deprecationWarnings.has(deprecationWarning)){return this}deprecationWarnings.add(deprecationWarning);return this.warn(deprecationWarning)}},{key:"info",value:function info(){return this.log(Log.INFO,[].slice.call(arguments))}},{key:"warn",value:function warn(){return this.log(Log.WARN,[].slice.call(arguments))}},{key:"warnOnce",value:function warnOnce(warning){if(this._warnings.has(warning)){return this}this._warnings.add(warning);return this.warn(warning)}},{key:"error",value:function error(){return this.log(Log.ERROR,[].slice.call(arguments))}},{key:"throw",value:function _throw(error,customMessage){if(error.clone){error=error.clone(customMessage)}this.log(Log.ERROR,error);throw error}}],[{key:"getLevelByName",value:function getLevelByName(name){if(!isNaN(name)){return parseInt(name,10)}name=name.toUpperCase();validateLogLevel(name);return Log[name]}}]);return Log}();Object.defineProperties(Log,{DEBUG:{value:0},INFO:{value:1},WARN:{value:2},ERROR:{value:3},OFF:{value:4},_levels:{value:[{name:"DEBUG",logFn:console.log},{name:"INFO",logFn:console.info},{name:"WARN",logFn:console.warn},{name:"ERROR",logFn:console.error},{name:"OFF",logFn:function noop(){}}]}});var LOG_LEVELS_SET={};var LOG_LEVEL_VALUES=[];var LOG_LEVEL_NAMES=Log._levels.map(function(level,i){LOG_LEVELS_SET[level.name]=true;LOG_LEVEL_VALUES.push(i);return level.name});function validateLogLevel(level){if(!(level in LOG_LEVELS_SET)){throw E.INVALID_VALUE("level",LOG_LEVEL_NAMES)}}function validateLogLevels(levels){Object.keys(levels).forEach(function(moduleName){validateLogLevel(levels[moduleName].toUpperCase())})}module.exports=Log},{"./constants":107}],113:[function(require,module,exports){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var difference=require("../").difference;var flatMap=require("../").flatMap;var setSimulcastInMediaSection=require("./simulcast");var ptToFixedBitrateAudioCodecName={0:"PCMU",8:"PCMA"};var RTCP_BITRATE=16e3;function createBLine(modifier,maxBitrate){if(!maxBitrate){return null}return"\r\nb="+modifier+":"+(modifier==="AS"?Math.round((maxBitrate+RTCP_BITRATE)/950):maxBitrate)}function createCodecMapForMediaSection(section){return Array.from(createPtToCodecName(section)).reduce(function(codecMap,pair){var pt=pair[0];var codecName=pair[1];var pts=codecMap.get(codecName)||[];return codecMap.set(codecName,pts.concat(pt))},new Map)}function createMidToMediaSectionMap(sdp){return getMediaSections(sdp).reduce(function(midsToMediaSections,mediaSection){var mid=getMidForMediaSection(mediaSection);return mid?midsToMediaSections.set(mid,mediaSection):midsToMediaSections},new Map)}function createPtToCodecName(mediaSection){return getPayloadTypesInMediaSection(mediaSection).reduce(function(ptToCodecName,pt){var rtpmapPattern=new RegExp("a=rtpmap:"+pt+" ([^/]+)");var matches=mediaSection.match(rtpmapPattern);var codecName=matches?matches[1].toLowerCase():ptToFixedBitrateAudioCodecName[pt]?ptToFixedBitrateAudioCodecName[pt].toLowerCase():"";return ptToCodecName.set(pt,codecName)},new Map)}function getFmtpAttributesForPt(pt,mediaSection){var fmtpRegex=new RegExp("^a=fmtp:"+pt+" (.+)$","m");var matches=mediaSection.match(fmtpRegex);return matches&&matches[1].split(";").reduce(function(attrs,nvPair){var _nvPair$split=nvPair.split("="),_nvPair$split2=_slicedToArray(_nvPair$split,2),name=_nvPair$split2[0],value=_nvPair$split2[1];attrs[name]=isNaN(value)?value:parseInt(value,10);return attrs},{})}function getMidForMediaSection(mediaSection){var midMatches=mediaSection.match(/^a=mid:(.+)$/m);return midMatches&&midMatches[1]}function getMediaSections(sdp,kind,direction){return sdp.replace(/\r\n\r\n$/,"\r\n").split("\r\nm=").slice(1).map(function(mediaSection){return"m="+mediaSection}).filter(function(mediaSection){var kindPattern=new RegExp("m="+(kind||".*"),"gm");var directionPattern=new RegExp("a="+(direction||".*"),"gm");return kindPattern.test(mediaSection)&&directionPattern.test(mediaSection)})}function getPayloadTypesInMediaSection(section){var mLine=section.split("\r\n")[0];var matches=mLine.match(/([0-9]+)/g);if(!matches){return[]}return matches.slice(1).map(function(match){return parseInt(match,10)})}function getReorderedPayloadTypes(codecMap,preferredCodecs){preferredCodecs=preferredCodecs.map(function(codecName){return codecName.toLowerCase()});var preferredPayloadTypes=flatMap(preferredCodecs,function(codecName){return codecMap.get(codecName)||[]});var remainingCodecs=difference(Array.from(codecMap.keys()),preferredCodecs);var remainingPayloadTypes=flatMap(remainingCodecs,function(codecName){return codecMap.get(codecName)});return preferredPayloadTypes.concat(remainingPayloadTypes)}function setBitrateInMediaSection(modifier,maxBitrate,section){var bLine=createBLine(modifier,maxBitrate)||"";var bLinePattern=/\r\nb=(AS|TIAS):([0-9]+)/;var bLineMatched=section.match(bLinePattern);if(!bLineMatched){return section.replace(/(\r\n)?$/,bLine+"$1")}var maxBitrateMatched=parseInt(bLineMatched[2],10);maxBitrate=maxBitrate||Infinity;bLine=createBLine(modifier,Math.min(maxBitrateMatched,maxBitrate));return section.replace(bLinePattern,bLine)}function setBitrateParameters(sdp,modifier,maxAudioBitrate,maxVideoBitrate){var mediaSections=getMediaSections(sdp);var session=sdp.split("\r\nm=")[0];return[session].concat(mediaSections.map(function(section){if(!/^m=(audio|video)/.test(section)||!/a=(recvonly|sendrecv)/.test(section)){return section}var kind=section.match(/^m=(audio|video)/)[1];var maxBitrate=kind==="audio"?maxAudioBitrate:maxVideoBitrate;return setBitrateInMediaSection(modifier,maxBitrate,section)})).join("\r\n")}function setPayloadTypesInMediaSection(payloadTypes,section){var lines=section.split("\r\n");var mLine=lines[0];var otherLines=lines.slice(1);mLine=mLine.replace(/([0-9]+\s?)+$/,payloadTypes.join(" "));return[mLine].concat(otherLines).join("\r\n")}function setCodecPreferences(sdp,preferredAudioCodecs,preferredVideoCodecs){var mediaSections=getMediaSections(sdp);var session=sdp.split("\r\nm=")[0];return[session].concat(mediaSections.map(function(section){if(!/^m=(audio|video)/.test(section)){return section}var kind=section.match(/^m=(audio|video)/)[1];var codecMap=createCodecMapForMediaSection(section);var preferredCodecs=kind==="audio"?preferredAudioCodecs:preferredVideoCodecs.map(function(codec){return codec.codec});var payloadTypes=getReorderedPayloadTypes(codecMap,preferredCodecs);var newSection=setPayloadTypesInMediaSection(payloadTypes,section);var pcmaPayloadTypes=codecMap.get("pcma")||[];var pcmuPayloadTypes=codecMap.get("pcmu")||[];var fixedBitratePayloadTypes=kind==="audio"?new Set(pcmaPayloadTypes.concat(pcmuPayloadTypes)):new Set;return fixedBitratePayloadTypes.has(payloadTypes[0])?newSection.replace(/\r\nb=(AS|TIAS):([0-9]+)/g,""):newSection})).join("\r\n")}function setSimulcast(sdp,sdpFormat,trackIdsToAttributes){var mediaSections=getMediaSections(sdp);var session=sdp.split("\r\nm=")[0];return[session].concat(mediaSections.map(function(section){section=section.replace(/\r\n$/,"");if(!/^m=video/.test(section)){return section}var codecMap=createCodecMapForMediaSection(section);var payloadTypes=getPayloadTypesInMediaSection(section);var vp8PayloadTypes=new Set(codecMap.get("vp8")||[]);var hasVP8PayloadType=payloadTypes.some(function(payloadType){return vp8PayloadTypes.has(payloadType)});return hasVP8PayloadType?setSimulcastInMediaSection(section,sdpFormat,trackIdsToAttributes):section})).concat("").join("\r\n")}function unifiedPlanGetMatchingLocalPayloadTypes(remoteCodec,remotePt,localCodecsToPts,localSection,remoteSection){var matchingLocalPts=localCodecsToPts.get(remoteCodec)||[];if(matchingLocalPts.length<=1){return matchingLocalPts}var remoteFmtpAttrs=getFmtpAttributesForPt(remotePt,remoteSection);if(!remoteFmtpAttrs){return matchingLocalPts}var matchinglocalPt=matchingLocalPts.find(function(localPt){var localFmtpAttrs=getFmtpAttributesForPt(localPt,localSection);return localFmtpAttrs&&Object.keys(remoteFmtpAttrs).every(function(attr){return remoteFmtpAttrs[attr]===localFmtpAttrs[attr]})});return typeof matchinglocalPt==="number"?[matchinglocalPt]:matchingLocalPts}function unifiedPlanAddOrRewriteNewTrackIds(sdp,activeMidsToTrackIds,trackIdsByKind){var newMidsToTrackIds=Array.from(trackIdsByKind).reduce(function(midsToTrackIds,_ref){var _ref2=_slicedToArray(_ref,2),kind=_ref2[0],trackIds=_ref2[1];var sendMids=getMediaSections(sdp,kind,"send(only|recv)").map(getMidForMediaSection);var newMids=sendMids.filter(function(mid){return!activeMidsToTrackIds.has(mid)});newMids.forEach(function(mid,i){return midsToTrackIds.set(mid,trackIds[i])});return midsToTrackIds},new Map);return unifiedPlanAddOrRewriteTrackIds(sdp,newMidsToTrackIds)}function unifiedPlanAddOrRewriteTrackIds(sdp,midsToTrackIds){var mediaSections=getMediaSections(sdp);var session=sdp.split("\r\nm=")[0];return[session].concat(mediaSections.map(function(mediaSection){if(!/^m=(audio|video)/.test(mediaSection)){return mediaSection}var mid=getMidForMediaSection(mediaSection);if(!mid){return mediaSection}var trackId=midsToTrackIds.get(mid);if(!trackId){return mediaSection}var attributes=(mediaSection.match(/^a=msid:(.+)$/m)||[])[1];if(!attributes){return mediaSection}var _attributes$split=attributes.split(" "),_attributes$split2=_slicedToArray(_attributes$split,2),msid=_attributes$split2[0],trackIdToRewrite=_attributes$split2[1];var msidRegex=new RegExp("msid:"+msid+(trackIdToRewrite?" "+trackIdToRewrite:"")+"$","gm");return mediaSection.replace(msidRegex,"msid:"+msid+" "+trackId)})).join("\r\n")}function unifiedPlanFilterCodecsInLocalMediaSection(localSection,remoteMidsToMediaSections){if(!/^m=(audio|video)/.test(localSection)){return localSection}var localMid=getMidForMediaSection(localSection);var remoteSection=localMid&&remoteMidsToMediaSections.get(localMid);if(!remoteSection){return localSection}var remotePtToCodecs=createPtToCodecName(remoteSection);var localCodecsToPts=createCodecMapForMediaSection(localSection)
    ;var localPts=flatMap(Array.from(remotePtToCodecs),function(_ref3){var _ref4=_slicedToArray(_ref3,2),remotePt=_ref4[0],remoteCodec=_ref4[1];return remoteCodec!=="rtx"?unifiedPlanGetMatchingLocalPayloadTypes(remoteCodec,remotePt,localCodecsToPts,localSection,remoteSection):[]});var localRtxPts=localCodecsToPts.get("rtx")||[];localPts=localPts.concat(localRtxPts.filter(function(rtxPt){var fmtpAttrs=getFmtpAttributesForPt(rtxPt,localSection);return fmtpAttrs&&localPts.includes(fmtpAttrs.apt)}));var lines=localSection.split("\r\n").filter(function(line){var ptMatches=line.match(/^a=(rtpmap|fmtp|rtcp-fb):(.+) .+$/);var pt=ptMatches&&ptMatches[2];return!ptMatches||pt&&localPts.includes(parseInt(pt,10))});var orderedLocalPts=getPayloadTypesInMediaSection(localSection).filter(function(pt){return localPts.includes(pt)});return setPayloadTypesInMediaSection(orderedLocalPts,lines.join("\r\n"))}function unifiedPlanFilterLocalCodecs(localSdp,remoteSdp){var localMediaSections=getMediaSections(localSdp);var localSession=localSdp.split("\r\nm=")[0];var remoteMidsToMediaSections=createMidToMediaSectionMap(remoteSdp);return[localSession].concat(localMediaSections.map(function(localSection){return unifiedPlanFilterCodecsInLocalMediaSection(localSection,remoteMidsToMediaSections)})).join("\r\n")}exports.createCodecMapForMediaSection=createCodecMapForMediaSection;exports.createPtToCodecName=createPtToCodecName;exports.getMediaSections=getMediaSections;exports.setBitrateParameters=setBitrateParameters;exports.setCodecPreferences=setCodecPreferences;exports.setSimulcast=setSimulcast;exports.unifiedPlanAddOrRewriteNewTrackIds=unifiedPlanAddOrRewriteNewTrackIds;exports.unifiedPlanAddOrRewriteTrackIds=unifiedPlanAddOrRewriteTrackIds;exports.unifiedPlanFilterLocalCodecs=unifiedPlanFilterLocalCodecs},{"../":109,"./simulcast":115}],114:[function(require,module,exports){"use strict";var RTCSessionDescription=require("@twilio/webrtc").RTCSessionDescription;var createPtToCodecName=require("./").createPtToCodecName;var getMediaSections=require("./").getMediaSections;function workaround(description){var descriptionInit={type:description.type};if(description.type!=="rollback"){descriptionInit.sdp=sdpWorkaround(description.sdp)}return new RTCSessionDescription(descriptionInit)}function sdpWorkaround(sdp){var mediaSections=getMediaSections(sdp);var session=sdp.split("\r\nm=")[0];return[session].concat(mediaSections.map(mediaSectionWorkaround)).join("\r\n")}function mediaSectionWorkaround(mediaSection){var ptToCodecName=createPtToCodecName(mediaSection);mediaSection=deleteDuplicateRtxPts(mediaSection,ptToCodecName);var codecNameToPts=createCodecNameToPts(ptToCodecName);var rtxPts=codecNameToPts.get("rtx")||new Set;var invalidRtxPts=new Set;var rtxPtToAssociatedPt=createRtxPtToAssociatedPt(mediaSection,ptToCodecName,rtxPts,invalidRtxPts);var associatedPtToRtxPt=createAssociatedPtToRtxPt(rtxPtToAssociatedPt,invalidRtxPts);var unassociatedRtxPts=Array.from(invalidRtxPts);var knownCodecNames=["h264","vp8","vp9"];var unassociatedPts=knownCodecNames.reduce(function(unassociatedPts,codecName){var pts=codecNameToPts.get(codecName)||new Set;return Array.from(pts).reduce(function(unassociatedPts,pt){return associatedPtToRtxPt.has(pt)?unassociatedPts:unassociatedPts.add(pt)},unassociatedPts)},new Set);unassociatedPts.forEach(function(pt){if(unassociatedRtxPts.length){var rtxPt=unassociatedRtxPts.shift();mediaSection=deleteFmtpAttributesForRtxPt(mediaSection,rtxPt);mediaSection=addFmtpAttributeForRtxPt(mediaSection,rtxPt,pt)}});unassociatedRtxPts.forEach(function(rtxPt){mediaSection=deleteFmtpAttributesForRtxPt(mediaSection,rtxPt);mediaSection=deleteRtpmapAttributesForRtxPt(mediaSection,rtxPt)});return mediaSection}function deleteDuplicateRtxPts(mediaSection,ptToCodecName){return Array.from(ptToCodecName.keys()).reduce(function(section,pt){var rtpmapRegex=new RegExp("^a=rtpmap:"+pt+" rtx.+$","gm");return(section.match(rtpmapRegex)||[]).slice(ptToCodecName.get(pt)==="rtx"?1:0).reduce(function(section,rtpmap){var rtpmapRegex=new RegExp("\r\n"+rtpmap);var fmtpmapRegex=new RegExp("\r\na=fmtp:"+pt+" apt=[0-9]+");return section.replace(rtpmapRegex,"").replace(fmtpmapRegex,"")},section)},mediaSection)}function createCodecNameToPts(ptToCodecName){var codecNameToPts=new Map;ptToCodecName.forEach(function(codecName,pt){var pts=codecNameToPts.get(codecName)||new Set;return codecNameToPts.set(codecName,pts.add(pt))});return codecNameToPts}function createRtxPtToAssociatedPt(mediaSection,ptToCodecName,rtxPts,invalidRtxPts){return Array.from(rtxPts).reduce(function(rtxPtToAssociatedPt,rtxPt){var fmtpPattern=new RegExp("a=fmtp:"+rtxPt+" apt=(\\d+)");var matches=mediaSection.match(fmtpPattern);if(!matches){invalidRtxPts.add(rtxPt);return rtxPtToAssociatedPt}var pt=Number.parseInt(matches[1]);if(!ptToCodecName.has(pt)){invalidRtxPts.add(rtxPt);return rtxPtToAssociatedPt}var codecName=ptToCodecName.get(pt);if(codecName==="rtx"){invalidRtxPts.add(rtxPt);return rtxPtToAssociatedPt}return rtxPtToAssociatedPt.set(rtxPt,pt)},new Map)}function createAssociatedPtToRtxPt(rtxPtToAssociatedPt,invalidRtxPts){var associatedPtToRtxPts=Array.from(rtxPtToAssociatedPt).reduce(function(associatedPtToRtxPts,pair){var rtxPt=pair[0];var pt=pair[1];var rtxPts=associatedPtToRtxPts.get(pt)||new Set;return associatedPtToRtxPts.set(pt,rtxPts.add(rtxPt))},new Map);return Array.from(associatedPtToRtxPts).reduce(function(associatedPtToRtxPt,pair){var pt=pair[0];var rtxPts=Array.from(pair[1]);if(rtxPts.length>1){rtxPts.forEach(function(rtxPt){invalidRtxPts.add(rtxPt)});return associatedPtToRtxPt}return associatedPtToRtxPt.set(pt,rtxPts[0])},new Map)}function deleteFmtpAttributesForRtxPt(mediaSection,rtxPt){var pattern=new RegExp("a=fmtp:"+rtxPt+".*\r\n","gm");return mediaSection.replace(pattern,"")}function deleteRtpmapAttributesForRtxPt(mediaSection,rtxPt){var pattern=new RegExp("a=rtpmap:"+rtxPt+".*\r\n","gm");return mediaSection.replace(pattern,"")}function addFmtpAttributeForRtxPt(mediaSection,rtxPt,pt){return mediaSection.endsWith("\r\n")?mediaSection+"a=fmtp:"+rtxPt+" apt="+pt+"\r\n":mediaSection+"\r\na=fmtp:"+rtxPt+" apt="+pt}module.exports=workaround},{"./":113,"@twilio/webrtc":162}],115:[function(require,module,exports){"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var difference=require("../").difference;var flatMap=require("../").flatMap;function createSSRC(){var ssrcMax=4294967295;return String(Math.floor(Math.random()*ssrcMax))}var TrackAttributes=function(){function TrackAttributes(trackId,streamId,cName){_classCallCheck(this,TrackAttributes);Object.defineProperties(this,{cName:{enumerable:true,value:cName},isSimulcastEnabled:{enumerable:true,value:false,writable:true},primarySSRCs:{enumerable:true,value:new Set},rtxPairs:{enumerable:true,value:new Map},streamId:{enumerable:true,value:streamId},trackId:{enumerable:true,value:trackId}})}_createClass(TrackAttributes,[{key:"addSimulcastSSRCs",value:function addSimulcastSSRCs(){if(this.isSimulcastEnabled){return}var simulcastSSRCs=[createSSRC(),createSSRC()];simulcastSSRCs.forEach(function(ssrc){this.primarySSRCs.add(ssrc)},this);if(this.rtxPairs.size){simulcastSSRCs.forEach(function(ssrc){this.rtxPairs.set(createSSRC(),ssrc)},this)}}},{key:"addSSRC",value:function addSSRC(ssrc,primarySSRC,isSimSSRC){if(primarySSRC){this.rtxPairs.set(ssrc,primarySSRC)}else{this.primarySSRCs.add(ssrc)}this.isSimulcastEnabled=this.isSimulcastEnabled||isSimSSRC}},{key:"toSdpLines",value:function toSdpLines(excludeRtx){var _this=this;var rtxPairs=excludeRtx?[]:Array.from(this.rtxPairs.entries()).map(function(rtxPair){return rtxPair.reverse()});var simSSRCs=Array.from(this.primarySSRCs.values());var ssrcs=rtxPairs.length?flatMap(rtxPairs):simSSRCs;var attrLines=flatMap(ssrcs,function(ssrc){return["a=ssrc:"+ssrc+" cname:"+_this.cName,"a=ssrc:"+ssrc+" msid:"+_this.streamId+" "+_this.trackId]});var rtxPairLines=rtxPairs.map(function(rtxPair){return"a=ssrc-group:FID "+rtxPair.join(" ")});var simGroupLines=["a=ssrc-group:SIM "+simSSRCs.join(" ")];return rtxPairLines.concat(attrLines).concat(simGroupLines)}}]);return TrackAttributes}();function getMatches(section,pattern){var matches=section.match(new RegExp(pattern,"gm"))||[];return matches.map(function(match){var matches=match.match(new RegExp(pattern))||[];return matches.slice(1)})}function getSimulcastSSRCs(section){var simGroupPattern="^a=ssrc-group:SIM ([0-9]+) ([0-9]+) ([0-9]+)$";return new Set(flatMap(getMatches(section,simGroupPattern)))}function getSSRCAttribute(section,ssrc,attribute){var pattern="a=ssrc:"+ssrc+" "+attribute+":(.+)";return section.match(new RegExp(pattern))[1]}function getSSRCRtxPairs(section){var rtxPairPattern="^a=ssrc-group:FID ([0-9]+) ([0-9]+)$";return new Map(getMatches(section,rtxPairPattern).map(function(pair){return pair.reverse()}))}function createSSRCAttributeTuples(section,sdpFormat){return{planb:createPlanBSSRCAttributeTuples,unified:createUnifiedPlanSSRCAttributeTuples}[sdpFormat](section)}function createPlanBSSRCAttributeTuples(section){return getMatches(section,"^a=ssrc:([0-9]+) msid:([^\\s]+) ([^\\s]+)$")}function createUnifiedPlanSSRCAttributeTuples(section){var _flatMap=flatMap(getMatches(section,"^a=msid:(.+) (.+)$")),_flatMap2=_slicedToArray(_flatMap,2),streamId=_flatMap2[0],trackId=_flatMap2[1];var ssrcs=flatMap(getMatches(section,"^a=ssrc:(.+) cname:.+$"));return ssrcs.map(function(ssrc){return[ssrc,streamId,trackId]})}function createTrackIdsToAttributes(section,sdpFormat){var simSSRCs=getSimulcastSSRCs(section);var rtxPairs=getSSRCRtxPairs(section);var ssrcAttrTuples=createSSRCAttributeTuples(section,sdpFormat);return ssrcAttrTuples.reduce(function(trackIdsToSSRCs,tuple){var ssrc=tuple[0];var streamId=tuple[1];var trackId=tuple[2];var trackAttributes=trackIdsToSSRCs.get(trackId)||new TrackAttributes(trackId,streamId,getSSRCAttribute(section,ssrc,"cname"));var primarySSRC=rtxPairs.get(ssrc)||null;trackAttributes.addSSRC(ssrc,primarySSRC,simSSRCs.has(ssrc));return trackIdsToSSRCs.set(trackId,trackAttributes)},new Map)}function setSimulcastInMediaSection(section,sdpFormat,trackIdsToAttributes){var newTrackIdsToAttributes=createTrackIdsToAttributes(section,sdpFormat);var newTrackIds=Array.from(newTrackIdsToAttributes.keys());var trackIds=Array.from(trackIdsToAttributes.keys());var trackIdsToAdd=difference(newTrackIds,trackIds);var trackIdsToIgnore=difference(trackIds,newTrackIds);var trackAttributesToAdd=flatMap(trackIdsToAdd,function(trackId){return newTrackIdsToAttributes.get(trackId)});trackAttributesToAdd.forEach(function(trackAttributes){trackAttributes.addSimulcastSSRCs();trackIdsToAttributes.set(trackAttributes.trackId,trackAttributes)});trackIds=Array.from(trackIdsToAttributes.keys());var relevantTrackIds=difference(trackIds,trackIdsToIgnore);var relevantTrackAttributes=flatMap(relevantTrackIds,function(trackId){return trackIdsToAttributes.get(trackId)});var excludeRtx=!section.match(/a=rtpmap:[0-9]+ rtx/);var relevantSdpLines=flatMap(relevantTrackAttributes,function(trackAttributes){return trackAttributes.toSdpLines(excludeRtx)});var sectionLines=flatMap(new Set(section.split("\r\n").concat(relevantSdpLines)));var xGoogleFlagConference="a=x-google-flag:conference";if(!section.match(xGoogleFlagConference)){sectionLines.push(xGoogleFlagConference)}return sectionLines.join("\r\n")}module.exports=setSimulcastInMediaSection},{"../":109}],116:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var IdentityTrackMatcher=function(){function IdentityTrackMatcher(){_classCallCheck(this,IdentityTrackMatcher)}_createClass(IdentityTrackMatcher,[{key:"match",value:function match(event){return event.track.id}},{key:"update",value:function update(){}}]);return IdentityTrackMatcher}();module.exports=IdentityTrackMatcher},{}],117:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var getMediaSections=require("../").getMediaSections;var MIDTrackMatcher=function(){function MIDTrackMatcher(){_classCallCheck(this,MIDTrackMatcher);Object.defineProperties(this,{_midsToTrackIds:{value:new Map,writable:true}})}_createClass(MIDTrackMatcher,[{key:"match",value:function match(event){return this._midsToTrackIds.get(event.transceiver.mid)||null}},{key:"update",value:function update(sdp){var sections=getMediaSections(sdp,"(audio|video)");this._midsToTrackIds=sections.reduce(function(midsToTrackIds,section){var midMatches=section.match(/^a=mid:(.+)$/m)||[];var trackIdMatches=section.match(/^a=msid:.+ (.+)$/m)||[];var mid=midMatches[1];var trackId=trackIdMatches[1];return mid&&trackId?midsToTrackIds.set(mid,trackId):midsToTrackIds},this._midsToTrackIds)}}]);return MIDTrackMatcher}();module.exports=MIDTrackMatcher},{"../":113}],118:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var util=require("../../");var getMediaSections=require("../").getMediaSections;function create(){return{matched:new Set,unmatched:new Set}}function _match(mAndM){var unmatched=Array.from(mAndM.unmatched);if(!unmatched.length){return null}var id=unmatched[0];mAndM.matched.add(id);mAndM.unmatched.delete(id);return id}function _update(mAndM,ids){ids=new Set(ids);var removedMatchedIds=util.difference(mAndM.matched,ids);removedMatchedIds.forEach(mAndM.matched.delete,mAndM.matched);mAndM.unmatched=util.difference(ids,mAndM.matched)}function parse(kind,sdp){var mediaSections=getMediaSections(sdp,kind);var pattern="msid: ?(.+) +(.+) ?$";return new Set(util.flatMap(mediaSections,function(mediaSection){return mediaSection.match(new RegExp(pattern,"mg"))||[]}).map(function(msid){return msid.match(new RegExp(pattern))[2]}))}var OrderedTrackMatcher=function(){function OrderedTrackMatcher(){_classCallCheck(this,OrderedTrackMatcher);if(!(this instanceof OrderedTrackMatcher)){return new OrderedTrackMatcher}Object.defineProperties(this,{audio:{enumerable:true,value:create()},video:{enumerable:true,value:create()}})}_createClass(OrderedTrackMatcher,[{key:"match",value:function match(event){return _match(this[event.track.kind])}},{key:"update",value:function update(sdp){["audio","video"].forEach(function(kind){_update(this[kind],parse(kind,sdp))},this)}}]);return OrderedTrackMatcher}();module.exports=OrderedTrackMatcher},{"../":113,"../../":109}],119:[function(require,module,exports){"use strict";var _require=require("@twilio/webrtc/lib/util"),guessBrowser=_require.guessBrowser;function isRTCPeerConnectionSupported(){return typeof RTCPeerConnection!=="undefined"||typeof webkitRTCPeerConnection!=="undefined"||typeof mozRTCPeerConnection!=="undefined"}function isGetUserMediaSupported(){return!!(navigator.mediaDevices&&navigator.mediaDevices.getUserMedia)||!!navigator.getUserMedia||!!navigator.webkitGetUserMedia||!!navigator.mozGetUserMedia}function isExplicitlyUnsupportedBrowser(){if(typeof navigator!=="undefined"&&typeof navigator.userAgent==="string"){return/Edg(e)?/.test(navigator.userAgent)}return false}function isSupported(){return!isExplicitlyUnsupportedBrowser()&&!!guessBrowser()&&isGetUserMediaSupported()&&isRTCPeerConnectionSupported()}module.exports=isSupported},{"@twilio/webrtc/lib/util":175}],120:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var EventEmitter=require("events").EventEmitter;var util=require("./");var TimeoutPromise=function(_EventEmitter){_inherits(TimeoutPromise,_EventEmitter);function TimeoutPromise(original,initialTimeout){_classCallCheck(this,TimeoutPromise);var _this=_possibleConstructorReturn(this,(TimeoutPromise.__proto__||Object.getPrototypeOf(TimeoutPromise)).call(this));var deferred=util.defer();var isTimedOut=false;var timedOut=new Error("Timed out");var timeout=null;var timer=null;Object.defineProperties(_this,{_deferred:{value:deferred},_isTimedOut:{get:function get(){return isTimedOut},set:function set(_isTimedOut){isTimedOut=_isTimedOut}},_timedOut:{value:timedOut},_timeout:{get:function get(){return timeout},set:function set(_timeout){timeout=_timeout}},_timer:{get:function get(){return timer},set:function set(_timer){timer=_timer}},_promise:{value:deferred.promise},isTimedOut:{enumerable:true,get:function get(){return isTimedOut}},timeout:{enumerable:true,get:function get(){return timeout}}});original.then(function(result){clearTimeout(_this._timer);deferred.resolve(result)},function(reason){clearTimeout(_this._timer);deferred.reject(reason)});if(initialTimeout){_this.start(initialTimeout)}return _this}_createClass(TimeoutPromise,[{key:"catch",value:function _catch(){var _promise;return(_promise=this._promise).catch.apply(_promise,arguments)}},{key:"start",value:function start(timeout){var _this2=this;if(this._timer){return this}this._timeout=timeout;this._timer=setTimeout(function(){if(_this2._timer){_this2._isTimedOut=true;_this2.emit("timedOut",_this2);_this2._deferred.reject(_this2._timedOut)}},this.timeout);return this}},{key:"then",value:function then(){var _promise2;return(_promise2=this._promise).then.apply(_promise2,arguments)}}]);return TimeoutPromise}(EventEmitter);module.exports=TimeoutPromise},{"./":109,events:179}],121:[function(require,module,exports){"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TwilioError=require("./twilioerror");var TwilioErrorByCode={};exports.createTwilioError=function createTwilioError(code,message){code=typeof code==="number"?code:0;message=typeof message==="string"&&message?message:"Unknown error";return TwilioErrorByCode[code]?new TwilioErrorByCode[code]:new TwilioError(code,message)};var AccessTokenInvalidError=function(_TwilioError){_inherits(AccessTokenInvalidError,_TwilioError);function AccessTokenInvalidError(){_classCallCheck(this,AccessTokenInvalidError);return _possibleConstructorReturn(this,(AccessTokenInvalidError.__proto__||Object.getPrototypeOf(AccessTokenInvalidError)).call(this,20101,"Invalid Access Token"))}return AccessTokenInvalidError}(TwilioError);exports.AccessTokenInvalidError=AccessTokenInvalidError;Object.defineProperty(TwilioErrorByCode,20101,{value:AccessTokenInvalidError});var AccessTokenHeaderInvalidError=function(_TwilioError2){_inherits(AccessTokenHeaderInvalidError,_TwilioError2);function AccessTokenHeaderInvalidError(){_classCallCheck(this,AccessTokenHeaderInvalidError);return _possibleConstructorReturn(this,(AccessTokenHeaderInvalidError.__proto__||Object.getPrototypeOf(AccessTokenHeaderInvalidError)).call(this,20102,"Invalid Access Token header"))}return AccessTokenHeaderInvalidError}(TwilioError);exports.AccessTokenHeaderInvalidError=AccessTokenHeaderInvalidError;Object.defineProperty(TwilioErrorByCode,20102,{value:AccessTokenHeaderInvalidError});var AccessTokenIssuerInvalidError=function(_TwilioError3){_inherits(AccessTokenIssuerInvalidError,_TwilioError3);function AccessTokenIssuerInvalidError(){_classCallCheck(this,AccessTokenIssuerInvalidError);return _possibleConstructorReturn(this,(AccessTokenIssuerInvalidError.__proto__||Object.getPrototypeOf(AccessTokenIssuerInvalidError)).call(this,20103,"Invalid Access Token issuer/subject"))}return AccessTokenIssuerInvalidError}(TwilioError);exports.AccessTokenIssuerInvalidError=AccessTokenIssuerInvalidError;Object.defineProperty(TwilioErrorByCode,20103,{value:AccessTokenIssuerInvalidError});var AccessTokenExpiredError=function(_TwilioError4){_inherits(AccessTokenExpiredError,_TwilioError4);function AccessTokenExpiredError(){_classCallCheck(this,AccessTokenExpiredError);return _possibleConstructorReturn(this,(AccessTokenExpiredError.__proto__||Object.getPrototypeOf(AccessTokenExpiredError)).call(this,20104,"Access Token expired or expiration date invalid"))}return AccessTokenExpiredError}(TwilioError);exports.AccessTokenExpiredError=AccessTokenExpiredError;Object.defineProperty(TwilioErrorByCode,20104,{value:AccessTokenExpiredError});var AccessTokenNotYetValidError=function(_TwilioError5){_inherits(AccessTokenNotYetValidError,_TwilioError5);function AccessTokenNotYetValidError(){_classCallCheck(this,AccessTokenNotYetValidError);return _possibleConstructorReturn(this,(AccessTokenNotYetValidError.__proto__||Object.getPrototypeOf(AccessTokenNotYetValidError)).call(this,20105,"Access Token not yet valid"))}return AccessTokenNotYetValidError}(TwilioError);exports.AccessTokenNotYetValidError=AccessTokenNotYetValidError;Object.defineProperty(TwilioErrorByCode,20105,{value:AccessTokenNotYetValidError});var AccessTokenGrantsInvalidError=function(_TwilioError6){_inherits(AccessTokenGrantsInvalidError,_TwilioError6);function AccessTokenGrantsInvalidError(){_classCallCheck(this,AccessTokenGrantsInvalidError);return _possibleConstructorReturn(this,(AccessTokenGrantsInvalidError.__proto__||Object.getPrototypeOf(AccessTokenGrantsInvalidError)).call(this,20106,"Invalid Access Token grants"))}return AccessTokenGrantsInvalidError}(TwilioError);exports.AccessTokenGrantsInvalidError=AccessTokenGrantsInvalidError;Object.defineProperty(TwilioErrorByCode,20106,{value:AccessTokenGrantsInvalidError});var AccessTokenSignatureInvalidError=function(_TwilioError7){_inherits(AccessTokenSignatureInvalidError,_TwilioError7);function AccessTokenSignatureInvalidError(){_classCallCheck(this,AccessTokenSignatureInvalidError);return _possibleConstructorReturn(this,(AccessTokenSignatureInvalidError.__proto__||Object.getPrototypeOf(AccessTokenSignatureInvalidError)).call(this,20107,"Invalid Access Token signature"))}return AccessTokenSignatureInvalidError}(TwilioError);exports.AccessTokenSignatureInvalidError=AccessTokenSignatureInvalidError;Object.defineProperty(TwilioErrorByCode,20107,{value:AccessTokenSignatureInvalidError});var SignalingConnectionError=function(_TwilioError8){_inherits(SignalingConnectionError,_TwilioError8);function SignalingConnectionError(){_classCallCheck(this,SignalingConnectionError);return _possibleConstructorReturn(this,(SignalingConnectionError.__proto__||Object.getPrototypeOf(SignalingConnectionError)).call(this,53e3,"Signaling connection error"))}return SignalingConnectionError}(TwilioError);exports.SignalingConnectionError=SignalingConnectionError;Object.defineProperty(TwilioErrorByCode,53e3,{value:SignalingConnectionError});var SignalingConnectionDisconnectedError=function(_TwilioError9){_inherits(SignalingConnectionDisconnectedError,_TwilioError9);function SignalingConnectionDisconnectedError(){_classCallCheck(this,SignalingConnectionDisconnectedError);return _possibleConstructorReturn(this,(SignalingConnectionDisconnectedError.__proto__||Object.getPrototypeOf(SignalingConnectionDisconnectedError)).call(this,53001,"Signaling connection disconnected"))}return SignalingConnectionDisconnectedError}(TwilioError);exports.SignalingConnectionDisconnectedError=SignalingConnectionDisconnectedError;Object.defineProperty(TwilioErrorByCode,53001,{value:SignalingConnectionDisconnectedError});var SignalingConnectionTimeoutError=function(_TwilioError10){_inherits(SignalingConnectionTimeoutError,_TwilioError10);function SignalingConnectionTimeoutError(){_classCallCheck(this,SignalingConnectionTimeoutError);return _possibleConstructorReturn(this,(SignalingConnectionTimeoutError.__proto__||Object.getPrototypeOf(SignalingConnectionTimeoutError)).call(this,53002,"Signaling connection timed out"))}return SignalingConnectionTimeoutError}(TwilioError);exports.SignalingConnectionTimeoutError=SignalingConnectionTimeoutError;Object.defineProperty(TwilioErrorByCode,53002,{value:SignalingConnectionTimeoutError});var SignalingIncomingMessageInvalidError=function(_TwilioError11){_inherits(SignalingIncomingMessageInvalidError,_TwilioError11);function SignalingIncomingMessageInvalidError(){_classCallCheck(this,SignalingIncomingMessageInvalidError);return _possibleConstructorReturn(this,(SignalingIncomingMessageInvalidError.__proto__||Object.getPrototypeOf(SignalingIncomingMessageInvalidError)).call(this,53003,"Client received an invalid signaling message"))}return SignalingIncomingMessageInvalidError}(TwilioError);exports.SignalingIncomingMessageInvalidError=SignalingIncomingMessageInvalidError;Object.defineProperty(TwilioErrorByCode,53003,{value:SignalingIncomingMessageInvalidError});var SignalingOutgoingMessageInvalidError=function(_TwilioError12){_inherits(SignalingOutgoingMessageInvalidError,_TwilioError12);function SignalingOutgoingMessageInvalidError(){_classCallCheck(this,SignalingOutgoingMessageInvalidError);return _possibleConstructorReturn(this,(SignalingOutgoingMessageInvalidError.__proto__||Object.getPrototypeOf(SignalingOutgoingMessageInvalidError)).call(this,53004,"Client sent an invalid signaling message"))}return SignalingOutgoingMessageInvalidError}(TwilioError);exports.SignalingOutgoingMessageInvalidError=SignalingOutgoingMessageInvalidError;Object.defineProperty(TwilioErrorByCode,53004,{value:SignalingOutgoingMessageInvalidError});var RoomNameInvalidError=function(_TwilioError13){_inherits(RoomNameInvalidError,_TwilioError13);function RoomNameInvalidError(){_classCallCheck(this,RoomNameInvalidError);return _possibleConstructorReturn(this,(RoomNameInvalidError.__proto__||Object.getPrototypeOf(RoomNameInvalidError)).call(this,53100,"Room name is invalid"))}return RoomNameInvalidError}(TwilioError);exports.RoomNameInvalidError=RoomNameInvalidError;Object.defineProperty(TwilioErrorByCode,53100,{value:RoomNameInvalidError});var RoomNameTooLongError=function(_TwilioError14){_inherits(RoomNameTooLongError,_TwilioError14);function RoomNameTooLongError(){_classCallCheck(this,RoomNameTooLongError);return _possibleConstructorReturn(this,(RoomNameTooLongError.__proto__||Object.getPrototypeOf(RoomNameTooLongError)).call(this,53101,"Room name is too long"))}return RoomNameTooLongError}(TwilioError);exports.RoomNameTooLongError=RoomNameTooLongError;Object.defineProperty(TwilioErrorByCode,53101,{value:RoomNameTooLongError});var RoomNameCharsInvalidError=function(_TwilioError15){_inherits(RoomNameCharsInvalidError,_TwilioError15);function RoomNameCharsInvalidError(){_classCallCheck(this,RoomNameCharsInvalidError);return _possibleConstructorReturn(this,(RoomNameCharsInvalidError.__proto__||Object.getPrototypeOf(RoomNameCharsInvalidError)).call(this,53102,"Room name contains invalid characters"))}return RoomNameCharsInvalidError}(TwilioError);exports.RoomNameCharsInvalidError=RoomNameCharsInvalidError;Object.defineProperty(TwilioErrorByCode,53102,{value:RoomNameCharsInvalidError});var RoomCreateFailedError=function(_TwilioError16){_inherits(RoomCreateFailedError,_TwilioError16);function RoomCreateFailedError(){_classCallCheck(this,RoomCreateFailedError);return _possibleConstructorReturn(this,(RoomCreateFailedError.__proto__||Object.getPrototypeOf(RoomCreateFailedError)).call(this,53103,"Unable to create Room"))}return RoomCreateFailedError}(TwilioError);exports.RoomCreateFailedError=RoomCreateFailedError;Object.defineProperty(TwilioErrorByCode,53103,{value:RoomCreateFailedError});var RoomConnectFailedError=function(_TwilioError17){
        _inherits(RoomConnectFailedError,_TwilioError17);function RoomConnectFailedError(){_classCallCheck(this,RoomConnectFailedError);return _possibleConstructorReturn(this,(RoomConnectFailedError.__proto__||Object.getPrototypeOf(RoomConnectFailedError)).call(this,53104,"Unable to connect to Room"))}return RoomConnectFailedError}(TwilioError);exports.RoomConnectFailedError=RoomConnectFailedError;Object.defineProperty(TwilioErrorByCode,53104,{value:RoomConnectFailedError});var RoomMaxParticipantsExceededError=function(_TwilioError18){_inherits(RoomMaxParticipantsExceededError,_TwilioError18);function RoomMaxParticipantsExceededError(){_classCallCheck(this,RoomMaxParticipantsExceededError);return _possibleConstructorReturn(this,(RoomMaxParticipantsExceededError.__proto__||Object.getPrototypeOf(RoomMaxParticipantsExceededError)).call(this,53105,"Room contains too many Participants"))}return RoomMaxParticipantsExceededError}(TwilioError);exports.RoomMaxParticipantsExceededError=RoomMaxParticipantsExceededError;Object.defineProperty(TwilioErrorByCode,53105,{value:RoomMaxParticipantsExceededError});var RoomNotFoundError=function(_TwilioError19){_inherits(RoomNotFoundError,_TwilioError19);function RoomNotFoundError(){_classCallCheck(this,RoomNotFoundError);return _possibleConstructorReturn(this,(RoomNotFoundError.__proto__||Object.getPrototypeOf(RoomNotFoundError)).call(this,53106,"Room not found"))}return RoomNotFoundError}(TwilioError);exports.RoomNotFoundError=RoomNotFoundError;Object.defineProperty(TwilioErrorByCode,53106,{value:RoomNotFoundError});var RoomMaxParticipantsOutOfRangeError=function(_TwilioError20){_inherits(RoomMaxParticipantsOutOfRangeError,_TwilioError20);function RoomMaxParticipantsOutOfRangeError(){_classCallCheck(this,RoomMaxParticipantsOutOfRangeError);return _possibleConstructorReturn(this,(RoomMaxParticipantsOutOfRangeError.__proto__||Object.getPrototypeOf(RoomMaxParticipantsOutOfRangeError)).call(this,53107,"MaxParticipants is out of range"))}return RoomMaxParticipantsOutOfRangeError}(TwilioError);exports.RoomMaxParticipantsOutOfRangeError=RoomMaxParticipantsOutOfRangeError;Object.defineProperty(TwilioErrorByCode,53107,{value:RoomMaxParticipantsOutOfRangeError});var RoomTypeInvalidError=function(_TwilioError21){_inherits(RoomTypeInvalidError,_TwilioError21);function RoomTypeInvalidError(){_classCallCheck(this,RoomTypeInvalidError);return _possibleConstructorReturn(this,(RoomTypeInvalidError.__proto__||Object.getPrototypeOf(RoomTypeInvalidError)).call(this,53108,"RoomType is not valid"))}return RoomTypeInvalidError}(TwilioError);exports.RoomTypeInvalidError=RoomTypeInvalidError;Object.defineProperty(TwilioErrorByCode,53108,{value:RoomTypeInvalidError});var RoomTimeoutOutOfRangeError=function(_TwilioError22){_inherits(RoomTimeoutOutOfRangeError,_TwilioError22);function RoomTimeoutOutOfRangeError(){_classCallCheck(this,RoomTimeoutOutOfRangeError);return _possibleConstructorReturn(this,(RoomTimeoutOutOfRangeError.__proto__||Object.getPrototypeOf(RoomTimeoutOutOfRangeError)).call(this,53109,"Timeout is out of range"))}return RoomTimeoutOutOfRangeError}(TwilioError);exports.RoomTimeoutOutOfRangeError=RoomTimeoutOutOfRangeError;Object.defineProperty(TwilioErrorByCode,53109,{value:RoomTimeoutOutOfRangeError});var RoomStatusCallbackMethodInvalidError=function(_TwilioError23){_inherits(RoomStatusCallbackMethodInvalidError,_TwilioError23);function RoomStatusCallbackMethodInvalidError(){_classCallCheck(this,RoomStatusCallbackMethodInvalidError);return _possibleConstructorReturn(this,(RoomStatusCallbackMethodInvalidError.__proto__||Object.getPrototypeOf(RoomStatusCallbackMethodInvalidError)).call(this,53110,"StatusCallbackMethod is invalid"))}return RoomStatusCallbackMethodInvalidError}(TwilioError);exports.RoomStatusCallbackMethodInvalidError=RoomStatusCallbackMethodInvalidError;Object.defineProperty(TwilioErrorByCode,53110,{value:RoomStatusCallbackMethodInvalidError});var RoomStatusCallbackInvalidError=function(_TwilioError24){_inherits(RoomStatusCallbackInvalidError,_TwilioError24);function RoomStatusCallbackInvalidError(){_classCallCheck(this,RoomStatusCallbackInvalidError);return _possibleConstructorReturn(this,(RoomStatusCallbackInvalidError.__proto__||Object.getPrototypeOf(RoomStatusCallbackInvalidError)).call(this,53111,"StatusCallback is invalid"))}return RoomStatusCallbackInvalidError}(TwilioError);exports.RoomStatusCallbackInvalidError=RoomStatusCallbackInvalidError;Object.defineProperty(TwilioErrorByCode,53111,{value:RoomStatusCallbackInvalidError});var RoomStatusInvalidError=function(_TwilioError25){_inherits(RoomStatusInvalidError,_TwilioError25);function RoomStatusInvalidError(){_classCallCheck(this,RoomStatusInvalidError);return _possibleConstructorReturn(this,(RoomStatusInvalidError.__proto__||Object.getPrototypeOf(RoomStatusInvalidError)).call(this,53112,"Status is invalid"))}return RoomStatusInvalidError}(TwilioError);exports.RoomStatusInvalidError=RoomStatusInvalidError;Object.defineProperty(TwilioErrorByCode,53112,{value:RoomStatusInvalidError});var RoomRoomExistsError=function(_TwilioError26){_inherits(RoomRoomExistsError,_TwilioError26);function RoomRoomExistsError(){_classCallCheck(this,RoomRoomExistsError);return _possibleConstructorReturn(this,(RoomRoomExistsError.__proto__||Object.getPrototypeOf(RoomRoomExistsError)).call(this,53113,"Room exists"))}return RoomRoomExistsError}(TwilioError);exports.RoomRoomExistsError=RoomRoomExistsError;Object.defineProperty(TwilioErrorByCode,53113,{value:RoomRoomExistsError});var RoomInvalidParametersError=function(_TwilioError27){_inherits(RoomInvalidParametersError,_TwilioError27);function RoomInvalidParametersError(){_classCallCheck(this,RoomInvalidParametersError);return _possibleConstructorReturn(this,(RoomInvalidParametersError.__proto__||Object.getPrototypeOf(RoomInvalidParametersError)).call(this,53114,"Room creation parameter(s) incompatible with the Room type"))}return RoomInvalidParametersError}(TwilioError);exports.RoomInvalidParametersError=RoomInvalidParametersError;Object.defineProperty(TwilioErrorByCode,53114,{value:RoomInvalidParametersError});var RoomMediaRegionInvalidError=function(_TwilioError28){_inherits(RoomMediaRegionInvalidError,_TwilioError28);function RoomMediaRegionInvalidError(){_classCallCheck(this,RoomMediaRegionInvalidError);return _possibleConstructorReturn(this,(RoomMediaRegionInvalidError.__proto__||Object.getPrototypeOf(RoomMediaRegionInvalidError)).call(this,53115,"MediaRegion is invalid"))}return RoomMediaRegionInvalidError}(TwilioError);exports.RoomMediaRegionInvalidError=RoomMediaRegionInvalidError;Object.defineProperty(TwilioErrorByCode,53115,{value:RoomMediaRegionInvalidError});var RoomMediaRegionUnavailableError=function(_TwilioError29){_inherits(RoomMediaRegionUnavailableError,_TwilioError29);function RoomMediaRegionUnavailableError(){_classCallCheck(this,RoomMediaRegionUnavailableError);return _possibleConstructorReturn(this,(RoomMediaRegionUnavailableError.__proto__||Object.getPrototypeOf(RoomMediaRegionUnavailableError)).call(this,53116,"There are no media servers available in the MediaRegion"))}return RoomMediaRegionUnavailableError}(TwilioError);exports.RoomMediaRegionUnavailableError=RoomMediaRegionUnavailableError;Object.defineProperty(TwilioErrorByCode,53116,{value:RoomMediaRegionUnavailableError});var RoomSubscriptionOperationNotSupportedError=function(_TwilioError30){_inherits(RoomSubscriptionOperationNotSupportedError,_TwilioError30);function RoomSubscriptionOperationNotSupportedError(){_classCallCheck(this,RoomSubscriptionOperationNotSupportedError);return _possibleConstructorReturn(this,(RoomSubscriptionOperationNotSupportedError.__proto__||Object.getPrototypeOf(RoomSubscriptionOperationNotSupportedError)).call(this,53117,"The subscription operation requested is not supported for the Room type"))}return RoomSubscriptionOperationNotSupportedError}(TwilioError);exports.RoomSubscriptionOperationNotSupportedError=RoomSubscriptionOperationNotSupportedError;Object.defineProperty(TwilioErrorByCode,53117,{value:RoomSubscriptionOperationNotSupportedError});var RoomCompletedError=function(_TwilioError31){_inherits(RoomCompletedError,_TwilioError31);function RoomCompletedError(){_classCallCheck(this,RoomCompletedError);return _possibleConstructorReturn(this,(RoomCompletedError.__proto__||Object.getPrototypeOf(RoomCompletedError)).call(this,53118,"Room completed"))}return RoomCompletedError}(TwilioError);exports.RoomCompletedError=RoomCompletedError;Object.defineProperty(TwilioErrorByCode,53118,{value:RoomCompletedError});var ParticipantIdentityInvalidError=function(_TwilioError32){_inherits(ParticipantIdentityInvalidError,_TwilioError32);function ParticipantIdentityInvalidError(){_classCallCheck(this,ParticipantIdentityInvalidError);return _possibleConstructorReturn(this,(ParticipantIdentityInvalidError.__proto__||Object.getPrototypeOf(ParticipantIdentityInvalidError)).call(this,53200,"Participant identity is invalid"))}return ParticipantIdentityInvalidError}(TwilioError);exports.ParticipantIdentityInvalidError=ParticipantIdentityInvalidError;Object.defineProperty(TwilioErrorByCode,53200,{value:ParticipantIdentityInvalidError});var ParticipantIdentityTooLongError=function(_TwilioError33){_inherits(ParticipantIdentityTooLongError,_TwilioError33);function ParticipantIdentityTooLongError(){_classCallCheck(this,ParticipantIdentityTooLongError);return _possibleConstructorReturn(this,(ParticipantIdentityTooLongError.__proto__||Object.getPrototypeOf(ParticipantIdentityTooLongError)).call(this,53201,"Participant identity is too long"))}return ParticipantIdentityTooLongError}(TwilioError);exports.ParticipantIdentityTooLongError=ParticipantIdentityTooLongError;Object.defineProperty(TwilioErrorByCode,53201,{value:ParticipantIdentityTooLongError});var ParticipantIdentityCharsInvalidError=function(_TwilioError34){_inherits(ParticipantIdentityCharsInvalidError,_TwilioError34);function ParticipantIdentityCharsInvalidError(){_classCallCheck(this,ParticipantIdentityCharsInvalidError);return _possibleConstructorReturn(this,(ParticipantIdentityCharsInvalidError.__proto__||Object.getPrototypeOf(ParticipantIdentityCharsInvalidError)).call(this,53202,"Participant identity contains invalid characters"))}return ParticipantIdentityCharsInvalidError}(TwilioError);exports.ParticipantIdentityCharsInvalidError=ParticipantIdentityCharsInvalidError;Object.defineProperty(TwilioErrorByCode,53202,{value:ParticipantIdentityCharsInvalidError});var ParticipantMaxTracksExceededError=function(_TwilioError35){_inherits(ParticipantMaxTracksExceededError,_TwilioError35);function ParticipantMaxTracksExceededError(){_classCallCheck(this,ParticipantMaxTracksExceededError);return _possibleConstructorReturn(this,(ParticipantMaxTracksExceededError.__proto__||Object.getPrototypeOf(ParticipantMaxTracksExceededError)).call(this,53203,"Participant has too many Tracks"))}return ParticipantMaxTracksExceededError}(TwilioError);exports.ParticipantMaxTracksExceededError=ParticipantMaxTracksExceededError;Object.defineProperty(TwilioErrorByCode,53203,{value:ParticipantMaxTracksExceededError});var ParticipantNotFoundError=function(_TwilioError36){_inherits(ParticipantNotFoundError,_TwilioError36);function ParticipantNotFoundError(){_classCallCheck(this,ParticipantNotFoundError);return _possibleConstructorReturn(this,(ParticipantNotFoundError.__proto__||Object.getPrototypeOf(ParticipantNotFoundError)).call(this,53204,"Participant not found"))}return ParticipantNotFoundError}(TwilioError);exports.ParticipantNotFoundError=ParticipantNotFoundError;Object.defineProperty(TwilioErrorByCode,53204,{value:ParticipantNotFoundError});var ParticipantDuplicateIdentityError=function(_TwilioError37){_inherits(ParticipantDuplicateIdentityError,_TwilioError37);function ParticipantDuplicateIdentityError(){_classCallCheck(this,ParticipantDuplicateIdentityError);return _possibleConstructorReturn(this,(ParticipantDuplicateIdentityError.__proto__||Object.getPrototypeOf(ParticipantDuplicateIdentityError)).call(this,53205,"Participant disconnected because of duplicate identity"))}return ParticipantDuplicateIdentityError}(TwilioError);exports.ParticipantDuplicateIdentityError=ParticipantDuplicateIdentityError;Object.defineProperty(TwilioErrorByCode,53205,{value:ParticipantDuplicateIdentityError});var TrackInvalidError=function(_TwilioError38){_inherits(TrackInvalidError,_TwilioError38);function TrackInvalidError(){_classCallCheck(this,TrackInvalidError);return _possibleConstructorReturn(this,(TrackInvalidError.__proto__||Object.getPrototypeOf(TrackInvalidError)).call(this,53300,"Track is invalid"))}return TrackInvalidError}(TwilioError);exports.TrackInvalidError=TrackInvalidError;Object.defineProperty(TwilioErrorByCode,53300,{value:TrackInvalidError});var TrackNameInvalidError=function(_TwilioError39){_inherits(TrackNameInvalidError,_TwilioError39);function TrackNameInvalidError(){_classCallCheck(this,TrackNameInvalidError);return _possibleConstructorReturn(this,(TrackNameInvalidError.__proto__||Object.getPrototypeOf(TrackNameInvalidError)).call(this,53301,"Track name is invalid"))}return TrackNameInvalidError}(TwilioError);exports.TrackNameInvalidError=TrackNameInvalidError;Object.defineProperty(TwilioErrorByCode,53301,{value:TrackNameInvalidError});var TrackNameTooLongError=function(_TwilioError40){_inherits(TrackNameTooLongError,_TwilioError40);function TrackNameTooLongError(){_classCallCheck(this,TrackNameTooLongError);return _possibleConstructorReturn(this,(TrackNameTooLongError.__proto__||Object.getPrototypeOf(TrackNameTooLongError)).call(this,53302,"Track name is too long"))}return TrackNameTooLongError}(TwilioError);exports.TrackNameTooLongError=TrackNameTooLongError;Object.defineProperty(TwilioErrorByCode,53302,{value:TrackNameTooLongError});var TrackNameCharsInvalidError=function(_TwilioError41){_inherits(TrackNameCharsInvalidError,_TwilioError41);function TrackNameCharsInvalidError(){_classCallCheck(this,TrackNameCharsInvalidError);return _possibleConstructorReturn(this,(TrackNameCharsInvalidError.__proto__||Object.getPrototypeOf(TrackNameCharsInvalidError)).call(this,53303,"Track name contains invalid characters"))}return TrackNameCharsInvalidError}(TwilioError);exports.TrackNameCharsInvalidError=TrackNameCharsInvalidError;Object.defineProperty(TwilioErrorByCode,53303,{value:TrackNameCharsInvalidError});var TrackNameIsDuplicatedError=function(_TwilioError42){_inherits(TrackNameIsDuplicatedError,_TwilioError42);function TrackNameIsDuplicatedError(){_classCallCheck(this,TrackNameIsDuplicatedError);return _possibleConstructorReturn(this,(TrackNameIsDuplicatedError.__proto__||Object.getPrototypeOf(TrackNameIsDuplicatedError)).call(this,53304,"Track name is duplicated"))}return TrackNameIsDuplicatedError}(TwilioError);exports.TrackNameIsDuplicatedError=TrackNameIsDuplicatedError;Object.defineProperty(TwilioErrorByCode,53304,{value:TrackNameIsDuplicatedError});var TrackServerTrackCapacityReachedError=function(_TwilioError43){_inherits(TrackServerTrackCapacityReachedError,_TwilioError43);function TrackServerTrackCapacityReachedError(){_classCallCheck(this,TrackServerTrackCapacityReachedError);return _possibleConstructorReturn(this,(TrackServerTrackCapacityReachedError.__proto__||Object.getPrototypeOf(TrackServerTrackCapacityReachedError)).call(this,53305,"The server has reached capacity and cannot fulfill this request."))}return TrackServerTrackCapacityReachedError}(TwilioError);exports.TrackServerTrackCapacityReachedError=TrackServerTrackCapacityReachedError;Object.defineProperty(TwilioErrorByCode,53305,{value:TrackServerTrackCapacityReachedError});var MediaClientLocalDescFailedError=function(_TwilioError44){_inherits(MediaClientLocalDescFailedError,_TwilioError44);function MediaClientLocalDescFailedError(){_classCallCheck(this,MediaClientLocalDescFailedError);return _possibleConstructorReturn(this,(MediaClientLocalDescFailedError.__proto__||Object.getPrototypeOf(MediaClientLocalDescFailedError)).call(this,53400,"Client is unable to create or apply a local media description"))}return MediaClientLocalDescFailedError}(TwilioError);exports.MediaClientLocalDescFailedError=MediaClientLocalDescFailedError;Object.defineProperty(TwilioErrorByCode,53400,{value:MediaClientLocalDescFailedError});var MediaServerLocalDescFailedError=function(_TwilioError45){_inherits(MediaServerLocalDescFailedError,_TwilioError45);function MediaServerLocalDescFailedError(){_classCallCheck(this,MediaServerLocalDescFailedError);return _possibleConstructorReturn(this,(MediaServerLocalDescFailedError.__proto__||Object.getPrototypeOf(MediaServerLocalDescFailedError)).call(this,53401,"Server is unable to create or apply a local media description"))}return MediaServerLocalDescFailedError}(TwilioError);exports.MediaServerLocalDescFailedError=MediaServerLocalDescFailedError;Object.defineProperty(TwilioErrorByCode,53401,{value:MediaServerLocalDescFailedError});var MediaClientRemoteDescFailedError=function(_TwilioError46){_inherits(MediaClientRemoteDescFailedError,_TwilioError46);function MediaClientRemoteDescFailedError(){_classCallCheck(this,MediaClientRemoteDescFailedError);return _possibleConstructorReturn(this,(MediaClientRemoteDescFailedError.__proto__||Object.getPrototypeOf(MediaClientRemoteDescFailedError)).call(this,53402,"Client is unable to apply a remote media description"))}return MediaClientRemoteDescFailedError}(TwilioError);exports.MediaClientRemoteDescFailedError=MediaClientRemoteDescFailedError;Object.defineProperty(TwilioErrorByCode,53402,{value:MediaClientRemoteDescFailedError});var MediaServerRemoteDescFailedError=function(_TwilioError47){_inherits(MediaServerRemoteDescFailedError,_TwilioError47);function MediaServerRemoteDescFailedError(){_classCallCheck(this,MediaServerRemoteDescFailedError);return _possibleConstructorReturn(this,(MediaServerRemoteDescFailedError.__proto__||Object.getPrototypeOf(MediaServerRemoteDescFailedError)).call(this,53403,"Server is unable to apply a remote media description"))}return MediaServerRemoteDescFailedError}(TwilioError);exports.MediaServerRemoteDescFailedError=MediaServerRemoteDescFailedError;Object.defineProperty(TwilioErrorByCode,53403,{value:MediaServerRemoteDescFailedError});var MediaNoSupportedCodecError=function(_TwilioError48){_inherits(MediaNoSupportedCodecError,_TwilioError48);function MediaNoSupportedCodecError(){_classCallCheck(this,MediaNoSupportedCodecError);return _possibleConstructorReturn(this,(MediaNoSupportedCodecError.__proto__||Object.getPrototypeOf(MediaNoSupportedCodecError)).call(this,53404,"No supported codec"))}return MediaNoSupportedCodecError}(TwilioError);exports.MediaNoSupportedCodecError=MediaNoSupportedCodecError;Object.defineProperty(TwilioErrorByCode,53404,{value:MediaNoSupportedCodecError});var MediaConnectionError=function(_TwilioError49){_inherits(MediaConnectionError,_TwilioError49);function MediaConnectionError(){_classCallCheck(this,MediaConnectionError);return _possibleConstructorReturn(this,(MediaConnectionError.__proto__||Object.getPrototypeOf(MediaConnectionError)).call(this,53405,"Media connection failed"))}return MediaConnectionError}(TwilioError);exports.MediaConnectionError=MediaConnectionError;Object.defineProperty(TwilioErrorByCode,53405,{value:MediaConnectionError});var ConfigurationAcquireFailedError=function(_TwilioError50){_inherits(ConfigurationAcquireFailedError,_TwilioError50);function ConfigurationAcquireFailedError(){_classCallCheck(this,ConfigurationAcquireFailedError);return _possibleConstructorReturn(this,(ConfigurationAcquireFailedError.__proto__||Object.getPrototypeOf(ConfigurationAcquireFailedError)).call(this,53500,"Unable to acquire configuration"))}return ConfigurationAcquireFailedError}(TwilioError);exports.ConfigurationAcquireFailedError=ConfigurationAcquireFailedError;Object.defineProperty(TwilioErrorByCode,53500,{value:ConfigurationAcquireFailedError});var ConfigurationAcquireTurnFailedError=function(_TwilioError51){_inherits(ConfigurationAcquireTurnFailedError,_TwilioError51);function ConfigurationAcquireTurnFailedError(){_classCallCheck(this,ConfigurationAcquireTurnFailedError);return _possibleConstructorReturn(this,(ConfigurationAcquireTurnFailedError.__proto__||Object.getPrototypeOf(ConfigurationAcquireTurnFailedError)).call(this,53501,"Unable to acquire TURN credentials"))}return ConfigurationAcquireTurnFailedError}(TwilioError);exports.ConfigurationAcquireTurnFailedError=ConfigurationAcquireTurnFailedError;Object.defineProperty(TwilioErrorByCode,53501,{value:ConfigurationAcquireTurnFailedError})},{"./twilioerror":122}],122:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}else{return Array.from(arr)}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var TwilioError=function(_Error){_inherits(TwilioError,_Error);function TwilioError(code){var _ref;_classCallCheck(this,TwilioError);var args=[].slice.call(arguments,1);var _this=_possibleConstructorReturn(this,(_ref=TwilioError.__proto__||Object.getPrototypeOf(TwilioError)).call.apply(_ref,[this].concat(_toConsumableArray(args))));var error=Error.apply(_this,args);error.name="TwilioError";Object.defineProperty(_this,"code",{value:code,enumerable:true});Object.getOwnPropertyNames(error).forEach(function(prop){Object.defineProperty(this,prop,{value:error[prop],enumerable:true})},_this);return _this}_createClass(TwilioError,[{key:"toString",value:function toString(){var message=this.message?": "+this.message:"";return this.name+" "+this.code+message}}]);return TwilioError}(Error);module.exports=TwilioError},{}],123:[function(require,module,exports){"use strict";var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var NativeAudioContext=typeof AudioContext!=="undefined"?AudioContext:typeof webkitAudioContext!=="undefined"?webkitAudioContext:null;var AudioContextFactory=function(){function AudioContextFactory(options){_classCallCheck(this,AudioContextFactory);options=Object.assign({AudioContext:NativeAudioContext},options);Object.defineProperties(this,{_AudioContext:{value:options.AudioContext},_audioContext:{value:null,writable:true},_holders:{value:new Set},AudioContextFactory:{enumerable:true,value:AudioContextFactory}})}_createClass(AudioContextFactory,[{key:"getOrCreate",value:function getOrCreate(holder){if(!this._holders.has(holder)){this._holders.add(holder);if(this._AudioContext&&!this._audioContext){try{this._audioContext=new this._AudioContext}catch(error){}}}return this._audioContext}},{key:"release",value:function release(holder){if(this._holders.has(holder)){this._holders.delete(holder);if(!this._holders.size&&this._audioContext){this._audioContext.close();this._audioContext=null}}}}]);return AudioContextFactory}();module.exports=new AudioContextFactory},{}],124:[function(require,module,exports){"use strict";function delay(timeout){timeout=typeof timeout==="number"?timeout:0;return new Promise(function(resolve){return setTimeout(resolve,timeout)})}function detectSilence(audioContext,stream,timeout){timeout=typeof timeout==="number"?timeout:250;var source=audioContext.createMediaStreamSource(stream);var analyser=audioContext.createAnalyser();analyser.fftSize=2048;source.connect(analyser);var samples=new Uint8Array(analyser.fftSize);var timeoutDidFire=false;setTimeout(function(){timeoutDidFire=true},timeout);function doDetectSilence(){if(timeoutDidFire){return Promise.resolve(true)}analyser.getByteTimeDomainData(samples);return samples.some(function(sample){return sample})?Promise.resolve(false):delay().then(doDetectSilence)}return doDetectSilence().then(function(isSilent){source.disconnect();return isSilent},function(error){source.disconnect();throw error})}module.exports=detectSilence},{}],125:[function(require,module,exports){"use strict";var detectSilence=require("./detectsilence");function workaround(log,getUserMedia,constraints,n,timeout){n=typeof n==="number"?n:3;var retry=0;var AudioContextFactory=require("./audiocontext");var holder={};var audioContext=AudioContextFactory.getOrCreate(holder);function doWorkaround(){return getUserMedia(constraints).then(function(stream){var isSilentPromise=constraints.audio?detectSilence(audioContext,stream,timeout).catch(function(){return true}):Promise.resolve(false);return isSilentPromise.then(function(isSilent){if(!isSilent){log.info("Got a non-silent audio MediaStreamTrack; returning it.");return stream}else if(n<=0){log.warn("Got a silent audio MediaStreamTrack. Normally we would try to get a new one, but we've run out of retries; returning it anyway.");return stream}log.warn("Got a silent audio MediaStreamTrack. Stopping all MediaStreamTracks and calling getUserMedia again. This is retry #"+ ++retry+".");stream.getTracks().forEach(function(track){return track.stop()});n--;return doWorkaround()})})}return doWorkaround().then(function(stream){AudioContextFactory.release(holder);return stream},function(error){AudioContextFactory.release(holder);throw error})}module.exports=workaround},{"./audiocontext":123,"./detectsilence":124}],126:[function(require,module,exports){module.exports={_from:"@twilio/sip.js@^0.7.7",_id:"@twilio/sip.js@0.7.7",_inBundle:false,_integrity:"sha1-z/UPZvmyldRvIZc3tyeAx9Dm31I=",_location:"/@twilio/sip.js",_phantomChildren:{},_requested:{type:"range",registry:true,raw:"@twilio/sip.js@^0.7.7",name:"@twilio/sip.js",escapedName:"@twilio%2fsip.js",scope:"@twilio",rawSpec:"^0.7.7",saveSpec:null,fetchSpec:"^0.7.7"},_requiredBy:["/"],_resolved:"https://registry.npmjs.org/@twilio/sip.js/-/sip.js-0.7.7.tgz",_shasum:"cff50f66f9b295d46f219737b72780c7d0e6df52",_spec:"@twilio/sip.js@^0.7.7",_where:"/home/travis/build/twilio/twilio-video.js",author:{name:"OnSIP",email:"developer@onsip.com",url:"http://sipjs.com/authors/"},browser:{"./src/environment.js":"./src/environment_browser.js"},bugs:{url:"https://github.com/onsip/SIP.js/issues"},bundleDependencies:false,contributors:[{url:"https://github.com/onsip/SIP.js/blob/master/THANKS.md"}],deprecated:false,description:"A simple, intuitive, and powerful JavaScript signaling library",devDependencies:{beefy:"^2.1.5",browserify:"^4.1.8",grunt:"~0.4.0","grunt-browserify":"^4.0.1","grunt-cli":"~0.1.6","grunt-contrib-copy":"^0.5.0","grunt-contrib-jasmine":"^1.0.3","grunt-contrib-jshint":">0.5.0","grunt-contrib-uglify":"~0.2.0","grunt-peg":"~1.3.1","grunt-trimtrailingspaces":"^0.4.0",pegjs:"^0.8.0","release-tool":"^0.2.2"},engines:{node:">=0.12"},homepage:"http://sipjs.com",keywords:["sip","websocket","webrtc","library","javascript"],license:"MIT",main:"src/index.js",name:"@twilio/sip.js",repository:{type:"git",url:"git+https://github.com/onsip/SIP.js.git"},scripts:{build:"grunt build",repl:"beefy test/repl.js --open",test:"grunt travis --verbose"},title:"SIP.js",version:"0.7.7"}},{}],127:[function(require,module,exports){"use strict";module.exports=function(SIP){var ClientContext;ClientContext=function(ua,method,target,options){var originalTarget=target;if(target===undefined){throw new TypeError("Not enough arguments")}this.ua=ua;this.logger=ua.getLogger("sip.clientcontext");this.method=method;target=ua.normalizeTarget(target);if(!target){throw new TypeError("Invalid target: "+originalTarget)}options=Object.create(options||Object.prototype);options.extraHeaders=(options.extraHeaders||[]).slice();this.request=new SIP.OutgoingRequest(this.method,target,this.ua,options.params,options.extraHeaders);if(options.body){this.body={};this.body.body=options.body;if(options.contentType){this.body.contentType=options.contentType}this.request.body=this.body}this.localIdentity=this.request.from;this.remoteIdentity=this.request.to;this.data={}};ClientContext.prototype=Object.create(SIP.EventEmitter.prototype);ClientContext.prototype.send=function(){new SIP.RequestSender(this,this.ua).send();return this};ClientContext.prototype.cancel=function(options){options=options||{};options.extraHeaders=(options.extraHeaders||[]).slice();var cancel_reason=SIP.Utils.getCancelReason(options.status_code,options.reason_phrase);this.request.cancel(cancel_reason,options.extraHeaders);this.emit("cancel")};ClientContext.prototype.receiveResponse=function(response){var cause=SIP.Utils.getReasonPhrase(response.status_code);switch(true){case/^1[0-9]{2}$/.test(response.status_code):this.emit("progress",response,cause);break;case/^2[0-9]{2}$/.test(response.status_code):if(this.ua.applicants[this]){delete this.ua.applicants[this]}this.emit("accepted",response,cause);break;default:if(this.ua.applicants[this]){delete this.ua.applicants[this]}this.emit("rejected",response,cause);this.emit("failed",response,cause);break}};ClientContext.prototype.onRequestTimeout=function(){this.emit("failed",null,SIP.C.causes.REQUEST_TIMEOUT)};ClientContext.prototype.onTransportError=function(){this.emit("failed",null,SIP.C.causes.CONNECTION_ERROR)};SIP.ClientContext=ClientContext}},{}],128:[function(require,module,exports){"use strict";module.exports=function(name,version){return{USER_AGENT:name+"/"+version,SIP:"sip",SIPS:"sips",causes:{CONNECTION_ERROR:"Connection Error",REQUEST_TIMEOUT:"Request Timeout",SIP_FAILURE_CODE:"SIP Failure Code",INTERNAL_ERROR:"Internal Error",BUSY:"Busy",REJECTED:"Rejected",REDIRECTED:"Redirected",UNAVAILABLE:"Unavailable",NOT_FOUND:"Not Found",ADDRESS_INCOMPLETE:"Address Incomplete",INCOMPATIBLE_SDP:"Incompatible SDP",AUTHENTICATION_ERROR:"Authentication Error",DIALOG_ERROR:"Dialog Error",WEBRTC_NOT_SUPPORTED:"WebRTC Not Supported",WEBRTC_ERROR:"WebRTC Error",CANCELED:"Canceled",NO_ANSWER:"No Answer",EXPIRES:"Expires",NO_ACK:"No ACK",NO_PRACK:"No PRACK",USER_DENIED_MEDIA_ACCESS:"User Denied Media Access",BAD_MEDIA_DESCRIPTION:"Bad Media Description",RTP_TIMEOUT:"RTP Timeout"},supported:{UNSUPPORTED:"none",SUPPORTED:"supported",REQUIRED:"required"},SIP_ERROR_CAUSES:{REDIRECTED:[300,301,302,305,380],BUSY:[486,600],REJECTED:[403,603],NOT_FOUND:[404,604],UNAVAILABLE:[480,410,408,430],ADDRESS_INCOMPLETE:[484],INCOMPATIBLE_SDP:[488,606],AUTHENTICATION_ERROR:[401,407]},ACK:"ACK",BYE:"BYE",
        CANCEL:"CANCEL",INFO:"INFO",INVITE:"INVITE",MESSAGE:"MESSAGE",NOTIFY:"NOTIFY",OPTIONS:"OPTIONS",REGISTER:"REGISTER",UPDATE:"UPDATE",SUBSCRIBE:"SUBSCRIBE",REFER:"REFER",PRACK:"PRACK",REASON_PHRASE:{100:"Trying",180:"Ringing",181:"Call Is Being Forwarded",182:"Queued",183:"Session Progress",199:"Early Dialog Terminated",200:"OK",202:"Accepted",204:"No Notification",300:"Multiple Choices",301:"Moved Permanently",302:"Moved Temporarily",305:"Use Proxy",380:"Alternative Service",400:"Bad Request",401:"Unauthorized",402:"Payment Required",403:"Forbidden",404:"Not Found",405:"Method Not Allowed",406:"Not Acceptable",407:"Proxy Authentication Required",408:"Request Timeout",410:"Gone",412:"Conditional Request Failed",413:"Request Entity Too Large",414:"Request-URI Too Long",415:"Unsupported Media Type",416:"Unsupported URI Scheme",417:"Unknown Resource-Priority",420:"Bad Extension",421:"Extension Required",422:"Session Interval Too Small",423:"Interval Too Brief",428:"Use Identity Header",429:"Provide Referrer Identity",430:"Flow Failed",433:"Anonymity Disallowed",436:"Bad Identity-Info",437:"Unsupported Certificate",438:"Invalid Identity Header",439:"First Hop Lacks Outbound Support",440:"Max-Breadth Exceeded",469:"Bad Info Package",470:"Consent Needed",478:"Unresolvable Destination",480:"Temporarily Unavailable",481:"Call/Transaction Does Not Exist",482:"Loop Detected",483:"Too Many Hops",484:"Address Incomplete",485:"Ambiguous",486:"Busy Here",487:"Request Terminated",488:"Not Acceptable Here",489:"Bad Event",491:"Request Pending",493:"Undecipherable",494:"Security Agreement Required",500:"Internal Server Error",501:"Not Implemented",502:"Bad Gateway",503:"Service Unavailable",504:"Server Time-out",505:"Version Not Supported",513:"Message Too Large",580:"Precondition Failure",600:"Busy Everywhere",603:"Decline",604:"Does Not Exist Anywhere",606:"Not Acceptable"},OPTION_TAGS:{"100rel":true,199:true,answermode:true,"early-session":true,eventlist:true,explicitsub:true,"from-change":true,"geolocation-http":true,"geolocation-sip":true,gin:true,gruu:true,histinfo:true,ice:true,join:true,"multiple-refer":true,norefersub:true,nosub:true,outbound:true,path:true,policy:true,precondition:true,pref:true,privacy:true,"recipient-list-invite":true,"recipient-list-message":true,"recipient-list-subscribe":true,replaces:true,"resource-priority":true,"sdp-anat":true,"sec-agree":true,tdialog:true,timer:true,uui:true}}}},{}],129:[function(require,module,exports){"use strict";module.exports=function(SIP){var RequestSender;RequestSender=function(dialog,applicant,request){this.dialog=dialog;this.applicant=applicant;this.request=request;this.reattempt=false;this.reattemptTimer=null};RequestSender.prototype={send:function(){var self=this,request_sender=new SIP.RequestSender(this,this.dialog.owner.ua);request_sender.send();if(this.request.method===SIP.C.INVITE&&request_sender.clientTransaction.state!==SIP.Transactions.C.STATUS_TERMINATED){this.dialog.uac_pending_reply=true;request_sender.clientTransaction.on("stateChanged",function stateChanged(){if(this.state===SIP.Transactions.C.STATUS_ACCEPTED||this.state===SIP.Transactions.C.STATUS_COMPLETED||this.state===SIP.Transactions.C.STATUS_TERMINATED){this.removeListener("stateChanged",stateChanged);self.dialog.uac_pending_reply=false;if(self.dialog.uas_pending_reply===false){self.dialog.owner.onReadyToReinvite()}}})}},onRequestTimeout:function(){this.applicant.onRequestTimeout()},onTransportError:function(){this.applicant.onTransportError()},receiveResponse:function(response){var self=this;if(response.status_code===408||response.status_code===481){this.applicant.onDialogError(response)}else if(response.method===SIP.C.INVITE&&response.status_code===491){if(this.reattempt){this.applicant.receiveResponse(response)}else{this.request.cseq.value=this.dialog.local_seqnum+=1;this.reattemptTimer=SIP.Timers.setTimeout(function(){if(self.applicant.owner.status!==SIP.Session.C.STATUS_TERMINATED){self.reattempt=true;self.request_sender.send()}},this.getReattemptTimeout())}}else{this.applicant.receiveResponse(response)}}};return RequestSender}},{}],130:[function(require,module,exports){"use strict";module.exports=function(SIP){var RequestSender=require("./Dialog/RequestSender")(SIP);var Dialog,C={STATUS_EARLY:1,STATUS_CONFIRMED:2};Dialog=function(owner,message,type,state){var contact;this.uac_pending_reply=false;this.uas_pending_reply=false;if(!message.hasHeader("contact")){return{error:"unable to create a Dialog without Contact header field"}}if(message instanceof SIP.IncomingResponse){state=message.status_code<200?C.STATUS_EARLY:C.STATUS_CONFIRMED}else{state=state||C.STATUS_CONFIRMED}contact=message.parseHeader("contact");if(type==="UAS"){this.id={call_id:message.call_id,local_tag:message.to_tag,remote_tag:message.from_tag,toString:function(){return this.call_id+this.local_tag+this.remote_tag}};this.state=state;this.remote_seqnum=message.cseq;this.local_uri=message.parseHeader("to").uri;this.remote_uri=message.parseHeader("from").uri;this.remote_target=contact.uri;this.route_set=message.getHeaders("record-route");this.invite_seqnum=message.cseq;this.local_seqnum=message.cseq}else if(type==="UAC"){this.id={call_id:message.call_id,local_tag:message.from_tag,remote_tag:message.to_tag,toString:function(){return this.call_id+this.local_tag+this.remote_tag}};this.state=state;this.invite_seqnum=message.cseq;this.local_seqnum=message.cseq;this.local_uri=message.parseHeader("from").uri;this.pracked=[];this.remote_uri=message.parseHeader("to").uri;this.remote_target=contact.uri;this.route_set=message.getHeaders("record-route").reverse();if(this.state===C.STATUS_EARLY&&!owner.hasOffer){this.mediaHandler=owner.mediaHandlerFactory(owner)}}this.logger=owner.ua.getLogger("sip.dialog",this.id.toString());this.owner=owner;owner.ua.dialogs[this.id.toString()]=this;this.logger.log("new "+type+" dialog created with status "+(this.state===C.STATUS_EARLY?"EARLY":"CONFIRMED"));owner.emit("dialog",this)};Dialog.prototype={update:function(message,type){this.state=C.STATUS_CONFIRMED;this.logger.log("dialog "+this.id.toString()+"  changed to CONFIRMED state");if(type==="UAC"){this.route_set=message.getHeaders("record-route").reverse()}},terminate:function(){this.logger.log("dialog "+this.id.toString()+" deleted");if(this.mediaHandler&&this.state!==C.STATUS_CONFIRMED){this.mediaHandler.peerConnection.close()}delete this.owner.ua.dialogs[this.id.toString()]},createRequest:function(method,extraHeaders,body){var cseq,request;extraHeaders=(extraHeaders||[]).slice();if(!this.local_seqnum){this.local_seqnum=Math.floor(Math.random()*1e4)}cseq=method===SIP.C.CANCEL||method===SIP.C.ACK?this.invite_seqnum:this.local_seqnum+=1;request=new SIP.OutgoingRequest(method,this.remote_target,this.owner.ua,{cseq:cseq,call_id:this.id.call_id,from_uri:this.local_uri,from_tag:this.id.local_tag,to_uri:this.remote_uri,to_tag:this.id.remote_tag,route_set:this.route_set},extraHeaders,body);request.dialog=this;return request},checkInDialogRequest:function(request){var self=this;if(!this.remote_seqnum){this.remote_seqnum=request.cseq}else if(request.cseq<this.remote_seqnum){if(request.method!==SIP.C.ACK){request.reply(500)}if(request.cseq===this.invite_seqnum){return true}return false}else if(request.cseq>this.remote_seqnum){this.remote_seqnum=request.cseq}switch(request.method){case SIP.C.INVITE:if(this.uac_pending_reply===true){request.reply(491)}else if(this.uas_pending_reply===true){var retryAfter=(Math.random()*10|0)+1;request.reply(500,null,["Retry-After:"+retryAfter]);return false}else{this.uas_pending_reply=true;request.server_transaction.on("stateChanged",function stateChanged(){if(this.state===SIP.Transactions.C.STATUS_ACCEPTED||this.state===SIP.Transactions.C.STATUS_COMPLETED||this.state===SIP.Transactions.C.STATUS_TERMINATED){this.removeListener("stateChanged",stateChanged);self.uas_pending_reply=false;if(self.uac_pending_reply===false){self.owner.onReadyToReinvite()}}})}if(request.hasHeader("contact")){request.server_transaction.on("stateChanged",function(){if(this.state===SIP.Transactions.C.STATUS_ACCEPTED){self.remote_target=request.parseHeader("contact").uri}})}break;case SIP.C.NOTIFY:if(request.hasHeader("contact")){request.server_transaction.on("stateChanged",function(){if(this.state===SIP.Transactions.C.STATUS_COMPLETED){self.remote_target=request.parseHeader("contact").uri}})}break}return true},sendRequest:function(applicant,method,options){options=options||{};var extraHeaders=(options.extraHeaders||[]).slice();var body=null;if(options.body){if(options.body.body){body=options.body}else{body={};body.body=options.body;if(options.contentType){body.contentType=options.contentType}}}var request=this.createRequest(method,extraHeaders,body),request_sender=new RequestSender(this,applicant,request);request_sender.send();return request},receiveRequest:function(request){if(!this.checkInDialogRequest(request)){return}this.owner.receiveRequest(request)}};Dialog.C=C;SIP.Dialog=Dialog}},{"./Dialog/RequestSender":129}],131:[function(require,module,exports){"use strict";module.exports=function(Utils){var DigestAuthentication;DigestAuthentication=function(ua){this.logger=ua.getLogger("sipjs.digestauthentication");this.username=ua.configuration.authorizationUser;this.password=ua.configuration.password;this.cnonce=null;this.nc=0;this.ncHex="00000000";this.response=null};DigestAuthentication.prototype.authenticate=function(request,challenge){this.algorithm=challenge.algorithm;this.realm=challenge.realm;this.nonce=challenge.nonce;this.opaque=challenge.opaque;this.stale=challenge.stale;if(this.algorithm){if(this.algorithm!=="MD5"){this.logger.warn('challenge with Digest algorithm different than "MD5", authentication aborted');return false}}else{this.algorithm="MD5"}if(!this.realm){this.logger.warn("challenge without Digest realm, authentication aborted");return false}if(!this.nonce){this.logger.warn("challenge without Digest nonce, authentication aborted");return false}if(challenge.qop){if(challenge.qop.indexOf("auth")>-1){this.qop="auth"}else if(challenge.qop.indexOf("auth-int")>-1){this.qop="auth-int"}else{this.logger.warn('challenge without Digest qop different than "auth" or "auth-int", authentication aborted');return false}}else{this.qop=null}this.method=request.method;this.uri=request.ruri;this.cnonce=Utils.createRandomToken(12);this.nc+=1;this.updateNcHex();if(this.nc===4294967296){this.nc=1;this.ncHex="00000001"}this.calculateResponse();return true};DigestAuthentication.prototype.calculateResponse=function(){var ha1,ha2;ha1=Utils.calculateMD5(this.username+":"+this.realm+":"+this.password);if(this.qop==="auth"){ha2=Utils.calculateMD5(this.method+":"+this.uri);this.response=Utils.calculateMD5(ha1+":"+this.nonce+":"+this.ncHex+":"+this.cnonce+":auth:"+ha2)}else if(this.qop==="auth-int"){ha2=Utils.calculateMD5(this.method+":"+this.uri+":"+Utils.calculateMD5(this.body?this.body:""));this.response=Utils.calculateMD5(ha1+":"+this.nonce+":"+this.ncHex+":"+this.cnonce+":auth-int:"+ha2)}else if(this.qop===null){ha2=Utils.calculateMD5(this.method+":"+this.uri);this.response=Utils.calculateMD5(ha1+":"+this.nonce+":"+ha2)}};DigestAuthentication.prototype.toString=function(){var auth_params=[];if(!this.response){throw new Error("response field does not exist, cannot generate Authorization header")}auth_params.push("algorithm="+this.algorithm);auth_params.push('username="'+this.username+'"');auth_params.push('realm="'+this.realm+'"');auth_params.push('nonce="'+this.nonce+'"');auth_params.push('uri="'+this.uri+'"');auth_params.push('response="'+this.response+'"');if(this.opaque){auth_params.push('opaque="'+this.opaque+'"')}if(this.qop){auth_params.push("qop="+this.qop);auth_params.push('cnonce="'+this.cnonce+'"');auth_params.push("nc="+this.ncHex)}return"Digest "+auth_params.join(", ")};DigestAuthentication.prototype.updateNcHex=function(){var hex=Number(this.nc).toString(16);this.ncHex="00000000".substr(0,8-hex.length)+hex};return DigestAuthentication}},{}],132:[function(require,module,exports){"use strict";var NodeEventEmitter=require("events").EventEmitter;module.exports=function(console){function EventEmitter(){NodeEventEmitter.call(this)}EventEmitter.prototype=Object.create(NodeEventEmitter.prototype,{constructor:{value:EventEmitter,enumerable:false,writable:true,configurable:true}});EventEmitter.prototype.off=function off(eventName,listener){var warning="";warning+="SIP.EventEmitter#off is deprecated and may be removed in future SIP.js versions.\n";warning+="Please use removeListener or removeAllListeners instead.\n";warning+="See here for more details:\n";warning+="http://nodejs.org/api/events.html#events_emitter_removelistener_event_listener";console.warn(warning);if(arguments.length<2){return this.removeAllListeners.apply(this,arguments)}else{return this.removeListener(eventName,listener)}};return EventEmitter}},{events:179}],133:[function(require,module,exports){"use strict";module.exports={ConfigurationError:function(){var exception=function(parameter,value){this.code=1;this.name="CONFIGURATION_ERROR";this.parameter=parameter;this.value=value;this.message=!this.value?"Missing parameter: "+this.parameter:"Invalid value "+JSON.stringify(this.value)+' for parameter "'+this.parameter+'"'};exception.prototype=new Error;return exception}(),InvalidStateError:function(){var exception=function(status){this.code=2;this.name="INVALID_STATE_ERROR";this.status=status;this.message="Invalid status: "+status};exception.prototype=new Error;return exception}(),NotSupportedError:function(){var exception=function(message){this.code=3;this.name="NOT_SUPPORTED_ERROR";this.message=message};exception.prototype=new Error;return exception}(),GetDescriptionError:function(){var exception=function(message){this.code=4;this.name="GET_DESCRIPTION_ERROR";this.message=message};exception.prototype=new Error;return exception}()}},{}],134:[function(require,module,exports){"use strict";var Grammar=require("./Grammar/dist/Grammar");module.exports=function(SIP){return{parse:function parseCustom(input,startRule){var options={startRule:startRule,SIP:SIP};try{Grammar.parse(input,options)}catch(e){options.data=-1}return options.data}}}},{"./Grammar/dist/Grammar":135}],135:[function(require,module,exports){module.exports=function(){function peg$subclass(child,parent){function ctor(){this.constructor=child}ctor.prototype=parent.prototype;child.prototype=new ctor}function SyntaxError(message,expected,found,offset,line,column){this.message=message;this.expected=expected;this.found=found;this.offset=offset;this.line=line;this.column=column;this.name="SyntaxError"}peg$subclass(SyntaxError,Error);function parse(input){var options=arguments.length>1?arguments[1]:{},peg$FAILED={},peg$startRuleIndices={Contact:118,Name_Addr_Header:155,Record_Route:175,Request_Response:81,SIP_URI:45,Subscription_State:185,Supported:190,Require:181,Via:193,absoluteURI:84,Call_ID:117,Content_Disposition:129,Content_Length:134,Content_Type:135,CSeq:145,displayName:121,Event:148,From:150,host:52,Max_Forwards:153,Min_SE:212,Proxy_Authenticate:156,quoted_string:40,Refer_To:177,Replaces:178,Session_Expires:209,stun_URI:216,To:191,turn_URI:223,uuid:226,WWW_Authenticate:208,challenge:157},peg$startRuleIndex=118,peg$consts=["\r\n",{type:"literal",value:"\r\n",description:'"\\r\\n"'},/^[0-9]/,{type:"class",value:"[0-9]",description:"[0-9]"},/^[a-zA-Z]/,{type:"class",value:"[a-zA-Z]",description:"[a-zA-Z]"},/^[0-9a-fA-F]/,{type:"class",value:"[0-9a-fA-F]",description:"[0-9a-fA-F]"},/^[\0-\xFF]/,{type:"class",value:"[\\0-\\xFF]",description:"[\\0-\\xFF]"},/^["]/,{type:"class",value:'["]',description:'["]'}," ",{type:"literal",value:" ",description:'" "'},"\t",{type:"literal",value:"\t",description:'"\\t"'},/^[a-zA-Z0-9]/,{type:"class",value:"[a-zA-Z0-9]",description:"[a-zA-Z0-9]"},";",{type:"literal",value:";",description:'";"'},"/",{type:"literal",value:"/",description:'"/"'},"?",{type:"literal",value:"?",description:'"?"'},":",{type:"literal",value:":",description:'":"'},"@",{type:"literal",value:"@",description:'"@"'},"&",{type:"literal",value:"&",description:'"&"'},"=",{type:"literal",value:"=",description:'"="'},"+",{type:"literal",value:"+",description:'"+"'},"$",{type:"literal",value:"$",description:'"$"'},",",{type:"literal",value:",",description:'","'},"-",{type:"literal",value:"-",description:'"-"'},"_",{type:"literal",value:"_",description:'"_"'},".",{type:"literal",value:".",description:'"."'},"!",{type:"literal",value:"!",description:'"!"'},"~",{type:"literal",value:"~",description:'"~"'},"*",{type:"literal",value:"*",description:'"*"'},"'",{type:"literal",value:"'",description:'"\'"'},"(",{type:"literal",value:"(",description:'"("'},")",{type:"literal",value:")",description:'")"'},peg$FAILED,"%",{type:"literal",value:"%",description:'"%"'},null,[],function(){return" "},function(){return":"},/^[!-~]/,{type:"class",value:"[!-~]",description:"[!-~]"},/^[\x80-\uFFFF]/,{type:"class",value:"[\\x80-\\uFFFF]",description:"[\\x80-\\uFFFF]"},/^[\x80-\xBF]/,{type:"class",value:"[\\x80-\\xBF]",description:"[\\x80-\\xBF]"},/^[a-f]/,{type:"class",value:"[a-f]",description:"[a-f]"},"`",{type:"literal",value:"`",description:'"`"'},"<",{type:"literal",value:"<",description:'"<"'},">",{type:"literal",value:">",description:'">"'},"\\",{type:"literal",value:"\\",description:'"\\\\"'},"[",{type:"literal",value:"[",description:'"["'},"]",{type:"literal",value:"]",description:'"]"'},"{",{type:"literal",value:"{",description:'"{"'},"}",{type:"literal",value:"}",description:'"}"'},function(){return"*"},function(){return"/"},function(){return"="},function(){return"("},function(){return")"},function(){return">"},function(){return"<"},function(){return","},function(){return";"},function(){return":"},function(){return'"'},/^[!-']/,{type:"class",value:"[!-']",description:"[!-']"},/^[*-[]/,{type:"class",value:"[*-[]",description:"[*-[]"},/^[\]-~]/,{type:"class",value:"[\\]-~]",description:"[\\]-~]"},function(contents){return contents},/^[#-[]/,{type:"class",value:"[#-[]",description:"[#-[]"},/^[\0-\t]/,{type:"class",value:"[\\0-\\t]",description:"[\\0-\\t]"},/^[\x0B-\f]/,{type:"class",value:"[\\x0B-\\f]",description:"[\\x0B-\\f]"},/^[\x0E-\x7f]/,{type:"class",value:"[\\x0E-\x7f]",description:"[\\x0E-\x7f]"},function(){options.data.uri=new options.SIP.URI(options.data.scheme,options.data.user,options.data.host,options.data.port);delete options.data.scheme;delete options.data.user;delete options.data.host;delete options.data.host_type;delete options.data.port},function(){options.data.uri=new options.SIP.URI(options.data.scheme,options.data.user,options.data.host,options.data.port,options.data.uri_params,options.data.uri_headers);delete options.data.scheme;delete options.data.user;delete options.data.host;delete options.data.host_type;delete options.data.port;delete options.data.uri_params;if(options.startRule==="SIP_URI"){options.data=options.data.uri}},"sips",{type:"literal",value:"sips",description:'"sips"'},"sip",{type:"literal",value:"sip",description:'"sip"'},function(uri_scheme){options.data.scheme=uri_scheme},function(){options.data.user=decodeURIComponent(text().slice(0,-1))},function(){options.data.password=text()},function(){options.data.host=text();return options.data.host},function(){options.data.host_type="domain";return text()},/^[a-zA-Z0-9_\-]/,{type:"class",value:"[a-zA-Z0-9_\\-]",description:"[a-zA-Z0-9_\\-]"},/^[a-zA-Z0-9\-]/,{type:"class",value:"[a-zA-Z0-9\\-]",description:"[a-zA-Z0-9\\-]"},function(){options.data.host_type="IPv6";return text()},"::",{type:"literal",value:"::",description:'"::"'},function(){options.data.host_type="IPv6";return text()},function(){options.data.host_type="IPv4";return text()},"25",{type:"literal",value:"25",description:'"25"'},/^[0-5]/,{type:"class",value:"[0-5]",description:"[0-5]"},"2",{type:"literal",value:"2",description:'"2"'},/^[0-4]/,{type:"class",value:"[0-4]",description:"[0-4]"},"1",{type:"literal",value:"1",description:'"1"'},/^[1-9]/,{type:"class",value:"[1-9]",description:"[1-9]"},function(port){port=parseInt(port.join(""));options.data.port=port;return port},"transport=",{type:"literal",value:"transport=",description:'"transport="'},"udp",{type:"literal",value:"udp",description:'"udp"'},"tcp",{type:"literal",value:"tcp",description:'"tcp"'},"sctp",{type:"literal",value:"sctp",description:'"sctp"'},"tls",{type:"literal",value:"tls",description:'"tls"'},function(transport){if(!options.data.uri_params)options.data.uri_params={};options.data.uri_params["transport"]=transport.toLowerCase()},"user=",{type:"literal",value:"user=",description:'"user="'},"phone",{type:"literal",value:"phone",description:'"phone"'},"ip",{type:"literal",value:"ip",description:'"ip"'},function(user){if(!options.data.uri_params)options.data.uri_params={};options.data.uri_params["user"]=user.toLowerCase()},"method=",{type:"literal",value:"method=",description:'"method="'},function(method){if(!options.data.uri_params)options.data.uri_params={};options.data.uri_params["method"]=method},"ttl=",{type:"literal",value:"ttl=",description:'"ttl="'},function(ttl){if(!options.data.params)options.data.params={};options.data.params["ttl"]=ttl},"maddr=",{type:"literal",value:"maddr=",description:'"maddr="'},function(maddr){if(!options.data.uri_params)options.data.uri_params={};options.data.uri_params["maddr"]=maddr},"lr",{type:"literal",value:"lr",description:'"lr"'},function(){if(!options.data.uri_params)options.data.uri_params={};options.data.uri_params["lr"]=undefined},function(param,value){if(!options.data.uri_params)options.data.uri_params={};if(value===null){value=undefined}else{value=value[1]}options.data.uri_params[param.toLowerCase()]=value&&value.toLowerCase()},function(hname,hvalue){hname=hname.join("").toLowerCase();hvalue=hvalue.join("");if(!options.data.uri_headers)options.data.uri_headers={};if(!options.data.uri_headers[hname]){options.data.uri_headers[hname]=[hvalue]}else{options.data.uri_headers[hname].push(hvalue)}},function(){if(options.startRule==="Refer_To"){options.data.uri=new options.SIP.URI(options.data.scheme,options.data.user,options.data.host,options.data.port,options.data.uri_params,options.data.uri_headers);delete options.data.scheme;delete options.data.user;delete options.data.host;delete options.data.host_type;delete options.data.port;delete options.data.uri_params}},"//",{type:"literal",value:"//",description:'"//"'},function(){options.data.scheme=text()},{type:"literal",value:"SIP",description:'"SIP"'},function(){options.data.sip_version=text()},"INVITE",{type:"literal",value:"INVITE",description:'"INVITE"'},"ACK",{type:"literal",value:"ACK",description:'"ACK"'},"VXACH",{type:"literal",value:"VXACH",description:'"VXACH"'},"OPTIONS",{type:"literal",value:"OPTIONS",description:'"OPTIONS"'},"BYE",{type:"literal",value:"BYE",description:'"BYE"'},"CANCEL",{type:"literal",value:"CANCEL",description:'"CANCEL"'},"REGISTER",{type:"literal",value:"REGISTER",description:'"REGISTER"'},"SUBSCRIBE",{type:"literal",value:"SUBSCRIBE",description:'"SUBSCRIBE"'},"NOTIFY",{type:"literal",value:"NOTIFY",description:'"NOTIFY"'},"REFER",{type:"literal",value:"REFER",description:'"REFER"'},function(){options.data.method=text();return options.data.method},function(status_code){options.data.status_code=parseInt(status_code.join(""))},function(){options.data.reason_phrase=text()},function(){options.data=text()},function(){var idx,length;length=options.data.multi_header.length;for(idx=0;idx<length;idx++){if(options.data.multi_header[idx].parsed===null){options.data=null;break}}if(options.data!==null){options.data=options.data.multi_header}else{options.data=-1}},function(){var header;if(!options.data.multi_header)options.data.multi_header=[];try{header=new options.SIP.NameAddrHeader(options.data.uri,options.data.displayName,options.data.params);delete options.data.uri;delete options.data.displayName;delete options.data.params}catch(e){header=null}options.data.multi_header.push({position:peg$currPos,offset:offset(),parsed:header})},function(displayName){displayName=text().trim();if(displayName[0]==='"'){displayName=displayName.substring(1,displayName.length-1)}options.data.displayName=displayName},"q",{type:"literal",value:"q",description:'"q"'},function(q){if(!options.data.params)options.data.params={};options.data.params["q"]=q},"expires",{type:"literal",value:"expires",description:'"expires"'},function(expires){if(!options.data.params)options.data.params={};options.data.params["expires"]=expires},function(delta_seconds){return parseInt(delta_seconds.join(""))},"0",{type:"literal",value:"0",description:'"0"'},function(){return parseFloat(text())},function(param,value){if(!options.data.params)options.data.params={};if(value===null){value=undefined}else{value=value[1]}options.data.params[param.toLowerCase()]=value},"render",{type:"literal",value:"render",description:'"render"'},"session",{type:"literal",value:"session",description:'"session"'},"icon",{type:"literal",value:"icon",description:'"icon"'},"alert",{type:"literal",value:"alert",description:'"alert"'},function(){if(options.startRule==="Content_Disposition"){options.data.type=text().toLowerCase()}},"handling",{type:"literal",value:"handling",description:'"handling"'},"optional",{type:"literal",value:"optional",description:'"optional"'},"required",{type:"literal",value:"required",description:'"required"'},function(length){options.data=parseInt(length.join(""))},function(){options.data=text()},"text",{type:"literal",value:"text",description:'"text"'},"image",{type:"literal",value:"image",description:'"image"'},"audio",{type:"literal",value:"audio",description:'"audio"'},"video",{type:"literal",value:"video",description:'"video"'},"application",{type:"literal",value:"application",description:'"application"'},"message",{type:"literal",value:"message",description:'"message"'},"multipart",{type:"literal",value:"multipart",description:'"multipart"'},"x-",{type:"literal",value:"x-",description:'"x-"'},function(cseq_value){options.data.value=parseInt(cseq_value.join(""))},function(expires){options.data=expires},function(event_type){options.data.event=event_type.toLowerCase()},function(){var tag=options.data.tag;options.data=new options.SIP.NameAddrHeader(options.data.uri,options.data.displayName,options.data.params);if(tag){options.data.setParam("tag",tag)}},"tag",{type:"literal",value:"tag",description:'"tag"'},function(tag){options.data.tag=tag},function(forwards){options.data=parseInt(forwards.join(""))},function(min_expires){options.data=min_expires},function(){options.data=new options.SIP.NameAddrHeader(options.data.uri,options.data.displayName,options.data.params)},"digest",{type:"literal",value:"Digest",description:'"Digest"'},"realm",{type:"literal",value:"realm",description:'"realm"'},function(realm){options.data.realm=realm},"domain",{type:"literal",value:"domain",description:'"domain"'},"nonce",{type:"literal",value:"nonce",description:'"nonce"'},function(nonce){options.data.nonce=nonce},"opaque",{type:"literal",value:"opaque",description:'"opaque"'},function(opaque){options.data.opaque=opaque},"stale",{type:"literal",value:"stale",description:'"stale"'},"true",{type:"literal",value:"true",description:'"true"'},function(){options.data.stale=true},"false",{type:"literal",value:"false",description:'"false"'},function(){options.data.stale=false},"algorithm",{type:"literal",value:"algorithm",description:'"algorithm"'},"md5",{type:"literal",value:"MD5",description:'"MD5"'},"md5-sess",{type:"literal",value:"MD5-sess",description:'"MD5-sess"'},function(algorithm){options.data.algorithm=algorithm.toUpperCase()},"qop",{type:"literal",value:"qop",description:'"qop"'},"auth-int",{type:"literal",value:"auth-int",description:'"auth-int"'},"auth",{type:"literal",value:"auth",description:'"auth"'},function(qop_value){options.data.qop||(options.data.qop=[]);options.data.qop.push(qop_value.toLowerCase())},function(rack_value){options.data.value=parseInt(rack_value.join(""))},function(){var idx,length;length=options.data.multi_header.length;for(idx=0;idx<length;idx++){if(options.data.multi_header[idx].parsed===null){options.data=null;break}}if(options.data!==null){options.data=options.data.multi_header}else{options.data=-1}},function(){var header;if(!options.data.multi_header)options.data.multi_header=[];try{header=new options.SIP.NameAddrHeader(options.data.uri,options.data.displayName,options.data.params);delete options.data.uri;delete options.data.displayName;delete options.data.params}catch(e){header=null}options.data.multi_header.push({position:peg$currPos,offset:offset(),parsed:header})},function(){options.data=new options.SIP.NameAddrHeader(options.data.uri,options.data.displayName,options.data.params)},function(){if(!(options.data.replaces_from_tag&&options.data.replaces_to_tag)){options.data=-1}},function(){options.data={call_id:options.data}},"from-tag",{type:"literal",value:"from-tag",description:'"from-tag"'},function(from_tag){options.data.replaces_from_tag=from_tag},"to-tag",{type:"literal",value:"to-tag",description:'"to-tag"'},function(to_tag){options.data.replaces_to_tag=to_tag},"early-only",{type:"literal",value:"early-only",description:'"early-only"'},function(){options.data.early_only=true},function(r){return r},function(first,rest){return list(first,rest)},function(value){if(options.startRule==="Require"){options.data=value||[]}},function(rseq_value){options.data.value=parseInt(rseq_value.join(""))},"active",{type:"literal",value:"active",description:'"active"'},"pending",{type:"literal",value:"pending",description:'"pending"'},"terminated",{type:"literal",value:"terminated",description:'"terminated"'},function(){options.data.state=text()},"reason",{type:"literal",value:"reason",description:'"reason"'},function(reason){if(typeof reason!=="undefined")options.data.reason=reason},function(expires){if(typeof expires!=="undefined")options.data.expires=expires},"retry_after",{type:"literal",value:"retry_after",description:'"retry_after"'},function(retry_after){if(typeof retry_after!=="undefined")options.data.retry_after=retry_after},"deactivated",{type:"literal",value:"deactivated",description:'"deactivated"'},"probation",{type:"literal",value:"probation",description:'"probation"'},"rejected",{type:"literal",value:"rejected",description:'"rejected"'},"timeout",{type:"literal",value:"timeout",description:'"timeout"'},"giveup",{type:"literal",value:"giveup",description:'"giveup"'},"noresource",{type:"literal",value:"noresource",description:'"noresource"'},"invariant",{type:"literal",value:"invariant",description:'"invariant"'},function(value){if(options.startRule==="Supported"){options.data=value||[]}},function(){var tag=options.data.tag;options.data=new options.SIP.NameAddrHeader(options.data.uri,options.data.displayName,options.data.params);if(tag){options.data.setParam("tag",tag)}},"ttl",{type:"literal",value:"ttl",description:'"ttl"'},function(via_ttl_value){options.data.ttl=via_ttl_value},"maddr",{type:"literal",value:"maddr",description:'"maddr"'},function(via_maddr){options.data.maddr=via_maddr},"received",{type:"literal",value:"received",description:'"received"'},function(via_received){options.data.received=via_received},"branch",{type:"literal",value:"branch",description:'"branch"'},function(via_branch){options.data.branch=via_branch},"rport",{type:"literal",value:"rport",description:'"rport"'},function(){if(typeof response_port!=="undefined")options.data.rport=response_port.join("")},function(via_protocol){options.data.protocol=via_protocol},{type:"literal",value:"UDP",description:'"UDP"'},{type:"literal",value:"TCP",description:'"TCP"'},{type:"literal",value:"TLS",description:'"TLS"'},{type:"literal",value:"SCTP",description:'"SCTP"'},function(via_transport){options.data.transport=via_transport},function(){options.data.host=text()},function(via_sent_by_port){options.data.port=parseInt(via_sent_by_port.join(""))},function(ttl){
        return parseInt(ttl.join(""))},function(deltaSeconds){if(options.startRule==="Session_Expires"){options.data.deltaSeconds=deltaSeconds}},"refresher",{type:"literal",value:"refresher",description:'"refresher"'},"uas",{type:"literal",value:"uas",description:'"uas"'},"uac",{type:"literal",value:"uac",description:'"uac"'},function(endpoint){if(options.startRule==="Session_Expires"){options.data.refresher=endpoint}},function(deltaSeconds){if(options.startRule==="Min_SE"){options.data=deltaSeconds}},"stuns",{type:"literal",value:"stuns",description:'"stuns"'},"stun",{type:"literal",value:"stun",description:'"stun"'},function(scheme){options.data.scheme=scheme},function(host){options.data.host=host},"?transport=",{type:"literal",value:"?transport=",description:'"?transport="'},"turns",{type:"literal",value:"turns",description:'"turns"'},"turn",{type:"literal",value:"turn",description:'"turn"'},function(){options.data.transport=transport},function(){options.data=text()}],peg$bytecode=[peg$decode('. ""2 3!'),peg$decode('0"""1!3#'),peg$decode('0$""1!3%'),peg$decode('0&""1!3\''),peg$decode("7'*# \"7("),peg$decode('0(""1!3)'),peg$decode('0*""1!3+'),peg$decode('.,""2,3-'),peg$decode('..""2.3/'),peg$decode('00""1!31'),peg$decode('.2""2233*\x89 ".4""2435*} ".6""2637*q ".8""2839*e ".:""2:3;*Y ".<""2<3=*M ".>""2>3?*A ".@""2@3A*5 ".B""2B3C*) ".D""2D3E'),peg$decode('7)*# "7,'),peg$decode('.F""2F3G*} ".H""2H3I*q ".J""2J3K*e ".L""2L3M*Y ".N""2N3O*M ".P""2P3Q*A ".R""2R3S*5 ".T""2T3U*) ".V""2V3W'),peg$decode('!!.Y""2Y3Z+7$7#+-%7#+#%\'#%$## X$"# X"# X+! (%'),peg$decode('!! \\7$,#&7$"+-$7 +#%\'"%$"# X"# X*# " [+@$ \\7$+&$,#&7$""" X+\'%4"6]" %$"# X"# X'),peg$decode('7.*# " ['),peg$decode('! \\7\'*# "7(,)&7\'*# "7("+A$.8""2839+1%7/+\'%4#6^# %$## X$"# X"# X'),peg$decode('!! \\72+&$,#&72""" X+o$ \\! \\7.,#&7."+-$72+#%\'"%$"# X"# X,@&! \\7.,#&7."+-$72+#%\'"%$"# X"# X"+#%\'"%$"# X"# X+! (%'),peg$decode('0_""1!3`*# "73'),peg$decode('0a""1!3b'),peg$decode('0c""1!3d'),peg$decode('7!*) "0e""1!3f'),peg$decode('! \\7)*\x95 ".F""2F3G*\x89 ".J""2J3K*} ".L""2L3M*q ".Y""2Y3Z*e ".P""2P3Q*Y ".H""2H3I*M ".@""2@3A*A ".g""2g3h*5 ".R""2R3S*) ".N""2N3O+\x9e$,\x9b&7)*\x95 ".F""2F3G*\x89 ".J""2J3K*} ".L""2L3M*q ".Y""2Y3Z*e ".P""2P3Q*Y ".H""2H3I*M ".@""2@3A*A ".g""2g3h*5 ".R""2R3S*) ".N""2N3O""" X+! (%'),peg$decode('! \\7)*\x89 ".F""2F3G*} ".L""2L3M*q ".Y""2Y3Z*e ".P""2P3Q*Y ".H""2H3I*M ".@""2@3A*A ".g""2g3h*5 ".R""2R3S*) ".N""2N3O+\x92$,\x8f&7)*\x89 ".F""2F3G*} ".L""2L3M*q ".Y""2Y3Z*e ".P""2P3Q*Y ".H""2H3I*M ".@""2@3A*A ".g""2g3h*5 ".R""2R3S*) ".N""2N3O""" X+! (%'),peg$decode('.T""2T3U*\xe3 ".V""2V3W*\xd7 ".i""2i3j*\xcb ".k""2k3l*\xbf ".:""2:3;*\xb3 ".D""2D3E*\xa7 ".2""2233*\x9b ".8""2839*\x8f ".m""2m3n*\x83 "7&*} ".4""2435*q ".o""2o3p*e ".q""2q3r*Y ".6""2637*M ".>""2>3?*A ".s""2s3t*5 ".u""2u3v*) "7\'*# "7('),peg$decode('! \\7)*\u012b ".F""2F3G*\u011f ".J""2J3K*\u0113 ".L""2L3M*\u0107 ".Y""2Y3Z*\xfb ".P""2P3Q*\xef ".H""2H3I*\xe3 ".@""2@3A*\xd7 ".g""2g3h*\xcb ".R""2R3S*\xbf ".N""2N3O*\xb3 ".T""2T3U*\xa7 ".V""2V3W*\x9b ".i""2i3j*\x8f ".k""2k3l*\x83 ".8""2839*w ".m""2m3n*k "7&*e ".4""2435*Y ".o""2o3p*M ".q""2q3r*A ".6""2637*5 ".s""2s3t*) ".u""2u3v+\u0134$,\u0131&7)*\u012b ".F""2F3G*\u011f ".J""2J3K*\u0113 ".L""2L3M*\u0107 ".Y""2Y3Z*\xfb ".P""2P3Q*\xef ".H""2H3I*\xe3 ".@""2@3A*\xd7 ".g""2g3h*\xcb ".R""2R3S*\xbf ".N""2N3O*\xb3 ".T""2T3U*\xa7 ".V""2V3W*\x9b ".i""2i3j*\x8f ".k""2k3l*\x83 ".8""2839*w ".m""2m3n*k "7&*e ".4""2435*Y ".o""2o3p*M ".q""2q3r*A ".6""2637*5 ".s""2s3t*) ".u""2u3v""" X+! (%'),peg$decode('!7/+A$.P""2P3Q+1%7/+\'%4#6w# %$## X$"# X"# X'),peg$decode('!7/+A$.4""2435+1%7/+\'%4#6x# %$## X$"# X"# X'),peg$decode('!7/+A$.>""2>3?+1%7/+\'%4#6y# %$## X$"# X"# X'),peg$decode('!7/+A$.T""2T3U+1%7/+\'%4#6z# %$## X$"# X"# X'),peg$decode('!7/+A$.V""2V3W+1%7/+\'%4#6{# %$## X$"# X"# X'),peg$decode('!.k""2k3l+1$7/+\'%4"6|" %$"# X"# X'),peg$decode('!7/+7$.i""2i3j+\'%4"6}" %$"# X"# X'),peg$decode('!7/+A$.D""2D3E+1%7/+\'%4#6~# %$## X$"# X"# X'),peg$decode('!7/+A$.2""2233+1%7/+\'%4#6\x7f# %$## X$"# X"# X'),peg$decode('!7/+A$.8""2839+1%7/+\'%4#6\x80# %$## X$"# X"# X'),peg$decode('!7/+1$7&+\'%4"6\x81" %$"# X"# X'),peg$decode('!7&+1$7/+\'%4"6\x81" %$"# X"# X'),peg$decode('!7=+W$ \\7G*) "7K*# "7F,/&7G*) "7K*# "7F"+-%7>+#%\'#%$## X$"# X"# X'),peg$decode('0\x82""1!3\x83*A "0\x84""1!3\x85*5 "0\x86""1!3\x87*) "73*# "7.'),peg$decode('!!7/+U$7&+K% \\7J*# "7K,)&7J*# "7K"+-%7&+#%\'$%$$# X$## X$"# X"# X+! (%'),peg$decode('!7/+`$7&+V%! \\7J*# "7K,)&7J*# "7K"+! (%+2%7&+(%4$6\x88$!!%$$# X$## X$"# X"# X'),peg$decode('7.*G ".L""2L3M*; "0\x89""1!3\x8a*/ "0\x86""1!3\x87*# "73'),peg$decode('!.m""2m3n+K$0\x8b""1!3\x8c*5 "0\x8d""1!3\x8e*) "0\x8f""1!3\x90+#%\'"%$"# X"# X'),peg$decode('!7N+Q$.8""2839+A%7O*# " [+1%7S+\'%4$6\x91$ %$$# X$## X$"# X"# X'),peg$decode('!7N+k$.8""2839+[%7O*# " [+K%7S+A%7_+7%7l*# " [+\'%4&6\x92& %$&# X$%# X$$# X$## X$"# X"# X'),peg$decode('!/\x93""1$3\x94*) "/\x95""1#3\x96+\' 4!6\x97!! %'),peg$decode('!7P+b$!.8""2839+-$7R+#%\'"%$"# X"# X*# " [+7%.:""2:3;+\'%4#6\x98# %$## X$"# X"# X'),peg$decode(' \\7+*) "7-*# "7Q+2$,/&7+*) "7-*# "7Q""" X'),peg$decode('.<""2<3=*q ".>""2>3?*e ".@""2@3A*Y ".B""2B3C*M ".D""2D3E*A ".2""2233*5 ".6""2637*) ".4""2435'),peg$decode('! \\7+*_ "7-*Y ".<""2<3=*M ".>""2>3?*A ".@""2@3A*5 ".B""2B3C*) ".D""2D3E,e&7+*_ "7-*Y ".<""2<3=*M ".>""2>3?*A ".@""2@3A*5 ".B""2B3C*) ".D""2D3E"+& 4!6\x99! %'),peg$decode('!7T+N$!.8""2839+-$7^+#%\'"%$"# X"# X*# " [+#%\'"%$"# X"# X'),peg$decode('!7U*) "7\\*# "7X+& 4!6\x9a! %'),peg$decode('! \\!7V+3$.J""2J3K+#%\'"%$"# X"# X,>&!7V+3$.J""2J3K+#%\'"%$"# X"# X"+G$7W+=%.J""2J3K*# " [+\'%4#6\x9b# %$## X$"# X"# X'),peg$decode(' \\0\x9c""1!3\x9d+,$,)&0\x9c""1!3\x9d""" X'),peg$decode('!0$""1!3%+A$ \\0\x9e""1!3\x9f,)&0\x9e""1!3\x9f"+#%\'"%$"# X"# X'),peg$decode('!.o""2o3p+A$7Y+7%.q""2q3r+\'%4#6\xa0# %$## X$"# X"# X'),peg$decode('!!7Z+\xbf$.8""2839+\xaf%7Z+\xa5%.8""2839+\x95%7Z+\x8b%.8""2839+{%7Z+q%.8""2839+a%7Z+W%.8""2839+G%7Z+=%.8""2839+-%7[+#%\'-%$-# X$,# X$+# X$*# X$)# X$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u0838 "!.\xa1""2\xa13\xa2+\xaf$7Z+\xa5%.8""2839+\x95%7Z+\x8b%.8""2839+{%7Z+q%.8""2839+a%7Z+W%.8""2839+G%7Z+=%.8""2839+-%7[+#%\',%$,# X$+# X$*# X$)# X$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u0795 "!.\xa1""2\xa13\xa2+\x95$7Z+\x8b%.8""2839+{%7Z+q%.8""2839+a%7Z+W%.8""2839+G%7Z+=%.8""2839+-%7[+#%\'*%$*# X$)# X$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u070c "!.\xa1""2\xa13\xa2+{$7Z+q%.8""2839+a%7Z+W%.8""2839+G%7Z+=%.8""2839+-%7[+#%\'(%$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u069d "!.\xa1""2\xa13\xa2+a$7Z+W%.8""2839+G%7Z+=%.8""2839+-%7[+#%\'&%$&# X$%# X$$# X$## X$"# X"# X*\u0648 "!.\xa1""2\xa13\xa2+G$7Z+=%.8""2839+-%7[+#%\'$%$$# X$## X$"# X"# X*\u060d "!.\xa1""2\xa13\xa2+-$7[+#%\'"%$"# X"# X*\u05ec "!.\xa1""2\xa13\xa2+-$7Z+#%\'"%$"# X"# X*\u05cb "!7Z+\xa5$.\xa1""2\xa13\xa2+\x95%7Z+\x8b%.8""2839+{%7Z+q%.8""2839+a%7Z+W%.8""2839+G%7Z+=%.8""2839+-%7[+#%\'+%$+# X$*# X$)# X$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u0538 "!7Z+\xb6$!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\x8b%.\xa1""2\xa13\xa2+{%7Z+q%.8""2839+a%7Z+W%.8""2839+G%7Z+=%.8""2839+-%7[+#%\'*%$*# X$)# X$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u0494 "!7Z+\xc7$!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\x9c%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+q%.\xa1""2\xa13\xa2+a%7Z+W%.8""2839+G%7Z+=%.8""2839+-%7[+#%\')%$)# X$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u03df "!7Z+\xd8$!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\xad%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\x82%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+W%.\xa1""2\xa13\xa2+G%7Z+=%.8""2839+-%7[+#%\'(%$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u0319 "!7Z+\xe9$!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\xbe%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\x93%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+h%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+=%.\xa1""2\xa13\xa2+-%7[+#%\'\'%$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u0242 "!7Z+\u0114$!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\xe9%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\xbe%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\x93%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+h%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+=%.\xa1""2\xa13\xa2+-%7Z+#%\'(%$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X*\u0140 "!7Z+\u0135$!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\u010a%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\xdf%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\xb4%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+\x89%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+^%!.8""2839+-$7Z+#%\'"%$"# X"# X*# " [+3%.\xa1""2\xa13\xa2+#%\'(%$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X+& 4!6\xa3! %'),peg$decode('!7#+S$7#*# " [+C%7#*# " [+3%7#*# " [+#%\'$%$$# X$## X$"# X"# X'),peg$decode('!7Z+=$.8""2839+-%7Z+#%\'#%$## X$"# X"# X*# "7\\'),peg$decode('!7]+u$.J""2J3K+e%7]+[%.J""2J3K+K%7]+A%.J""2J3K+1%7]+\'%4\'6\xa4\' %$\'# X$&# X$%# X$$# X$## X$"# X"# X'),peg$decode('!.\xa5""2\xa53\xa6+3$0\xa7""1!3\xa8+#%\'"%$"# X"# X*\xa0 "!.\xa9""2\xa93\xaa+=$0\xab""1!3\xac+-%7!+#%\'#%$## X$"# X"# X*o "!.\xad""2\xad3\xae+7$7!+-%7!+#%\'#%$## X$"# X"# X*D "!0\xaf""1!3\xb0+-$7!+#%\'"%$"# X"# X*# "7!'),peg$decode('!!7!*# " [+c$7!*# " [+S%7!*# " [+C%7!*# " [+3%7!*# " [+#%\'%%$%# X$$# X$## X$"# X"# X+\' 4!6\xb1!! %'),peg$decode(' \\!.2""2233+-$7`+#%\'"%$"# X"# X,>&!.2""2233+-$7`+#%\'"%$"# X"# X"'),peg$decode('7a*A "7b*; "7c*5 "7d*/ "7e*) "7f*# "7g'),peg$decode('!/\xb2""1*3\xb3+b$/\xb4""1#3\xb5*G "/\xb6""1#3\xb7*; "/\xb8""1$3\xb9*/ "/\xba""1#3\xbb*# "76+(%4"6\xbc"! %$"# X"# X'),peg$decode('!/\xbd""1%3\xbe+J$/\xbf""1%3\xc0*/ "/\xc1""1"3\xc2*# "76+(%4"6\xc3"! %$"# X"# X'),peg$decode('!/\xc4""1\'3\xc5+2$7\x8f+(%4"6\xc6"! %$"# X"# X'),peg$decode('!/\xc7""1$3\xc8+2$7\xef+(%4"6\xc9"! %$"# X"# X'),peg$decode('!/\xca""1&3\xcb+2$7T+(%4"6\xcc"! %$"# X"# X'),peg$decode('!/\xcd""1"3\xce+R$!.>""2>3?+-$76+#%\'"%$"# X"# X*# " [+\'%4"6\xcf" %$"# X"# X'),peg$decode('!7h+T$!.>""2>3?+-$7i+#%\'"%$"# X"# X*# " [+)%4"6\xd0""! %$"# X"# X'),peg$decode('! \\7j+&$,#&7j""" X+! (%'),peg$decode('! \\7j+&$,#&7j""" X+! (%'),peg$decode('7k*) "7+*# "7-'),peg$decode('.o""2o3p*e ".q""2q3r*Y ".4""2435*M ".8""2839*A ".<""2<3=*5 ".@""2@3A*) ".B""2B3C'),peg$decode('!.6""2637+u$7m+k% \\!.<""2<3=+-$7m+#%\'"%$"# X"# X,>&!.<""2<3=+-$7m+#%\'"%$"# X"# X"+#%\'#%$## X$"# X"# X'),peg$decode('!7n+C$.>""2>3?+3%7o+)%4#6\xd1#"" %$## X$"# X"# X'),peg$decode(' \\7p*) "7+*# "7-+2$,/&7p*) "7+*# "7-""" X'),peg$decode(' \\7p*) "7+*# "7-,/&7p*) "7+*# "7-"'),peg$decode('.o""2o3p*e ".q""2q3r*Y ".4""2435*M ".6""2637*A ".8""2839*5 ".@""2@3A*) ".B""2B3C'),peg$decode('7\x90*# "7r'),peg$decode("!7\x8f+K$7'+A%7s+7%7'+-%7\x84+#%'%%$%# X$$# X$## X$\"# X\"# X"),peg$decode('7M*# "7t'),peg$decode('!7\x7f+G$.8""2839+7%7u*# "7x+\'%4#6\xd2# %$## X$"# X"# X'),peg$decode('!7v*# "7w+N$!.6""2637+-$7\x83+#%\'"%$"# X"# X*# " [+#%\'"%$"# X"# X'),peg$decode('!.\xd3""2\xd33\xd4+=$7\x80+3%7w*# " [+#%\'#%$## X$"# X"# X'),peg$decode('!.4""2435+-$7{+#%\'"%$"# X"# X'),peg$decode('!7z+5$ \\7y,#&7y"+#%\'"%$"# X"# X'),peg$decode('7**) "7+*# "7-'),peg$decode('7+*\x8f "7-*\x89 ".2""2233*} ".6""2637*q ".8""2839*e ".:""2:3;*Y ".<""2<3=*M ".>""2>3?*A ".@""2@3A*5 ".B""2B3C*) ".D""2D3E'),peg$decode('!7|+k$ \\!.4""2435+-$7|+#%\'"%$"# X"# X,>&!.4""2435+-$7|+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('! \\7~,#&7~"+k$ \\!.2""2233+-$7}+#%\'"%$"# X"# X,>&!.2""2233+-$7}+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode(' \\7~,#&7~"'),peg$decode('7+*w "7-*q ".8""2839*e ".:""2:3;*Y ".<""2<3=*M ".>""2>3?*A ".@""2@3A*5 ".B""2B3C*) ".D""2D3E'),peg$decode('!7"+\x8d$ \\7"*G "7!*A ".@""2@3A*5 ".F""2F3G*) ".J""2J3K,M&7"*G "7!*A ".@""2@3A*5 ".F""2F3G*) ".J""2J3K"+\'%4"6\xd5" %$"# X"# X'),peg$decode('7\x81*# "7\x82'),peg$decode('!!7O+3$.:""2:3;+#%\'"%$"# X"# X*# " [+-$7S+#%\'"%$"# X"# X*# " ['),peg$decode(' \\7+*\x83 "7-*} ".B""2B3C*q ".D""2D3E*e ".2""2233*Y ".8""2839*M ".:""2:3;*A ".<""2<3=*5 ".>""2>3?*) ".@""2@3A+\x8c$,\x89&7+*\x83 "7-*} ".B""2B3C*q ".D""2D3E*e ".2""2233*Y ".8""2839*M ".:""2:3;*A ".<""2<3=*5 ".>""2>3?*) ".@""2@3A""" X'),peg$decode(' \\7y,#&7y"'),peg$decode('!/\x95""1#3\xd6+y$.4""2435+i% \\7!+&$,#&7!""" X+P%.J""2J3K+@% \\7!+&$,#&7!""" X+\'%4%6\xd7% %$%# X$$# X$## X$"# X"# X'),peg$decode('.\xd8""2\xd83\xd9'),peg$decode('.\xda""2\xda3\xdb'),peg$decode('.\xdc""2\xdc3\xdd'),peg$decode('.\xde""2\xde3\xdf'),peg$decode('.\xe0""2\xe03\xe1'),peg$decode('.\xe2""2\xe23\xe3'),peg$decode('.\xe4""2\xe43\xe5'),peg$decode('.\xe6""2\xe63\xe7'),peg$decode('.\xe8""2\xe83\xe9'),peg$decode('.\xea""2\xea3\xeb'),peg$decode('!7\x85*S "7\x86*M "7\x88*G "7\x89*A "7\x8a*; "7\x8b*5 "7\x8c*/ "7\x8d*) "7\x8e*# "76+& 4!6\xec! %'),peg$decode("!7\x84+K$7'+A%7\x91+7%7'+-%7\x93+#%'%%$%# X$$# X$## X$\"# X\"# X"),peg$decode("!7\x92+' 4!6\xed!! %"),peg$decode('!7!+7$7!+-%7!+#%\'#%$## X$"# X"# X'),peg$decode('! \\7**A "7+*; "7-*5 "73*/ "74*) "7\'*# "7(,G&7**A "7+*; "7-*5 "73*/ "74*) "7\'*# "7("+& 4!6\xee! %'),peg$decode('!7\xb5+_$ \\!7A+-$7\xb5+#%\'"%$"# X"# X,8&!7A+-$7\xb5+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('!79+R$!.:""2:3;+-$79+#%\'"%$"# X"# X*# " [+\'%4"6\xef" %$"# X"# X'),peg$decode('!7:*j "!7\x97+_$ \\!7A+-$7\x97+#%\'"%$"# X"# X,8&!7A+-$7\x97+#%\'"%$"# X"# X"+#%\'"%$"# X"# X+& 4!6\xf0! %'),peg$decode('!7L*# "7\x98+c$ \\!7B+-$7\x9a+#%\'"%$"# X"# X,8&!7B+-$7\x9a+#%\'"%$"# X"# X"+\'%4"6\xf1" %$"# X"# X'),peg$decode('!7\x99*# " [+A$7@+7%7M+-%7?+#%\'$%$$# X$## X$"# X"# X'),peg$decode('!!76+_$ \\!7.+-$76+#%\'"%$"# X"# X,8&!7.+-$76+#%\'"%$"# X"# X"+#%\'"%$"# X"# X*# "7H+\' 4!6\xf2!! %'),peg$decode('7\x9b*) "7\x9c*# "7\x9f'),peg$decode('!/\xf3""1!3\xf4+<$7<+2%7\x9e+(%4#6\xf5#! %$## X$"# X"# X'),peg$decode('!/\xf6""1\'3\xf7+<$7<+2%7\x9d+(%4#6\xf8#! %$## X$"# X"# X'),peg$decode('! \\7!+&$,#&7!""" X+\' 4!6\xf9!! %'),peg$decode('!.\xfa""2\xfa3\xfb+x$!.J""2J3K+S$7!*# " [+C%7!*# " [+3%7!*# " [+#%\'$%$$# X$## X$"# X"# X*# " [+\'%4"6\xfc" %$"# X"# X'),peg$decode('!76+N$!7<+-$7\xa0+#%\'"%$"# X"# X*# " [+)%4"6\xfd""! %$"# X"# X'),peg$decode('76*) "7T*# "7H'),peg$decode('!7\xa2+_$ \\!7B+-$7\xa3+#%\'"%$"# X"# X,8&!7B+-$7\xa3+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('!/\xfe""1&3\xff*G "/\u0100""1\'3\u0101*; "/\u0102""1$3\u0103*/ "/\u0104""1%3\u0105*# "76+& 4!6\u0106! %'),peg$decode('7\xa4*# "7\x9f'),peg$decode('!/\u0107""1(3\u0108+O$7<+E%/\u0109""1(3\u010a*/ "/\u010b""1(3\u010c*# "76+#%\'#%$## X$"# X"# X'),peg$decode('!76+_$ \\!7A+-$76+#%\'"%$"# X"# X,8&!7A+-$76+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('! \\7!+&$,#&7!""" X+\' 4!6\u010d!! %'),peg$decode("!7\xa8+& 4!6\u010e! %"),peg$decode('!7\xa9+s$7;+i%7\xae+_% \\!7B+-$7\xaf+#%\'"%$"# X"# X,8&!7B+-$7\xaf+#%\'"%$"# X"# X"+#%\'$%$$# X$## X$"# X"# X'),peg$decode('7\xaa*# "7\xab'),peg$decode('/\u010f""1$3\u0110*S "/\u0111""1%3\u0112*G "/\u0113""1%3\u0114*; "/\u0115""1%3\u0116*/ "/\u0117""1+3\u0118*# "7\xac'),peg$decode('/\u0119""1\'3\u011a*/ "/\u011b""1)3\u011c*# "7\xac'),peg$decode('76*# "7\xad'),peg$decode('!/\u011d""1"3\u011e+-$76+#%\'"%$"# X"# X'),peg$decode('7\xac*# "76'),peg$decode('!76+7$7<+-%7\xb0+#%\'#%$## X$"# X"# X'),peg$decode('76*# "7H'),peg$decode('!7\xb2+7$7.+-%7\x8f+#%\'#%$## X$"# X"# X'),peg$decode('! \\7!+&$,#&7!""" X+\' 4!6\u011f!! %'),peg$decode("!7\x9d+' 4!6\u0120!! %"),peg$decode('!7\xb5+d$ \\!7B+-$7\x9f+#%\'"%$"# X"# X,8&!7B+-$7\x9f+#%\'"%$"# X"# X"+(%4"6\u0121"!!%$"# X"# X'),peg$decode('!!77+k$ \\!.J""2J3K+-$77+#%\'"%$"# X"# X,>&!.J""2J3K+-$77+#%\'"%$"# X"# X"+#%\'"%$"# X"# X+! (%'),peg$decode('!7L*# "7\x98+c$ \\!7B+-$7\xb7+#%\'"%$"# X"# X,8&!7B+-$7\xb7+#%\'"%$"# X"# X"+\'%4"6\u0122" %$"# X"# X'),peg$decode('7\xb8*# "7\x9f'),peg$decode('!/\u0123""1#3\u0124+<$7<+2%76+(%4#6\u0125#! %$## X$"# X"# X'),peg$decode('! \\7!+&$,#&7!""" X+\' 4!6\u0126!! %'),peg$decode("!7\x9d+' 4!6\u0127!! %"),peg$decode('! \\7\x99,#&7\x99"+\x81$7@+w%7M+m%7?+c% \\!7B+-$7\x9f+#%\'"%$"# X"# X,8&!7B+-$7\x9f+#%\'"%$"# X"# X"+\'%4%6\u0128% %$%# X$$# X$## X$"# X"# X'),peg$decode("7\xbd"),peg$decode('!/\u0129""1&3\u012a+s$7.+i%7\xc0+_% \\!7A+-$7\xc0+#%\'"%$"# X"# X,8&!7A+-$7\xc0+#%\'"%$"# X"# X"+#%\'$%$$# X$## X$"# X"# X*# "7\xbe'),peg$decode('!76+s$7.+i%7\xbf+_% \\!7A+-$7\xbf+#%\'"%$"# X"# X,8&!7A+-$7\xbf+#%\'"%$"# X"# X"+#%\'$%$$# X$## X$"# X"# X'),peg$decode('!76+=$7<+3%76*# "7H+#%\'#%$## X$"# X"# X'),peg$decode('7\xc1*G "7\xc3*A "7\xc5*; "7\xc7*5 "7\xc8*/ "7\xc9*) "7\xca*# "7\xbf'),peg$decode('!/\u012b""1%3\u012c+7$7<+-%7\xc2+#%\'#%$## X$"# X"# X'),peg$decode("!7I+' 4!6\u012d!! %"),peg$decode('!/\u012e""1&3\u012f+\xa5$7<+\x9b%7D+\x91%7\xc4+\x87% \\! \\7\'+&$,#&7\'""" X+-$7\xc4+#%\'"%$"# X"# X,G&! \\7\'+&$,#&7\'""" X+-$7\xc4+#%\'"%$"# X"# X"+-%7E+#%\'&%$&# X$%# X$$# X$## X$"# X"# X'),peg$decode('7t*# "7w'),peg$decode('!/\u0130""1%3\u0131+7$7<+-%7\xc6+#%\'#%$## X$"# X"# X'),peg$decode("!7I+' 4!6\u0132!! %"),peg$decode('!/\u0133""1&3\u0134+<$7<+2%7I+(%4#6\u0135#! %$## X$"# X"# X'),peg$decode('!/\u0136""1%3\u0137+_$7<+U%!/\u0138""1$3\u0139+& 4!6\u013a! %*4 "!/\u013b""1%3\u013c+& 4!6\u013d! %+#%\'#%$## X$"# X"# X'),peg$decode('!/\u013e""1)3\u013f+T$7<+J%/\u0140""1#3\u0141*/ "/\u0142""1(3\u0143*# "76+(%4#6\u0144#! %$## X$"# X"# X'),peg$decode('!/\u0145""1#3\u0146+\x9e$7<+\x94%7D+\x8a%!7\xcb+k$ \\!.D""2D3E+-$7\xcb+#%\'"%$"# X"# X,>&!.D""2D3E+-$7\xcb+#%\'"%$"# X"# X"+#%\'"%$"# X"# X+-%7E+#%\'%%$%# X$$# X$## X$"# X"# X'),peg$decode('!/\u0147""1(3\u0148*/ "/\u0149""1$3\u014a*# "76+\' 4!6\u014b!! %'),peg$decode('!76+_$ \\!7A+-$76+#%\'"%$"# X"# X,8&!7A+-$76+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('!7\xce+K$7.+A%7\xce+7%7.+-%7\x8f+#%\'%%$%# X$$# X$## X$"# X"# X'),peg$decode('! \\7!+&$,#&7!""" X+\' 4!6\u014c!! %'),peg$decode('!7\xd0+c$ \\!7A+-$7\xd0+#%\'"%$"# X"# X,8&!7A+-$7\xd0+#%\'"%$"# X"# X"+\'%4"6\u014d" %$"# X"# X'),peg$decode('!7\x98+c$ \\!7B+-$7\x9f+#%\'"%$"# X"# X,8&!7B+-$7\x9f+#%\'"%$"# X"# X"+\'%4"6\u014e" %$"# X"# X'),peg$decode('!7L*T "7\x98*N "!7@*# " [+=$7t+3%7?*# " [+#%\'#%$## X$"# X"# X+c$ \\!7B+-$7\x9f+#%\'"%$"# X"# X,8&!7B+-$7\x9f+#%\'"%$"# X"# X"+\'%4"6\u014f" %$"# X"# X'),peg$decode('!7\xd3+c$ \\!7B+-$7\xd4+#%\'"%$"# X"# X,8&!7B+-$7\xd4+#%\'"%$"# X"# X"+\'%4"6\u0150" %$"# X"# X'),peg$decode("!7\x95+& 4!6\u0151! %"),peg$decode('!/\u0152""1(3\u0153+<$7<+2%76+(%4#6\u0154#! %$## X$"# X"# X*j "!/\u0155""1&3\u0156+<$7<+2%76+(%4#6\u0157#! %$## X$"# X"# X*: "!/\u0158""1*3\u0159+& 4!6\u015a! %*# "7\x9f'),peg$decode('!!76+o$ \\!7A+2$76+(%4"6\u015b"! %$"# X"# X,=&!7A+2$76+(%4"6\u015b"! %$"# X"# X"+)%4"6\u015c""! %$"# X"# X*# " [+\' 4!6\u015d!! %'),peg$decode('!7\xd7+_$ \\!7A+-$7\xd7+#%\'"%$"# X"# X,8&!7A+-$7\xd7+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('!7\x98+_$ \\!7B+-$7\x9f+#%\'"%$"# X"# X,8&!7B+-$7\x9f+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('! \\7!+&$,#&7!""" X+\' 4!6\u015e!! %'),peg$decode('!7\xda+_$ \\!7B+-$7\xdb+#%\'"%$"# X"# X,8&!7B+-$7\xdb+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('!/\u015f""1&3\u0160*; "/\u0161""1\'3\u0162*/ "/\u0163""1*3\u0164*# "76+& 4!6\u0165! %'),peg$decode('!/\u0166""1&3\u0167+<$7<+2%7\xdc+(%4#6\u0168#! %$## X$"# X"# X*\x83 "!/\xf6""1\'3\xf7+<$7<+2%7\x9d+(%4#6\u0169#! %$## X$"# X"# X*S "!/\u016a""1+3\u016b+<$7<+2%7\x9d+(%4#6\u016c#! %$## X$"# X"# X*# "7\x9f'),peg$decode('/\u016d""1+3\u016e*k "/\u016f""1)3\u0170*_ "/\u0171""1(3\u0172*S "/\u0173""1\'3\u0174*G "/\u0175""1&3\u0176*; "/\u0177""1*3\u0178*/ "/\u0179""1)3\u017a*# "76'),peg$decode('71*# " ['),peg$decode('!!76+o$ \\!7A+2$76+(%4"6\u015b"! %$"# X"# X,=&!7A+2$76+(%4"6\u015b"! %$"# X"# X"+)%4"6\u015c""! %$"# X"# X*# " [+\' 4!6\u017b!! %'),peg$decode('!7L*# "7\x98+c$ \\!7B+-$7\xe0+#%\'"%$"# X"# X,8&!7B+-$7\xe0+#%\'"%$"# X"# X"+\'%4"6\u017c" %$"# X"# X'),peg$decode('7\xb8*# "7\x9f'),peg$decode('!7\xe2+_$ \\!7A+-$7\xe2+#%\'"%$"# X"# X,8&!7A+-$7\xe2+#%\'"%$"# X"# X"+#%\'"%$"# X"# X'),peg$decode('!7\xe9+s$7.+i%7\xec+_% \\!7B+-$7\xe3+#%\'"%$"# X"# X,8&!7B+-$7\xe3+#%\'"%$"# X"# X"+#%\'$%$$# X$## X$"# X"# X'),peg$decode('7\xe4*; "7\xe5*5 "7\xe6*/ "7\xe7*) "7\xe8*# "7\x9f'),peg$decode('!/\u017d""1#3\u017e+<$7<+2%7\xef+(%4#6\u017f#! %$## X$"# X"# X'),peg$decode('!/\u0180""1%3\u0181+<$7<+2%7T+(%4#6\u0182#! %$## X$"# X"# X'),peg$decode('!/\u0183""1(3\u0184+B$7<+8%7\\*# "7Y+(%4#6\u0185#! %$## X$"# X"# X'),peg$decode('!/\u0186""1&3\u0187+<$7<+2%76+(%4#6\u0188#! %$## X$"# X"# X'),peg$decode('!/\u0189""1%3\u018a+T$!7<+5$ \\7!,#&7!"+#%\'"%$"# X"# X*# " [+\'%4"6\u018b" %$"# X"# X'),peg$decode('!7\xea+K$7;+A%76+7%7;+-%7\xeb+#%\'%%$%# X$$# X$## X$"# X"# X'),peg$decode('!/\x95""1#3\xd6*# "76+\' 4!6\u018c!! %'),peg$decode('!/\xb4""1#3\u018d*G "/\xb6""1#3\u018e*; "/\xba""1#3\u018f*/ "/\xb8""1$3\u0190*# "76+\' 4!6\u0191!! %'),peg$decode('!7\xed+H$!7C+-$7\xee+#%\'"%$"# X"# X*# " [+#%\'"%$"# X"# X'),peg$decode('!7U*) "7\\*# "7X+& 4!6\u0192! %'),peg$decode('!!7!*# " [+c$7!*# " [+S%7!*# " [+C%7!*# " [+3%7!*# " [+#%\'%%$%# X$$# X$## X$"# X"# X+\' 4!6\u0193!! %'),peg$decode('!!7!+C$7!*# " [+3%7!*# " [+#%\'#%$## X$"# X"# X+\' 4!6\u0194!! %'),peg$decode("7\xbd"),peg$decode('!7\x9d+d$ \\!7B+-$7\xf2+#%\'"%$"# X"# X,8&!7B+-$7\xf2+#%\'"%$"# X"# X"+(%4"6\u0195"!!%$"# X"# X'),peg$decode('7\xf3*# "7\x9f'),peg$decode('!.\u0196""2\u01963\u0197+N$7<+D%.\u0198""2\u01983\u0199*) ".\u019a""2\u019a3\u019b+(%4#6\u019c#! %$## X$"# X"# X'),peg$decode('!7\x9d+d$ \\!7B+-$7\x9f+#%\'"%$"# X"# X,8&!7B+-$7\x9f+#%\'"%$"# X"# X"+(%4"6\u019d"!!%$"# X"# X'),peg$decode('!76+7$70+-%7\xf6+#%\'#%$## X$"# X"# X'),peg$decode(' \\72*) "74*# "7.,/&72*) "74*# "7."'),peg$decode(' \\7%,#&7%"'),peg$decode('!7\xf9+=$.8""2839+-%7\xfa+#%\'#%$## X$"# X"# X'),peg$decode('!/\u019e""1%3\u019f*) "/\u01a0""1$3\u01a1+\' 4!6\u01a2!! %'),peg$decode('!7\xfb+N$!.8""2839+-$7^+#%\'"%$"# X"# X*# " [+#%\'"%$"# X"# X'),peg$decode('!7\\*) "7X*# "7\x82+\' 4!6\u01a3!! %'),peg$decode('! \\7\xfd*) "7-*# "7\xfe,/&7\xfd*) "7-*# "7\xfe"+! (%'),peg$decode('7"*S "7!*M ".F""2F3G*A ".J""2J3K*5 ".H""2H3I*) ".N""2N3O'),peg$decode('.L""2L3M*\x95 ".B""2B3C*\x89 ".<""2<3=*} ".R""2R3S*q ".T""2T3U*e ".V""2V3W*Y ".P""2P3Q*M ".@""2@3A*A ".D""2D3E*5 ".2""2233*) ".>""2>3?'),peg$decode('!7\u0100+h$.8""2839+X%7\xfa+N%!.\u01a4""2\u01a43\u01a5+-$7\xeb+#%\'"%$"# X"# X*# " [+#%\'$%$$# X$## X$"# X"# X'),peg$decode('!/\u01a6""1%3\u01a7*) "/\u01a8""1$3\u01a9+\' 4!6\u01a2!! %'),peg$decode('!7\xeb+Q$/\xb4""1#3\xb5*7 "/\xb6""1#3\xb7*+ " \\7+,#&7+"+\'%4"6\u01aa" %$"# X"# X'),peg$decode('!7\u0104+\x8f$.F""2F3G+\x7f%7\u0103+u%.F""2F3G+e%7\u0103+[%.F""2F3G+K%7\u0103+A%.F""2F3G+1%7\u0105+\'%4)6\u01ab) %$)# X$(# X$\'# X$&# X$%# X$$# X$## X$"# X"# X'),peg$decode('!7#+A$7#+7%7#+-%7#+#%\'$%$$# X$## X$"# X"# X'),peg$decode('!7\u0103+-$7\u0103+#%\'"%$"# X"# X'),peg$decode('!7\u0103+7$7\u0103+-%7\u0103+#%\'#%$## X$"# X"# X')],peg$currPos=0,peg$reportedPos=0,peg$cachedPos=0,peg$cachedPosDetails={line:1,column:1,seenCR:false},peg$maxFailPos=0,peg$maxFailExpected=[],peg$silentFails=0,peg$result;if("startRule"in options){if(!(options.startRule in peg$startRuleIndices)){throw new Error("Can't start parsing from rule \""+options.startRule+'".')}peg$startRuleIndex=peg$startRuleIndices[options.startRule]}function text(){return input.substring(peg$reportedPos,peg$currPos)}function offset(){return peg$reportedPos}function line(){return peg$computePosDetails(peg$reportedPos).line}function column(){return peg$computePosDetails(peg$reportedPos).column}function expected(description){throw peg$buildException(null,[{type:"other",description:description}],peg$reportedPos)}function error(message){throw peg$buildException(message,null,peg$reportedPos)}function peg$computePosDetails(pos){function advance(details,startPos,endPos){var p,ch;for(p=startPos;p<endPos;p++){ch=input.charAt(p);if(ch==="\n"){if(!details.seenCR){details.line++}details.column=1;details.seenCR=false}else if(ch==="\r"||ch==="\u2028"||ch==="\u2029"){details.line++;details.column=1;details.seenCR=true}else{details.column++;details.seenCR=false}}}if(peg$cachedPos!==pos){if(peg$cachedPos>pos){peg$cachedPos=0;peg$cachedPosDetails={line:1,column:1,seenCR:false}}advance(peg$cachedPosDetails,peg$cachedPos,pos);peg$cachedPos=pos}return peg$cachedPosDetails}function peg$fail(expected){if(peg$currPos<peg$maxFailPos){return}if(peg$currPos>peg$maxFailPos){peg$maxFailPos=peg$currPos;peg$maxFailExpected=[]}peg$maxFailExpected.push(expected)}function peg$buildException(message,expected,pos){function cleanupExpected(expected){var i=1;expected.sort(function(a,b){if(a.description<b.description){return-1}else if(a.description>b.description){return 1}else{return 0}});while(i<expected.length){if(expected[i-1]===expected[i]){expected.splice(i,1)}else{i++}}}function buildMessage(expected,found){function stringEscape(s){function hex(ch){return ch.charCodeAt(0).toString(16).toUpperCase()}return s.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\x08/g,"\\b").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\f/g,"\\f").replace(/\r/g,"\\r").replace(/[\x00-\x07\x0B\x0E\x0F]/g,function(ch){return"\\x0"+hex(ch)}).replace(/[\x10-\x1F\x80-\xFF]/g,function(ch){return"\\x"+hex(ch)}).replace(/[\u0180-\u0FFF]/g,function(ch){return"\\u0"+hex(ch)}).replace(/[\u1080-\uFFFF]/g,function(ch){return"\\u"+hex(ch)})}var expectedDescs=new Array(expected.length),expectedDesc,foundDesc,i;for(i=0;i<expected.length;i++){expectedDescs[i]=expected[i].description}expectedDesc=expected.length>1?expectedDescs.slice(0,-1).join(", ")+" or "+expectedDescs[expected.length-1]:expectedDescs[0];foundDesc=found?'"'+stringEscape(found)+'"':"end of input";return"Expected "+expectedDesc+" but "+foundDesc+" found."}var posDetails=peg$computePosDetails(pos),found=pos<input.length?input.charAt(pos):null;if(expected!==null){cleanupExpected(expected)}return new SyntaxError(message!==null?message:buildMessage(expected,found),expected,found,pos,posDetails.line,posDetails.column)}function peg$decode(s){var bc=new Array(s.length),i;for(i=0;i<s.length;i++){bc[i]=s.charCodeAt(i)-32}return bc}function peg$parseRule(index){var bc=peg$bytecode[index],ip=0,ips=[],end=bc.length,ends=[],stack=[],params,i;function protect(object){return Object.prototype.toString.apply(object)==="[object Array]"?[]:object}while(true){while(ip<end){switch(bc[ip]){case 0:stack.push(protect(peg$consts[bc[ip+1]]));ip+=2;break;case 1:stack.push(peg$currPos);ip++;break;case 2:stack.pop();ip++;break;case 3:peg$currPos=stack.pop();ip++;break;case 4:stack.length-=bc[ip+1];ip+=2;break;case 5:stack.splice(-2,1);ip++;break;case 6:stack[stack.length-2].push(stack.pop());ip++;break;case 7:stack.push(stack.splice(stack.length-bc[ip+1],bc[ip+1]));ip+=2;break;case 8:stack.pop();stack.push(input.substring(stack[stack.length-1],peg$currPos));ip++;break;case 9:ends.push(end);ips.push(ip+3+bc[ip+1]+bc[ip+2]);if(stack[stack.length-1]){end=ip+3+bc[ip+1];ip+=3}else{end=ip+3+bc[ip+1]+bc[ip+2];ip+=3+bc[ip+1]}break;case 10:ends.push(end);ips.push(ip+3+bc[ip+1]+bc[ip+2]);if(stack[stack.length-1]===peg$FAILED){end=ip+3+bc[ip+1];ip+=3}else{end=ip+3+bc[ip+1]+bc[ip+2];ip+=3+bc[ip+1]}break;case 11:ends.push(end);ips.push(ip+3+bc[ip+1]+bc[ip+2]);if(stack[stack.length-1]!==peg$FAILED){end=ip+3+bc[ip+1];ip+=3}else{end=ip+3+bc[ip+1]+bc[ip+2];ip+=3+bc[ip+1]}break;case 12:if(stack[stack.length-1]!==peg$FAILED){ends.push(end);ips.push(ip);end=ip+2+bc[ip+1];ip+=2}else{ip+=2+bc[ip+1]}break;case 13:ends.push(end);ips.push(ip+3+bc[ip+1]+bc[ip+2]);if(input.length>peg$currPos){end=ip+3+bc[ip+1];ip+=3}else{end=ip+3+bc[ip+1]+bc[ip+2];ip+=3+bc[ip+1]}break;case 14:ends.push(end);ips.push(ip+4+bc[ip+2]+bc[ip+3]);if(input.substr(peg$currPos,peg$consts[bc[ip+1]].length)===peg$consts[bc[ip+1]]){end=ip+4+bc[ip+2];ip+=4}else{end=ip+4+bc[ip+2]+bc[ip+3];ip+=4+bc[ip+2]}break;case 15:ends.push(end);ips.push(ip+4+bc[ip+2]+bc[ip+3]);if(input.substr(peg$currPos,peg$consts[bc[ip+1]].length).toLowerCase()===peg$consts[bc[ip+1]]){end=ip+4+bc[ip+2];ip+=4}else{end=ip+4+bc[ip+2]+bc[ip+3];ip+=4+bc[ip+2]}break;case 16:ends.push(end);ips.push(ip+4+bc[ip+2]+bc[ip+3]);if(peg$consts[bc[ip+1]].test(input.charAt(peg$currPos))){end=ip+4+bc[ip+2];ip+=4}else{end=ip+4+bc[ip+2]+bc[ip+3];ip+=4+bc[ip+2]}break;case 17:stack.push(input.substr(peg$currPos,bc[ip+1]));peg$currPos+=bc[ip+1];ip+=2;break;case 18:stack.push(peg$consts[bc[ip+1]]);peg$currPos+=peg$consts[bc[ip+1]].length;ip+=2;break;case 19:stack.push(peg$FAILED);if(peg$silentFails===0){peg$fail(peg$consts[bc[ip+1]])}ip+=2;break;case 20:peg$reportedPos=stack[stack.length-1-bc[ip+1]];ip+=2;break;case 21:peg$reportedPos=peg$currPos;ip++;break;case 22:params=bc.slice(ip+4,ip+4+bc[ip+3]);for(i=0;i<bc[ip+3];i++){params[i]=stack[stack.length-1-params[i]]}stack.splice(stack.length-bc[ip+2],bc[ip+2],peg$consts[bc[ip+1]].apply(null,params));ip+=4+bc[ip+3];break;case 23:stack.push(peg$parseRule(bc[ip+1]));ip+=2;break;case 24:peg$silentFails++;ip++;break;case 25:peg$silentFails--;ip++;break;default:throw new Error("Invalid opcode: "+bc[ip]+".")}}if(ends.length>0){end=ends.pop();ip=ips.pop()}else{break}}return stack[0]}options.data={};function list(first,rest){return[first].concat(rest)}peg$result=peg$parseRule(peg$startRuleIndex);if(peg$result!==peg$FAILED&&peg$currPos===input.length){return peg$result}else{if(peg$result!==peg$FAILED&&peg$currPos<input.length){peg$fail({type:"end",description:"end of input"})}throw peg$buildException(null,peg$maxFailExpected,peg$maxFailPos)}}return{SyntaxError:SyntaxError,parse:parse}}()},{}],136:[function(require,module,exports){"use strict";module.exports=function(SIP){SIP=SIP;var Hacks={AllBrowsers:{maskDtls:function(sdp){if(sdp){sdp=sdp.replace(/ UDP\/TLS\/RTP\/SAVP/gim," RTP/SAVP")}return sdp},unmaskDtls:function(sdp){return sdp.replace(/ RTP\/SAVP/gim," UDP/TLS/RTP/SAVP")}},Firefox:{isFirefox:function(){return typeof mozRTCPeerConnection!=="undefined"},cannotHandleExtraWhitespace:function(sdp){if(this.isFirefox()&&sdp){sdp=sdp.replace(/ \r\n/g,"\r\n")}return sdp},hasMissingCLineInSDP:function(sdp){var insertAt,mlines;if(sdp.indexOf("c=")>sdp.indexOf("m=")){mlines=sdp.match(/m=.*\r\n.*/g);for(var i=0;i<mlines.length;i++){if(mlines[i].toString().search(/i=.*/)>=0){insertAt=sdp.indexOf(mlines[i].toString())+mlines[i].toString().length;if(sdp.substr(insertAt,2)!=="c="){sdp=sdp.substr(0,insertAt)+"\r\nc=IN IP4 0.0.0.0"+sdp.substr(insertAt)}}else if(mlines[i].toString().search(/c=.*/)<0){insertAt=sdp.indexOf(mlines[i].toString().match(/.*/))+mlines[i].toString().match(/.*/).toString().length;sdp=sdp.substr(0,insertAt)+"\r\nc=IN IP4 0.0.0.0"+sdp.substr(insertAt)}}}return sdp}},Chrome:{needsExplicitlyInactiveSDP:function(sdp){var sub,index;if(Hacks.Firefox.isFirefox()){index=sdp.indexOf("m=video 0");if(index!==-1){sub=sdp.substr(index);sub=sub.replace(/\r\nc=IN IP4.*\r\n$/,"\r\nc=IN IP4 0.0.0.0\r\na=inactive\r\n");return sdp.substr(0,index)+sub}}return sdp},getsConfusedAboutGUM:function(session){if(session.mediaHandler){session.mediaHandler.close()}}}};return Hacks}},{}],137:[function(require,module,exports){"use strict";var levels={error:0,warn:1,log:2,debug:3};module.exports=function(console){var LoggerFactory=function(){var logger,level=2,builtinEnabled=true,connector=null;this.loggers={};logger=this.getLogger("sip.loggerfactory");Object.defineProperties(this,{builtinEnabled:{get:function(){return builtinEnabled},set:function(value){if(typeof value==="boolean"){builtinEnabled=value}else{logger.error('invalid "builtinEnabled" parameter value: '+JSON.stringify(value))}}},level:{get:function(){return level},set:function(value){if(value>=0&&value<=3){level=value}else if(value>3){level=3}else if(levels.hasOwnProperty(value)){level=levels[value]}else{logger.error('invalid "level" parameter value: '+JSON.stringify(value))}}},connector:{get:function(){return connector},set:function(value){if(value===null||value===""||value===undefined){connector=null}else if(typeof value==="function"){connector=value}else{logger.error('invalid "connector" parameter value: '+JSON.stringify(value))}}}})};LoggerFactory.prototype.print=function(target,category,label,content){if(typeof content==="string"){var prefix=[new Date,category];if(label){prefix.push(label)}content=prefix.concat(content).join(" | ")}target.call(console,content)};function Logger(logger,category,label){this.logger=logger;this.category=category;this.label=label}Object.keys(levels).forEach(function(targetName){Logger.prototype[targetName]=function(content){this.logger[targetName](this.category,this.label,content)}
    ;LoggerFactory.prototype[targetName]=function(category,label,content){if(this.level>=levels[targetName]){if(this.builtinEnabled){this.print(console[targetName],category,label,content)}if(this.connector){this.connector(targetName,category,label,content)}}}});LoggerFactory.prototype.getLogger=function(category,label){var logger;if(label&&this.level===3){return new Logger(this,category,label)}else if(this.loggers[category]){return this.loggers[category]}else{logger=new Logger(this,category);this.loggers[category]=logger;return logger}};return LoggerFactory}},{}],138:[function(require,module,exports){"use strict";module.exports=function(EventEmitter){var MediaHandler=function(session,options){session=session;options=options};MediaHandler.prototype=Object.create(EventEmitter.prototype,{isReady:{value:function isReady(){}},close:{value:function close(){}},getDescription:{value:function getDescription(mediaHint){mediaHint=mediaHint}},hasDescription:{value:function hasDescription(message){message=message}},setDescription:{value:function setDescription(message){message=message}}});return MediaHandler}},{}],139:[function(require,module,exports){"use strict";module.exports=function(SIP){var NameAddrHeader;NameAddrHeader=function(uri,displayName,parameters){var param;if(!uri||!(uri instanceof SIP.URI)){throw new TypeError('missing or invalid "uri" parameter')}this.uri=uri;this.parameters={};for(param in parameters){this.setParam(param,parameters[param])}Object.defineProperties(this,{friendlyName:{get:function(){return this.displayName||uri.aor}},displayName:{get:function(){return displayName},set:function(value){displayName=value===0?"0":value}}})};NameAddrHeader.prototype={setParam:function(key,value){if(key){this.parameters[key.toLowerCase()]=typeof value==="undefined"||value===null?null:value.toString()}},getParam:SIP.URI.prototype.getParam,hasParam:SIP.URI.prototype.hasParam,deleteParam:SIP.URI.prototype.deleteParam,clearParams:SIP.URI.prototype.clearParams,clone:function(){return new NameAddrHeader(this.uri.clone(),this.displayName,JSON.parse(JSON.stringify(this.parameters)))},toString:function(){var body,parameter;body=this.displayName||this.displayName===0?'"'+this.displayName+'" ':"";body+="<"+this.uri.toString()+">";for(parameter in this.parameters){body+=";"+parameter;if(this.parameters[parameter]!==null){body+="="+this.parameters[parameter]}}return body}};NameAddrHeader.parse=function(name_addr_header){name_addr_header=SIP.Grammar.parse(name_addr_header,"Name_Addr_Header");if(name_addr_header!==-1){return name_addr_header}else{return undefined}};SIP.NameAddrHeader=NameAddrHeader}},{}],140:[function(require,module,exports){"use strict";module.exports=function(SIP){var Parser;function getHeader(data,headerStart){var start=headerStart,end=0,partialEnd=0;if(data.substring(start,start+2).match(/(^\r\n)/)){return-2}while(end===0){partialEnd=data.indexOf("\r\n",start);if(partialEnd===-1){return partialEnd}if(!data.substring(partialEnd+2,partialEnd+4).match(/(^\r\n)/)&&data.charAt(partialEnd+2).match(/(^\s+)/)){start=partialEnd+2}else{end=partialEnd}}return end}function parseHeader(message,data,headerStart,headerEnd){var header,idx,length,parsed,hcolonIndex=data.indexOf(":",headerStart),headerName=data.substring(headerStart,hcolonIndex).trim(),headerValue=data.substring(hcolonIndex+1,headerEnd).trim();switch(headerName.toLowerCase()){case"via":case"v":message.addHeader("via",headerValue);if(message.getHeaders("via").length===1){parsed=message.parseHeader("Via");if(parsed){message.via=parsed;message.via_branch=parsed.branch}}else{parsed=0}break;case"from":case"f":message.setHeader("from",headerValue);parsed=message.parseHeader("from");if(parsed){message.from=parsed;message.from_tag=parsed.getParam("tag")}break;case"to":case"t":message.setHeader("to",headerValue);parsed=message.parseHeader("to");if(parsed){message.to=parsed;message.to_tag=parsed.getParam("tag")}break;case"record-route":parsed=SIP.Grammar.parse(headerValue,"Record_Route");if(parsed===-1){parsed=undefined;break}length=parsed.length;for(idx=0;idx<length;idx++){header=parsed[idx];message.addHeader("record-route",headerValue.substring(header.position,header.offset));message.headers["Record-Route"][message.getHeaders("record-route").length-1].parsed=header.parsed}break;case"call-id":case"i":message.setHeader("call-id",headerValue);parsed=message.parseHeader("call-id");if(parsed){message.call_id=headerValue}break;case"contact":case"m":parsed=SIP.Grammar.parse(headerValue,"Contact");if(parsed===-1){parsed=undefined;break}length=parsed.length;for(idx=0;idx<length;idx++){header=parsed[idx];message.addHeader("contact",headerValue.substring(header.position,header.offset));message.headers["Contact"][message.getHeaders("contact").length-1].parsed=header.parsed}break;case"content-length":case"l":message.setHeader("content-length",headerValue);parsed=message.parseHeader("content-length");break;case"content-type":case"c":message.setHeader("content-type",headerValue);parsed=message.parseHeader("content-type");break;case"cseq":message.setHeader("cseq",headerValue);parsed=message.parseHeader("cseq");if(parsed){message.cseq=parsed.value}if(message instanceof SIP.IncomingResponse){message.method=parsed.method}break;case"max-forwards":message.setHeader("max-forwards",headerValue);parsed=message.parseHeader("max-forwards");break;case"www-authenticate":message.setHeader("www-authenticate",headerValue);parsed=message.parseHeader("www-authenticate");break;case"proxy-authenticate":message.setHeader("proxy-authenticate",headerValue);parsed=message.parseHeader("proxy-authenticate");break;case"refer-to":case"r":message.setHeader("refer-to",headerValue);parsed=message.parseHeader("refer-to");if(parsed){message.refer_to=parsed}break;default:message.setHeader(headerName,headerValue);parsed=0}if(parsed===undefined){return{error:'error parsing header "'+headerName+'"'}}else{return true}}Parser={};Parser.parseMessage=function(data,ua){var message,firstLine,contentLength,bodyStart,parsed,headerStart=0,headerEnd=data.indexOf("\r\n"),logger=ua.getLogger("sip.parser");if(headerEnd===-1){logger.warn("no CRLF found, not a SIP message, discarded");return}firstLine=data.substring(0,headerEnd);parsed=SIP.Grammar.parse(firstLine,"Request_Response");if(parsed===-1){logger.warn('error parsing first line of SIP message: "'+firstLine+'"');return}else if(!parsed.status_code){message=new SIP.IncomingRequest(ua);message.method=parsed.method;message.ruri=parsed.uri}else{message=new SIP.IncomingResponse(ua);message.status_code=parsed.status_code;message.reason_phrase=parsed.reason_phrase}message.data=data;headerStart=headerEnd+2;while(true){headerEnd=getHeader(data,headerStart);if(headerEnd===-2){bodyStart=headerStart+2;break}else if(headerEnd===-1){logger.error("malformed message");return}parsed=parseHeader(message,data,headerStart,headerEnd);if(parsed!==true){logger.error(parsed.error);return}headerStart=headerEnd+2}if(message.hasHeader("content-length")){contentLength=message.getHeader("content-length");message.body=data.substr(bodyStart,contentLength)}else{message.body=data.substring(bodyStart)}return message};SIP.Parser=Parser}},{}],141:[function(require,module,exports){var localMinSE=90;module.exports=function(Timers){function hasSmallMinSE(message){var supportedOptions=message.parseHeader("Supported")||[];var sessionExpires=message.parseHeader("Session-Expires")||{};return supportedOptions.indexOf("timer")>=0&&sessionExpires.deltaSeconds<localMinSE}function updateState(dialog,response,parseMessage,ua){dialog.sessionTimerState=dialog.sessionTimerState||{};Timers.clearTimeout(dialog.sessionTimerState.timeout);var isUAS=typeof response==="string";if(isUAS){response=parseMessage(response,ua)}var sessionExpires=response.parseHeader("Session-Expires");if(!sessionExpires){dialog.sessionTimerState=null;return}var interval=sessionExpires.deltaSeconds;var isRefresher=isUAS===(sessionExpires.refresher==="uas");dialog.sessionTimerState={interval:interval,isRefresher:isRefresher};var intervalMilliseconds=interval*1e3;var self=this;if(isRefresher){dialog.sessionTimerState.timeout=Timers.setInterval(function sendRefresh(){var exists=dialog.owner.ua.dialogs[dialog.id.toString()]||false;if(exists){dialog.sendRequest(self,"UPDATE",{extraHeaders:["Session-Expires: "+interval]})}else{Timers.clearInterval(dialog.sessionTimerState.timeout)}},intervalMilliseconds/2)}else{var before=Math.min(32*1e3,intervalMilliseconds/3);dialog.sessionTimerState.timeout=Timers.setTimeout(function sendBye(){},intervalMilliseconds-before)}}function receiveResponse(response){}function onDialogError(response){}function onRequestTimeout(){}function onTransportError(){}return{localMinSE:localMinSE,hasSmallMinSE:hasSmallMinSE,updateState:updateState,receiveResponse:receiveResponse,onDialogError:onDialogError,onRequestTimeout:onRequestTimeout,onTransportError:onTransportError}}},{}],142:[function(require,module,exports){"use strict";module.exports=function(SIP){var RegisterContext;RegisterContext=function(ua){var params={},regId=1;this.registrar=ua.configuration.registrarServer;this.expires=ua.configuration.registerExpires;this.contact=ua.contact.toString();if(regId){this.contact+=";reg-id="+regId;this.contact+=';+sip.instance="<urn:uuid:'+ua.configuration.instanceId+'>"'}this.call_id=SIP.Utils.createRandomToken(22);this.cseq=80;this.to_uri=ua.configuration.uri;params.to_uri=this.to_uri;params.to_displayName=ua.configuration.displayName;params.call_id=this.call_id;params.cseq=this.cseq;SIP.Utils.augment(this,SIP.ClientContext,[ua,"REGISTER",this.registrar,{params:params}]);this.registrationTimer=null;this.registrationExpiredTimer=null;this.registered=false;this.logger=ua.getLogger("sip.registercontext")};RegisterContext.prototype={register:function(options){var self=this,extraHeaders;this.options=options||{};extraHeaders=(this.options.extraHeaders||[]).slice();extraHeaders.push("Contact: "+this.contact+";expires="+this.expires);extraHeaders.push("Allow: "+SIP.UA.C.ALLOWED_METHODS.toString());this.closeHeaders=this.options.closeWithHeaders?(this.options.extraHeaders||[]).slice():[];this.receiveResponse=function(response){var contact,expires,contacts=response.getHeaders("contact").length,cause;if(response.cseq!==this.cseq){return}if(this.registrationTimer!==null){SIP.Timers.clearTimeout(this.registrationTimer);this.registrationTimer=null}switch(true){case/^1[0-9]{2}$/.test(response.status_code):this.emit("progress",response);break;case/^2[0-9]{2}$/.test(response.status_code):this.emit("accepted",response);if(response.hasHeader("expires")){expires=response.getHeader("expires")}if(this.registrationExpiredTimer!==null){SIP.Timers.clearTimeout(this.registrationExpiredTimer);this.registrationExpiredTimer=null}if(!contacts){this.logger.warn("no Contact header in response to REGISTER, response ignored");break}while(contacts--){contact=response.parseHeader("contact",contacts);if(contact.uri.user===this.ua.contact.uri.user){expires=contact.getParam("expires");break}else{contact=null}}if(!contact){this.logger.warn("no Contact header pointing to us, response ignored");break}if(!expires){expires=this.expires}this.registrationTimer=SIP.Timers.setTimeout(function(){self.registrationTimer=null;self.register(self.options)},expires*1e3-3e3);this.registrationExpiredTimer=SIP.Timers.setTimeout(function(){self.logger.warn("registration expired");if(self.registered){self.unregistered(null,SIP.C.causes.EXPIRES)}},expires*1e3);if(contact.hasParam("temp-gruu")){this.ua.contact.temp_gruu=SIP.URI.parse(contact.getParam("temp-gruu").replace(/"/g,""))}if(contact.hasParam("pub-gruu")){this.ua.contact.pub_gruu=SIP.URI.parse(contact.getParam("pub-gruu").replace(/"/g,""))}this.registered=true;this.emit("registered",response||null);break;case/^423$/.test(response.status_code):if(response.hasHeader("min-expires")){this.expires=response.getHeader("min-expires");this.register(this.options)}else{this.logger.warn("423 response received for REGISTER without Min-Expires");this.registrationFailure(response,SIP.C.causes.SIP_FAILURE_CODE)}break;default:cause=SIP.Utils.sipErrorCause(response.status_code);this.registrationFailure(response,cause)}};this.onRequestTimeout=function(){this.registrationFailure(null,SIP.C.causes.REQUEST_TIMEOUT)};this.onTransportError=function(){this.registrationFailure(null,SIP.C.causes.CONNECTION_ERROR)};this.cseq++;this.request.cseq=this.cseq;this.request.setHeader("cseq",this.cseq+" REGISTER");this.request.extraHeaders=extraHeaders;this.send()},registrationFailure:function(response,cause){this.emit("failed",response||null,cause||null)},onTransportClosed:function(){this.registered_before=this.registered;if(this.registrationTimer!==null){SIP.Timers.clearTimeout(this.registrationTimer);this.registrationTimer=null}if(this.registrationExpiredTimer!==null){SIP.Timers.clearTimeout(this.registrationExpiredTimer);this.registrationExpiredTimer=null}if(this.registered){this.unregistered(null,SIP.C.causes.CONNECTION_ERROR)}},onTransportConnected:function(){this.register(this.options)},close:function(){var options={all:false,extraHeaders:this.closeHeaders};this.registered_before=this.registered;this.unregister(options)},unregister:function(options){var extraHeaders;options=options||{};if(!this.registered&&!options.all){this.logger.warn("already unregistered");return}extraHeaders=(options.extraHeaders||[]).slice();this.registered=false;if(this.registrationTimer!==null){SIP.Timers.clearTimeout(this.registrationTimer);this.registrationTimer=null}if(options.all){extraHeaders.push("Contact: *");extraHeaders.push("Expires: 0")}else{extraHeaders.push("Contact: "+this.contact+";expires=0")}this.receiveResponse=function(response){var cause;switch(true){case/^1[0-9]{2}$/.test(response.status_code):this.emit("progress",response);break;case/^2[0-9]{2}$/.test(response.status_code):this.emit("accepted",response);if(this.registrationExpiredTimer!==null){SIP.Timers.clearTimeout(this.registrationExpiredTimer);this.registrationExpiredTimer=null}this.unregistered(response);break;default:cause=SIP.Utils.sipErrorCause(response.status_code);this.unregistered(response,cause)}};this.onRequestTimeout=function(){};this.onTransportError=function(){};this.cseq++;this.request.cseq=this.cseq;this.request.setHeader("cseq",this.cseq+" REGISTER");this.request.extraHeaders=extraHeaders;this.send()},unregistered:function(response,cause){this.registered=false;this.emit("unregistered",response||null,cause||null)}};SIP.RegisterContext=RegisterContext}},{}],143:[function(require,module,exports){"use strict";module.exports=function(SIP){var RequestSender;RequestSender=function(applicant,ua){this.logger=ua.getLogger("sip.requestsender");this.ua=ua;this.applicant=applicant;this.method=applicant.request.method;this.request=applicant.request;this.credentials=null;this.challenged=false;this.staled=false;if(ua.status===SIP.UA.C.STATUS_USER_CLOSED&&(this.method!==SIP.C.BYE||this.method!==SIP.C.ACK)){this.onTransportError()}};RequestSender.prototype={send:function(){switch(this.method){case"INVITE":this.clientTransaction=new SIP.Transactions.InviteClientTransaction(this,this.request,this.ua.transport);break;case"ACK":this.clientTransaction=new SIP.Transactions.AckClientTransaction(this,this.request,this.ua.transport);break;default:this.clientTransaction=new SIP.Transactions.NonInviteClientTransaction(this,this.request,this.ua.transport)}this.clientTransaction.send();return this.clientTransaction},onRequestTimeout:function(){this.applicant.onRequestTimeout()},onTransportError:function(){this.applicant.onTransportError()},receiveResponse:function(response){var cseq,challenge,authorization_header_name,status_code=response.status_code;if(status_code===401||status_code===407){if(response.status_code===401){challenge=response.parseHeader("www-authenticate");authorization_header_name="authorization"}else{challenge=response.parseHeader("proxy-authenticate");authorization_header_name="proxy-authorization"}if(!challenge){this.logger.warn(response.status_code+" with wrong or missing challenge, cannot authenticate");this.applicant.receiveResponse(response);return}if(!this.challenged||!this.staled&&challenge.stale===true){if(!this.credentials){this.credentials=this.ua.configuration.authenticationFactory(this.ua)}if(!this.credentials.authenticate(this.request,challenge)){this.applicant.receiveResponse(response);return}this.challenged=true;if(challenge.stale){this.staled=true}if(response.method===SIP.C.REGISTER){cseq=this.applicant.cseq+=1}else if(this.request.dialog){cseq=this.request.dialog.local_seqnum+=1}else{cseq=this.request.cseq+1;this.request.cseq=cseq}this.request.setHeader("cseq",cseq+" "+this.method);this.request.setHeader(authorization_header_name,this.credentials.toString());this.send()}else{this.applicant.receiveResponse(response)}}else{this.applicant.receiveResponse(response)}}};SIP.RequestSender=RequestSender}},{}],144:[function(require,module,exports){"use strict";module.exports=function(environment){var pkg=require("../package.json");var SIP=Object.defineProperties({},{version:{get:function(){return pkg.version}},name:{get:function(){return pkg.title}}});require("./Utils")(SIP,environment);SIP.LoggerFactory=require("./LoggerFactory")(environment.console);SIP.EventEmitter=require("./EventEmitter")(environment.console);SIP.C=require("./Constants")(SIP.name,SIP.version);SIP.Exceptions=require("./Exceptions");SIP.Timers=require("./Timers")(environment.timers);SIP.Transport=environment.Transport(SIP,environment.WebSocket);require("./Parser")(SIP);require("./SIPMessage")(SIP);require("./URI")(SIP);require("./NameAddrHeader")(SIP);require("./Transactions")(SIP);require("./Dialogs")(SIP);require("./RequestSender")(SIP);require("./RegisterContext")(SIP);SIP.MediaHandler=require("./MediaHandler")(SIP.EventEmitter);require("./ClientContext")(SIP);require("./ServerContext")(SIP);require("./Session")(SIP,environment);require("./Subscription")(SIP);SIP.WebRTC=require("./WebRTC")(SIP,environment);require("./UA")(SIP,environment);SIP.Hacks=require("./Hacks")(SIP);require("./SanityCheck")(SIP);SIP.DigestAuthentication=require("./DigestAuthentication")(SIP.Utils);SIP.Grammar=require("./Grammar")(SIP);return SIP}},{"../package.json":126,"./ClientContext":127,"./Constants":128,"./Dialogs":130,"./DigestAuthentication":131,"./EventEmitter":132,"./Exceptions":133,"./Grammar":134,"./Hacks":136,"./LoggerFactory":137,"./MediaHandler":138,"./NameAddrHeader":139,"./Parser":140,"./RegisterContext":142,"./RequestSender":143,"./SIPMessage":145,"./SanityCheck":146,"./ServerContext":147,"./Session":148,"./Subscription":150,"./Timers":151,"./Transactions":152,"./UA":154,"./URI":155,"./Utils":156,"./WebRTC":157}],145:[function(require,module,exports){"use strict";module.exports=function(SIP){var OutgoingRequest,IncomingMessage,IncomingRequest,IncomingResponse;function getSupportedHeader(request){var allowUnregistered=request.ua.configuration.hackAllowUnregisteredOptionTags;var optionTags=[];var optionTagSet={};if(request.method===SIP.C.REGISTER){optionTags.push("path","gruu")}else if(request.method===SIP.C.INVITE&&(request.ua.contact.pub_gruu||request.ua.contact.temp_gruu)){optionTags.push("gruu")}if(request.ua.configuration.rel100===SIP.C.supported.SUPPORTED){optionTags.push("100rel")}if(request.ua.configuration.replaces===SIP.C.supported.SUPPORTED){optionTags.push("replaces")}optionTags.push("outbound");optionTags=optionTags.concat(request.ua.configuration.extraSupported);optionTags=optionTags.filter(function(optionTag){var registered=SIP.C.OPTION_TAGS[optionTag];var unique=!optionTagSet[optionTag];optionTagSet[optionTag]=true;return(registered||allowUnregistered)&&unique});return"Supported: "+optionTags.join(", ")+"\r\n"}OutgoingRequest=function(method,ruri,ua,params,extraHeaders,body){var to,from,call_id,cseq,to_uri,from_uri;params=params||{};if(!method||!ruri||!ua){return null}this.logger=ua.getLogger("sip.sipmessage");this.ua=ua;this.headers={};this.method=method;this.ruri=ruri;this.body=body;this.extraHeaders=(extraHeaders||[]).slice();this.statusCode=params.status_code;this.reasonPhrase=params.reason_phrase;if(params.route_set){this.setHeader("route",params.route_set)}else if(ua.configuration.usePreloadedRoute){this.setHeader("route",ua.transport.server.sip_uri)}this.setHeader("via","");this.setHeader("max-forwards",SIP.UA.C.MAX_FORWARDS);to_uri=params.to_uri||ruri;to=params.to_displayName||params.to_displayName===0?'"'+params.to_displayName+'" ':"";to+="<"+(to_uri&&to_uri.toRaw?to_uri.toRaw():to_uri)+">";to+=params.to_tag?";tag="+params.to_tag:"";this.to=new SIP.NameAddrHeader.parse(to);this.setHeader("to",to);from_uri=params.from_uri||ua.configuration.uri;if(params.from_displayName||params.from_displayName===0){from='"'+params.from_displayName+'" '}else if(ua.configuration.displayName){from='"'+ua.configuration.displayName+'" '}else{from=""}from+="<"+(from_uri&&from_uri.toRaw?from_uri.toRaw():from_uri)+">;tag=";from+=params.from_tag||SIP.Utils.newTag();this.from=new SIP.NameAddrHeader.parse(from);this.setHeader("from",from);call_id=params.call_id||ua.configuration.sipjsId+SIP.Utils.createRandomToken(15);this.call_id=call_id;this.setHeader("call-id",call_id);cseq=params.cseq||Math.floor(Math.random()*1e4);this.cseq=cseq;this.setHeader("cseq",cseq+" "+method)};OutgoingRequest.prototype={setHeader:function(name,value){this.headers[SIP.Utils.headerize(name)]=value instanceof Array?value:[value]},getHeader:function(name){var regexp,idx,length=this.extraHeaders.length,header=this.headers[SIP.Utils.headerize(name)];if(header){if(header[0]){return header[0]}}else{regexp=new RegExp("^\\s*"+name+"\\s*:","i");for(idx=0;idx<length;idx++){header=this.extraHeaders[idx];if(regexp.test(header)){return header.substring(header.indexOf(":")+1).trim()}}}return},getHeaders:function(name){var idx,length,regexp,header=this.headers[SIP.Utils.headerize(name)],result=[];if(header){length=header.length;for(idx=0;idx<length;idx++){result.push(header[idx])}return result}else{length=this.extraHeaders.length;regexp=new RegExp("^\\s*"+name+"\\s*:","i");for(idx=0;idx<length;idx++){header=this.extraHeaders[idx];if(regexp.test(header)){result.push(header.substring(header.indexOf(":")+1).trim())}}return result}},hasHeader:function(name){var regexp,idx,length=this.extraHeaders.length;if(this.headers[SIP.Utils.headerize(name)]){return true}else{regexp=new RegExp("^\\s*"+name+"\\s*:","i");for(idx=0;idx<length;idx++){if(regexp.test(this.extraHeaders[idx])){return true}}}return false},toString:function(){var msg="",header,length,idx;msg+=this.method+" "+(this.ruri.toRaw?this.ruri.toRaw():this.ruri)+" SIP/2.0\r\n";for(header in this.headers){length=this.headers[header].length;for(idx=0;idx<length;idx++){msg+=header+": "+this.headers[header][idx]+"\r\n"}}length=this.extraHeaders.length;for(idx=0;idx<length;idx++){msg+=this.extraHeaders[idx].trim()+"\r\n"}msg+=getSupportedHeader(this);msg+="User-Agent: "+this.ua.configuration.userAgentString+"\r\n";if(this.body){if(typeof this.body==="string"){length=SIP.Utils.str_utf8_length(this.body);msg+="Content-Length: "+length+"\r\n\r\n";msg+=this.body}else{if(this.body.body&&this.body.contentType){length=SIP.Utils.str_utf8_length(this.body.body);msg+="Content-Type: "+this.body.contentType+"\r\n";msg+="Content-Length: "+length+"\r\n\r\n";msg+=this.body.body}else{msg+="Content-Length: "+0+"\r\n\r\n"}}}else{msg+="Content-Length: "+0+"\r\n\r\n"}return msg}};IncomingMessage=function(){this.data=null;this.headers=null;this.method=null;this.via=null;this.via_branch=null;this.call_id=null;this.cseq=null;this.from=null;this.from_tag=null;this.to=null;this.to_tag=null;this.body=null};IncomingMessage.prototype={addHeader:function(name,value){var header={raw:value};name=SIP.Utils.headerize(name);if(this.headers[name]){this.headers[name].push(header)}else{this.headers[name]=[header]}},getHeader:function(name){var header=this.headers[SIP.Utils.headerize(name)];if(header){if(header[0]){return header[0].raw}}else{return}},getHeaders:function(name){var idx,length,header=this.headers[SIP.Utils.headerize(name)],result=[];if(!header){return[]}length=header.length;for(idx=0;idx<length;idx++){result.push(header[idx].raw)}return result},hasHeader:function(name){return this.headers[SIP.Utils.headerize(name)]?true:false},parseHeader:function(name,idx){var header,value,parsed;name=SIP.Utils.headerize(name);idx=idx||0;if(!this.headers[name]){this.logger.log('header "'+name+'" not present');return}else if(idx>=this.headers[name].length){this.logger.log('not so many "'+name+'" headers present');return}header=this.headers[name][idx];value=header.raw;if(header.parsed){return header.parsed}parsed=SIP.Grammar.parse(value,name.replace(/-/g,"_"));if(parsed===-1){this.headers[name].splice(idx,1);this.logger.warn('error parsing "'+name+'" header field with value "'+value+'"');return}else{header.parsed=parsed;return parsed}},s:function(name,idx){return this.parseHeader(name,idx)},setHeader:function(name,value){var header={raw:value};this.headers[SIP.Utils.headerize(name)]=[header]},toString:function(){return this.data}};IncomingRequest=function(ua){this.logger=ua.getLogger("sip.sipmessage");this.ua=ua;this.headers={};this.ruri=null;this.transport=null;this.server_transaction=null};IncomingRequest.prototype=new IncomingMessage;IncomingRequest.prototype.reply=function(code,reason,extraHeaders,body,onSuccess,onFailure){var rr,vias,length,idx,response,to=this.getHeader("To"),r=0,v=0;response=SIP.Utils.buildStatusLine(code,reason);extraHeaders=(extraHeaders||[]).slice();if(this.method===SIP.C.INVITE&&code>100&&code<=200){rr=this.getHeaders("record-route");length=rr.length;for(r;r<length;r++){response+="Record-Route: "+rr[r]+"\r\n"}}vias=this.getHeaders("via");length=vias.length;for(v;v<length;v++){response+="Via: "+vias[v]+"\r\n"}if(!this.to_tag&&code>100){to+=";tag="+SIP.Utils.newTag()}else if(this.to_tag&&!this.s("to").hasParam("tag")){to+=";tag="+this.to_tag}response+="To: "+to+"\r\n";response+="From: "+this.getHeader("From")+"\r\n";response+="Call-ID: "+this.call_id+"\r\n";response+="CSeq: "+this.cseq+" "+this.method+"\r\n";length=extraHeaders.length;for(idx=0;idx<length;idx++){response+=extraHeaders[idx].trim()+"\r\n"}response+=getSupportedHeader(this);response+="User-Agent: "+this.ua.configuration.userAgentString+"\r\n";if(body){if(typeof body==="string"){length=SIP.Utils.str_utf8_length(body);response+="Content-Type: application/sdp\r\n";response+="Content-Length: "+length+"\r\n\r\n";response+=body}else{if(body.body&&body.contentType){length=SIP.Utils.str_utf8_length(body.body);response+="Content-Type: "+body.contentType+"\r\n";response+="Content-Length: "+length+"\r\n\r\n";response+=body.body}else{response+="Content-Length: "+0+"\r\n\r\n"}}}else{response+="Content-Length: "+0+"\r\n\r\n"}this.server_transaction.receiveResponse(code,response).then(onSuccess,onFailure);return response};IncomingRequest.prototype.reply_sl=function(code,reason){var to,response,v=0,vias=this.getHeaders("via"),length=vias.length;response=SIP.Utils.buildStatusLine(code,reason);for(v;v<length;v++){response+="Via: "+vias[v]+"\r\n"}to=this.getHeader("To");if(!this.to_tag&&code>100){to+=";tag="+SIP.Utils.newTag()}else if(this.to_tag&&!this.s("to").hasParam("tag")){to+=";tag="+this.to_tag}response+="To: "+to+"\r\n";response+="From: "+this.getHeader("From")+"\r\n";response+="Call-ID: "+this.call_id+"\r\n";response+="CSeq: "+this.cseq+" "+this.method+"\r\n";response+="User-Agent: "+this.ua.configuration.userAgentString+"\r\n";response+="Content-Length: "+0+"\r\n\r\n";this.transport.send(response)};IncomingResponse=function(ua){this.logger=ua.getLogger("sip.sipmessage");this.headers={};this.status_code=null;this.reason_phrase=null};IncomingResponse.prototype=new IncomingMessage;SIP.OutgoingRequest=OutgoingRequest;SIP.IncomingRequest=IncomingRequest;SIP.IncomingResponse=IncomingResponse}},{}],146:[function(require,module,exports){"use strict";module.exports=function(SIP){var sanityCheck,requests=[],responses=[],all=[];function reply(status_code,message,transport){var to,response=SIP.Utils.buildStatusLine(status_code),vias=message.getHeaders("via"),length=vias.length,idx=0;for(idx;idx<length;idx++){response+="Via: "+vias[idx]+"\r\n"}to=message.getHeader("To");if(!message.to_tag){to+=";tag="+SIP.Utils.newTag()}response+="To: "+to+"\r\n";response+="From: "+message.getHeader("From")+"\r\n";response+="Call-ID: "+message.call_id+"\r\n";response+="CSeq: "+message.cseq+" "+message.method+"\r\n";response+="\r\n";transport.send(response)}function rfc3261_8_2_2_1(message,ua,transport){if(!message.ruri||message.ruri.scheme!=="sip"){reply(416,message,transport);return false}}function rfc3261_16_3_4(message,ua,transport){if(!message.to_tag){if(message.call_id.substr(0,5)===ua.configuration.sipjsId){reply(482,message,transport);return false}}}function rfc3261_18_3_request(message,ua,transport){var len=SIP.Utils.str_utf8_length(message.body),contentLength=message.getHeader("content-length");if(len<contentLength){reply(400,message,transport);return false}}function rfc3261_8_2_2_2(message,ua,transport){var tr,idx,fromTag=message.from_tag,call_id=message.call_id,cseq=message.cseq;if(!message.to_tag){if(message.method===SIP.C.INVITE){tr=ua.transactions.ist[message.via_branch];if(tr){return}else{for(idx in ua.transactions.ist){tr=ua.transactions.ist[idx];if(tr.request.from_tag===fromTag&&tr.request.call_id===call_id&&tr.request.cseq===cseq){reply(482,message,transport);return false}}}}else{tr=ua.transactions.nist[message.via_branch];if(tr){return}else{for(idx in ua.transactions.nist){tr=ua.transactions.nist[idx];if(tr.request.from_tag===fromTag&&tr.request.call_id===call_id&&tr.request.cseq===cseq){reply(482,message,transport);return false}}}}}}function rfc3261_8_1_3_3(message,ua){if(message.getHeaders("via").length>1){ua.getLogger("sip.sanitycheck").warn("More than one Via header field present in the response. Dropping the response");return false}}function rfc3261_18_3_response(message,ua){var len=SIP.Utils.str_utf8_length(message.body),contentLength=message.getHeader("content-length");if(len<contentLength){ua.getLogger("sip.sanitycheck").warn("Message body length is lower than the value in Content-Length header field. Dropping the response");return false}}function minimumHeaders(message,ua){var mandatoryHeaders=["from","to","call_id","cseq","via"],idx=mandatoryHeaders.length;while(idx--){if(!message.hasHeader(mandatoryHeaders[idx])){ua.getLogger("sip.sanitycheck").warn("Missing mandatory header field : "+mandatoryHeaders[idx]+". Dropping the response");return false}}}requests.push(rfc3261_8_2_2_1);requests.push(rfc3261_16_3_4);requests.push(rfc3261_18_3_request);requests.push(rfc3261_8_2_2_2);responses.push(rfc3261_8_1_3_3);responses.push(rfc3261_18_3_response);all.push(minimumHeaders);sanityCheck=function(message,ua,transport){var len,pass;len=all.length;while(len--){pass=all[len](message,ua,transport);if(pass===false){return false}}if(message instanceof SIP.IncomingRequest){len=requests.length;while(len--){pass=requests[len](message,ua,transport);if(pass===false){return false}}}else if(message instanceof SIP.IncomingResponse){len=responses.length;while(len--){pass=responses[len](message,ua,transport);if(pass===false){return false}}}return true};SIP.sanityCheck=sanityCheck}},{}],147:[function(require,module,exports){"use strict";module.exports=function(SIP){var ServerContext;ServerContext=function(ua,request){this.ua=ua;this.logger=ua.getLogger("sip.servercontext");this.request=request;if(request.method===SIP.C.INVITE){this.transaction=new SIP.Transactions.InviteServerTransaction(request,ua)}else{this.transaction=new SIP.Transactions.NonInviteServerTransaction(request,ua)}if(request.body){this.body=request.body}if(request.hasHeader("Content-Type")){this.contentType=request.getHeader("Content-Type")}this.method=request.method;this.data={};this.localIdentity=request.to;this.remoteIdentity=request.from}
    ;ServerContext.prototype=Object.create(SIP.EventEmitter.prototype);ServerContext.prototype.progress=function(options){options=Object.create(options||Object.prototype);options.statusCode||(options.statusCode=180);options.minCode=100;options.maxCode=199;options.events=["progress"];return this.reply(options)};ServerContext.prototype.accept=function(options){options=Object.create(options||Object.prototype);options.statusCode||(options.statusCode=200);options.minCode=200;options.maxCode=299;options.events=["accepted"];return this.reply(options)};ServerContext.prototype.reject=function(options){options=Object.create(options||Object.prototype);options.statusCode||(options.statusCode=480);options.minCode=300;options.maxCode=699;options.events=["rejected","failed"];return this.reply(options)};ServerContext.prototype.reply=function(options){options=options||{};var statusCode=options.statusCode||100,minCode=options.minCode||100,maxCode=options.maxCode||699,reasonPhrase=SIP.Utils.getReasonPhrase(statusCode,options.reasonPhrase),extraHeaders=options.extraHeaders||[],body=options.body,events=options.events||[],response;if(statusCode<minCode||statusCode>maxCode){throw new TypeError("Invalid statusCode: "+statusCode)}response=this.request.reply(statusCode,reasonPhrase,extraHeaders,body);events.forEach(function(event){this.emit(event,response,reasonPhrase)},this);return this};ServerContext.prototype.onRequestTimeout=function(){this.emit("failed",null,SIP.C.causes.REQUEST_TIMEOUT)};ServerContext.prototype.onTransportError=function(){this.emit("failed",null,SIP.C.causes.CONNECTION_ERROR)};SIP.ServerContext=ServerContext}},{}],148:[function(require,module,exports){"use strict";module.exports=function(SIP,environment){var DTMF=require("./Session/DTMF")(SIP);var RFC4028=require("./RFC4028")(SIP.Timers);var Session,InviteServerContext,InviteClientContext,C={STATUS_NULL:0,STATUS_INVITE_SENT:1,STATUS_1XX_RECEIVED:2,STATUS_INVITE_RECEIVED:3,STATUS_WAITING_FOR_ANSWER:4,STATUS_ANSWERED:5,STATUS_WAITING_FOR_PRACK:6,STATUS_WAITING_FOR_ACK:7,STATUS_CANCELED:8,STATUS_TERMINATED:9,STATUS_ANSWERED_WAITING_FOR_PRACK:10,STATUS_EARLY_MEDIA:11,STATUS_CONFIRMED:12};Session=function(mediaHandlerFactory){this.status=C.STATUS_NULL;this.dialog=null;this.earlyDialogs={};this.mediaHandlerFactory=mediaHandlerFactory||SIP.WebRTC.MediaHandler.defaultFactory;this.hasOffer=false;this.hasAnswer=false;this.timers={ackTimer:null,expiresTimer:null,invite2xxTimer:null,userNoAnswerTimer:null,rel1xxTimer:null,prackTimer:null};this.startTime=null;this.endTime=null;this.tones=null;this.local_hold=false;this.remote_hold=false;this.pending_actions={actions:[],length:function(){return this.actions.length},isPending:function(name){var idx=0,length=this.actions.length;for(idx;idx<length;idx++){if(this.actions[idx].name===name){return true}}return false},shift:function(){return this.actions.shift()},push:function(name){this.actions.push({name:name})},pop:function(name){var idx=0,length=this.actions.length;for(idx;idx<length;idx++){if(this.actions[idx].name===name){this.actions.splice(idx,1);length--;idx--}}}};this.early_sdp=null;this.rel100=SIP.C.supported.UNSUPPORTED};Session.prototype={dtmf:function(tones,options){var tone,dtmfs=[],self=this;options=options||{};if(tones===undefined){throw new TypeError("Not enough arguments")}if(this.status!==C.STATUS_CONFIRMED&&this.status!==C.STATUS_WAITING_FOR_ACK){throw new SIP.Exceptions.InvalidStateError(this.status)}if(typeof tones!=="string"&&typeof tones!=="number"||!tones.toString().match(/^[0-9A-D#*,]+$/i)){throw new TypeError("Invalid tones: "+tones)}tones=tones.toString().split("");while(tones.length>0){dtmfs.push(new DTMF(this,tones.shift(),options))}if(this.tones){this.tones=this.tones.concat(dtmfs);return this}var sendDTMF=function(){var dtmf,timeout;if(self.status===C.STATUS_TERMINATED||!self.tones||self.tones.length===0){self.tones=null;return this}dtmf=self.tones.shift();if(tone===","){timeout=2e3}else{dtmf.on("failed",function(){self.tones=null});dtmf.send(options);timeout=dtmf.duration+dtmf.interToneGap}SIP.Timers.setTimeout(sendDTMF,timeout)};this.tones=dtmfs;sendDTMF();return this},bye:function(options){options=Object.create(options||Object.prototype);var statusCode=options.statusCode;if(this.status===C.STATUS_TERMINATED){this.logger.error("Error: Attempted to send BYE in a terminated session.");return this}this.logger.log("terminating Session");if(statusCode&&(statusCode<200||statusCode>=700)){throw new TypeError("Invalid statusCode: "+statusCode)}options.receiveResponse=function(){};return this.sendRequest(SIP.C.BYE,options).terminated()},refer:function(target,options){options=options||{};var extraHeaders=(options.extraHeaders||[]).slice(),withReplaces=target instanceof SIP.InviteServerContext||target instanceof SIP.InviteClientContext,originalTarget=target;if(target===undefined){throw new TypeError("Not enough arguments")}if(this.status!==C.STATUS_CONFIRMED){throw new SIP.Exceptions.InvalidStateError(this.status)}if(withReplaces){target='"'+target.remoteIdentity.friendlyName+'" '+"<"+target.dialog.remote_target.toString()+"?Replaces="+target.dialog.id.call_id+"%3Bto-tag%3D"+target.dialog.id.remote_tag+"%3Bfrom-tag%3D"+target.dialog.id.local_tag+">"}else{try{target=SIP.Grammar.parse(target,"Refer_To").uri||target}catch(e){this.logger.debug(".refer() cannot parse Refer_To from",target);this.logger.debug("...falling through to normalizeTarget()")}target=this.ua.normalizeTarget(target);if(!target){throw new TypeError("Invalid target: "+originalTarget)}}extraHeaders.push("Contact: "+this.contact);extraHeaders.push("Allow: "+SIP.UA.C.ALLOWED_METHODS.toString());extraHeaders.push("Refer-To: "+target);this.sendRequest(SIP.C.REFER,{extraHeaders:extraHeaders,body:options.body,receiveResponse:function(response){if(!/^2[0-9]{2}$/.test(response.status_code)){return}if(withReplaces||target.scheme&&target.scheme.match("^sips?$")){this.terminate()}}.bind(this)});return this},followRefer:function followRefer(callback){return function referListener(callback,request){var referTo=request.parseHeader("refer-to");var target=referTo.uri;if(!target.scheme.match("^sips?$")){var targetString=target.toString();if(typeof environment.open==="function"){environment.open(targetString)}else{this.logger.warn("referred to non-SIP URI but `open` isn't in the environment: "+targetString)}return}var extraHeaders=[];var replaces=target.getHeader("Replaces");if(replaces!==undefined){extraHeaders.push("Replaces: "+decodeURIComponent(replaces))}target.clearHeaders();var getReferMedia=this.mediaHandler.getReferMedia;var mediaHint=getReferMedia?getReferMedia.call(this.mediaHandler):this.mediaHint;SIP.Hacks.Chrome.getsConfusedAboutGUM(this);var referSession=this.ua.invite(target,{media:mediaHint,params:{to_displayName:referTo.friendlyName},extraHeaders:extraHeaders});callback.call(this,request,referSession);this.terminate()}.bind(this,callback)},sendRequest:function(method,options){options=options||{};var self=this;var request=new SIP.OutgoingRequest(method,this.dialog.remote_target,this.ua,{cseq:options.cseq||(this.dialog.local_seqnum+=1),call_id:this.dialog.id.call_id,from_uri:this.dialog.local_uri,from_tag:this.dialog.id.local_tag,to_uri:this.dialog.remote_uri,to_tag:this.dialog.id.remote_tag,route_set:this.dialog.route_set,statusCode:options.statusCode,reasonPhrase:options.reasonPhrase},options.extraHeaders||[],options.body);new SIP.RequestSender({request:request,onRequestTimeout:function(){self.onRequestTimeout()},onTransportError:function(){self.onTransportError()},receiveResponse:options.receiveResponse||function(response){self.receiveNonInviteResponse(response)}},this.ua).send();this.emit(method.toLowerCase(),request);return this},close:function(){var idx;if(this.status===C.STATUS_TERMINATED){return this}this.logger.log("closing INVITE session "+this.id);if(this.mediaHandler){this.mediaHandler.close()}for(idx in this.timers){SIP.Timers.clearTimeout(this.timers[idx])}if(this.dialog){this.dialog.terminate();delete this.dialog}for(idx in this.earlyDialogs){this.earlyDialogs[idx].terminate();delete this.earlyDialogs[idx]}this.status=C.STATUS_TERMINATED;delete this.ua.sessions[this.id];return this},createDialog:function(message,type,early){var dialog,early_dialog,local_tag=message[type==="UAS"?"to_tag":"from_tag"],remote_tag=message[type==="UAS"?"from_tag":"to_tag"],id=message.call_id+local_tag+remote_tag;early_dialog=this.earlyDialogs[id];if(early){if(early_dialog){return true}else{early_dialog=new SIP.Dialog(this,message,type,SIP.Dialog.C.STATUS_EARLY);if(early_dialog.error){this.logger.error(early_dialog.error);this.failed(message,SIP.C.causes.INTERNAL_ERROR);return false}else{this.earlyDialogs[id]=early_dialog;return true}}}else{if(early_dialog){early_dialog.update(message,type);this.dialog=early_dialog;delete this.earlyDialogs[id];for(var dia in this.earlyDialogs){this.earlyDialogs[dia].terminate();delete this.earlyDialogs[dia]}return true}dialog=new SIP.Dialog(this,message,type);if(dialog.error){this.logger.error(dialog.error);this.failed(message,SIP.C.causes.INTERNAL_ERROR);return false}else{this.to_tag=message.to_tag;this.dialog=dialog;return true}}},isReadyToReinvite:function(){return this.mediaHandler.isReady()&&!this.dialog.uac_pending_reply&&!this.dialog.uas_pending_reply},mute:function(options){var ret=this.mediaHandler.mute(options);if(ret){this.onmute(ret)}},unmute:function(options){var ret=this.mediaHandler.unmute(options);if(ret){this.onunmute(ret)}},hold:function(){if(this.status!==C.STATUS_WAITING_FOR_ACK&&this.status!==C.STATUS_CONFIRMED){throw new SIP.Exceptions.InvalidStateError(this.status)}this.mediaHandler.hold();if(!this.isReadyToReinvite()){if(this.pending_actions.isPending("unhold")){this.pending_actions.pop("unhold")}else if(!this.pending_actions.isPending("hold")){this.pending_actions.push("hold")}return}else if(this.local_hold===true){return}this.onhold("local");this.sendReinvite()},unhold:function(options){if(this.status!==C.STATUS_WAITING_FOR_ACK&&this.status!==C.STATUS_CONFIRMED){throw new SIP.Exceptions.InvalidStateError(this.status)}this.mediaHandler.unhold();if(!this.isReadyToReinvite()){if(this.pending_actions.isPending("hold")){this.pending_actions.pop("hold")}else if(!this.pending_actions.isPending("unhold")){this.pending_actions.push("unhold")}return}else if(this.local_hold===false){return}this.onunhold("local");this.sendReinvite(options)},isOnHold:function(){return{local:this.local_hold,remote:this.remote_hold}},receiveReinvite:function(request){var self=this;if(!this.mediaHandler.hasDescription(request)){this.logger.warn("invalid Content-Type");request.reply(415);return}this.mediaHandler.setDescription(request).then(this.mediaHandler.getDescription.bind(this.mediaHandler,this.mediaHint)).then(function(description){var extraHeaders=["Contact: "+self.contact];request.reply(200,null,extraHeaders,description,function(){self.status=C.STATUS_WAITING_FOR_ACK;self.setInvite2xxTimer(request,description);self.setACKTimer();if(self.remote_hold&&!self.mediaHandler.remote_hold){self.onunhold("remote")}else if(!self.remote_hold&&self.mediaHandler.remote_hold){self.onhold("remote")}})}).catch(function onFailure(e){var statusCode;if(e instanceof SIP.Exceptions.GetDescriptionError){statusCode=500}else{self.logger.error(e);statusCode=488}request.reply(statusCode)})},sendReinvite:function(options){options=options||{};var self=this,extraHeaders=(options.extraHeaders||[]).slice(),eventHandlers=options.eventHandlers||{},succeeded;if(eventHandlers.succeeded){succeeded=eventHandlers.succeeded}this.reinviteSucceeded=function(){SIP.Timers.clearTimeout(self.timers.ackTimer);SIP.Timers.clearTimeout(self.timers.invite2xxTimer);self.status=C.STATUS_CONFIRMED;succeeded&&succeeded.apply(this,arguments)};if(eventHandlers.failed){this.reinviteFailed=eventHandlers.failed}else{this.reinviteFailed=function(){}}extraHeaders.push("Contact: "+this.contact);extraHeaders.push("Allow: "+SIP.UA.C.ALLOWED_METHODS.toString());this.receiveResponse=this.receiveReinviteResponse;this.mediaHandler.getDescription(self.mediaHint).then(function(description){self.dialog.sendRequest(self,SIP.C.INVITE,{extraHeaders:extraHeaders,body:description})},function(){if(self.isReadyToReinvite()){self.onReadyToReinvite()}self.reinviteFailed()})},receiveRequest:function(request){switch(request.method){case SIP.C.BYE:request.reply(200);if(this.status===C.STATUS_CONFIRMED){this.emit("bye",request);this.terminated(request,SIP.C.causes.BYE)}break;case SIP.C.INVITE:if(this.status===C.STATUS_CONFIRMED){this.logger.log("re-INVITE received");this.receiveReinvite(request)}break;case SIP.C.INFO:if(this.status===C.STATUS_1XX_RECEIVED||this.status===C.STATUS_WAITING_FOR_PRACK||this.status===C.STATUS_WAITING_FOR_ACK||this.status===C.STATUS_ANSWERED_WAITING_FOR_PRACK||this.status===C.STATUS_EARLY_MEDIA||this.status===C.STATUS_CONFIRMED||this.dialog){if(this.onInfo){return this.onInfo(request)}var body,tone,duration,contentType=request.getHeader("content-type"),reg_tone=/^(Signal\s*?=\s*?)([0-9A-D#*]{1})(\s)?.*/,reg_duration=/^(Duration\s?=\s?)([0-9]{1,4})(\s)?.*/;if(contentType){if(contentType.match(/^application\/dtmf-relay/i)){if(request.body){body=request.body.split("\r\n",2);if(body.length===2){if(reg_tone.test(body[0])){tone=body[0].replace(reg_tone,"$2")}if(reg_duration.test(body[1])){duration=parseInt(body[1].replace(reg_duration,"$2"),10)}}}new DTMF(this,tone,{duration:duration}).init_incoming(request)}else{request.reply(415,null,["Accept: application/dtmf-relay"])}}}break;case SIP.C.REFER:if(this.status===C.STATUS_CONFIRMED){this.logger.log("REFER received");var hasReferListener=this.listeners("refer").length,notifyBody;if(hasReferListener){request.reply(202,"Accepted");notifyBody="SIP/2.0 100 Trying";this.sendRequest(SIP.C.NOTIFY,{extraHeaders:["Event: refer","Subscription-State: terminated","Content-Type: message/sipfrag"],body:notifyBody,receiveResponse:function(){}});this.emit("refer",request)}else{request.reply(603,"Declined")}}break;case SIP.C.NOTIFY:request.reply(200,"OK");this.emit("notify",request);break}},receiveReinviteResponse:function(response){var self=this;if(this.status===C.STATUS_TERMINATED){return}switch(true){case/^1[0-9]{2}$/.test(response.status_code):break;case/^2[0-9]{2}$/.test(response.status_code):this.status=C.STATUS_CONFIRMED;this.sendRequest(SIP.C.ACK,{cseq:response.cseq});if(!this.mediaHandler.hasDescription(response)){this.reinviteFailed();break}this.mediaHandler.setDescription(response).then(function onSuccess(){self.reinviteSucceeded()},function onFailure(){self.reinviteFailed()});break;default:this.reinviteFailed()}},acceptAndTerminate:function(response,status_code,reason_phrase){var extraHeaders=[];if(status_code){extraHeaders.push("Reason: "+SIP.Utils.getReasonHeaderValue(status_code,reason_phrase))}if(this.dialog||this.createDialog(response,"UAC")){this.sendRequest(SIP.C.ACK,{cseq:response.cseq});this.sendRequest(SIP.C.BYE,{extraHeaders:extraHeaders})}return this},setInvite2xxTimer:function(request,description){var self=this,timeout=SIP.Timers.T1;this.timers.invite2xxTimer=SIP.Timers.setTimeout(function invite2xxRetransmission(){if(self.status!==C.STATUS_WAITING_FOR_ACK){return}self.logger.log("no ACK received, attempting to retransmit OK");var extraHeaders=["Contact: "+self.contact];request.reply(200,null,extraHeaders,description);timeout=Math.min(timeout*2,SIP.Timers.T2);self.timers.invite2xxTimer=SIP.Timers.setTimeout(invite2xxRetransmission,timeout)},timeout)},setACKTimer:function(){var self=this;this.timers.ackTimer=SIP.Timers.setTimeout(function(){if(self.status===C.STATUS_WAITING_FOR_ACK){self.logger.log("no ACK received for an extended period of time, terminating the call");SIP.Timers.clearTimeout(self.timers.invite2xxTimer);self.sendRequest(SIP.C.BYE);self.terminated(null,SIP.C.causes.NO_ACK)}},SIP.Timers.TIMER_H)},onReadyToReinvite:function(){var action=this.pending_actions.shift();if(!action||!this[action.name]){return}this[action.name]()},onTransportError:function(){if(this.status!==C.STATUS_CONFIRMED&&this.status!==C.STATUS_TERMINATED){this.failed(null,SIP.C.causes.CONNECTION_ERROR)}},onRequestTimeout:function(){if(this.status===C.STATUS_CONFIRMED){this.terminated(null,SIP.C.causes.REQUEST_TIMEOUT)}else if(this.status!==C.STATUS_TERMINATED){this.failed(null,SIP.C.causes.REQUEST_TIMEOUT);this.terminated(null,SIP.C.causes.REQUEST_TIMEOUT)}},onDialogError:function(response){if(this.status===C.STATUS_CONFIRMED){this.terminated(response,SIP.C.causes.DIALOG_ERROR)}else if(this.status!==C.STATUS_TERMINATED){this.failed(response,SIP.C.causes.DIALOG_ERROR);this.terminated(response,SIP.C.causes.DIALOG_ERROR)}},onhold:function(originator){this[originator==="local"?"local_hold":"remote_hold"]=true;this.emit("hold",{originator:originator})},onunhold:function(originator){this[originator==="local"?"local_hold":"remote_hold"]=false;this.emit("unhold",{originator:originator})},onmute:function(options){this.emit("muted",{audio:options.audio,video:options.video})},onunmute:function(options){this.emit("unmuted",{audio:options.audio,video:options.video})},failed:function(response,cause){if(this.status===C.STATUS_TERMINATED){return this}this.emit("failed",response||null,cause||null);return this},rejected:function(response,cause){this.emit("rejected",response||null,cause||null);return this},canceled:function(){this.emit("cancel");return this},accepted:function(response,cause){cause=SIP.Utils.getReasonPhrase(response&&response.status_code,cause);this.startTime=new Date;if(this.replacee){this.replacee.emit("replaced",this);this.replacee.terminate()}if(response){RFC4028.updateState(this.dialog,response,SIP.Parser.parseMessage,this.ua)}this.emit("accepted",response,cause);return this},terminated:function(message,cause){if(this.status===C.STATUS_TERMINATED){return this}this.endTime=new Date;this.close();this.emit("terminated",message||null,cause||null);return this},connecting:function(request){this.emit("connecting",{request:request});return this}};Session.desugar=function desugar(options){if(environment.HTMLMediaElement&&options instanceof environment.HTMLMediaElement){options={media:{constraints:{audio:true,video:options.tagName==="VIDEO"},render:{remote:options}}}}return options||{}};Session.C=C;SIP.Session=Session;InviteServerContext=function(ua,request){var expires,self=this,contentType=request.getHeader("Content-Type"),contentDisp=request.parseHeader("Content-Disposition");SIP.Utils.augment(this,SIP.ServerContext,[ua,request]);SIP.Utils.augment(this,SIP.Session,[ua.configuration.mediaHandlerFactory]);this.mediaHandler=this.mediaHandlerFactory(this,{RTCConstraints:{optional:[{DtlsSrtpKeyAgreement:"true"}]}});if(!contentDisp&&!this.mediaHandler.hasDescription(request)||contentDisp&&contentDisp.type==="render"){this.renderbody=request.body;this.rendertype=contentType}else if(!this.mediaHandler.hasDescription(request)&&(contentDisp&&contentDisp.type==="session")){request.reply(415);return}if(RFC4028.hasSmallMinSE(request)){request.reply(422,null,["Min-SE: "+RFC4028.localMinSE]);return}this.status=C.STATUS_INVITE_RECEIVED;this.from_tag=request.from_tag;this.id=request.call_id+this.from_tag;this.request=request;this.contact=this.ua.contact.toString();this.receiveNonInviteResponse=function(){};this.logger=ua.getLogger("sip.inviteservercontext",this.id);this.ua.sessions[this.id]=this;if(request.hasHeader("expires")){expires=request.getHeader("expires")*1e3}function set100rel(h,c){if(request.hasHeader(h)&&request.getHeader(h).toLowerCase().indexOf("100rel")>=0){self.rel100=c}}set100rel("require",SIP.C.supported.REQUIRED);set100rel("supported",SIP.C.supported.SUPPORTED);request.to_tag=SIP.Utils.newTag();if(!this.createDialog(request,"UAS",true)){request.reply(500,"Missing Contact header field");return}if(this.mediaHandler&&this.mediaHandler.getRemoteStreams){this.getRemoteStreams=this.mediaHandler.getRemoteStreams.bind(this.mediaHandler);this.getLocalStreams=this.mediaHandler.getLocalStreams.bind(this.mediaHandler)}function fireNewSession(){var options={extraHeaders:["Contact: "+self.contact]};if(self.rel100!==SIP.C.supported.REQUIRED){self.progress(options)}self.status=C.STATUS_WAITING_FOR_ANSWER;self.timers.userNoAnswerTimer=SIP.Timers.setTimeout(function(){request.reply(408);self.failed(request,SIP.C.causes.NO_ANSWER);self.terminated(request,SIP.C.causes.NO_ANSWER)},self.ua.configuration.noAnswerTimeout);if(expires){self.timers.expiresTimer=SIP.Timers.setTimeout(function(){if(self.status===C.STATUS_WAITING_FOR_ANSWER){request.reply(487);self.failed(request,SIP.C.causes.EXPIRES);self.terminated(request,SIP.C.causes.EXPIRES)}},expires)}self.emit("invite",request)}if(!this.mediaHandler.hasDescription(request)||this.renderbody){SIP.Timers.setTimeout(fireNewSession,0)}else{this.hasOffer=true;this.mediaHandler.setDescription(request).then(fireNewSession,function onFailure(e){self.logger.warn("invalid description");self.logger.warn(e);request.reply(488)})}};InviteServerContext.prototype={reject:function(options){if(this.status===C.STATUS_TERMINATED){throw new SIP.Exceptions.InvalidStateError(this.status)}this.logger.log("rejecting RTCSession");SIP.ServerContext.prototype.reject.call(this,options);return this.terminated()},terminate:function(options){options=options||{};var extraHeaders=(options.extraHeaders||[]).slice(),body=options.body,dialog,self=this;if(this.status===C.STATUS_WAITING_FOR_ACK&&this.request.server_transaction.state!==SIP.Transactions.C.STATUS_TERMINATED){dialog=this.dialog;this.receiveRequest=function(request){if(request.method===SIP.C.ACK){this.sendRequest(SIP.C.BYE,{extraHeaders:extraHeaders,body:body});dialog.terminate()}};this.request.server_transaction.on("stateChanged",function(){if(this.state===SIP.Transactions.C.STATUS_TERMINATED&&this.dialog){this.request=new SIP.OutgoingRequest(SIP.C.BYE,this.dialog.remote_target,this.ua,{cseq:this.dialog.local_seqnum+=1,call_id:this.dialog.id.call_id,from_uri:this.dialog.local_uri,from_tag:this.dialog.id.local_tag,to_uri:this.dialog.remote_uri,to_tag:this.dialog.id.remote_tag,route_set:this.dialog.route_set},extraHeaders,body);new SIP.RequestSender({request:this.request,onRequestTimeout:function(){self.onRequestTimeout()},onTransportError:function(){self.onTransportError()},receiveResponse:function(){return}},this.ua).send();dialog.terminate()}});this.emit("bye",this.request);this.terminated();this.dialog=dialog;this.ua.dialogs[dialog.id.toString()]=dialog}else if(this.status===C.STATUS_CONFIRMED){this.bye(options)}else{this.reject(options)}return this},progress:function(options){options=options||{};var statusCode=options.statusCode||180,reasonPhrase=options.reasonPhrase,extraHeaders=(options.extraHeaders||[]).slice(),iceServers,stunServers=options.stunServers||null,turnServers=options.turnServers||null,body=options.body,response;if(statusCode<100||statusCode>199){throw new TypeError("Invalid statusCode: "+statusCode)}if(this.isCanceled||this.status===C.STATUS_TERMINATED){return this}if(stunServers||turnServers){if(stunServers){iceServers=SIP.UA.configuration_check.optional["stunServers"](stunServers);if(!iceServers){throw new TypeError("Invalid stunServers: "+stunServers)}else{this.stunServers=iceServers}}if(turnServers){iceServers=SIP.UA.configuration_check.optional["turnServers"](turnServers);if(!iceServers){throw new TypeError("Invalid turnServers: "+turnServers)}else{this.turnServers=iceServers}}this.mediaHandler.updateIceServers({stunServers:this.stunServers,turnServers:this.turnServers})}function do100rel(){statusCode=options.statusCode||183;this.status=C.STATUS_WAITING_FOR_PRACK;extraHeaders.push("Contact: "+this.contact);extraHeaders.push("Require: 100rel");extraHeaders.push("RSeq: "+Math.floor(Math.random()*1e4));this.mediaHint=options.media;this.mediaHandler.getDescription(options.media).then(function onSuccess(description){if(this.isCanceled||this.status===C.STATUS_TERMINATED){return}this.early_sdp=description.body;this[this.hasOffer?"hasAnswer":"hasOffer"]=true;var timeout=SIP.Timers.T1;this.timers.rel1xxTimer=SIP.Timers.setTimeout(function rel1xxRetransmission(){this.request.reply(statusCode,null,extraHeaders,description);timeout*=2;this.timers.rel1xxTimer=SIP.Timers.setTimeout(rel1xxRetransmission.bind(this),timeout)}.bind(this),timeout);this.timers.prackTimer=SIP.Timers.setTimeout(function(){if(this.status!==C.STATUS_WAITING_FOR_PRACK){return}this.logger.log("no PRACK received, rejecting the call");SIP.Timers.clearTimeout(this.timers.rel1xxTimer);this.request.reply(504);this.terminated(null,SIP.C.causes.NO_PRACK)}.bind(this),SIP.Timers.T1*64);response=this.request.reply(statusCode,reasonPhrase,extraHeaders,description);this.emit("progress",response,reasonPhrase)}.bind(this),function onFailure(){this.request.reply(480);this.failed(null,SIP.C.causes.WEBRTC_ERROR);this.terminated(null,SIP.C.causes.WEBRTC_ERROR)}.bind(this))}function normalReply(){response=this.request.reply(statusCode,reasonPhrase,extraHeaders,body);this.emit("progress",response,reasonPhrase)}if(options.statusCode!==100&&(this.rel100===SIP.C.supported.REQUIRED||this.rel100===SIP.C.supported.SUPPORTED&&options.rel100||this.rel100===SIP.C.supported.SUPPORTED&&this.ua.configuration.rel100===SIP.C.supported.REQUIRED)){do100rel.apply(this)}else{normalReply.apply(this)}return this},accept:function(options){options=Object.create(Session.desugar(options));SIP.Utils.optionsOverride(options,"media","mediaConstraints",true,this.logger,this.ua.configuration.media);this.mediaHint=options.media;this.onInfo=options.onInfo;var self=this,request=this.request,extraHeaders=(options.extraHeaders||[]).slice(),iceServers,stunServers=options.stunServers||null,turnServers=options.turnServers||null,descriptionCreationSucceeded=function(description){var response,replySucceeded=function(){self.status=C.STATUS_WAITING_FOR_ACK;self.setInvite2xxTimer(request,description);self.setACKTimer()},replyFailed=function(){self.failed(null,SIP.C.causes.CONNECTION_ERROR);self.terminated(null,SIP.C.causes.CONNECTION_ERROR)};self.mediaHandler.render();extraHeaders.push("Contact: "+self.contact);extraHeaders.push("Allow: "+SIP.UA.C.ALLOWED_METHODS.toString());var supportedOptions=request.parseHeader("Supported")||[];var sessionExpires=request.parseHeader("Session-Expires")||{};var interval=sessionExpires.deltaSeconds;if(interval){var refresher=sessionExpires.refresher||"uas";extraHeaders.push("Session-Expires: "+interval+";"+refresher);if(refresher==="uac"||supportedOptions.indexOf("timer")>=0){extraHeaders.push("Require: timer")}}if(!self.hasOffer){self.hasOffer=true}else{self.hasAnswer=true}response=request.reply(200,null,extraHeaders,description,replySucceeded,replyFailed);if(self.status!==C.STATUS_TERMINATED){self.accepted(response,SIP.Utils.getReasonPhrase(200))}},descriptionCreationFailed=function(){if(self.status===C.STATUS_TERMINATED){return}self.request.reply(480);self.failed(null,SIP.C.causes.WEBRTC_ERROR);self.terminated(null,SIP.C.causes.WEBRTC_ERROR)};if(this.status===C.STATUS_WAITING_FOR_PRACK){this.status=C.STATUS_ANSWERED_WAITING_FOR_PRACK;return this}else if(this.status===C.STATUS_WAITING_FOR_ANSWER){this.status=C.STATUS_ANSWERED}else if(this.status!==C.STATUS_EARLY_MEDIA){throw new SIP.Exceptions.InvalidStateError(this.status)}if((stunServers||turnServers)&&(this.status!==C.STATUS_EARLY_MEDIA&&this.status!==C.STATUS_ANSWERED_WAITING_FOR_PRACK)){if(stunServers){iceServers=SIP.UA.configuration_check.optional["stunServers"](stunServers);if(!iceServers){throw new TypeError("Invalid stunServers: "+stunServers)}else{this.stunServers=iceServers}}if(turnServers){iceServers=SIP.UA.configuration_check.optional["turnServers"](turnServers);if(!iceServers){throw new TypeError("Invalid turnServers: "+turnServers)}else{this.turnServers=iceServers}}this.mediaHandler.updateIceServers({stunServers:this.stunServers,turnServers:this.turnServers})}if(!this.createDialog(request,"UAS")){request.reply(500,"Missing Contact header field");return this}SIP.Timers.clearTimeout(this.timers.userNoAnswerTimer);if(this.status===C.STATUS_EARLY_MEDIA){descriptionCreationSucceeded({})}else{this.mediaHandler.getDescription(self.mediaHint).then(descriptionCreationSucceeded,descriptionCreationFailed)}return this},receiveRequest:function(request){function confirmSession(){var contentType;SIP.Timers.clearTimeout(this.timers.ackTimer);SIP.Timers.clearTimeout(this.timers.invite2xxTimer);this.status=C.STATUS_CONFIRMED;this.unmute();contentType=request.getHeader("Content-Type");if(!this.mediaHandler.hasDescription(request)){this.renderbody=request.body;this.rendertype=contentType}this.emit("confirmed",request)}switch(request.method){case SIP.C.CANCEL:if(this.status===C.STATUS_WAITING_FOR_ANSWER||this.status===C.STATUS_WAITING_FOR_PRACK||this.status===C.STATUS_ANSWERED_WAITING_FOR_PRACK||this.status===C.STATUS_EARLY_MEDIA||this.status===C.STATUS_ANSWERED){this.status=C.STATUS_CANCELED;this.request.reply(487);this.canceled(request);this.rejected(request,SIP.C.causes.CANCELED);this.failed(request,SIP.C.causes.CANCELED);this.terminated(request,SIP.C.causes.CANCELED)}break;case SIP.C.ACK:if(this.status===C.STATUS_WAITING_FOR_ACK){if(!this.hasAnswer){if(this.mediaHandler.hasDescription(request)){this.hasAnswer=true;this.mediaHandler.setDescription(request).then(confirmSession.bind(this),function onFailure(e){this.logger.warn(e);this.terminate({statusCode:"488",reasonPhrase:"Bad Media Description"});this.failed(request,SIP.C.causes.BAD_MEDIA_DESCRIPTION);this.terminated(request,SIP.C.causes.BAD_MEDIA_DESCRIPTION)}.bind(this))}else if(this.early_sdp){confirmSession.apply(this)}else{this.failed(request,SIP.C.causes.BAD_MEDIA_DESCRIPTION);this.terminated(request,SIP.C.causes.BAD_MEDIA_DESCRIPTION)}}else{confirmSession.apply(this)}}break;case SIP.C.PRACK:if(this.status===C.STATUS_WAITING_FOR_PRACK||this.status===C.STATUS_ANSWERED_WAITING_FOR_PRACK){if(!this.hasAnswer){if(this.mediaHandler.hasDescription(request)){this.hasAnswer=true;this.mediaHandler.setDescription(request).then(function onSuccess(){SIP.Timers.clearTimeout(this.timers.rel1xxTimer);SIP.Timers.clearTimeout(this.timers.prackTimer);request.reply(200);if(this.status===C.STATUS_ANSWERED_WAITING_FOR_PRACK){this.status=C.STATUS_EARLY_MEDIA;this.accept()}this.status=C.STATUS_EARLY_MEDIA;this.mute()}.bind(this),function onFailure(e){this.logger.warn(e);this.terminate({statusCode:"488",reasonPhrase:"Bad Media Description"});this.failed(request,SIP.C.causes.BAD_MEDIA_DESCRIPTION);this.terminated(request,SIP.C.causes.BAD_MEDIA_DESCRIPTION)}.bind(this))}else{this.terminate({statusCode:"488",reasonPhrase:"Bad Media Description"});this.failed(request,SIP.C.causes.BAD_MEDIA_DESCRIPTION);this.terminated(request,SIP.C.causes.BAD_MEDIA_DESCRIPTION)}}else{SIP.Timers.clearTimeout(this.timers.rel1xxTimer);SIP.Timers.clearTimeout(this.timers.prackTimer);request.reply(200);if(this.status===C.STATUS_ANSWERED_WAITING_FOR_PRACK){this.status=C.STATUS_EARLY_MEDIA;this.accept()}this.status=C.STATUS_EARLY_MEDIA;this.mute()}}else if(this.status===C.STATUS_EARLY_MEDIA){request.reply(200)}break;default:Session.prototype.receiveRequest.apply(this,[request]);break}},onTransportError:function(){if(this.status!==C.STATUS_CONFIRMED&&this.status!==C.STATUS_TERMINATED){this.failed(null,SIP.C.causes.CONNECTION_ERROR)}},onRequestTimeout:function(){if(this.status===C.STATUS_CONFIRMED){this.terminated(null,SIP.C.causes.REQUEST_TIMEOUT)}else if(this.status!==C.STATUS_TERMINATED){this.failed(null,SIP.C.causes.REQUEST_TIMEOUT);this.terminated(null,SIP.C.causes.REQUEST_TIMEOUT)}}};SIP.InviteServerContext=InviteServerContext;InviteClientContext=function(ua,target,options){options=Object.create(Session.desugar(options));options.params=Object.create(options.params||Object.prototype)
    ;var iceServers,extraHeaders=(options.extraHeaders||[]).slice(),stunServers=options.stunServers||null,turnServers=options.turnServers||null,mediaHandlerFactory=options.mediaHandlerFactory||ua.configuration.mediaHandlerFactory,isMediaSupported=mediaHandlerFactory.isSupported;if(isMediaSupported&&!isMediaSupported()){throw new SIP.Exceptions.NotSupportedError("Media not supported")}this.RTCConstraints=options.RTCConstraints||{};this.inviteWithoutSdp=options.inviteWithoutSdp||false;this.anonymous=options.anonymous||false;this.renderbody=options.renderbody||null;this.rendertype=options.rendertype||"text/plain";options.params.from_tag=this.from_tag;this.contact=ua.contact.toString({anonymous:this.anonymous,outbound:this.anonymous?!ua.contact.temp_gruu:!ua.contact.pub_gruu});if(this.anonymous){options.params.from_displayName="Anonymous";options.params.from_uri="sip:anonymous@anonymous.invalid";extraHeaders.push("P-Preferred-Identity: "+ua.configuration.uri.toString());extraHeaders.push("Privacy: id")}extraHeaders.push("Contact: "+this.contact);extraHeaders.push("Allow: "+SIP.UA.C.ALLOWED_METHODS.toString());if(this.inviteWithoutSdp&&this.renderbody){extraHeaders.push("Content-Type: "+this.rendertype);extraHeaders.push("Content-Disposition: render;handling=optional")}if(ua.configuration.rel100===SIP.C.supported.REQUIRED){extraHeaders.push("Require: 100rel")}if(ua.configuration.replaces===SIP.C.supported.REQUIRED){extraHeaders.push("Require: replaces")}options.extraHeaders=extraHeaders;SIP.Utils.augment(this,SIP.ClientContext,[ua,SIP.C.INVITE,target,options]);SIP.Utils.augment(this,SIP.Session,[mediaHandlerFactory]);if(this.status!==C.STATUS_NULL){throw new SIP.Exceptions.InvalidStateError(this.status)}this.from_tag=SIP.Utils.newTag();this.isCanceled=false;this.received_100=false;this.method=SIP.C.INVITE;this.receiveNonInviteResponse=this.receiveResponse;this.receiveResponse=this.receiveInviteResponse;this.logger=ua.getLogger("sip.inviteclientcontext");if(stunServers){iceServers=SIP.UA.configuration_check.optional["stunServers"](stunServers);if(!iceServers){throw new TypeError("Invalid stunServers: "+stunServers)}else{this.stunServers=iceServers}}if(turnServers){iceServers=SIP.UA.configuration_check.optional["turnServers"](turnServers);if(!iceServers){throw new TypeError("Invalid turnServers: "+turnServers)}else{this.turnServers=iceServers}}ua.applicants[this]=this;this.id=this.request.call_id+this.from_tag;this.mediaHandler=this.mediaHandlerFactory(this,{RTCConstraints:this.RTCConstraints,stunServers:this.stunServers,turnServers:this.turnServers});if(this.mediaHandler&&this.mediaHandler.getRemoteStreams){this.getRemoteStreams=this.mediaHandler.getRemoteStreams.bind(this.mediaHandler);this.getLocalStreams=this.mediaHandler.getLocalStreams.bind(this.mediaHandler)}SIP.Utils.optionsOverride(options,"media","mediaConstraints",true,this.logger,this.ua.configuration.media);this.mediaHint=options.media;this.onInfo=options.onInfo};InviteClientContext.prototype={invite:function(){var self=this;this.ua.sessions[this.id]=this;if(this.inviteWithoutSdp){this.request.body=self.renderbody;this.status=C.STATUS_INVITE_SENT;this.send()}else{this.mediaHandler.getDescription(self.mediaHint).then(function onSuccess(description){if(self.isCanceled||self.status===C.STATUS_TERMINATED){return}self.hasOffer=true;self.request.body=description;self.status=C.STATUS_INVITE_SENT;self.send()},function onFailure(){if(self.status===C.STATUS_TERMINATED){return}self.failed(null,SIP.C.causes.WEBRTC_ERROR);self.terminated(null,SIP.C.causes.WEBRTC_ERROR)})}return this},receiveInviteResponse:function(response){var cause,session=this,id=response.call_id+response.from_tag+response.to_tag,extraHeaders=[],options={};if(this.status===C.STATUS_TERMINATED||response.method!==SIP.C.INVITE){return}if(this.dialog&&(response.status_code>=200&&response.status_code<=299)){if(id!==this.dialog.id.toString()){if(!this.createDialog(response,"UAC",true)){return}this.earlyDialogs[id].sendRequest(this,SIP.C.ACK,{body:SIP.Utils.generateFakeSDP(response.body)});this.earlyDialogs[id].sendRequest(this,SIP.C.BYE);if(this.status!==C.STATUS_CONFIRMED){this.failed(response,SIP.C.causes.WEBRTC_ERROR);this.terminated(response,SIP.C.causes.WEBRTC_ERROR)}return}else if(this.status===C.STATUS_CONFIRMED){this.sendRequest(SIP.C.ACK,{cseq:response.cseq});return}else if(!this.hasAnswer){return}}if(this.dialog&&response.status_code<200){if(this.dialog.pracked.indexOf(response.getHeader("rseq"))!==-1||this.dialog.pracked[this.dialog.pracked.length-1]>=response.getHeader("rseq")&&this.dialog.pracked.length>0){return}if(!this.earlyDialogs[id]&&!this.createDialog(response,"UAC",true)){return}if(this.earlyDialogs[id].pracked.indexOf(response.getHeader("rseq"))!==-1||this.earlyDialogs[id].pracked[this.earlyDialogs[id].pracked.length-1]>=response.getHeader("rseq")&&this.earlyDialogs[id].pracked.length>0){return}extraHeaders.push("RAck: "+response.getHeader("rseq")+" "+response.getHeader("cseq"));this.earlyDialogs[id].pracked.push(response.getHeader("rseq"));this.earlyDialogs[id].sendRequest(this,SIP.C.PRACK,{extraHeaders:extraHeaders,body:SIP.Utils.generateFakeSDP(response.body)});return}if(this.isCanceled){if(response.status_code>=100&&response.status_code<200){this.request.cancel(this.cancelReason,extraHeaders);this.canceled(null)}else if(response.status_code>=200&&response.status_code<299){this.acceptAndTerminate(response);this.emit("bye",this.request)}else if(response.status_code>=300){cause=SIP.C.REASON_PHRASE[response.status_code]||SIP.C.causes.CANCELED;this.rejected(response,cause);this.failed(response,cause);this.terminated(response,cause)}return}switch(true){case/^100$/.test(response.status_code):this.received_100=true;this.emit("progress",response);break;case/^1[0-9]{2}$/.test(response.status_code):if(!response.to_tag){this.logger.warn("1xx response received without to tag");break}if(response.hasHeader("contact")){if(!this.createDialog(response,"UAC",true)){break}}this.status=C.STATUS_1XX_RECEIVED;if(response.hasHeader("require")&&response.getHeader("require").indexOf("100rel")!==-1){if(this.dialog||!this.earlyDialogs[id]){break}if(this.earlyDialogs[id].pracked.indexOf(response.getHeader("rseq"))!==-1||this.earlyDialogs[id].pracked[this.earlyDialogs[id].pracked.length-1]>=response.getHeader("rseq")&&this.earlyDialogs[id].pracked.length>0){return}if(!this.mediaHandler.hasDescription(response)){extraHeaders.push("RAck: "+response.getHeader("rseq")+" "+response.getHeader("cseq"));this.earlyDialogs[id].pracked.push(response.getHeader("rseq"));this.earlyDialogs[id].sendRequest(this,SIP.C.PRACK,{extraHeaders:extraHeaders});this.emit("progress",response)}else if(this.hasOffer){if(!this.createDialog(response,"UAC")){break}this.hasAnswer=true;this.dialog.pracked.push(response.getHeader("rseq"));this.mediaHandler.setDescription(response).then(function onSuccess(){extraHeaders.push("RAck: "+response.getHeader("rseq")+" "+response.getHeader("cseq"));session.sendRequest(SIP.C.PRACK,{extraHeaders:extraHeaders,receiveResponse:function(){}});session.status=C.STATUS_EARLY_MEDIA;session.mute();session.emit("progress",response)},function onFailure(e){session.logger.warn(e);session.acceptAndTerminate(response,488,"Not Acceptable Here");session.failed(response,SIP.C.causes.BAD_MEDIA_DESCRIPTION)})}else{var earlyDialog=this.earlyDialogs[id];var earlyMedia=earlyDialog.mediaHandler;earlyDialog.pracked.push(response.getHeader("rseq"));earlyMedia.setDescription(response).then(earlyMedia.getDescription.bind(earlyMedia,session.mediaHint)).then(function onSuccess(description){extraHeaders.push("RAck: "+response.getHeader("rseq")+" "+response.getHeader("cseq"));earlyDialog.sendRequest(session,SIP.C.PRACK,{extraHeaders:extraHeaders,body:description});session.status=C.STATUS_EARLY_MEDIA;session.emit("progress",response)}).catch(function onFailure(e){if(e instanceof SIP.Exceptions.GetDescriptionError){earlyDialog.pracked.push(response.getHeader("rseq"));if(session.status===C.STATUS_TERMINATED){return}session.failed(null,SIP.C.causes.WEBRTC_ERROR);session.terminated(null,SIP.C.causes.WEBRTC_ERROR)}else{earlyDialog.pracked.splice(earlyDialog.pracked.indexOf(response.getHeader("rseq")),1);session.logger.warn("invalid description");session.logger.warn(e)}})}}else{this.emit("progress",response)}break;case/^2[0-9]{2}$/.test(response.status_code):var cseq=this.request.cseq+" "+this.request.method;if(cseq!==response.getHeader("cseq")){break}if(this.status===C.STATUS_EARLY_MEDIA&&this.dialog){this.status=C.STATUS_CONFIRMED;this.unmute();options={};if(this.renderbody){extraHeaders.push("Content-Type: "+this.rendertype);options.extraHeaders=extraHeaders;options.body=this.renderbody}options.cseq=response.cseq;this.sendRequest(SIP.C.ACK,options);this.accepted(response);break}if(this.dialog){break}if(!this.hasOffer){if(this.earlyDialogs[id]&&this.earlyDialogs[id].mediaHandler.localMedia){this.hasOffer=true;this.hasAnswer=true;this.mediaHandler=this.earlyDialogs[id].mediaHandler;if(!this.createDialog(response,"UAC")){break}this.status=C.STATUS_CONFIRMED;this.sendRequest(SIP.C.ACK,{cseq:response.cseq});this.unmute();this.accepted(response)}else{if(!this.mediaHandler.hasDescription(response)){this.acceptAndTerminate(response,400,"Missing session description");this.failed(response,SIP.C.causes.BAD_MEDIA_DESCRIPTION);break}if(!this.createDialog(response,"UAC")){break}this.hasOffer=true;this.mediaHandler.setDescription(response).then(this.mediaHandler.getDescription.bind(this.mediaHandler,this.mediaHint)).then(function onSuccess(description){if(session.isCanceled||session.status===C.STATUS_TERMINATED){return}session.status=C.STATUS_CONFIRMED;session.hasAnswer=true;session.unmute();session.sendRequest(SIP.C.ACK,{body:description,cseq:response.cseq});session.accepted(response)}).catch(function onFailure(e){if(e instanceof SIP.Exceptions.GetDescriptionError){session.logger.warn("there was a problem")}else{session.logger.warn("invalid description");session.logger.warn(e);response.reply(488)}})}}else if(this.hasAnswer){if(this.renderbody){extraHeaders.push("Content-Type: "+session.rendertype);options.extraHeaders=extraHeaders;options.body=this.renderbody}this.sendRequest(SIP.C.ACK,options)}else{if(!this.mediaHandler.hasDescription(response)){this.acceptAndTerminate(response,400,"Missing session description");this.failed(response,SIP.C.causes.BAD_MEDIA_DESCRIPTION);break}if(!this.createDialog(response,"UAC")){break}this.hasAnswer=true;this.mediaHandler.setDescription(response).then(function onSuccess(){var options={};session.status=C.STATUS_CONFIRMED;session.unmute();if(session.renderbody){extraHeaders.push("Content-Type: "+session.rendertype);options.extraHeaders=extraHeaders;options.body=session.renderbody}options.cseq=response.cseq;session.sendRequest(SIP.C.ACK,options);session.accepted(response)},function onFailure(e){session.logger.warn(e);session.acceptAndTerminate(response,488,"Not Acceptable Here");session.failed(response,SIP.C.causes.BAD_MEDIA_DESCRIPTION)})}break;default:cause=SIP.Utils.sipErrorCause(response.status_code);this.rejected(response,cause);this.failed(response,cause);this.terminated(response,cause)}},cancel:function(options){options=options||{};options.extraHeaders=(options.extraHeaders||[]).slice();if(this.status===C.STATUS_TERMINATED||this.status===C.STATUS_CONFIRMED){throw new SIP.Exceptions.InvalidStateError(this.status)}this.logger.log("canceling RTCSession");var cancel_reason=SIP.Utils.getCancelReason(options.status_code,options.reason_phrase);if(this.status===C.STATUS_NULL||this.status===C.STATUS_INVITE_SENT&&!this.received_100){this.isCanceled=true;this.cancelReason=cancel_reason}else if(this.status===C.STATUS_INVITE_SENT||this.status===C.STATUS_1XX_RECEIVED||this.status===C.STATUS_EARLY_MEDIA){this.request.cancel(cancel_reason,options.extraHeaders)}return this.canceled()},terminate:function(options){if(this.status===C.STATUS_TERMINATED){return this}if(this.status===C.STATUS_WAITING_FOR_ACK||this.status===C.STATUS_CONFIRMED){this.bye(options)}else{this.cancel(options)}return this},receiveRequest:function(request){if(request.method===SIP.C.CANCEL){}if(request.method===SIP.C.ACK&&this.status===C.STATUS_WAITING_FOR_ACK){SIP.Timers.clearTimeout(this.timers.ackTimer);SIP.Timers.clearTimeout(this.timers.invite2xxTimer);this.status=C.STATUS_CONFIRMED;this.unmute();this.accepted()}return Session.prototype.receiveRequest.apply(this,[request])},onTransportError:function(){if(this.status!==C.STATUS_CONFIRMED&&this.status!==C.STATUS_TERMINATED){this.failed(null,SIP.C.causes.CONNECTION_ERROR)}},onRequestTimeout:function(){if(this.status===C.STATUS_CONFIRMED){this.terminated(null,SIP.C.causes.REQUEST_TIMEOUT)}else if(this.status!==C.STATUS_TERMINATED){this.failed(null,SIP.C.causes.REQUEST_TIMEOUT);this.terminated(null,SIP.C.causes.REQUEST_TIMEOUT)}}};SIP.InviteClientContext=InviteClientContext}},{"./RFC4028":141,"./Session/DTMF":149}],149:[function(require,module,exports){"use strict";module.exports=function(SIP){var DTMF,C={MIN_DURATION:70,MAX_DURATION:6e3,DEFAULT_DURATION:100,MIN_INTER_TONE_GAP:50,DEFAULT_INTER_TONE_GAP:500};DTMF=function(session,tone,options){var duration,interToneGap;if(tone===undefined){throw new TypeError("Not enough arguments")}this.logger=session.ua.getLogger("sip.invitecontext.dtmf",session.id);this.owner=session;this.direction=null;options=options||{};duration=options.duration||null;interToneGap=options.interToneGap||null;if(typeof tone==="string"){tone=tone.toUpperCase()}else if(typeof tone==="number"){tone=tone.toString()}else{throw new TypeError("Invalid tone: "+tone)}if(!tone.match(/^[0-9A-D#*]$/)){throw new TypeError("Invalid tone: "+tone)}else{this.tone=tone}if(duration&&!SIP.Utils.isDecimal(duration)){throw new TypeError("Invalid tone duration: "+duration)}else if(!duration){duration=DTMF.C.DEFAULT_DURATION}else if(duration<DTMF.C.MIN_DURATION){this.logger.warn('"duration" value is lower than the minimum allowed, setting it to '+DTMF.C.MIN_DURATION+" milliseconds");duration=DTMF.C.MIN_DURATION}else if(duration>DTMF.C.MAX_DURATION){this.logger.warn('"duration" value is greater than the maximum allowed, setting it to '+DTMF.C.MAX_DURATION+" milliseconds");duration=DTMF.C.MAX_DURATION}else{duration=Math.abs(duration)}this.duration=duration;if(interToneGap&&!SIP.Utils.isDecimal(interToneGap)){throw new TypeError("Invalid interToneGap: "+interToneGap)}else if(!interToneGap){interToneGap=DTMF.C.DEFAULT_INTER_TONE_GAP}else if(interToneGap<DTMF.C.MIN_INTER_TONE_GAP){this.logger.warn('"interToneGap" value is lower than the minimum allowed, setting it to '+DTMF.C.MIN_INTER_TONE_GAP+" milliseconds");interToneGap=DTMF.C.MIN_INTER_TONE_GAP}else{interToneGap=Math.abs(interToneGap)}this.interToneGap=interToneGap};DTMF.prototype=Object.create(SIP.EventEmitter.prototype);DTMF.prototype.send=function(options){var extraHeaders,body={};this.direction="outgoing";if(this.owner.status!==SIP.Session.C.STATUS_CONFIRMED&&this.owner.status!==SIP.Session.C.STATUS_WAITING_FOR_ACK){throw new SIP.Exceptions.InvalidStateError(this.owner.status)}options=options||{};extraHeaders=options.extraHeaders?options.extraHeaders.slice():[];body.contentType="application/dtmf-relay";body.body="Signal= "+this.tone+"\r\n";body.body+="Duration= "+this.duration;this.request=this.owner.dialog.sendRequest(this,SIP.C.INFO,{extraHeaders:extraHeaders,body:body});this.owner.emit("dtmf",this.request,this)};DTMF.prototype.receiveResponse=function(response){var cause;switch(true){case/^1[0-9]{2}$/.test(response.status_code):break;case/^2[0-9]{2}$/.test(response.status_code):this.emit("succeeded",{originator:"remote",response:response});break;default:cause=SIP.Utils.sipErrorCause(response.status_code);this.emit("failed",response,cause);break}};DTMF.prototype.onRequestTimeout=function(){this.emit("failed",null,SIP.C.causes.REQUEST_TIMEOUT);this.owner.onRequestTimeout()};DTMF.prototype.onTransportError=function(){this.emit("failed",null,SIP.C.causes.CONNECTION_ERROR);this.owner.onTransportError()};DTMF.prototype.onDialogError=function(response){this.emit("failed",response,SIP.C.causes.DIALOG_ERROR);this.owner.onDialogError(response)};DTMF.prototype.init_incoming=function(request){this.direction="incoming";this.request=request;request.reply(200);if(!this.tone||!this.duration){this.logger.warn("invalid INFO DTMF received, discarded")}else{this.owner.emit("dtmf",request,this)}};DTMF.C=C;return DTMF}},{}],150:[function(require,module,exports){"use strict";module.exports=function(SIP){SIP.Subscription=function(ua,target,event,options){options=Object.create(options||Object.prototype);this.extraHeaders=options.extraHeaders=(options.extraHeaders||[]).slice();this.id=null;this.state="init";if(!event){throw new TypeError("Event necessary to create a subscription.")}else{this.event=event}if(typeof options.expires!=="number"){ua.logger.warn("expires must be a number. Using default of 3600.");this.expires=3600}else{this.expires=options.expires}options.extraHeaders.push("Event: "+this.event);options.extraHeaders.push("Expires: "+this.expires);if(options.body){this.body=options.body}this.contact=ua.contact.toString();options.extraHeaders.push("Contact: "+this.contact);options.extraHeaders.push("Allow: "+SIP.UA.C.ALLOWED_METHODS.toString());SIP.Utils.augment(this,SIP.ClientContext,[ua,SIP.C.SUBSCRIBE,target,options]);this.logger=ua.getLogger("sip.subscription");this.dialog=null;this.timers={N:null,sub_duration:null};this.errorCodes=[404,405,410,416,480,481,482,483,484,485,489,501,604]};SIP.Subscription.prototype={subscribe:function(){var sub=this;if(this.state==="active"){this.refresh();return this}else if(this.state==="notify_wait"){return this}SIP.Timers.clearTimeout(this.timers.sub_duration);SIP.Timers.clearTimeout(this.timers.N);this.timers.N=SIP.Timers.setTimeout(sub.timer_fire.bind(sub),SIP.Timers.TIMER_N);this.send();this.state="notify_wait";return this},refresh:function(){if(this.state==="terminated"||this.state==="pending"||this.state==="notify_wait"){return}this.dialog.sendRequest(this,SIP.C.SUBSCRIBE,{extraHeaders:this.extraHeaders,body:this.body})},receiveResponse:function(response){var expires,sub=this,cause=SIP.Utils.getReasonPhrase(response.status_code);if(this.state==="notify_wait"&&response.status_code>=300||this.state!=="notify_wait"&&this.errorCodes.indexOf(response.status_code)!==-1){this.failed(response,null)}else if(/^2[0-9]{2}$/.test(response.status_code)){expires=response.getHeader("Expires");SIP.Timers.clearTimeout(this.timers.N);if(this.createConfirmedDialog(response,"UAC")){this.id=this.dialog.id.toString();this.ua.subscriptions[this.id]=this;this.emit("accepted",response,cause)}if(expires&&expires<=this.expires){this.expires=expires;this.timers.sub_duration=SIP.Timers.setTimeout(sub.refresh.bind(sub),expires*900)}else{if(!expires){this.logger.warn("Expires header missing in a 200-class response to SUBSCRIBE");this.failed(response,SIP.C.EXPIRES_HEADER_MISSING)}else{this.logger.warn("Expires header in a 200-class response to SUBSCRIBE with a higher value than the one in the request");this.failed(response,SIP.C.INVALID_EXPIRES_HEADER)}}}},unsubscribe:function(){var extraHeaders=[],sub=this;this.state="terminated";extraHeaders.push("Event: "+this.event);extraHeaders.push("Expires: 0");extraHeaders.push("Contact: "+this.contact);extraHeaders.push("Allow: "+SIP.UA.C.ALLOWED_METHODS.toString());this.receiveResponse=function(){};this.dialog.sendRequest(this,this.method,{extraHeaders:extraHeaders,body:this.body});SIP.Timers.clearTimeout(this.timers.sub_duration);SIP.Timers.clearTimeout(this.timers.N);this.timers.N=SIP.Timers.setTimeout(sub.timer_fire.bind(sub),SIP.Timers.TIMER_N)},timer_fire:function(){if(this.state==="terminated"){this.terminateDialog();SIP.Timers.clearTimeout(this.timers.N);SIP.Timers.clearTimeout(this.timers.sub_duration);delete this.ua.subscriptions[this.id]}else if(this.state==="pending"||this.state==="notify_wait"){this.close()}else{this.refresh()}},close:function(){if(this.state!=="notify_wait"&&this.state!=="terminated"){this.unsubscribe()}},createConfirmedDialog:function(message,type){var dialog;this.terminateDialog();dialog=new SIP.Dialog(this,message,type);if(!dialog.error){this.dialog=dialog;return true}else{return false}},terminateDialog:function(){if(this.dialog){delete this.ua.subscriptions[this.id];this.dialog.terminate();delete this.dialog}},receiveRequest:function(request){var sub_state,sub=this;function setExpiresTimeout(){if(sub_state.expires){SIP.Timers.clearTimeout(sub.timers.sub_duration);sub_state.expires=Math.min(sub.expires,Math.max(sub_state.expires,0));sub.timers.sub_duration=SIP.Timers.setTimeout(sub.refresh.bind(sub),sub_state.expires*900)}}if(!this.matchEvent(request)){request.reply(489);return}sub_state=request.parseHeader("Subscription-State");request.reply(200,SIP.C.REASON_200);SIP.Timers.clearTimeout(this.timers.N);this.emit("notify",{request:request});if(this.state==="terminated"){if(sub_state.state==="terminated"){this.terminateDialog();SIP.Timers.clearTimeout(this.timers.N);SIP.Timers.clearTimeout(this.timers.sub_duration);delete this.ua.subscriptions[this.id]}return}switch(sub_state.state){case"active":this.state="active";setExpiresTimeout();break;case"pending":if(this.state==="notify_wait"){setExpiresTimeout()}this.state="pending";break;case"terminated":SIP.Timers.clearTimeout(this.timers.sub_duration);if(sub_state.reason){this.logger.log("terminating subscription with reason "+sub_state.reason);switch(sub_state.reason){case"deactivated":case"timeout":this.subscribe();return;case"probation":case"giveup":if(sub_state.params&&sub_state.params["retry-after"]){this.timers.sub_duration=SIP.Timers.setTimeout(sub.subscribe.bind(sub),sub_state.params["retry-after"])}else{this.subscribe()}return;case"rejected":case"noresource":case"invariant":break}}this.close();break}},failed:function(response,cause){this.close();this.emit("failed",response,cause);return this},onDialogError:function(response){this.failed(response,SIP.C.causes.DIALOG_ERROR)},matchEvent:function(request){var event;if(!request.hasHeader("Event")){this.logger.warn("missing Event header");return false}if(!request.hasHeader("Subscription-State")){this.logger.warn("missing Subscription-State header");return false}event=request.parseHeader("event").event;if(this.event!==event){this.logger.warn("event match failed");request.reply(481,"Event Match Failed");return false}else{return true}}}}},{}],151:[function(require,module,exports){"use strict";var T1=500,T2=4e3,T4=5e3;module.exports=function(timers){var Timers={T1:T1,T2:T2,T4:T4,TIMER_B:64*T1,TIMER_D:0*T1,TIMER_F:64*T1,TIMER_H:64*T1,TIMER_I:0*T1,TIMER_J:0*T1,TIMER_K:0*T4,TIMER_L:64*T1,TIMER_M:64*T1,TIMER_N:64*T1,PROVISIONAL_RESPONSE_INTERVAL:6e4};["setTimeout","clearTimeout","setInterval","clearInterval"].forEach(function(name){Timers[name]=function(){return timers[name].apply(timers,arguments)}});return Timers}},{}],152:[function(require,module,exports){"use strict";module.exports=function(SIP){var C={STATUS_TRYING:1,STATUS_PROCEEDING:2,STATUS_CALLING:3,STATUS_ACCEPTED:4,STATUS_COMPLETED:5,STATUS_TERMINATED:6,STATUS_CONFIRMED:7,NON_INVITE_CLIENT:"nict",NON_INVITE_SERVER:"nist",INVITE_CLIENT:"ict",INVITE_SERVER:"ist"};function buildViaHeader(request_sender,transport,id){var via;via="SIP/2.0/"+(request_sender.ua.configuration.hackViaTcp?"TCP":transport.server.scheme);via+=" "+request_sender.ua.configuration.viaHost+";branch="+id;if(request_sender.ua.configuration.forceRport){via+=";rport"}return via}var NonInviteClientTransaction=function(request_sender,request,transport){var via;this.type=C.NON_INVITE_CLIENT;this.transport=transport;this.id="z9hG4bK"+Math.floor(Math.random()*1e7);this.request_sender=request_sender;this.request=request;this.logger=request_sender.ua.getLogger("sip.transaction.nict",this.id);via=buildViaHeader(request_sender,transport,this.id);this.request.setHeader("via",via);this.request_sender.ua.newTransaction(this)};NonInviteClientTransaction.prototype=Object.create(SIP.EventEmitter.prototype);NonInviteClientTransaction.prototype.stateChanged=function(state){this.state=state;this.emit("stateChanged")};NonInviteClientTransaction.prototype.send=function(){var tr=this;this.stateChanged(C.STATUS_TRYING);this.F=SIP.Timers.setTimeout(tr.timer_F.bind(tr),SIP.Timers.TIMER_F);if(!this.transport.send(this.request)){this.onTransportError()}};NonInviteClientTransaction.prototype.onTransportError=function(){this.logger.log("transport error occurred, deleting non-INVITE client transaction "+this.id);SIP.Timers.clearTimeout(this.F);SIP.Timers.clearTimeout(this.K);this.stateChanged(C.STATUS_TERMINATED);this.request_sender.ua.destroyTransaction(this);this.request_sender.onTransportError()};NonInviteClientTransaction.prototype.timer_F=function(){this.logger.log("Timer F expired for non-INVITE client transaction "+this.id);this.stateChanged(C.STATUS_TERMINATED);this.request_sender.ua.destroyTransaction(this);this.request_sender.onRequestTimeout()};NonInviteClientTransaction.prototype.timer_K=function(){this.stateChanged(C.STATUS_TERMINATED);this.request_sender.ua.destroyTransaction(this)};NonInviteClientTransaction.prototype.receiveResponse=function(response){var tr=this,status_code=response.status_code;if(status_code<200){switch(this.state){case C.STATUS_TRYING:case C.STATUS_PROCEEDING:this.stateChanged(C.STATUS_PROCEEDING);this.request_sender.receiveResponse(response);break}}else{switch(this.state){case C.STATUS_TRYING:case C.STATUS_PROCEEDING:this.stateChanged(C.STATUS_COMPLETED);SIP.Timers.clearTimeout(this.F);if(status_code===408){this.request_sender.onRequestTimeout()}else{this.request_sender.receiveResponse(response)}this.K=SIP.Timers.setTimeout(tr.timer_K.bind(tr),SIP.Timers.TIMER_K);break;case C.STATUS_COMPLETED:break}}};var InviteClientTransaction=function(request_sender,request,transport){var via,tr=this;this.type=C.INVITE_CLIENT;this.transport=transport;this.id="z9hG4bK"+Math.floor(Math.random()*1e7);this.request_sender=request_sender;this.request=request;this.logger=request_sender.ua.getLogger("sip.transaction.ict",this.id);via=buildViaHeader(request_sender,transport,this.id);this.request.setHeader("via",via);this.request_sender.ua.newTransaction(this);this.request.cancel=function(reason,extraHeaders){extraHeaders=(extraHeaders||[]).slice();var length=extraHeaders.length;var extraHeadersString=null;for(var idx=0;idx<length;idx++){extraHeadersString=(extraHeadersString||"")+extraHeaders[idx].trim()+"\r\n"}tr.cancel_request(tr,reason,extraHeadersString)}};InviteClientTransaction.prototype=Object.create(SIP.EventEmitter.prototype);InviteClientTransaction.prototype.stateChanged=function(state){this.state=state;this.emit("stateChanged")};InviteClientTransaction.prototype.send=function(){var tr=this;this.stateChanged(C.STATUS_CALLING);this.B=SIP.Timers.setTimeout(tr.timer_B.bind(tr),SIP.Timers.TIMER_B);if(!this.transport.send(this.request)){this.onTransportError()}};InviteClientTransaction.prototype.onTransportError=function(){this.logger.log("transport error occurred, deleting INVITE client transaction "+this.id);SIP.Timers.clearTimeout(this.B);SIP.Timers.clearTimeout(this.D);SIP.Timers.clearTimeout(this.M);this.stateChanged(C.STATUS_TERMINATED);this.request_sender.ua.destroyTransaction(this);if(this.state!==C.STATUS_ACCEPTED){this.request_sender.onTransportError()}};InviteClientTransaction.prototype.timer_M=function(){this.logger.log("Timer M expired for INVITE client transaction "+this.id);if(this.state===C.STATUS_ACCEPTED){SIP.Timers.clearTimeout(this.B);this.stateChanged(C.STATUS_TERMINATED);this.request_sender.ua.destroyTransaction(this)}};InviteClientTransaction.prototype.timer_B=function(){this.logger.log("Timer B expired for INVITE client transaction "+this.id);if(this.state===C.STATUS_CALLING){this.stateChanged(C.STATUS_TERMINATED);this.request_sender.ua.destroyTransaction(this);this.request_sender.onRequestTimeout()}};InviteClientTransaction.prototype.timer_D=function(){this.logger.log("Timer D expired for INVITE client transaction "+this.id);SIP.Timers.clearTimeout(this.B);this.stateChanged(C.STATUS_TERMINATED);this.request_sender.ua.destroyTransaction(this)};InviteClientTransaction.prototype.sendACK=function(response){var tr=this;this.ack="ACK "+this.request.ruri+" SIP/2.0\r\n";this.ack+="Via: "+this.request.headers["Via"].toString()+"\r\n";if(this.request.headers["Route"]){this.ack+="Route: "+this.request.headers["Route"].toString()+"\r\n"}this.ack+="To: "+response.getHeader("to")+"\r\n";this.ack+="From: "+this.request.headers["From"].toString()+"\r\n";this.ack+="Call-ID: "+this.request.headers["Call-ID"].toString()+"\r\n";this.ack+="Content-Length: 0\r\n";this.ack+="CSeq: "+this.request.headers["CSeq"].toString().split(" ")[0];this.ack+=" ACK\r\n\r\n";this.D=SIP.Timers.setTimeout(tr.timer_D.bind(tr),SIP.Timers.TIMER_D);this.transport.send(this.ack)};InviteClientTransaction.prototype.cancel_request=function(tr,reason,extraHeaders){var request=tr.request;this.cancel=SIP.C.CANCEL+" "+request.ruri+" SIP/2.0\r\n";this.cancel+="Via: "+request.headers["Via"].toString()+"\r\n";if(this.request.headers["Route"]){this.cancel+="Route: "+request.headers["Route"].toString()+"\r\n"}this.cancel+="To: "+request.headers["To"].toString()+"\r\n";this.cancel+="From: "+request.headers["From"].toString()+"\r\n";this.cancel+="Call-ID: "+request.headers["Call-ID"].toString()+"\r\n";this.cancel+="CSeq: "+request.headers["CSeq"].toString().split(" ")[0]+" CANCEL\r\n";if(reason){this.cancel+="Reason: "+reason+"\r\n"}if(extraHeaders){this.cancel+=extraHeaders}this.cancel+="Content-Length: 0\r\n\r\n";if(this.state===C.STATUS_PROCEEDING){this.transport.send(this.cancel)}};InviteClientTransaction.prototype.receiveResponse=function(response){var tr=this,status_code=response.status_code;if(status_code>=100&&status_code<=199){switch(this.state){case C.STATUS_CALLING:this.stateChanged(C.STATUS_PROCEEDING);this.request_sender.receiveResponse(response);if(this.cancel){this.transport.send(this.cancel)}break;case C.STATUS_PROCEEDING:this.request_sender.receiveResponse(response);break}}else if(status_code>=200&&status_code<=299){switch(this.state){case C.STATUS_CALLING:case C.STATUS_PROCEEDING:this.stateChanged(C.STATUS_ACCEPTED);this.M=SIP.Timers.setTimeout(tr.timer_M.bind(tr),SIP.Timers.TIMER_M);this.request_sender.receiveResponse(response);break;case C.STATUS_ACCEPTED:this.request_sender.receiveResponse(response);break}}else if(status_code>=300&&status_code<=699){switch(this.state){case C.STATUS_CALLING:case C.STATUS_PROCEEDING:this.stateChanged(C.STATUS_COMPLETED);this.sendACK(response);this.request_sender.receiveResponse(response);break;case C.STATUS_COMPLETED:this.sendACK(response);break}}};var AckClientTransaction=function(request_sender,request,transport){var via;this.transport=transport;this.id="z9hG4bK"+Math.floor(Math.random()*1e7);this.request_sender=request_sender;this.request=request;this.logger=request_sender.ua.getLogger("sip.transaction.nict",this.id);via=buildViaHeader(request_sender,transport,this.id);this.request.setHeader("via",via)};AckClientTransaction.prototype=Object.create(SIP.EventEmitter.prototype);AckClientTransaction.prototype.send=function(){if(!this.transport.send(this.request)){this.onTransportError()}};AckClientTransaction.prototype.onTransportError=function(){this.logger.log("transport error occurred, for an ACK client transaction "+this.id);this.request_sender.onTransportError()};var NonInviteServerTransaction=function(request,ua){this.type=C.NON_INVITE_SERVER;this.id=request.via_branch;this.request=request;this.transport=request.transport;this.ua=ua;this.last_response="";request.server_transaction=this;this.logger=ua.getLogger("sip.transaction.nist",this.id);this.state=C.STATUS_TRYING;ua.newTransaction(this)};NonInviteServerTransaction.prototype=Object.create(SIP.EventEmitter.prototype);NonInviteServerTransaction.prototype.stateChanged=function(state){
        this.state=state;this.emit("stateChanged")};NonInviteServerTransaction.prototype.timer_J=function(){this.logger.log("Timer J expired for non-INVITE server transaction "+this.id);this.stateChanged(C.STATUS_TERMINATED);this.ua.destroyTransaction(this)};NonInviteServerTransaction.prototype.onTransportError=function(){if(!this.transportError){this.transportError=true;this.logger.log("transport error occurred, deleting non-INVITE server transaction "+this.id);SIP.Timers.clearTimeout(this.J);this.stateChanged(C.STATUS_TERMINATED);this.ua.destroyTransaction(this)}};NonInviteServerTransaction.prototype.receiveResponse=function(status_code,response){var tr=this;var deferred=SIP.Utils.defer();if(status_code===100){switch(this.state){case C.STATUS_TRYING:this.stateChanged(C.STATUS_PROCEEDING);if(!this.transport.send(response)){this.onTransportError()}break;case C.STATUS_PROCEEDING:this.last_response=response;if(!this.transport.send(response)){this.onTransportError();deferred.reject()}else{deferred.resolve()}break}}else if(status_code>=200&&status_code<=699){switch(this.state){case C.STATUS_TRYING:case C.STATUS_PROCEEDING:this.stateChanged(C.STATUS_COMPLETED);this.last_response=response;this.J=SIP.Timers.setTimeout(tr.timer_J.bind(tr),SIP.Timers.TIMER_J);if(!this.transport.send(response)){this.onTransportError();deferred.reject()}else{deferred.resolve()}break;case C.STATUS_COMPLETED:break}}return deferred.promise};var InviteServerTransaction=function(request,ua){this.type=C.INVITE_SERVER;this.id=request.via_branch;this.request=request;this.transport=request.transport;this.ua=ua;this.last_response="";request.server_transaction=this;this.logger=ua.getLogger("sip.transaction.ist",this.id);this.state=C.STATUS_PROCEEDING;ua.newTransaction(this);this.resendProvisionalTimer=null;request.reply(100)};InviteServerTransaction.prototype=Object.create(SIP.EventEmitter.prototype);InviteServerTransaction.prototype.stateChanged=function(state){this.state=state;this.emit("stateChanged")};InviteServerTransaction.prototype.timer_H=function(){this.logger.log("Timer H expired for INVITE server transaction "+this.id);if(this.state===C.STATUS_COMPLETED){this.logger.warn("transactions","ACK for INVITE server transaction was never received, call will be terminated")}this.stateChanged(C.STATUS_TERMINATED);this.ua.destroyTransaction(this)};InviteServerTransaction.prototype.timer_I=function(){this.stateChanged(C.STATUS_TERMINATED);this.ua.destroyTransaction(this)};InviteServerTransaction.prototype.timer_L=function(){this.logger.log("Timer L expired for INVITE server transaction "+this.id);if(this.state===C.STATUS_ACCEPTED){this.stateChanged(C.STATUS_TERMINATED);this.ua.destroyTransaction(this)}};InviteServerTransaction.prototype.onTransportError=function(){if(!this.transportError){this.transportError=true;this.logger.log("transport error occurred, deleting INVITE server transaction "+this.id);if(this.resendProvisionalTimer!==null){SIP.Timers.clearInterval(this.resendProvisionalTimer);this.resendProvisionalTimer=null}SIP.Timers.clearTimeout(this.L);SIP.Timers.clearTimeout(this.H);SIP.Timers.clearTimeout(this.I);this.stateChanged(C.STATUS_TERMINATED);this.ua.destroyTransaction(this)}};InviteServerTransaction.prototype.resend_provisional=function(){if(!this.transport.send(this.last_response)){this.onTransportError()}};InviteServerTransaction.prototype.receiveResponse=function(status_code,response){var tr=this;var deferred=SIP.Utils.defer();if(status_code>=100&&status_code<=199){switch(this.state){case C.STATUS_PROCEEDING:if(!this.transport.send(response)){this.onTransportError()}this.last_response=response;break}}if(status_code>100&&status_code<=199&&this.state===C.STATUS_PROCEEDING){if(this.resendProvisionalTimer===null){this.resendProvisionalTimer=SIP.Timers.setInterval(tr.resend_provisional.bind(tr),SIP.Timers.PROVISIONAL_RESPONSE_INTERVAL)}}else if(status_code>=200&&status_code<=299){switch(this.state){case C.STATUS_PROCEEDING:this.stateChanged(C.STATUS_ACCEPTED);this.last_response=response;this.L=SIP.Timers.setTimeout(tr.timer_L.bind(tr),SIP.Timers.TIMER_L);if(this.resendProvisionalTimer!==null){SIP.Timers.clearInterval(this.resendProvisionalTimer);this.resendProvisionalTimer=null}case C.STATUS_ACCEPTED:if(!this.transport.send(response)){this.onTransportError();deferred.reject()}else{deferred.resolve()}break}}else if(status_code>=300&&status_code<=699){switch(this.state){case C.STATUS_PROCEEDING:if(this.resendProvisionalTimer!==null){SIP.Timers.clearInterval(this.resendProvisionalTimer);this.resendProvisionalTimer=null}if(!this.transport.send(response)){this.onTransportError();deferred.reject()}else{this.stateChanged(C.STATUS_COMPLETED);this.H=SIP.Timers.setTimeout(tr.timer_H.bind(tr),SIP.Timers.TIMER_H);deferred.resolve()}break}}return deferred.promise};var checkTransaction=function(ua,request){var tr;switch(request.method){case SIP.C.INVITE:tr=ua.transactions.ist[request.via_branch];if(tr){switch(tr.state){case C.STATUS_PROCEEDING:tr.transport.send(tr.last_response);break;case C.STATUS_ACCEPTED:break}return true}break;case SIP.C.ACK:tr=ua.transactions.ist[request.via_branch];if(tr){if(tr.state===C.STATUS_ACCEPTED){return false}else if(tr.state===C.STATUS_COMPLETED){tr.stateChanged(C.STATUS_CONFIRMED);tr.I=SIP.Timers.setTimeout(tr.timer_I.bind(tr),SIP.Timers.TIMER_I);return true}}else{return false}break;case SIP.C.CANCEL:tr=ua.transactions.ist[request.via_branch];if(tr){request.reply_sl(200);if(tr.state===C.STATUS_PROCEEDING){return false}else{return true}}else{request.reply_sl(481);return true}break;default:tr=ua.transactions.nist[request.via_branch];if(tr){switch(tr.state){case C.STATUS_TRYING:break;case C.STATUS_PROCEEDING:case C.STATUS_COMPLETED:tr.transport.send(tr.last_response);break}return true}break}};SIP.Transactions={C:C,checkTransaction:checkTransaction,NonInviteClientTransaction:NonInviteClientTransaction,InviteClientTransaction:InviteClientTransaction,AckClientTransaction:AckClientTransaction,NonInviteServerTransaction:NonInviteServerTransaction,InviteServerTransaction:InviteServerTransaction}}},{}],153:[function(require,module,exports){"use strict";module.exports=function(SIP,WebSocket){var Transport,C={STATUS_READY:0,STATUS_DISCONNECTED:1,STATUS_ERROR:2};function computeKeepAliveTimeout(upperBound){var lowerBound=upperBound*.8;return 1e3*(Math.random()*(upperBound-lowerBound)+lowerBound)}Transport=function(ua,server){this.logger=ua.getLogger("sip.transport");this.ua=ua;this.ws=null;this.server=server;this.reconnection_attempts=0;this.closed=false;this.connected=false;this.reconnectTimer=null;this.lastTransportError={};this.keepAliveInterval=ua.configuration.keepAliveInterval;this.keepAliveTimeout=null;this.keepAliveTimer=null;this.ua.transport=this;this.connect()};Transport.prototype={send:function(msg){var message=msg.toString();if(this.ws&&this.ws.readyState===WebSocket.OPEN){if(this.ua.configuration.traceSip===true){this.logger.log("sending WebSocket message:\n\n"+message+"\n")}this.ws.send(message);return true}else{this.logger.warn("unable to send message, WebSocket is not open");return false}},sendKeepAlive:function(){if(this.keepAliveTimeout){return}this.keepAliveTimeout=SIP.Timers.setTimeout(function(){this.ua.emit("keepAliveTimeout")}.bind(this),1e4);return this.send("\r\n\r\n")},startSendingKeepAlives:function(){if(this.keepAliveInterval&&!this.keepAliveTimer){this.keepAliveTimer=SIP.Timers.setTimeout(function(){this.sendKeepAlive();this.keepAliveTimer=null;this.startSendingKeepAlives()}.bind(this),computeKeepAliveTimeout(this.keepAliveInterval))}},stopSendingKeepAlives:function(){SIP.Timers.clearTimeout(this.keepAliveTimer);SIP.Timers.clearTimeout(this.keepAliveTimeout);this.keepAliveTimer=null;this.keepAliveTimeout=null},disconnect:function(){if(this.ws){SIP.Timers.clearTimeout(this.reconnectTimer);this.stopSendingKeepAlives();this.closed=true;this.logger.log("closing WebSocket "+this.server.ws_uri);this.ws.close()}if(this.reconnectTimer!==null){SIP.Timers.clearTimeout(this.reconnectTimer);this.reconnectTimer=null;this.ua.emit("disconnected",{transport:this,code:this.lastTransportError.code,reason:this.lastTransportError.reason})}},connect:function(){var transport=this;if(this.ws&&(this.ws.readyState===WebSocket.OPEN||this.ws.readyState===WebSocket.CONNECTING)){this.logger.log("WebSocket "+this.server.ws_uri+" is already connected");return false}if(this.ws){this.ws.close()}this.logger.log("connecting to WebSocket "+this.server.ws_uri);this.ua.onTransportConnecting(this,this.reconnection_attempts===0?1:this.reconnection_attempts);try{this.ws=new WebSocket(this.server.ws_uri,"sip")}catch(e){this.logger.warn("error connecting to WebSocket "+this.server.ws_uri+": "+e)}this.ws.binaryType="arraybuffer";this.ws.onopen=function(){transport.onOpen()};this.ws.onclose=function(e){transport.onClose(e)};this.ws.onmessage=function(e){transport.onMessage(e)};this.ws.onerror=function(e){transport.onError(e)}},onOpen:function(){this.connected=true;this.logger.log("WebSocket "+this.server.ws_uri+" connected");if(this.reconnectTimer!==null){SIP.Timers.clearTimeout(this.reconnectTimer);this.reconnectTimer=null}this.reconnection_attempts=0;this.closed=false;this.ua.onTransportConnected(this);this.startSendingKeepAlives()},onClose:function(e){var connected_before=this.connected;this.lastTransportError.code=e.code;this.lastTransportError.reason=e.reason;this.stopSendingKeepAlives();if(this.reconnection_attempts>0){this.logger.log("Reconnection attempt "+this.reconnection_attempts+" failed (code: "+e.code+(e.reason?"| reason: "+e.reason:"")+")");this.reconnect()}else{this.connected=false;this.logger.log("WebSocket disconnected (code: "+e.code+(e.reason?"| reason: "+e.reason:"")+")");if(e.wasClean===false){this.logger.warn("WebSocket abrupt disconnection")}if(connected_before===true){this.ua.onTransportClosed(this);if(!this.closed){this.reconnect()}else{this.ua.emit("disconnected",{transport:this,code:this.lastTransportError.code,reason:this.lastTransportError.reason})}}else{this.ua.onTransportError(this)}}},onMessage:function(e){var message,transaction,data=e.data;if(data==="\r\n"){SIP.Timers.clearTimeout(this.keepAliveTimeout);this.keepAliveTimeout=null;if(this.ua.configuration.traceSip===true){this.logger.log("received WebSocket message with CRLF Keep Alive response")}return}else if(typeof data!=="string"){try{data=String.fromCharCode.apply(null,new Uint8Array(data))}catch(evt){this.logger.warn("received WebSocket binary message failed to be converted into string, message discarded");return}if(this.ua.configuration.traceSip===true){this.logger.log("received WebSocket binary message:\n\n"+data+"\n")}}else{if(this.ua.configuration.traceSip===true){this.logger.log("received WebSocket text message:\n\n"+data+"\n")}}message=SIP.Parser.parseMessage(data,this.ua);if(!message){return}if(this.ua.status===SIP.UA.C.STATUS_USER_CLOSED&&message instanceof SIP.IncomingRequest){return}if(SIP.sanityCheck(message,this.ua,this)){if(message instanceof SIP.IncomingRequest){message.transport=this;this.ua.receiveRequest(message)}else if(message instanceof SIP.IncomingResponse){switch(message.method){case SIP.C.INVITE:transaction=this.ua.transactions.ict[message.via_branch];if(transaction){transaction.receiveResponse(message)}break;case SIP.C.ACK:break;default:transaction=this.ua.transactions.nict[message.via_branch];if(transaction){transaction.receiveResponse(message)}break}}}},onError:function(e){this.logger.warn("WebSocket connection error: "+JSON.stringify(e))},reconnect:function(){var transport=this;this.reconnection_attempts+=1;if(this.reconnection_attempts>this.ua.configuration.wsServerMaxReconnection){this.logger.warn("maximum reconnection attempts for WebSocket "+this.server.ws_uri);this.ua.onTransportError(this)}else if(this.reconnection_attempts===1){this.logger.log("Connection to WebSocket "+this.server.ws_uri+" severed, attempting first reconnect");transport.connect()}else{this.logger.log("trying to reconnect to WebSocket "+this.server.ws_uri+" (reconnection attempt "+this.reconnection_attempts+")");this.reconnectTimer=SIP.Timers.setTimeout(function(){transport.connect();transport.reconnectTimer=null},this.ua.configuration.wsServerReconnectionTimeout*1e3)}}};Transport.C=C;return Transport}},{}],154:[function(require,module,exports){(function(global){"use strict";module.exports=function(SIP,environment){var UA,C={STATUS_INIT:0,STATUS_STARTING:1,STATUS_READY:2,STATUS_USER_CLOSED:3,STATUS_NOT_READY:4,CONFIGURATION_ERROR:1,NETWORK_ERROR:2,ALLOWED_METHODS:["ACK","CANCEL","INVITE","MESSAGE","BYE","OPTIONS","INFO","NOTIFY","REFER"],ACCEPTED_BODY_TYPES:["application/sdp","application/dtmf-relay"],MAX_FORWARDS:70,TAG_LENGTH:10};UA=function(configuration){var self=this;function selfEmit(type){return self.emit.bind(self,type)}C.ACCEPTED_BODY_TYPES=C.ACCEPTED_BODY_TYPES.toString();this.log=new SIP.LoggerFactory;this.logger=this.getLogger("sip.ua");this.cache={credentials:{}};this.configuration={};this.dialogs={};this.applicants={};this.data={};this.sessions={};this.subscriptions={};this.transport=null;this.contact=null;this.status=C.STATUS_INIT;this.error=null;this.transactions={nist:{},nict:{},ist:{},ict:{}};this.transportRecoverAttempts=0;this.transportRecoveryTimer=null;Object.defineProperties(this,{transactionsCount:{get:function(){var type,transactions=["nist","nict","ist","ict"],count=0;for(type in transactions){count+=Object.keys(this.transactions[transactions[type]]).length}return count}},nictTransactionsCount:{get:function(){return Object.keys(this.transactions["nict"]).length}},nistTransactionsCount:{get:function(){return Object.keys(this.transactions["nist"]).length}},ictTransactionsCount:{get:function(){return Object.keys(this.transactions["ict"]).length}},istTransactionsCount:{get:function(){return Object.keys(this.transactions["ist"]).length}}});if(configuration===undefined){configuration={}}else if(typeof configuration==="string"||configuration instanceof String){configuration={uri:configuration}}if(configuration.log){if(configuration.log.hasOwnProperty("builtinEnabled")){this.log.builtinEnabled=configuration.log.builtinEnabled}if(configuration.log.hasOwnProperty("level")){this.log.level=configuration.log.level}if(configuration.log.hasOwnProperty("connector")){this.log.connector=configuration.log.connector}}try{this.loadConfig(configuration)}catch(e){this.status=C.STATUS_NOT_READY;this.error=C.CONFIGURATION_ERROR;throw e}this.registerContext=new SIP.RegisterContext(this);this.registerContext.on("failed",selfEmit("registrationFailed"));this.registerContext.on("registered",selfEmit("registered"));this.registerContext.on("unregistered",selfEmit("unregistered"));if(this.configuration.autostart){this.start()}if(typeof environment.addEventListener==="function"){if(!(global.chrome&&global.chrome.app&&global.chrome.app.runtime)){environment.addEventListener("unload",this.stop.bind(this))}}};UA.prototype=Object.create(SIP.EventEmitter.prototype);UA.prototype.register=function(options){this.configuration.register=true;this.registerContext.register(options);return this};UA.prototype.unregister=function(options){this.configuration.register=false;var context=this.registerContext;this.afterConnected(context.unregister.bind(context,options));return this};UA.prototype.isRegistered=function(){return this.registerContext.registered};UA.prototype.isConnected=function(){return this.transport?this.transport.connected:false};UA.prototype.afterConnected=function afterConnected(callback){if(this.isConnected()){callback()}else{this.once("connected",callback)}};UA.prototype.invite=function(target,options){var context=new SIP.InviteClientContext(this,target,options);this.afterConnected(context.invite.bind(context));return context};UA.prototype.subscribe=function(target,event,options){var sub=new SIP.Subscription(this,target,event,options);this.afterConnected(sub.subscribe.bind(sub));return sub};UA.prototype.message=function(target,body,options){if(body===undefined){throw new TypeError("Not enough arguments")}options=Object.create(options||Object.prototype);options.contentType||(options.contentType="text/plain");options.body=body;return this.request(SIP.C.MESSAGE,target,options)};UA.prototype.request=function(method,target,options){var req=new SIP.ClientContext(this,method,target,options);this.afterConnected(req.send.bind(req));return req};UA.prototype.stop=function(){var session,subscription,applicant,ua=this;function transactionsListener(){if(ua.nistTransactionsCount===0&&ua.nictTransactionsCount===0){ua.removeListener("transactionDestroyed",transactionsListener);ua.transport.disconnect()}}this.logger.log("user requested closure...");if(this.status===C.STATUS_USER_CLOSED){this.logger.warn("UA already closed");return this}SIP.Timers.clearTimeout(this.transportRecoveryTimer);this.logger.log("closing registerContext");this.registerContext.close();for(session in this.sessions){this.logger.log("closing session "+session);this.sessions[session].terminate()}for(subscription in this.subscriptions){this.logger.log("unsubscribing from subscription "+subscription);this.subscriptions[subscription].close()}for(applicant in this.applicants){this.applicants[applicant].close()}this.status=C.STATUS_USER_CLOSED;if(this.nistTransactionsCount===0&&this.nictTransactionsCount===0){if(this.transport){this.transport.disconnect()}}else{this.on("transactionDestroyed",transactionsListener)}return this};UA.prototype.start=function(){var server;this.logger.log("user requested startup...");if(this.status===C.STATUS_INIT){server=this.getNextWsServer();this.status=C.STATUS_STARTING;new SIP.Transport(this,server)}else if(this.status===C.STATUS_USER_CLOSED){this.logger.log("resuming");this.status=C.STATUS_READY;this.transport.connect()}else if(this.status===C.STATUS_STARTING){this.logger.log("UA is in STARTING status, not opening new connection")}else if(this.status===C.STATUS_READY){this.logger.log("UA is in READY status, not resuming")}else{this.logger.error("Connection is down. Auto-Recovery system is trying to connect")}return this};UA.prototype.normalizeTarget=function(target){return SIP.Utils.normalizeTarget(target,this.configuration.hostportParams)};UA.prototype.saveCredentials=function(credentials){this.cache.credentials[credentials.realm]=this.cache.credentials[credentials.realm]||{};this.cache.credentials[credentials.realm][credentials.uri]=credentials;return this};UA.prototype.getCredentials=function(request){var realm,credentials;realm=request.ruri.host;if(this.cache.credentials[realm]&&this.cache.credentials[realm][request.ruri]){credentials=this.cache.credentials[realm][request.ruri];credentials.method=request.method}return credentials};UA.prototype.getLogger=function(category,label){return this.log.getLogger(category,label)};UA.prototype.onTransportClosed=function(transport){var type,idx,length,client_transactions=["nict","ict","nist","ist"];transport.server.status=SIP.Transport.C.STATUS_DISCONNECTED;this.logger.log("connection state set to "+SIP.Transport.C.STATUS_DISCONNECTED);length=client_transactions.length;for(type=0;type<length;type++){for(idx in this.transactions[client_transactions[type]]){this.transactions[client_transactions[type]][idx].onTransportError()}}if(!this.contact.pub_gruu){this.closeSessionsOnTransportError()}};UA.prototype.onTransportError=function(transport){var server;this.logger.log("transport "+transport.server.ws_uri+" failed | connection state set to "+SIP.Transport.C.STATUS_ERROR);transport.server.status=SIP.Transport.C.STATUS_ERROR;this.emit("disconnected",{transport:transport});if(this.status===C.STATUS_USER_CLOSED){return}server=this.getNextWsServer();if(server){new SIP.Transport(this,server)}else{this.closeSessionsOnTransportError();if(!this.error||this.error!==C.NETWORK_ERROR){this.status=C.STATUS_NOT_READY;this.error=C.NETWORK_ERROR}this.recoverTransport()}};UA.prototype.onTransportConnected=function(transport){this.transport=transport;this.transportRecoverAttempts=0;transport.server.status=SIP.Transport.C.STATUS_READY;this.logger.log("connection state set to "+SIP.Transport.C.STATUS_READY);if(this.status===C.STATUS_USER_CLOSED){return}this.status=C.STATUS_READY;this.error=null;if(this.configuration.register){this.configuration.authenticationFactory.initialize().then(function(){this.registerContext.onTransportConnected()}.bind(this))}this.emit("connected",{transport:transport})};UA.prototype.onTransportConnecting=function(transport,attempts){this.emit("connecting",{transport:transport,attempts:attempts})};UA.prototype.newTransaction=function(transaction){this.transactions[transaction.type][transaction.id]=transaction;this.emit("newTransaction",{transaction:transaction})};UA.prototype.destroyTransaction=function(transaction){delete this.transactions[transaction.type][transaction.id];this.emit("transactionDestroyed",{transaction:transaction})};UA.prototype.receiveRequest=function(request){var dialog,session,message,method=request.method,transaction,replaces,replacedDialog,self=this;function ruriMatches(uri){return uri&&uri.user===request.ruri.user}if(!(ruriMatches(this.configuration.uri)||ruriMatches(this.contact.uri)||ruriMatches(this.contact.pub_gruu)||ruriMatches(this.contact.temp_gruu))){this.logger.warn("Request-URI does not point to us");if(request.method!==SIP.C.ACK){request.reply_sl(404)}return}if(request.ruri.scheme===SIP.C.SIPS){request.reply_sl(416);return}if(SIP.Transactions.checkTransaction(this,request)){return}if(method===SIP.C.OPTIONS){new SIP.Transactions.NonInviteServerTransaction(request,this);request.reply(200,null,["Allow: "+SIP.UA.C.ALLOWED_METHODS.toString(),"Accept: "+C.ACCEPTED_BODY_TYPES])}else if(method===SIP.C.MESSAGE){message=new SIP.ServerContext(this,request);message.body=request.body;message.content_type=request.getHeader("Content-Type")||"text/plain";request.reply(200,null);this.emit("message",message)}else if(method!==SIP.C.INVITE&&method!==SIP.C.ACK){transaction=new SIP.ServerContext(this,request)}if(!request.to_tag){switch(method){case SIP.C.INVITE:replaces=this.configuration.replaces!==SIP.C.supported.UNSUPPORTED&&request.parseHeader("replaces");if(replaces){replacedDialog=this.dialogs[replaces.call_id+replaces.replaces_to_tag+replaces.replaces_from_tag];if(!replacedDialog){request.reply_sl(481,null);return}else if(replacedDialog.owner.status===SIP.Session.C.STATUS_TERMINATED){request.reply_sl(603,null);return}else if(replacedDialog.state===SIP.Dialog.C.STATUS_CONFIRMED&&replaces.early_only){request.reply_sl(486,null);return}}var isMediaSupported=this.configuration.mediaHandlerFactory.isSupported;if(!isMediaSupported||isMediaSupported()){session=new SIP.InviteServerContext(this,request);session.replacee=replacedDialog&&replacedDialog.owner;session.on("invite",function(){self.emit("invite",this)})}else{this.logger.warn("INVITE received but WebRTC is not supported");request.reply(488)}break;case SIP.C.BYE:request.reply(481);break;case SIP.C.CANCEL:session=this.findSession(request);if(session){session.receiveRequest(request)}else{this.logger.warn("received CANCEL request for a non existent session")}break;case SIP.C.ACK:break;case SIP.C.NOTIFY:if(this.configuration.allowLegacyNotifications&&this.listeners("notify").length>0){request.reply(200,null);self.emit("notify",{request:request})}else{request.reply(481,"Subscription does not exist")}break;default:request.reply(405);break}}else{dialog=this.findDialog(request);if(dialog){if(method===SIP.C.INVITE){new SIP.Transactions.InviteServerTransaction(request,this)}dialog.receiveRequest(request)}else if(method===SIP.C.NOTIFY){session=this.findSession(request);if(session){session.receiveRequest(request)}else{this.logger.warn("received NOTIFY request for a non existent session");request.reply(481,"Subscription does not exist")}}else{if(method!==SIP.C.ACK){request.reply(481)}}}};UA.prototype.findSession=function(request){return this.sessions[request.call_id+request.from_tag]||this.sessions[request.call_id+request.to_tag]||null};UA.prototype.findDialog=function(request){return this.dialogs[request.call_id+request.from_tag+request.to_tag]||this.dialogs[request.call_id+request.to_tag+request.from_tag]||null};UA.prototype.getNextWsServer=function(){var idx,length,ws_server,candidates=[];length=this.configuration.wsServers.length;for(idx=0;idx<length;idx++){ws_server=this.configuration.wsServers[idx];if(ws_server.status===SIP.Transport.C.STATUS_ERROR){continue}else if(candidates.length===0){candidates.push(ws_server)}else if(ws_server.weight>candidates[0].weight){candidates=[ws_server]}else if(ws_server.weight===candidates[0].weight){candidates.push(ws_server)}}idx=Math.floor(Math.random()*candidates.length);return candidates[idx]};UA.prototype.closeSessionsOnTransportError=function(){var idx;for(idx in this.sessions){this.sessions[idx].onTransportError()}this.registerContext.onTransportClosed()};UA.prototype.recoverTransport=function(ua){var idx,length,k,nextRetry,count,server;ua=ua||this;count=ua.transportRecoverAttempts;length=ua.configuration.wsServers.length;for(idx=0;idx<length;idx++){ua.configuration.wsServers[idx].status=0}server=ua.getNextWsServer();k=Math.floor(Math.random()*Math.pow(2,count)+1);nextRetry=k*ua.configuration.connectionRecoveryMinInterval;if(nextRetry>ua.configuration.connectionRecoveryMaxInterval){this.logger.log("time for next connection attempt exceeds connectionRecoveryMaxInterval, resetting counter");nextRetry=ua.configuration.connectionRecoveryMinInterval;count=0}this.logger.log("next connection attempt in "+nextRetry+" seconds");this.transportRecoveryTimer=SIP.Timers.setTimeout(function(){ua.transportRecoverAttempts=count+1;new SIP.Transport(ua,server)},nextRetry*1e3)};function checkAuthenticationFactory(authenticationFactory){if(!(authenticationFactory instanceof Function)){return}if(!authenticationFactory.initialize){authenticationFactory.initialize=function initialize(){return SIP.Utils.Promise.resolve()}}return authenticationFactory}UA.prototype.loadConfig=function(configuration){var parameter,value,checked_value,hostportParams,registrarServer,settings={viaHost:SIP.Utils.createRandomToken(12)+".invalid",uri:new SIP.URI("sip","anonymous."+SIP.Utils.createRandomToken(6),"anonymous.invalid",null,null),wsServers:[{scheme:"WSS",sip_uri:"<sip:edge.sip.onsip.com;transport=ws;lr>",status:0,weight:0,ws_uri:"wss://edge.sip.onsip.com"}],password:null,registerExpires:600,register:true,registrarServer:null,wsServerMaxReconnection:3,wsServerReconnectionTimeout:4,connectionRecoveryMinInterval:2,connectionRecoveryMaxInterval:30,keepAliveInterval:0,extraSupported:[],usePreloadedRoute:false,userAgentString:SIP.C.USER_AGENT,iceCheckingTimeout:5e3,noAnswerTimeout:60,stunServers:["stun:stun.l.google.com:19302"],turnServers:[],traceSip:false,hackViaTcp:false,hackIpInContact:false,hackWssInTransport:false,hackAllowUnregisteredOptionTags:false,hackCleanJitsiSdpImageattr:false,hackStripTcp:false,contactTransport:"ws",forceRport:false,autostart:true,rel100:SIP.C.supported.UNSUPPORTED,replaces:SIP.C.supported.UNSUPPORTED,mediaHandlerFactory:SIP.WebRTC.MediaHandler.defaultFactory,authenticationFactory:checkAuthenticationFactory(function authenticationFactory(ua){return new SIP.DigestAuthentication(ua)}),allowLegacyNotifications:false};function aliasUnderscored(parameter,logger){var underscored=parameter.replace(/([a-z][A-Z])/g,function(m){return m[0]+"_"+m[1].toLowerCase()});if(parameter===underscored){return}var hasParameter=configuration.hasOwnProperty(parameter);if(configuration.hasOwnProperty(underscored)){logger.warn(underscored+" is deprecated, please use "+parameter);if(hasParameter){logger.warn(parameter+" overriding "+underscored)}}configuration[parameter]=hasParameter?configuration[parameter]:configuration[underscored]}for(parameter in UA.configuration_check.mandatory){aliasUnderscored(parameter,this.logger);if(!configuration.hasOwnProperty(parameter)){throw new SIP.Exceptions.ConfigurationError(parameter)}else{value=configuration[parameter];checked_value=UA.configuration_check.mandatory[parameter](value);if(checked_value!==undefined){settings[parameter]=checked_value}else{throw new SIP.Exceptions.ConfigurationError(parameter,value)}}}SIP.Utils.optionsOverride(configuration,"rel100","reliable",true,this.logger,SIP.C.supported.UNSUPPORTED);var emptyArraysAllowed=["stunServers","turnServers"];for(parameter in UA.configuration_check.optional){aliasUnderscored(parameter,this.logger);if(configuration.hasOwnProperty(parameter)){value=configuration[parameter];if(value instanceof Array&&value.length===0&&emptyArraysAllowed.indexOf(parameter)<0){continue}if(value===null||value===""||value===undefined){continue}else if(typeof value==="number"&&isNaN(value)){continue}checked_value=UA.configuration_check.optional[parameter](value);if(checked_value!==undefined){settings[parameter]=checked_value}else{throw new SIP.Exceptions.ConfigurationError(parameter,value)}}}if(settings.connectionRecoveryMaxInterval<settings.connectionRecoveryMinInterval){throw new SIP.Exceptions.ConfigurationError("connectionRecoveryMaxInterval",settings.connectionRecoveryMaxInterval)}if(settings.displayName===0){settings.displayName="0"}if(!settings.instanceId){settings.instanceId=SIP.Utils.newUUID()}settings.sipjsId=SIP.Utils.createRandomToken(5);hostportParams=settings.uri.clone();hostportParams.user=null;settings.hostportParams=hostportParams.toRaw().replace(/^sip:/i,"");if(!settings.authorizationUser){settings.authorizationUser=settings.uri.user}if(!settings.registrarServer){registrarServer=settings.uri.clone();registrarServer.user=null;settings.registrarServer=registrarServer}settings.noAnswerTimeout=settings.noAnswerTimeout*1e3;if(settings.hackIpInContact){if(typeof settings.hackIpInContact==="boolean"){settings.viaHost=SIP.Utils.getRandomTestNetIP()}else if(typeof settings.hackIpInContact==="string"){settings.viaHost=settings.hackIpInContact}}if(settings.hackWssInTransport){settings.contactTransport="wss"}this.contact={pub_gruu:null,temp_gruu:null,uri:new SIP.URI("sip",SIP.Utils.createRandomToken(8),settings.viaHost,null,{transport:settings.contactTransport}),toString:function(options){options=options||{};var anonymous=options.anonymous||null,outbound=options.outbound||null,contact="<";if(anonymous){contact+=(this.temp_gruu||"sip:anonymous@anonymous.invalid;transport="+settings.contactTransport).toString()}else{contact+=(this.pub_gruu||this.uri).toString()}if(outbound){contact+=";ob"}contact+=">";return contact}};SIP.Utils.optionsOverride(settings,"media","mediaConstraints",true,this.logger);for(parameter in settings){UA.configuration_skeleton[parameter].value=settings[parameter]}Object.defineProperties(this.configuration,UA.configuration_skeleton);for(parameter in settings){UA.configuration_skeleton[parameter].value=""}this.logger.log("configuration parameters after validation:");for(parameter in settings){switch(parameter){case"uri":case"registrarServer":case"mediaHandlerFactory":this.logger.log("\xb7 "+parameter+": "+settings[parameter]);break;case"password":this.logger.log("\xb7 "+parameter+": "+"NOT SHOWN");break;default:this.logger.log("\xb7 "+parameter+": "+JSON.stringify(settings[parameter]))}}return};UA.configuration_skeleton=function(){
        var idx,parameter,skeleton={},parameters=["sipjsId","hostportParams","uri","wsServers","authorizationUser","connectionRecoveryMaxInterval","connectionRecoveryMinInterval","keepAliveInterval","extraSupported","displayName","hackViaTcp","hackIpInContact","hackWssInTransport","hackAllowUnregisteredOptionTags","hackCleanJitsiSdpImageattr","hackStripTcp","contactTransport","forceRport","iceCheckingTimeout","instanceId","noAnswerTimeout","password","registerExpires","registrarServer","reliable","rel100","replaces","userAgentString","autostart","stunServers","traceSip","turnServers","usePreloadedRoute","wsServerMaxReconnection","wsServerReconnectionTimeout","mediaHandlerFactory","media","mediaConstraints","authenticationFactory","allowLegacyNotifications","via_core_value","viaHost"];for(idx in parameters){parameter=parameters[idx];skeleton[parameter]={value:"",writable:false,configurable:false}}skeleton["register"]={value:"",writable:true,configurable:false};return skeleton}();UA.configuration_check={mandatory:{},optional:{uri:function(uri){var parsed;if(!/^sip:/i.test(uri)){uri=SIP.C.SIP+":"+uri}parsed=SIP.URI.parse(uri);if(!parsed){return}else if(!parsed.user){return}else{return parsed}},wsServers:function(wsServers){var idx,length,url;if(typeof wsServers==="string"){wsServers=[{ws_uri:wsServers}]}else if(wsServers instanceof Array){length=wsServers.length;for(idx=0;idx<length;idx++){if(typeof wsServers[idx]==="string"){wsServers[idx]={ws_uri:wsServers[idx]}}}}else{return}if(wsServers.length===0){return false}length=wsServers.length;for(idx=0;idx<length;idx++){if(!wsServers[idx].ws_uri){return}if(wsServers[idx].weight&&!Number(wsServers[idx].weight)){return}url=SIP.Grammar.parse(wsServers[idx].ws_uri,"absoluteURI");if(url===-1){return}else if(["wss","ws","udp"].indexOf(url.scheme)<0){return}else{wsServers[idx].sip_uri="<sip:"+url.host+(url.port?":"+url.port:"")+";transport="+url.scheme.replace(/^wss$/i,"ws")+";lr>";if(!wsServers[idx].weight){wsServers[idx].weight=0}wsServers[idx].status=0;wsServers[idx].scheme=url.scheme.toUpperCase()}}return wsServers},authorizationUser:function(authorizationUser){if(SIP.Grammar.parse('"'+authorizationUser+'"',"quoted_string")===-1){return}else{return authorizationUser}},connectionRecoveryMaxInterval:function(connectionRecoveryMaxInterval){var value;if(SIP.Utils.isDecimal(connectionRecoveryMaxInterval)){value=Number(connectionRecoveryMaxInterval);if(value>0){return value}}},connectionRecoveryMinInterval:function(connectionRecoveryMinInterval){var value;if(SIP.Utils.isDecimal(connectionRecoveryMinInterval)){value=Number(connectionRecoveryMinInterval);if(value>0){return value}}},displayName:function(displayName){if(SIP.Grammar.parse('"'+displayName+'"',"displayName")===-1){return}else{return displayName}},hackViaTcp:function(hackViaTcp){if(typeof hackViaTcp==="boolean"){return hackViaTcp}},hackIpInContact:function(hackIpInContact){if(typeof hackIpInContact==="boolean"){return hackIpInContact}else if(typeof hackIpInContact==="string"&&SIP.Grammar.parse(hackIpInContact,"host")!==-1){return hackIpInContact}},iceCheckingTimeout:function(iceCheckingTimeout){if(SIP.Utils.isDecimal(iceCheckingTimeout)){return Math.max(500,iceCheckingTimeout)}},hackWssInTransport:function(hackWssInTransport){if(typeof hackWssInTransport==="boolean"){return hackWssInTransport}},hackAllowUnregisteredOptionTags:function(hackAllowUnregisteredOptionTags){if(typeof hackAllowUnregisteredOptionTags==="boolean"){return hackAllowUnregisteredOptionTags}},hackCleanJitsiSdpImageattr:function(hackCleanJitsiSdpImageattr){if(typeof hackCleanJitsiSdpImageattr==="boolean"){return hackCleanJitsiSdpImageattr}},hackStripTcp:function(hackStripTcp){if(typeof hackStripTcp==="boolean"){return hackStripTcp}},contactTransport:function(contactTransport){if(typeof contactTransport==="string"){return contactTransport}},forceRport:function(forceRport){if(typeof forceRport==="boolean"){return forceRport}},instanceId:function(instanceId){if(typeof instanceId!=="string"){return}if(/^uuid:/i.test(instanceId)){instanceId=instanceId.substr(5)}if(SIP.Grammar.parse(instanceId,"uuid")===-1){return}else{return instanceId}},keepAliveInterval:function(keepAliveInterval){var value;if(SIP.Utils.isDecimal(keepAliveInterval)){value=Number(keepAliveInterval);if(value>0){return value}}},extraSupported:function(optionTags){var idx,length;if(!(optionTags instanceof Array)){return}length=optionTags.length;for(idx=0;idx<length;idx++){if(typeof optionTags[idx]!=="string"){return}}return optionTags},noAnswerTimeout:function(noAnswerTimeout){var value;if(SIP.Utils.isDecimal(noAnswerTimeout)){value=Number(noAnswerTimeout);if(value>0){return value}}},password:function(password){return String(password)},rel100:function(rel100){if(rel100===SIP.C.supported.REQUIRED){return SIP.C.supported.REQUIRED}else if(rel100===SIP.C.supported.SUPPORTED){return SIP.C.supported.SUPPORTED}else{return SIP.C.supported.UNSUPPORTED}},replaces:function(replaces){if(replaces===SIP.C.supported.REQUIRED){return SIP.C.supported.REQUIRED}else if(replaces===SIP.C.supported.SUPPORTED){return SIP.C.supported.SUPPORTED}else{return SIP.C.supported.UNSUPPORTED}},register:function(register){if(typeof register==="boolean"){return register}},registerExpires:function(registerExpires){var value;if(SIP.Utils.isDecimal(registerExpires)){value=Number(registerExpires);if(value>0){return value}}},registrarServer:function(registrarServer){var parsed;if(typeof registrarServer!=="string"){return}if(!/^sip:/i.test(registrarServer)){registrarServer=SIP.C.SIP+":"+registrarServer}parsed=SIP.URI.parse(registrarServer);if(!parsed){return}else if(parsed.user){return}else{return parsed}},stunServers:function(stunServers){var idx,length,stun_server;if(typeof stunServers==="string"){stunServers=[stunServers]}else if(!(stunServers instanceof Array)){return}length=stunServers.length;for(idx=0;idx<length;idx++){stun_server=stunServers[idx];if(!/^stuns?:/.test(stun_server)){stun_server="stun:"+stun_server}if(SIP.Grammar.parse(stun_server,"stun_URI")===-1){return}else{stunServers[idx]=stun_server}}return stunServers},traceSip:function(traceSip){if(typeof traceSip==="boolean"){return traceSip}},turnServers:function(turnServers){var idx,jdx,length,turn_server,num_turn_server_urls,url;if(turnServers instanceof Array){}else{turnServers=[turnServers]}length=turnServers.length;for(idx=0;idx<length;idx++){turn_server=turnServers[idx];if(turn_server.server){turn_server.urls=[turn_server.server]}if(!turn_server.urls||!turn_server.username||!turn_server.password){return}if(turn_server.urls instanceof Array){num_turn_server_urls=turn_server.urls.length}else{turn_server.urls=[turn_server.urls];num_turn_server_urls=1}for(jdx=0;jdx<num_turn_server_urls;jdx++){url=turn_server.urls[jdx];if(!/^turns?:/.test(url)){url="turn:"+url}if(SIP.Grammar.parse(url,"turn_URI")===-1){return}}}return turnServers},userAgentString:function(userAgentString){if(typeof userAgentString==="string"){return userAgentString}},usePreloadedRoute:function(usePreloadedRoute){if(typeof usePreloadedRoute==="boolean"){return usePreloadedRoute}},wsServerMaxReconnection:function(wsServerMaxReconnection){var value;if(SIP.Utils.isDecimal(wsServerMaxReconnection)){value=Number(wsServerMaxReconnection);if(value>0){return value}}},wsServerReconnectionTimeout:function(wsServerReconnectionTimeout){var value;if(SIP.Utils.isDecimal(wsServerReconnectionTimeout)){value=Number(wsServerReconnectionTimeout);if(value>0){return value}}},autostart:function(autostart){if(typeof autostart==="boolean"){return autostart}},mediaHandlerFactory:function(mediaHandlerFactory){if(mediaHandlerFactory instanceof Function){var promisifiedFactory=function promisifiedFactory(){var mediaHandler=mediaHandlerFactory.apply(this,arguments);function patchMethod(methodName){var method=mediaHandler[methodName];if(method.length>1){var callbacksFirst=methodName==="getDescription";mediaHandler[methodName]=SIP.Utils.promisify(mediaHandler,methodName,callbacksFirst)}}patchMethod("getDescription");patchMethod("setDescription");return mediaHandler};promisifiedFactory.isSupported=mediaHandlerFactory.isSupported;return promisifiedFactory}},authenticationFactory:checkAuthenticationFactory,allowLegacyNotifications:function(allowLegacyNotifications){if(typeof allowLegacyNotifications==="boolean"){return allowLegacyNotifications}}}};UA.C=C;SIP.UA=UA}}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{}],155:[function(require,module,exports){"use strict";module.exports=function(SIP){var URI;URI=function(scheme,user,host,port,parameters,headers){var param,header,raw,normal;if(!host){throw new TypeError('missing or invalid "host" parameter')}scheme=scheme||SIP.C.SIP;this.parameters={};this.headers={};for(param in parameters){this.setParam(param,parameters[param])}for(header in headers){this.setHeader(header,headers[header])}raw={scheme:scheme,user:user,host:host,port:port};normal={scheme:scheme.toLowerCase(),user:user,host:host.toLowerCase(),port:port};Object.defineProperties(this,{_normal:{get:function(){return normal}},_raw:{get:function(){return raw}},scheme:{get:function(){return normal.scheme},set:function(value){raw.scheme=value;normal.scheme=value.toLowerCase()}},user:{get:function(){return normal.user},set:function(value){normal.user=raw.user=value}},host:{get:function(){return normal.host},set:function(value){raw.host=value;normal.host=value.toLowerCase()}},aor:{get:function(){return normal.user+"@"+normal.host}},port:{get:function(){return normal.port},set:function(value){normal.port=raw.port=value===0?value:parseInt(value,10)||null}}})};URI.prototype={setParam:function(key,value){if(key){this.parameters[key.toLowerCase()]=typeof value==="undefined"||value===null?null:value.toString().toLowerCase()}},getParam:function(key){if(key){return this.parameters[key.toLowerCase()]}},hasParam:function(key){if(key){return this.parameters.hasOwnProperty(key.toLowerCase())&&true||false}},deleteParam:function(parameter){var value;parameter=parameter.toLowerCase();if(this.parameters.hasOwnProperty(parameter)){value=this.parameters[parameter];delete this.parameters[parameter];return value}},clearParams:function(){this.parameters={}},setHeader:function(name,value){this.headers[SIP.Utils.headerize(name)]=value instanceof Array?value:[value]},getHeader:function(name){if(name){return this.headers[SIP.Utils.headerize(name)]}},hasHeader:function(name){if(name){return this.headers.hasOwnProperty(SIP.Utils.headerize(name))&&true||false}},deleteHeader:function(header){var value;header=SIP.Utils.headerize(header);if(this.headers.hasOwnProperty(header)){value=this.headers[header];delete this.headers[header];return value}},clearHeaders:function(){this.headers={}},clone:function(){return new URI(this._raw.scheme,this._raw.user,this._raw.host,this._raw.port,JSON.parse(JSON.stringify(this.parameters)),JSON.parse(JSON.stringify(this.headers)))},toRaw:function(){return this._toString(this._raw)},toString:function(){return this._toString(this._normal)},_toString:function(uri){var header,parameter,idx,uriString,headers=[];uriString=uri.scheme+":";if(!uri.scheme.toLowerCase().match("^sips?$")){uriString+="//"}if(uri.user){uriString+=SIP.Utils.escapeUser(uri.user)+"@"}uriString+=uri.host;if(uri.port||uri.port===0){uriString+=":"+uri.port}for(parameter in this.parameters){uriString+=";"+parameter;if(this.parameters[parameter]!==null){uriString+="="+this.parameters[parameter]}}for(header in this.headers){for(idx in this.headers[header]){headers.push(header+"="+this.headers[header][idx])}}if(headers.length>0){uriString+="?"+headers.join("&")}return uriString}};URI.parse=function(uri){uri=SIP.Grammar.parse(uri,"SIP_URI");if(uri!==-1){return uri}else{return undefined}};SIP.URI=URI}},{}],156:[function(require,module,exports){"use strict";module.exports=function(SIP,environment){var Utils;Utils={Promise:environment.Promise,defer:function defer(){var deferred={};deferred.promise=new Utils.Promise(function(resolve,reject){deferred.resolve=resolve;deferred.reject=reject});return deferred},promisify:function promisify(object,methodName,callbacksFirst){var oldMethod=object[methodName];return function promisifiedMethod(arg,onSuccess,onFailure){return new Utils.Promise(function(resolve,reject){var oldArgs=[arg,resolve,reject];if(callbacksFirst){oldArgs=[resolve,reject,arg]}oldMethod.apply(object,oldArgs)}).then(onSuccess,onFailure)}},augment:function(object,constructor,args,override){var idx,proto;proto=constructor.prototype;for(idx in proto){if(override||object[idx]===undefined){object[idx]=proto[idx]}}constructor.apply(object,args)},optionsOverride:function(options,winner,loser,isDeprecated,logger,defaultValue){if(isDeprecated&&options[loser]){logger.warn(loser+" is deprecated, please use "+winner+" instead")}if(options[winner]&&options[loser]){logger.warn(winner+" overriding "+loser)}options[winner]=options[winner]||options[loser]||defaultValue},str_utf8_length:function(string){return encodeURIComponent(string).replace(/%[A-F\d]{2}/g,"U").length},generateFakeSDP:function(body){if(!body){return}var start=body.indexOf("o=");var end=body.indexOf("\r\n",start);return"v=0\r\n"+body.slice(start,end)+"\r\ns=-\r\nt=0 0\r\nc=IN IP4 0.0.0.0"},isFunction:function(fn){if(fn!==undefined){return Object.prototype.toString.call(fn)==="[object Function]"}else{return false}},isDecimal:function(num){return!isNaN(num)&&parseFloat(num)===parseInt(num,10)},createRandomToken:function(size,base){var i,r,token="";base=base||32;for(i=0;i<size;i++){r=Math.random()*base|0;token+=r.toString(base)}return token},newTag:function(){return SIP.Utils.createRandomToken(SIP.UA.C.TAG_LENGTH)},newUUID:function(){var UUID="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r=Math.random()*16|0,v=c==="x"?r:r&3|8;return v.toString(16)});return UUID},hostType:function(host){if(!host){return}else{host=SIP.Grammar.parse(host,"host");if(host!==-1){return host.host_type}}},normalizeTarget:function(target,domain){var uri,target_array,target_user,target_domain;if(!target){return}else if(target instanceof SIP.URI){return target}else if(typeof target==="string"){target_array=target.split("@");switch(target_array.length){case 1:if(!domain){return}target_user=target;target_domain=domain;break;case 2:target_user=target_array[0];target_domain=target_array[1];break;default:target_user=target_array.slice(0,target_array.length-1).join("@");target_domain=target_array[target_array.length-1]}target_user=target_user.replace(/^(sips?|tel):/i,"");if(/^[\-\.\(\)]*\+?[0-9\-\.\(\)]+$/.test(target_user)){target_user=target_user.replace(/[\-\.\(\)]/g,"")}target=SIP.C.SIP+":"+SIP.Utils.escapeUser(target_user)+"@"+target_domain;if(uri=SIP.URI.parse(target)){return uri}else{return}}else{return}},escapeUser:function(user){return encodeURIComponent(decodeURIComponent(user)).replace(/%3A/gi,":").replace(/%2B/gi,"+").replace(/%3F/gi,"?").replace(/%2F/gi,"/")},headerize:function(string){var exceptions={"Call-Id":"Call-ID",Cseq:"CSeq","Min-Se":"Min-SE",Rack:"RAck",Rseq:"RSeq","Www-Authenticate":"WWW-Authenticate"},name=string.toLowerCase().replace(/_/g,"-").split("-"),hname="",parts=name.length,part;for(part=0;part<parts;part++){if(part!==0){hname+="-"}hname+=name[part].charAt(0).toUpperCase()+name[part].substring(1)}if(exceptions[hname]){hname=exceptions[hname]}return hname},sipErrorCause:function(status_code){var cause;for(cause in SIP.C.SIP_ERROR_CAUSES){if(SIP.C.SIP_ERROR_CAUSES[cause].indexOf(status_code)!==-1){return SIP.C.causes[cause]}}return SIP.C.causes.SIP_FAILURE_CODE},getReasonPhrase:function getReasonPhrase(code,specific){return specific||SIP.C.REASON_PHRASE[code]||""},getReasonHeaderValue:function getReasonHeaderValue(code,reason){reason=SIP.Utils.getReasonPhrase(code,reason);return"SIP ;cause="+code+' ;text="'+reason+'"'},getCancelReason:function getCancelReason(code,reason){if(code&&code<200||code>699){throw new TypeError("Invalid status_code: "+code)}else if(code){return SIP.Utils.getReasonHeaderValue(code,reason)}},buildStatusLine:function buildStatusLine(code,reason){code=code||null;reason=reason||null;if(!code||(code<100||code>699)){throw new TypeError("Invalid status_code: "+code)}else if(reason&&typeof reason!=="string"&&!(reason instanceof String)){throw new TypeError("Invalid reason_phrase: "+reason)}reason=Utils.getReasonPhrase(code,reason);return"SIP/2.0 "+code+" "+reason+"\r\n"},getRandomTestNetIP:function(){function getOctet(from,to){return Math.floor(Math.random()*(to-from+1)+from)}return"192.0.2."+getOctet(1,254)},calculateMD5:function(string){function RotateLeft(lValue,iShiftBits){return lValue<<iShiftBits|lValue>>>32-iShiftBits}function AddUnsigned(lX,lY){var lX4,lY4,lX8,lY8,lResult;lX8=lX&2147483648;lY8=lY&2147483648;lX4=lX&1073741824;lY4=lY&1073741824;lResult=(lX&1073741823)+(lY&1073741823);if(lX4&lY4){return lResult^2147483648^lX8^lY8}if(lX4|lY4){if(lResult&1073741824){return lResult^3221225472^lX8^lY8}else{return lResult^1073741824^lX8^lY8}}else{return lResult^lX8^lY8}}function F(x,y,z){return x&y|~x&z}function G(x,y,z){return x&z|y&~z}function H(x,y,z){return x^y^z}function I(x,y,z){return y^(x|~z)}function FF(a,b,c,d,x,s,ac){a=AddUnsigned(a,AddUnsigned(AddUnsigned(F(b,c,d),x),ac));return AddUnsigned(RotateLeft(a,s),b)}function GG(a,b,c,d,x,s,ac){a=AddUnsigned(a,AddUnsigned(AddUnsigned(G(b,c,d),x),ac));return AddUnsigned(RotateLeft(a,s),b)}function HH(a,b,c,d,x,s,ac){a=AddUnsigned(a,AddUnsigned(AddUnsigned(H(b,c,d),x),ac));return AddUnsigned(RotateLeft(a,s),b)}function II(a,b,c,d,x,s,ac){a=AddUnsigned(a,AddUnsigned(AddUnsigned(I(b,c,d),x),ac));return AddUnsigned(RotateLeft(a,s),b)}function ConvertToWordArray(string){var lWordCount;var lMessageLength=string.length;var lNumberOfWords_temp1=lMessageLength+8;var lNumberOfWords_temp2=(lNumberOfWords_temp1-lNumberOfWords_temp1%64)/64;var lNumberOfWords=(lNumberOfWords_temp2+1)*16;var lWordArray=Array(lNumberOfWords-1);var lBytePosition=0;var lByteCount=0;while(lByteCount<lMessageLength){lWordCount=(lByteCount-lByteCount%4)/4;lBytePosition=lByteCount%4*8;lWordArray[lWordCount]=lWordArray[lWordCount]|string.charCodeAt(lByteCount)<<lBytePosition;lByteCount++}lWordCount=(lByteCount-lByteCount%4)/4;lBytePosition=lByteCount%4*8;lWordArray[lWordCount]=lWordArray[lWordCount]|128<<lBytePosition;lWordArray[lNumberOfWords-2]=lMessageLength<<3;lWordArray[lNumberOfWords-1]=lMessageLength>>>29;return lWordArray}function WordToHex(lValue){var WordToHexValue="",WordToHexValue_temp="",lByte,lCount;for(lCount=0;lCount<=3;lCount++){lByte=lValue>>>lCount*8&255;WordToHexValue_temp="0"+lByte.toString(16);WordToHexValue=WordToHexValue+WordToHexValue_temp.substr(WordToHexValue_temp.length-2,2)}return WordToHexValue}function Utf8Encode(string){string=string.replace(/\r\n/g,"\n");var utftext="";for(var n=0;n<string.length;n++){var c=string.charCodeAt(n);if(c<128){utftext+=String.fromCharCode(c)}else if(c>127&&c<2048){utftext+=String.fromCharCode(c>>6|192);utftext+=String.fromCharCode(c&63|128)}else{utftext+=String.fromCharCode(c>>12|224);utftext+=String.fromCharCode(c>>6&63|128);utftext+=String.fromCharCode(c&63|128)}}return utftext}var x=[];var k,AA,BB,CC,DD,a,b,c,d;var S11=7,S12=12,S13=17,S14=22;var S21=5,S22=9,S23=14,S24=20;var S31=4,S32=11,S33=16,S34=23;var S41=6,S42=10,S43=15,S44=21;string=Utf8Encode(string);x=ConvertToWordArray(string);a=1732584193;b=4023233417;c=2562383102;d=271733878;for(k=0;k<x.length;k+=16){AA=a;BB=b;CC=c;DD=d;a=FF(a,b,c,d,x[k+0],S11,3614090360);d=FF(d,a,b,c,x[k+1],S12,3905402710);c=FF(c,d,a,b,x[k+2],S13,606105819);b=FF(b,c,d,a,x[k+3],S14,3250441966);a=FF(a,b,c,d,x[k+4],S11,4118548399);d=FF(d,a,b,c,x[k+5],S12,1200080426);c=FF(c,d,a,b,x[k+6],S13,2821735955);b=FF(b,c,d,a,x[k+7],S14,4249261313);a=FF(a,b,c,d,x[k+8],S11,1770035416);d=FF(d,a,b,c,x[k+9],S12,2336552879);c=FF(c,d,a,b,x[k+10],S13,4294925233);b=FF(b,c,d,a,x[k+11],S14,2304563134);a=FF(a,b,c,d,x[k+12],S11,1804603682);d=FF(d,a,b,c,x[k+13],S12,4254626195);c=FF(c,d,a,b,x[k+14],S13,2792965006);b=FF(b,c,d,a,x[k+15],S14,1236535329);a=GG(a,b,c,d,x[k+1],S21,4129170786);d=GG(d,a,b,c,x[k+6],S22,3225465664);c=GG(c,d,a,b,x[k+11],S23,643717713);b=GG(b,c,d,a,x[k+0],S24,3921069994);a=GG(a,b,c,d,x[k+5],S21,3593408605);d=GG(d,a,b,c,x[k+10],S22,38016083);c=GG(c,d,a,b,x[k+15],S23,3634488961);b=GG(b,c,d,a,x[k+4],S24,3889429448);a=GG(a,b,c,d,x[k+9],S21,568446438);d=GG(d,a,b,c,x[k+14],S22,3275163606);c=GG(c,d,a,b,x[k+3],S23,4107603335);b=GG(b,c,d,a,x[k+8],S24,1163531501);a=GG(a,b,c,d,x[k+13],S21,2850285829);d=GG(d,a,b,c,x[k+2],S22,4243563512);c=GG(c,d,a,b,x[k+7],S23,1735328473);b=GG(b,c,d,a,x[k+12],S24,2368359562);a=HH(a,b,c,d,x[k+5],S31,4294588738);d=HH(d,a,b,c,x[k+8],S32,2272392833);c=HH(c,d,a,b,x[k+11],S33,1839030562);b=HH(b,c,d,a,x[k+14],S34,4259657740);a=HH(a,b,c,d,x[k+1],S31,2763975236);d=HH(d,a,b,c,x[k+4],S32,1272893353);c=HH(c,d,a,b,x[k+7],S33,4139469664);b=HH(b,c,d,a,x[k+10],S34,3200236656);a=HH(a,b,c,d,x[k+13],S31,681279174);d=HH(d,a,b,c,x[k+0],S32,3936430074);c=HH(c,d,a,b,x[k+3],S33,3572445317);b=HH(b,c,d,a,x[k+6],S34,76029189);a=HH(a,b,c,d,x[k+9],S31,3654602809);d=HH(d,a,b,c,x[k+12],S32,3873151461);c=HH(c,d,a,b,x[k+15],S33,530742520);b=HH(b,c,d,a,x[k+2],S34,3299628645);a=II(a,b,c,d,x[k+0],S41,4096336452);d=II(d,a,b,c,x[k+7],S42,1126891415);c=II(c,d,a,b,x[k+14],S43,2878612391);b=II(b,c,d,a,x[k+5],S44,4237533241);a=II(a,b,c,d,x[k+12],S41,1700485571);d=II(d,a,b,c,x[k+3],S42,2399980690);c=II(c,d,a,b,x[k+10],S43,4293915773);b=II(b,c,d,a,x[k+1],S44,2240044497);a=II(a,b,c,d,x[k+8],S41,1873313359);d=II(d,a,b,c,x[k+15],S42,4264355552);c=II(c,d,a,b,x[k+6],S43,2734768916);b=II(b,c,d,a,x[k+13],S44,1309151649);a=II(a,b,c,d,x[k+4],S41,4149444226);d=II(d,a,b,c,x[k+11],S42,3174756917);c=II(c,d,a,b,x[k+2],S43,718787259);b=II(b,c,d,a,x[k+9],S44,3951481745);a=AddUnsigned(a,AA);b=AddUnsigned(b,BB);c=AddUnsigned(c,CC);d=AddUnsigned(d,DD)}var temp=WordToHex(a)+WordToHex(b)+WordToHex(c)+WordToHex(d);return temp.toLowerCase()}};SIP.Utils=Utils}},{}],157:[function(require,module,exports){"use strict";module.exports=function(SIP,environment){var WebRTC;WebRTC={};WebRTC.MediaHandler=require("./WebRTC/MediaHandler")(SIP);WebRTC.MediaStreamManager=require("./WebRTC/MediaStreamManager")(SIP,environment);var _isSupported;WebRTC.isSupported=function(){if(_isSupported!==undefined){return _isSupported}WebRTC.MediaStream=environment.MediaStream;WebRTC.getUserMedia=environment.getUserMedia;WebRTC.RTCPeerConnection=environment.RTCPeerConnection;WebRTC.RTCSessionDescription=environment.RTCSessionDescription;if(WebRTC.RTCPeerConnection&&WebRTC.RTCSessionDescription){if(WebRTC.getUserMedia){WebRTC.getUserMedia=SIP.Utils.promisify(environment,"getUserMedia")}_isSupported=true}else{_isSupported=false}return _isSupported};return WebRTC}},{"./WebRTC/MediaHandler":158,"./WebRTC/MediaStreamManager":159}],158:[function(require,module,exports){"use strict";module.exports=function(SIP){var MediaHandler=function(session,options){options=options||{};this.logger=session.ua.getLogger("sip.invitecontext.mediahandler",session.id);this.session=session;this.localMedia=null;this.ready=true;this.mediaStreamManager=options.mediaStreamManager||new SIP.WebRTC.MediaStreamManager(this.logger);this.audioMuted=false;this.videoMuted=false;this.local_hold=false;this.remote_hold=false;var servers=this.prepareIceServers(options.stunServers,options.turnServers);this.RTCConstraints=options.RTCConstraints||{};this.initPeerConnection(servers);function selfEmit(mh,event){if(mh.mediaStreamManager.on){mh.mediaStreamManager.on(event,function(){mh.emit.apply(mh,[event].concat(Array.prototype.slice.call(arguments)))})}}selfEmit(this,"userMediaRequest");selfEmit(this,"userMedia");selfEmit(this,"userMediaFailed")};MediaHandler.defaultFactory=function defaultFactory(session,options){return new MediaHandler(session,options)};MediaHandler.defaultFactory.isSupported=function(){return SIP.WebRTC.isSupported()};MediaHandler.prototype=Object.create(SIP.MediaHandler.prototype,{isReady:{writable:true,value:function isReady(){return this.ready}},close:{writable:true,value:function close(){this.logger.log("closing PeerConnection");this._remoteStreams=[];if(this.peerConnection&&this.peerConnection.signalingState!=="closed"){this.peerConnection.close();if(this.localMedia){this.mediaStreamManager.release(this.localMedia)}}}},getDescription:{writable:true,value:function getDescription(mediaHint){var self=this;var acquire=self.mediaStreamManager.acquire;if(acquire.length>1){acquire=SIP.Utils.promisify(this.mediaStreamManager,"acquire",true)}mediaHint=mediaHint||{};if(mediaHint.dataChannel===true){mediaHint.dataChannel={}}this.mediaHint=mediaHint;var streamPromise;if(self.localMedia){self.logger.log("already have local media");streamPromise=SIP.Utils.Promise.resolve(self.localMedia)}else{self.logger.log("acquiring local media");streamPromise=acquire.call(self.mediaStreamManager,mediaHint).then(function acquireSucceeded(streams){self.logger.log("acquired local media streams");self.localMedia=streams;self.session.connecting();return streams},function acquireFailed(err){self.logger.error("unable to acquire streams");self.logger.error(err);self.session.connecting();throw err}).then(this.addStreams.bind(this))}return streamPromise.then(function streamAdditionSucceeded(){if(self.hasOffer("remote")){self.peerConnection.ondatachannel=function(evt){self.dataChannel=evt.channel;self.emit("dataChannel",self.dataChannel)}}else if(mediaHint.dataChannel&&self.peerConnection.createDataChannel){self.dataChannel=self.peerConnection.createDataChannel("sipjs",mediaHint.dataChannel);self.emit("dataChannel",self.dataChannel)}self.render();return self.createOfferOrAnswer(self.RTCConstraints)}).then(function(sdp){sdp=SIP.Hacks.Firefox.hasMissingCLineInSDP(sdp);if(self.local_hold){if(!/a=(sendrecv|sendonly|recvonly|inactive)/.test(sdp)){sdp=sdp.replace(/(m=[^\r]*\r\n)/g,"$1a=sendonly\r\n")}else{sdp=sdp.replace(/a=sendrecv\r\n/g,"a=sendonly\r\n");sdp=sdp.replace(/a=recvonly\r\n/g,"a=inactive\r\n")}}return{body:sdp,contentType:"application/sdp"}})}},hasDescription:{writeable:true,value:function hasDescription(message){return message.getHeader("Content-Type")==="application/sdp"&&!!message.body}},setDescription:{writable:true,value:function setDescription(message){var sdp=message.body;this.remote_hold=/a=(sendonly|inactive)/.test(sdp);sdp=SIP.Hacks.Firefox.cannotHandleExtraWhitespace(sdp);sdp=SIP.Hacks.AllBrowsers.maskDtls(sdp);var rawDescription={type:this.hasOffer("local")?"answer":"offer",sdp:sdp};this.emit("setDescription",rawDescription);var description=new SIP.WebRTC.RTCSessionDescription(rawDescription);return SIP.Utils.promisify(this.peerConnection,"setRemoteDescription")(description)}},getReferMedia:{writable:true,value:function getReferMedia(){function hasTracks(trackGetter,stream){return stream[trackGetter]().length>0}function bothHaveTracks(trackGetter){return this.getLocalStreams().some(hasTracks.bind(null,trackGetter))&&this.getRemoteStreams().some(hasTracks.bind(null,trackGetter))}return{constraints:{audio:bothHaveTracks.call(this,"getAudioTracks"),video:bothHaveTracks.call(this,"getVideoTracks")}}}},updateIceServers:{writeable:true,value:function(options){var servers=this.prepareIceServers(options.stunServers,options.turnServers);this.RTCConstraints=options.RTCConstraints||this.RTCConstraints;this.initPeerConnection(servers)}},isMuted:{writable:true,value:function isMuted(){return{audio:this.audioMuted,video:this.videoMuted}}},mute:{writable:true,value:function mute(options){if(this.getLocalStreams().length===0){return}options=options||{audio:this.getLocalStreams()[0].getAudioTracks().length>0,video:this.getLocalStreams()[0].getVideoTracks().length>0};var audioMuted=false,videoMuted=false;if(options.audio&&!this.audioMuted){audioMuted=true;this.audioMuted=true;this.toggleMuteAudio(true)}if(options.video&&!this.videoMuted){videoMuted=true;this.videoMuted=true;this.toggleMuteVideo(true)}if(audioMuted||videoMuted){return{audio:audioMuted,video:videoMuted}}}},unmute:{writable:true,value:function unmute(options){if(this.getLocalStreams().length===0){return}options=options||{audio:this.getLocalStreams()[0].getAudioTracks().length>0,video:this.getLocalStreams()[0].getVideoTracks().length>0};var audioUnMuted=false,videoUnMuted=false;if(options.audio&&this.audioMuted){audioUnMuted=true;this.audioMuted=false;this.toggleMuteAudio(false)}if(options.video&&this.videoMuted){videoUnMuted=true;this.videoMuted=false;this.toggleMuteVideo(false)}if(audioUnMuted||videoUnMuted){return{audio:audioUnMuted,video:videoUnMuted}}}},hold:{writable:true,value:function hold(){this.local_hold=true;this.toggleMuteAudio(true);this.toggleMuteVideo(true)}},unhold:{writable:true,value:function unhold(){this.local_hold=false;if(!this.audioMuted){this.toggleMuteAudio(false)}if(!this.videoMuted){this.toggleMuteVideo(false)}}},getLocalStreams:{writable:true,value:function getLocalStreams(){var pc=this.peerConnection;if(pc&&pc.signalingState==="closed"){this.logger.warn("peerConnection is closed, getLocalStreams returning []");return[]}return pc.getLocalStreams&&pc.getLocalStreams()||pc.localStreams||[]}},getRemoteStreams:{writable:true,value:function getRemoteStreams(){var pc=this.peerConnection;if(pc&&pc.signalingState==="closed"){this.logger.warn("peerConnection is closed, getRemoteStreams returning this._remoteStreams");return this._remoteStreams}return pc.getRemoteStreams&&pc.getRemoteStreams()||pc.remoteStreams||[]}},render:{writable:true,value:function render(renderHint){renderHint=renderHint||this.mediaHint&&this.mediaHint.render;if(!renderHint){return false}var streamGetters={local:"getLocalStreams",remote:"getRemoteStreams"};Object.keys(streamGetters).forEach(function(loc){var streamGetter=streamGetters[loc];var streams=this[streamGetter]();SIP.WebRTC.MediaStreamManager.render(streams,renderHint[loc])}.bind(this))}},hasOffer:{writable:true,value:function hasOffer(where){var offerState="have-"+where+"-offer";return this.peerConnection.signalingState===offerState}},prepareIceServers:{writable:true,value:function prepareIceServers(stunServers,turnServers){var servers=[],config=this.session.ua.configuration;stunServers=stunServers||config.stunServers;turnServers=turnServers||config.turnServers;[].concat(stunServers).forEach(function(server){servers.push({urls:server})});[].concat(turnServers).forEach(function(server){servers.push({urls:server.urls,username:server.username,credential:server.password})});return servers}},initPeerConnection:{writable:true,value:function initPeerConnection(servers){var self=this,config=this.session.ua.configuration;this.onIceCompleted=SIP.Utils.defer();this.onIceCompleted.promise.then(function(pc){self.emit("iceGatheringComplete",pc);if(self.iceCheckingTimer){SIP.Timers.clearTimeout(self.iceCheckingTimer);self.iceCheckingTimer=null}});if(this.peerConnection){this.peerConnection.close()}this.peerConnection=new SIP.WebRTC.RTCPeerConnection({iceServers:servers});this._remoteStreams=[];this.peerConnection.onaddstream=function(e){self.logger.log("stream added: "+e.stream.id);self._remoteStreams.push(e.stream);self.render();self.emit("addStream",e)};this.peerConnection.onremovestream=function(e){self.logger.log("stream removed: "+e.stream.id)};this.startIceCheckingTimer=function(){if(!self.iceCheckingTimer){self.iceCheckingTimer=SIP.Timers.setTimeout(function(){self.logger.log("RTCIceChecking Timeout Triggered after "+config.iceCheckingTimeout+" milliseconds");self.onIceCompleted.resolve(this)}.bind(this.peerConnection),config.iceCheckingTimeout)}};this.peerConnection.onicecandidate=function(e){self.emit("iceCandidate",e);if(e.candidate){self.logger.log("ICE candidate received: "+(e.candidate.candidate===null?null:e.candidate.candidate.trim()));self.startIceCheckingTimer()}else{self.onIceCompleted.resolve(this)}};this.peerConnection.onicegatheringstatechange=function(){
                self.logger.log("RTCIceGatheringState changed: "+this.iceGatheringState);if(this.iceGatheringState==="gathering"){self.emit("iceGathering",this)}if(this.iceGatheringState==="complete"){self.onIceCompleted.resolve(this)}};this.peerConnection.oniceconnectionstatechange=function(){var stateEvent;if(this.iceConnectionState==="checking"){self.startIceCheckingTimer()}switch(this.iceConnectionState){case"new":stateEvent="iceConnection";break;case"checking":stateEvent="iceConnectionChecking";break;case"connected":stateEvent="iceConnectionConnected";break;case"completed":stateEvent="iceConnectionCompleted";break;case"failed":stateEvent="iceConnectionFailed";break;case"disconnected":stateEvent="iceConnectionDisconnected";break;case"closed":stateEvent="iceConnectionClosed";break;default:self.logger.warn("Unknown iceConnection state:",this.iceConnectionState);return}self.emit(stateEvent,this)};this.peerConnection.onstatechange=function(){self.logger.log('PeerConnection state changed to "'+this.readyState+'"')}}},createOfferOrAnswer:{writable:true,value:function createOfferOrAnswer(constraints){var self=this;var methodName;var pc=self.peerConnection;self.ready=false;methodName=self.hasOffer("remote")?"createAnswer":"createOffer";return SIP.Utils.promisify(pc,methodName,true)(constraints).then(SIP.Utils.promisify(pc,"setLocalDescription")).then(function onSetLocalDescriptionSuccess(){var deferred=SIP.Utils.defer();if(pc.iceConnectionState==="complete"||pc.iceConnectionState==="completed"){deferred.resolve()}else{self.onIceCompleted.promise.then(deferred.resolve)}return deferred.promise}).then(function readySuccess(){var sdp=pc.localDescription.sdp;sdp=SIP.Hacks.Chrome.needsExplicitlyInactiveSDP(sdp);sdp=SIP.Hacks.AllBrowsers.unmaskDtls(sdp);var sdpWrapper={type:methodName==="createOffer"?"offer":"answer",sdp:sdp};self.emit("getDescription",sdpWrapper);if(self.session.ua.configuration.hackStripTcp){sdpWrapper.sdp=sdpWrapper.sdp.replace(/^a=candidate:\d+ \d+ tcp .*?\r\n/gim,"")}self.ready=true;return sdpWrapper.sdp}).catch(function methodFailed(e){self.logger.error(e);self.ready=true;throw new SIP.Exceptions.GetDescriptionError(e)})}},addStreams:{writable:true,value:function addStreams(streams){try{streams=[].concat(streams);streams.forEach(function(stream){this.peerConnection.addStream(stream)},this)}catch(e){this.logger.error("error adding stream");this.logger.error(e);return SIP.Utils.Promise.reject(e)}return SIP.Utils.Promise.resolve()}},toggleMuteHelper:{writable:true,value:function toggleMuteHelper(trackGetter,mute){this.getLocalStreams().forEach(function(stream){stream[trackGetter]().forEach(function(track){track.enabled=!mute})})}},toggleMuteAudio:{writable:true,value:function toggleMuteAudio(mute){this.toggleMuteHelper("getAudioTracks",mute)}},toggleMuteVideo:{writable:true,value:function toggleMuteVideo(mute){this.toggleMuteHelper("getVideoTracks",mute)}}});return MediaHandler}},{}],159:[function(require,module,exports){"use strict";module.exports=function(SIP,environment){var MediaStreamManager=function MediaStreamManager(logger,defaultMediaHint){if(!SIP.WebRTC.isSupported()){throw new SIP.Exceptions.NotSupportedError("Media not supported")}this.mediaHint=defaultMediaHint||{constraints:{audio:true,video:true}};this.acquisitions={}};MediaStreamManager.streamId=function(stream){return stream.getAudioTracks().concat(stream.getVideoTracks()).map(function trackId(track){return track.id}).join("")};MediaStreamManager.render=function render(streams,elements){if(!elements){return false}if(Array.isArray(elements)&&!elements.length){throw new TypeError("elements must not be empty")}function attachMediaStream(element,stream){element.srcObject=stream}function ensureMediaPlaying(mediaElement){var interval=100;mediaElement.ensurePlayingIntervalId=SIP.Timers.setInterval(function(){if(mediaElement.paused&&mediaElement.srcObject){mediaElement.play()}else{SIP.Timers.clearInterval(mediaElement.ensurePlayingIntervalId)}},interval)}function attachAndPlay(elements,stream,index){var element=elements[index%elements.length];if(typeof element==="function"){element=element()}(environment.attachMediaStream||attachMediaStream)(element,stream);ensureMediaPlaying(element)}elements=[].concat(elements);[].concat(streams).forEach(attachAndPlay.bind(null,elements))};MediaStreamManager.prototype=Object.create(SIP.EventEmitter.prototype,{acquire:{writable:true,value:function acquire(mediaHint){mediaHint=Object.keys(mediaHint||{}).length?mediaHint:this.mediaHint;var saveSuccess=function(isHintStream,streams){streams=[].concat(streams);streams.forEach(function(stream){var streamId=MediaStreamManager.streamId(stream);this.acquisitions[streamId]=!!isHintStream},this);return SIP.Utils.Promise.resolve(streams)}.bind(this);if(mediaHint.stream){return saveSuccess(true,mediaHint.stream)}else{var constraints=mediaHint.constraints||this.mediaHint&&this.mediaHint.constraints||{audio:true,video:true};var deferred=SIP.Utils.defer();SIP.Timers.setTimeout(function(){this.emit("userMediaRequest",constraints);var emitThenCall=function(eventName,callback){var callbackArgs=Array.prototype.slice.call(arguments,2);var newArgs=[eventName].concat(callbackArgs);this.emit.apply(this,newArgs);return callback.apply(null,callbackArgs)}.bind(this);if(constraints.audio||constraints.video){deferred.resolve(SIP.WebRTC.getUserMedia(constraints).then(emitThenCall.bind(this,"userMedia",saveSuccess.bind(null,false)),emitThenCall.bind(this,"userMediaFailed",function(e){throw e})))}else{deferred.resolve([])}}.bind(this),0);return deferred.promise}}},release:{writable:true,value:function release(streams){streams=[].concat(streams);streams.forEach(function(stream){var streamId=MediaStreamManager.streamId(stream);if(this.acquisitions[streamId]===false){stream.getTracks().forEach(function(track){track.stop()})}delete this.acquisitions[streamId]},this)}}});return MediaStreamManager}},{}],160:[function(require,module,exports){"use strict";var flatMap=require("./util").flatMap;var guessBrowser=require("./util").guessBrowser;var getSdpFormat=require("./util/sdp").getSdpFormat;var guess=guessBrowser();var isChrome=guess==="chrome";var isFirefox=guess==="firefox";var isSafari=guess==="safari";var sdpFormat=getSdpFormat();var chromeMajorVersion=isChrome?parseInt(navigator.userAgent.match(/Chrome\/([0-9]+)/)[1],10):null;var CHROME_LEGACY_MAX_AUDIO_LEVEL=32767;function getStats(peerConnection,options){if(!(peerConnection&&typeof peerConnection.getStats==="function")){return Promise.reject(new Error("Given PeerConnection does not support getStats"))}return _getStats(peerConnection,options)}function _getStats(peerConnection,options){var localAudioTracks=getTracks(peerConnection,"audio","local");var localVideoTracks=getTracks(peerConnection,"video","local");var remoteAudioTracks=getTracks(peerConnection,"audio");var remoteVideoTracks=getTracks(peerConnection,"video");var statsResponse={activeIceCandidatePair:null,localAudioTrackStats:[],localVideoTrackStats:[],remoteAudioTrackStats:[],remoteVideoTrackStats:[]};var trackStatsPromises=flatMap([[localAudioTracks,"localAudioTrackStats",false],[localVideoTracks,"localVideoTrackStats",false],[remoteAudioTracks,"remoteAudioTrackStats",true],[remoteVideoTracks,"remoteVideoTrackStats",true]],function(triple){var tracks=triple[0];var statsArrayName=triple[1];var isRemote=triple[2];return tracks.map(function(track){return getTrackStats(peerConnection,track,Object.assign({isRemote:isRemote},options)).then(function(stats){stats.trackId=track.id;statsResponse[statsArrayName].push(stats)})})});return Promise.all(trackStatsPromises).then(function(){return getActiveIceCandidatePairStats(peerConnection,options)}).then(function(activeIceCandidatePairStatsReport){statsResponse.activeIceCandidatePair=activeIceCandidatePairStatsReport;return statsResponse})}function getActiveIceCandidatePairStats(peerConnection,options){options=options||{};if(typeof options.testForChrome!=="undefined"||isChrome||typeof options.testForSafari!=="undefined"||isSafari){return peerConnection.getStats().then(standardizeChromeOrSafariActiveIceCandidatePairStats)}if(typeof options.testForFirefox!=="undefined"||isFirefox){return peerConnection.getStats().then(standardizeFirefoxActiveIceCandidatePairStats)}return Promise.reject(new Error("RTCPeerConnection#getStats() not supported"))}function standardizeChromeOrSafariActiveIceCandidatePairStats(stats){var activeCandidatePairStats=Array.from(stats.values()).find(function(stat){return stat.type==="candidate-pair"&&stat.nominated});if(!activeCandidatePairStats){return null}var activeLocalCandidateStats=stats.get(activeCandidatePairStats.localCandidateId);var activeRemoteCandidateStats=stats.get(activeCandidatePairStats.remoteCandidateId);var standardizedCandidateStatsKeys=[{key:"candidateType",type:"string"},{key:"ip",type:"string"},{key:"port",type:"number"},{key:"priority",type:"number"},{key:"protocol",type:"string"},{key:"url",type:"string"}];var standardizedLocalCandidateStatsKeys=standardizedCandidateStatsKeys.concat([{key:"deleted",type:"boolean"},{key:"relayProtocol",type:"string"}]);var standatdizedLocalCandidateStatsReport=activeLocalCandidateStats?standardizedLocalCandidateStatsKeys.reduce(function(report,keyInfo){report[keyInfo.key]=typeof activeLocalCandidateStats[keyInfo.key]===keyInfo.type?activeLocalCandidateStats[keyInfo.key]:keyInfo.key==="deleted"?false:null;return report},{}):null;var standardizedRemoteCandidateStatsReport=activeRemoteCandidateStats?standardizedCandidateStatsKeys.reduce(function(report,keyInfo){report[keyInfo.key]=typeof activeRemoteCandidateStats[keyInfo.key]===keyInfo.type?activeRemoteCandidateStats[keyInfo.key]:null;return report},{}):null;return[{key:"availableIncomingBitrate",type:"number"},{key:"availableOutgoingBitrate",type:"number"},{key:"bytesReceived",type:"number"},{key:"bytesSent",type:"number"},{key:"consentRequestsSent",type:"number"},{key:"currentRoundTripTime",type:"number"},{key:"lastPacketReceivedTimestamp",type:"number"},{key:"lastPacketSentTimestamp",type:"number"},{key:"nominated",type:"boolean"},{key:"priority",type:"number"},{key:"readable",type:"boolean"},{key:"requestsReceived",type:"number"},{key:"requestsSent",type:"number"},{key:"responsesReceived",type:"number"},{key:"responsesSent",type:"number"},{key:"retransmissionsReceived",type:"number"},{key:"retransmissionsSent",type:"number"},{key:"state",type:"string"},{key:"totalRoundTripTime",type:"number"},{key:"transportId",type:"string"},{key:"writable",type:"boolean"}].reduce(function(report,keyInfo){report[keyInfo.key]=typeof activeCandidatePairStats[keyInfo.key]===keyInfo.type?activeCandidatePairStats[keyInfo.key]:null;return report},{localCandidate:standatdizedLocalCandidateStatsReport,remoteCandidate:standardizedRemoteCandidateStatsReport})}function standardizeFirefoxActiveIceCandidatePairStats(stats){var activeCandidatePairStats=Array.from(stats.values()).find(function(stat){return stat.type==="candidate-pair"&&stat.nominated});if(!activeCandidatePairStats){return null}var activeLocalCandidateStats=stats.get(activeCandidatePairStats.localCandidateId);var activeRemoteCandidateStats=stats.get(activeCandidatePairStats.remoteCandidateId);var standardizedCandidateStatsKeys=[{key:"candidateType",type:"string"},{key:"ip",ffKeys:["address","ipAddress"],type:"string"},{key:"port",ffKeys:["portNumber"],type:"number"},{key:"priority",type:"number"},{key:"protocol",ffKeys:["transport"],type:"string"},{key:"url",type:"string"}];var standardizedLocalCandidateStatsKeys=standardizedCandidateStatsKeys.concat([{key:"deleted",type:"boolean"},{key:"relayProtocol",type:"string"}]);var candidateTypes={host:"host",peerreflexive:"prflx",relayed:"relay",serverreflexive:"srflx"};var standatdizedLocalCandidateStatsReport=activeLocalCandidateStats?standardizedLocalCandidateStatsKeys.reduce(function(report,keyInfo){var key=keyInfo.ffKeys&&keyInfo.ffKeys.find(function(key){return key in activeLocalCandidateStats})||keyInfo.key;report[keyInfo.key]=typeof activeLocalCandidateStats[key]===keyInfo.type?key==="candidateType"?candidateTypes[activeLocalCandidateStats[key]]||activeLocalCandidateStats[key]:activeLocalCandidateStats[key]:key==="deleted"?false:null;return report},{}):null;var standardizedRemoteCandidateStatsReport=activeRemoteCandidateStats?standardizedCandidateStatsKeys.reduce(function(report,keyInfo){var key=keyInfo.ffKeys&&keyInfo.ffKeys.find(function(key){return key in activeRemoteCandidateStats})||keyInfo.key;report[keyInfo.key]=typeof activeRemoteCandidateStats[key]===keyInfo.type?key==="candidateType"?candidateTypes[activeRemoteCandidateStats[key]]||activeRemoteCandidateStats[key]:activeRemoteCandidateStats[key]:null;return report},{}):null;return[{key:"availableIncomingBitrate",type:"number"},{key:"availableOutgoingBitrate",type:"number"},{key:"bytesReceived",type:"number"},{key:"bytesSent",type:"number"},{key:"consentRequestsSent",type:"number"},{key:"currentRoundTripTime",type:"number"},{key:"lastPacketReceivedTimestamp",type:"number"},{key:"lastPacketSentTimestamp",type:"number"},{key:"nominated",type:"boolean"},{key:"priority",type:"number"},{key:"readable",type:"boolean"},{key:"requestsReceived",type:"number"},{key:"requestsSent",type:"number"},{key:"responsesReceived",type:"number"},{key:"responsesSent",type:"number"},{key:"retransmissionsReceived",type:"number"},{key:"retransmissionsSent",type:"number"},{key:"state",type:"string"},{key:"totalRoundTripTime",type:"number"},{key:"transportId",type:"string"},{key:"writable",type:"boolean"}].reduce(function(report,keyInfo){report[keyInfo.key]=typeof activeCandidatePairStats[keyInfo.key]===keyInfo.type?activeCandidatePairStats[keyInfo.key]:null;return report},{localCandidate:standatdizedLocalCandidateStatsReport,remoteCandidate:standardizedRemoteCandidateStatsReport})}function getTracks(peerConnection,kind,localOrRemote){var getSendersOrReceivers=localOrRemote==="local"?"getSenders":"getReceivers";if(peerConnection[getSendersOrReceivers]&&!(chromeMajorVersion&&chromeMajorVersion<66)){return peerConnection[getSendersOrReceivers]().map(function(senderOrReceiver){return senderOrReceiver.track}).filter(function(track){return track&&track.kind===kind})}var getStreams=localOrRemote==="local"?"getLocalStreams":"getRemoteStreams";return flatMap(peerConnection[getStreams](),function(stream){var getTracks=kind==="audio"?"getAudioTracks":"getVideoTracks";return stream[getTracks]()})}function getTrackStats(peerConnection,track,options){options=options||{};if(typeof options.testForChrome!=="undefined"||isChrome){return chromeOrSafariGetTrackStats(peerConnection,track)}if(typeof options.testForFirefox!=="undefined"||isFirefox){return firefoxGetTrackStats(peerConnection,track,options.isRemote)}if(typeof options.testForSafari!=="undefined"||isSafari){if(typeof options.testForSafari!=="undefined"||sdpFormat==="unified"){return chromeOrSafariGetTrackStats(peerConnection,track)}return Promise.reject(new Error(["getStats() is not supported on this version of Safari","due to this bug: https://bugs.webkit.org/show_bug.cgi?id=192601"].join(" ")))}return Promise.reject(new Error("RTCPeerConnection#getStats() not supported"))}function chromeOrSafariGetTrackStats(peerConnection,track){return new Promise(function(resolve,reject){if(chromeMajorVersion&&chromeMajorVersion<67){peerConnection.getStats(function(response){resolve(standardizeChromeLegacyStats(response,track))},null,reject);return}peerConnection.getStats(track).then(function(response){resolve(standardizeChromeOrSafariStats(response))},reject)})}function firefoxGetTrackStats(peerConnection,track,isRemote){return new Promise(function(resolve,reject){peerConnection.getStats(track).then(function(response){resolve(standardizeFirefoxStats(response,isRemote))},reject)})}function standardizeChromeLegacyStats(response,track){var ssrcReport=response.result().find(function(report){return report.type==="ssrc"&&report.stat("googTrackId")===track.id});var standardizedStats={};if(ssrcReport){standardizedStats.timestamp=Math.round(Number(ssrcReport.timestamp));standardizedStats=ssrcReport.names().reduce(function(stats,name){switch(name){case"googCodecName":stats.codecName=ssrcReport.stat(name);break;case"googRtt":stats.roundTripTime=Number(ssrcReport.stat(name));break;case"googJitterReceived":stats.jitter=Number(ssrcReport.stat(name));break;case"googFrameWidthInput":stats.frameWidthInput=Number(ssrcReport.stat(name));break;case"googFrameHeightInput":stats.frameHeightInput=Number(ssrcReport.stat(name));break;case"googFrameWidthSent":stats.frameWidthSent=Number(ssrcReport.stat(name));break;case"googFrameHeightSent":stats.frameHeightSent=Number(ssrcReport.stat(name));break;case"googFrameWidthReceived":stats.frameWidthReceived=Number(ssrcReport.stat(name));break;case"googFrameHeightReceived":stats.frameHeightReceived=Number(ssrcReport.stat(name));break;case"googFrameRateInput":stats.frameRateInput=Number(ssrcReport.stat(name));break;case"googFrameRateSent":stats.frameRateSent=Number(ssrcReport.stat(name));break;case"googFrameRateReceived":stats.frameRateReceived=Number(ssrcReport.stat(name));break;case"ssrc":stats[name]=ssrcReport.stat(name);break;case"bytesReceived":case"bytesSent":case"packetsLost":case"packetsReceived":case"packetsSent":case"audioInputLevel":case"audioOutputLevel":stats[name]=Number(ssrcReport.stat(name));break}return stats},standardizedStats)}return standardizedStats}function standardizeChromeOrSafariStats(response){var inbound=null;var outbound=null;var track=null;var codec=null;response.forEach(function(stat){switch(stat.type){case"inbound-rtp":inbound=stat;break;case"outbound-rtp":outbound=stat;break;case"track":track=stat;break;case"codec":codec=stat;break}});var isRemote=track&&track.remoteSource;var standardizedStats={};var first=isRemote?inbound:outbound;var second=track;var third=codec;function getStatValue(name){if(first&&typeof first[name]!=="undefined"){return first[name]}if(second&&typeof second[name]!=="undefined"){return second[name]}if(third&&typeof third[name]!=="undefined"){return third[name]}return null}var ssrc=getStatValue("ssrc");if(typeof ssrc==="number"){standardizedStats.ssrc=String(ssrc)}var timestamp=getStatValue("timestamp");standardizedStats.timestamp=Math.round(timestamp);var mimeType=getStatValue("mimeType");if(typeof mimeType==="string"){mimeType=mimeType.split("/");standardizedStats.codecName=mimeType[mimeType.length-1]}var roundTripTime=getStatValue("roundTripTime");if(typeof roundTripTime==="number"){standardizedStats.roundTripTime=roundTripTime}var jitter=getStatValue("jitter");if(typeof jitter==="number"){standardizedStats.jitter=Math.round(jitter*1e3)}var frameWidth=getStatValue("frameWidth");if(typeof frameWidth==="number"){if(isRemote){standardizedStats.frameWidthReceived=frameWidth}else{standardizedStats.frameWidthSent=frameWidth}}var frameHeight=getStatValue("frameHeight");if(typeof frameHeight==="number"){if(isRemote){standardizedStats.frameHeightReceived=frameHeight}else{standardizedStats.frameHeightSent=frameHeight}}var framesPerSecond=getStatValue("framesPerSecond");if(typeof framesPerSecond==="number"){standardizedStats.frameRateSent=framesPerSecond}var bytesReceived=getStatValue("bytesReceived");if(typeof bytesReceived==="number"){standardizedStats.bytesReceived=bytesReceived}var bytesSent=getStatValue("bytesSent");if(typeof bytesSent==="number"){standardizedStats.bytesSent=bytesSent}var packetsLost=getStatValue("packetsLost");if(typeof packetsLost==="number"){standardizedStats.packetsLost=packetsLost}var packetsReceived=getStatValue("packetsReceived");if(typeof packetsReceived==="number"){standardizedStats.packetsReceived=packetsReceived}var packetsSent=getStatValue("packetsSent");if(typeof packetsSent==="number"){standardizedStats.packetsSent=packetsSent}var audioLevel=getStatValue("audioLevel");if(typeof audioLevel==="number"){audioLevel=Math.round(audioLevel*CHROME_LEGACY_MAX_AUDIO_LEVEL);if(isRemote){standardizedStats.audioOutputLevel=audioLevel}else{standardizedStats.audioInputLevel=audioLevel}}return standardizedStats}function standardizeFirefoxStats(response,isRemote){response=response||new Map;var inbound=null;var outbound=null;response.forEach(function(stat){if(stat.isRemote){return}switch(stat.type){case"inbound-rtp":inbound=stat;outbound=response.get(stat.remoteId);break;case"outbound-rtp":outbound=stat;inbound=response.get(stat.remoteId);break}});var first=isRemote?inbound:outbound;var second=isRemote?outbound:inbound;function getStatValue(name){if(first&&typeof first[name]!=="undefined"){return first[name]}if(second&&typeof second[name]!=="undefined"){return second[name]}return null}var standardizedStats={};var timestamp=getStatValue("timestamp");standardizedStats.timestamp=Math.round(timestamp);var ssrc=getStatValue("ssrc");if(typeof ssrc==="number"){standardizedStats.ssrc=String(ssrc)}var bytesSent=getStatValue("bytesSent");if(typeof bytesSent==="number"){standardizedStats.bytesSent=bytesSent}var packetsLost=getStatValue("packetsLost");if(typeof packetsLost==="number"){standardizedStats.packetsLost=packetsLost}var packetsSent=getStatValue("packetsSent");if(typeof packetsSent==="number"){standardizedStats.packetsSent=packetsSent}var roundTripTime=getStatValue("roundTripTime");if(typeof roundTripTime==="number"){standardizedStats.roundTripTime=roundTripTime}var jitter=getStatValue("jitter");if(typeof jitter==="number"){standardizedStats.jitter=Math.round(jitter*1e3)}var frameRateSent=getStatValue("framerateMean");if(typeof frameRateSent==="number"){standardizedStats.frameRateSent=Math.round(frameRateSent)}var bytesReceived=getStatValue("bytesReceived");if(typeof bytesReceived==="number"){standardizedStats.bytesReceived=bytesReceived}var packetsReceived=getStatValue("packetsReceived");if(typeof packetsReceived==="number"){standardizedStats.packetsReceived=packetsReceived}var frameRateReceived=getStatValue("framerateMean");if(typeof frameRateReceived==="number"){standardizedStats.frameRateReceived=Math.round(frameRateReceived)}return standardizedStats}module.exports=getStats},{"./util":175,"./util/sdp":177}],161:[function(require,module,exports){"use strict";function getUserMedia(constraints){return new Promise(function getUserMediaPromise(resolve,reject){_getUserMedia(constraints||{audio:true,video:true},resolve,reject)})}function _getUserMedia(constraints,onSuccess,onFailure){if(typeof window!=="undefined"&&typeof navigator!=="undefined"){if(typeof navigator.mediaDevices==="object"&&typeof navigator.mediaDevices.getUserMedia==="function"){navigator.mediaDevices.getUserMedia(constraints).then(onSuccess,onFailure);return}else if(typeof navigator.webkitGetUserMedia==="function"){navigator.webkitGetUserMedia(constraints,onSuccess,onFailure);return}else if(typeof navigator.mozGetUserMedia==="function"){navigator.mozGetUserMedia(constraints,onSuccess,onFailure);return}}onFailure(new Error("getUserMedia is not supported"))}module.exports=getUserMedia},{}],162:[function(require,module,exports){"use strict";var WebRTC={};Object.defineProperties(WebRTC,{getStats:{enumerable:true,value:require("./getstats")},getUserMedia:{enumerable:true,value:require("./getusermedia")},MediaStream:{enumerable:true,value:require("./mediastream")},MediaStreamTrack:{enumerable:true,value:require("./mediastreamtrack")},RTCIceCandidate:{enumerable:true,value:require("./rtcicecandidate")},RTCPeerConnection:{enumerable:true,value:require("./rtcpeerconnection")},RTCSessionDescription:{enumerable:true,value:require("./rtcsessiondescription")},version:{enumerable:true,value:require("../package.json").version}});module.exports=WebRTC},{"../package.json":178,"./getstats":160,"./getusermedia":161,"./mediastream":163,"./mediastreamtrack":164,"./rtcicecandidate":165,"./rtcpeerconnection":168,"./rtcsessiondescription":173}],163:[function(require,module,exports){"use strict";if(typeof MediaStream!=="undefined"){module.exports=MediaStream}else{module.exports=function MediaStream(){throw new Error("WebRTC is not supported in this browser")}}},{}],164:[function(require,module,exports){"use strict";if(typeof MediaStreamTrack!=="undefined"){module.exports=MediaStreamTrack}else{module.exports=function MediaStreamTrack(){throw new Error("WebRTC is not supported in this browser")}}},{}],165:[function(require,module,exports){"use strict";if(typeof RTCIceCandidate!=="undefined"){module.exports=RTCIceCandidate}else if(typeof mozRTCIceCandidate!=="undefined"){module.exports=mozRTCIceCandidate}else{module.exports=function RTCIceCandidate(){throw new Error("WebRTC is unsupported")}}},{}],166:[function(require,module,exports){"use strict";var ChromeRTCSessionDescription=require("../rtcsessiondescription/chrome");var EventTarget=require("../util/eventtarget");var inherits=require("util").inherits;var Latch=require("../util/latch");var MediaStream=require("../mediastream");var RTCRtpSenderShim=require("../rtcrtpsender");var sdpUtils=require("../util/sdp");var util=require("../util");var sdpFormat=sdpUtils.getSdpFormat();function ChromeRTCPeerConnection(configuration,constraints){if(!(this instanceof ChromeRTCPeerConnection)){return new ChromeRTCPeerConnection(configuration,constraints)}EventTarget.call(this);configuration=configuration||{};var newConfiguration=Object.assign(configuration.iceTransportPolicy?{iceTransports:configuration.iceTransportPolicy}:{},configuration);util.interceptEvent(this,"datachannel");util.interceptEvent(this,"signalingstatechange");var peerConnection=new RTCPeerConnection(newConfiguration,constraints);Object.defineProperties(this,{_localStream:{value:new MediaStream},_peerConnection:{value:peerConnection},_pendingLocalOffer:{value:null,writable:true},_pendingRemoteOffer:{value:null,writable:true},_senders:{value:new Map},_signalingStateLatch:{value:new Latch},_tracksToSSRCs:{value:new Map},localDescription:{enumerable:true,get:function(){return this._pendingLocalOffer?this._pendingLocalOffer:peerConnection.localDescription}},remoteDescription:{enumerable:true,get:function(){return this._pendingRemoteOffer?this._pendingRemoteOffer:peerConnection.remoteDescription}},signalingState:{enumerable:true,get:function(){if(this._pendingLocalOffer){return"have-local-offer"}else if(this._pendingRemoteOffer){return"have-remote-offer"}return peerConnection.signalingState}}});var self=this;if(sdpFormat==="planb"){util.interceptEvent(this,"track")}peerConnection.addEventListener("datachannel",function ondatachannel(event){shimDataChannel(event.channel);self.dispatchEvent(event)});peerConnection.addEventListener("signalingstatechange",function onsignalingstatechange(){if(!self._pendingLocalOffer&&!self._pendingRemoteOffer){self.dispatchEvent.apply(self,arguments)}});peerConnection.ontrack=function ontrack(){};if(!RTCPeerConnection.prototype.addTrack){peerConnection.addStream(this._localStream)}util.proxyProperties(RTCPeerConnection.prototype,this,peerConnection)}inherits(ChromeRTCPeerConnection,EventTarget);ChromeRTCPeerConnection.prototype.addTrack=function addTrack(){var args=[].slice.call(arguments);var track=args[0];var sender=this._senders.get(track);if(this._peerConnection.signalingState==="closed"){throw new Error("Cannot add MediaStreamTrack ["+track.id+", "+track.kind+"]: RTCPeerConnection is closed")}if(sender&&sender.track){throw new Error("Cannot add MediaStreamTrack ["+track.id+", "+track.kind+"]: RTCPeerConnection already has it")}if(RTCPeerConnection.prototype.addTrack){return this._peerConnection.addTrack.apply(this._peerConnection,args)}this._peerConnection.removeStream(this._localStream);this._localStream.addTrack(track);this._peerConnection.addStream(this._localStream);sender=new RTCRtpSenderShim(track);this._senders.set(track,sender);return sender};ChromeRTCPeerConnection.prototype.removeTrack=function removeTrack(sender){if(this._peerConnection.signalingState==="closed"){throw new Error("Cannot remove MediaStreamTrack: RTCPeerConnection is closed")}if(RTCPeerConnection.prototype.removeTrack){try{this._peerConnection.removeTrack(sender)}catch(error){}return}var track=sender.track;if(!track){return}sender=this._senders.get(track);if(sender&&sender.track){sender.track=null;this._peerConnection.removeStream(this._localStream);this._localStream.removeTrack(track);this._peerConnection.addStream(this._localStream)}};ChromeRTCPeerConnection.prototype.getSenders=function getSenders(){return this._peerConnection.getSenders?this._peerConnection.getSenders():Array.from(this._senders.values())};ChromeRTCPeerConnection.prototype.addIceCandidate=function addIceCandidate(candidate){var args=[].slice.call(arguments);var promise;var self=this;if(this.signalingState==="have-remote-offer"){promise=this._signalingStateLatch.when("low").then(function signalingStatesResolved(){return self._peerConnection.addIceCandidate(candidate)})}else{promise=this._peerConnection.addIceCandidate(candidate)}return args.length>1?util.legacyPromise(promise,args[1],args[2]):promise};ChromeRTCPeerConnection.prototype.close=function close(){if(this.signalingState!=="closed"){this._pendingLocalOffer=null;this._pendingRemoteOffer=null;this._peerConnection.close()}};ChromeRTCPeerConnection.prototype.createAnswer=function createAnswer(){var args=[].slice.call(arguments);var promise;var isPlanB=sdpFormat==="planb";var self=this;if(this._pendingRemoteOffer){var mediaStreamTracks=isPlanB?util.flatMap(this.getRemoteStreams(),function(mediaStream){return mediaStream.getTracks()}):[];promise=this._peerConnection.setRemoteDescription(this._pendingRemoteOffer).then(function setRemoteDescriptionSucceeded(){if(isPlanB){maybeDispatchTrackEvents(self,mediaStreamTracks)}self._signalingStateLatch.lower();return self._peerConnection.createAnswer()}).then(function createAnswerSucceeded(answer){self._pendingRemoteOffer=null;return new ChromeRTCSessionDescription({type:"answer",sdp:updateTrackIdsToSSRCs(sdpFormat,self._tracksToSSRCs,answer.sdp)})},function setRemoteDescriptionOrCreateAnswerFailed(error){self._pendingRemoteOffer=null;throw error})}else{promise=this._peerConnection.createAnswer().then(function(answer){return new ChromeRTCSessionDescription({type:"answer",sdp:updateTrackIdsToSSRCs(sdpFormat,self._tracksToSSRCs,answer.sdp)})})}return args.length>1?util.legacyPromise(promise,args[0],args[1]):promise};ChromeRTCPeerConnection.prototype.createOffer=function createOffer(){var args=[].slice.call(arguments);var options=(args.length>1?args[2]:args[0])||{};var self=this;var promise=this._peerConnection.createOffer(options).then(function(offer){return new ChromeRTCSessionDescription({type:offer.type,sdp:updateTrackIdsToSSRCs(sdpFormat,self._tracksToSSRCs,offer.sdp)})});return args.length>1?util.legacyPromise(promise,args[0],args[1]):promise};ChromeRTCPeerConnection.prototype.createDataChannel=function createDataChannel(label,dataChannelDict){dataChannelDict=shimDataChannelInit(dataChannelDict);var dataChannel=this._peerConnection.createDataChannel(label,dataChannelDict);shimDataChannel(dataChannel);return dataChannel};ChromeRTCPeerConnection.prototype.setLocalDescription=function setLocalDescription(){var args=[].slice.call(arguments);var description=args[0];var promise=setDescription(this,true,description);return args.length>1?util.legacyPromise(promise,args[1],args[2]):promise};ChromeRTCPeerConnection.prototype.setRemoteDescription=function setRemoteDescription(){var args=[].slice.call(arguments);var description=args[0];var promise=setDescription(this,false,description);return args.length>1?util.legacyPromise(promise,args[1],args[2]):promise};util.delegateMethods(RTCPeerConnection.prototype,ChromeRTCPeerConnection.prototype,"_peerConnection");function maybeDispatchTrackEvents(peerConnection,mediaStreamTracks){var currentMediaStreamTracks=util.flatMap(peerConnection.getRemoteStreams(),function(mediaStream){return mediaStream.getTracks()});var mediaStreamTracksAdded=util.difference(currentMediaStreamTracks,mediaStreamTracks)
    ;mediaStreamTracksAdded.forEach(function(mediaStreamTrack){var newEvent=new Event("track");newEvent.track=mediaStreamTrack;peerConnection.dispatchEvent(newEvent)})}function setDescription(peerConnection,local,description){function setPendingLocalOffer(offer){if(local){peerConnection._pendingLocalOffer=offer}else{peerConnection._pendingRemoteOffer=offer}}function clearPendingLocalOffer(){if(local){peerConnection._pendingLocalOffer=null}else{peerConnection._pendingRemoteOffer=null}}var pendingLocalOffer=local?peerConnection._pendingLocalOffer:peerConnection._pendingRemoteOffer;var pendingRemoteOffer=local?peerConnection._pendingRemoteOffer:peerConnection._pendingLocalOffer;var intermediateState=local?"have-local-offer":"have-remote-offer";var setLocalDescription=local?"setLocalDescription":"setRemoteDescription";var promise;var isPlanB=sdpFormat==="planb";var mediaStreamTracks=isPlanB?util.flatMap(peerConnection.getRemoteStreams(),function(mediaStream){return mediaStream.getTracks()}):[];if(!local&&pendingRemoteOffer&&description.type==="answer"){promise=setRemoteAnswer(peerConnection,description)}else if(description.type==="offer"){if(peerConnection.signalingState!==intermediateState&&peerConnection.signalingState!=="stable"){return Promise.reject(new Error("Cannot set "+(local?"local":"remote")+" offer in state "+peerConnection.signalingState))}if(!pendingLocalOffer&&peerConnection._signalingStateLatch.state==="low"){peerConnection._signalingStateLatch.raise()}var previousSignalingState=peerConnection.signalingState;setPendingLocalOffer(unwrap(description));promise=Promise.resolve();if(peerConnection.signalingState!==previousSignalingState){promise.then(function dispatchSignalingStateChangeEvent(){peerConnection.dispatchEvent(new Event("signalingstatechange"))})}}else if(description.type==="rollback"){if(peerConnection.signalingState!==intermediateState){promise=Promise.reject(new Error("Cannot rollback "+(local?"local":"remote")+" description in "+peerConnection.signalingState))}else{clearPendingLocalOffer();promise=Promise.resolve();promise.then(function dispatchSignalingStateChangeEvent(){peerConnection.dispatchEvent(new Event("signalingstatechange"))})}}return promise||peerConnection._peerConnection[setLocalDescription](unwrap(description)).then(function(){if(!local&&isPlanB){maybeDispatchTrackEvents(peerConnection,mediaStreamTracks)}})}function setRemoteAnswer(peerConnection,answer){var isPlanB=sdpFormat==="planb";var mediaStreamTracks=isPlanB?util.flatMap(peerConnection.getRemoteStreams(),function(mediaStream){return mediaStream.getTracks()}):[];var pendingLocalOffer=peerConnection._pendingLocalOffer;return peerConnection._peerConnection.setLocalDescription(pendingLocalOffer).then(function setLocalOfferSucceeded(){peerConnection._pendingLocalOffer=null;return peerConnection.setRemoteDescription(answer)}).then(function setRemoteAnswerSucceeded(){if(isPlanB){maybeDispatchTrackEvents(peerConnection,mediaStreamTracks)}peerConnection._signalingStateLatch.lower()})}function unwrap(description){if(description instanceof ChromeRTCSessionDescription){if(description._description){return description._description}}return new RTCSessionDescription(description)}function needsMaxPacketLifeTimeShim(){return"maxRetransmitTime"in RTCDataChannel.prototype&&!("maxPacketLifeTime"in RTCDataChannel.prototype)}function shimDataChannelInit(dataChannelDict){dataChannelDict=Object.assign({},dataChannelDict);if(needsMaxPacketLifeTimeShim()&&"maxPacketLifeTime"in dataChannelDict){dataChannelDict.maxRetransmitTime=dataChannelDict.maxPacketLifeTime}return dataChannelDict}function shimDataChannel(dataChannel){Object.defineProperty(dataChannel,"maxRetransmits",{value:dataChannel.maxRetransmits===65535?null:dataChannel.maxRetransmits});if(needsMaxPacketLifeTimeShim()){Object.defineProperty(dataChannel,"maxPacketLifeTime",{value:dataChannel.maxRetransmitTime===65535?null:dataChannel.maxRetransmitTime})}return dataChannel}function updateTrackIdsToSSRCs(sdpFormat,tracksToSSRCs,sdp){return sdpFormat==="unified"?sdpUtils.updateUnifiedPlanTrackIdsToSSRCs(tracksToSSRCs,sdp):sdpUtils.updatePlanBTrackIdsToSSRCs(tracksToSSRCs,sdp)}module.exports=ChromeRTCPeerConnection},{"../mediastream":163,"../rtcrtpsender":170,"../rtcsessiondescription/chrome":171,"../util":175,"../util/eventtarget":174,"../util/latch":176,"../util/sdp":177,util:183}],167:[function(require,module,exports){"use strict";var EventTarget=require("../util/eventtarget");var FirefoxRTCSessionDescription=require("../rtcsessiondescription/firefox");var inherits=require("util").inherits;var updateTracksToSSRCs=require("../util/sdp").updateUnifiedPlanTrackIdsToSSRCs;var util=require("../util");var needsWorkaroundForBug1480277=typeof navigator==="object"&&navigator.userAgent&&(navigator.userAgent.match(/Firefox\/61/)||navigator.userAgent.match(/Firefox\/62/));function FirefoxRTCPeerConnection(configuration){if(!(this instanceof FirefoxRTCPeerConnection)){return new FirefoxRTCPeerConnection(configuration)}EventTarget.call(this);util.interceptEvent(this,"signalingstatechange");var peerConnection=new RTCPeerConnection(configuration);Object.defineProperties(this,{_initiallyNegotiatedDtlsRole:{value:null,writable:true},_isClosed:{value:false,writable:true},_peerConnection:{value:peerConnection},_rollingBack:{value:false,writable:true},_tracksToSSRCs:{value:new Map},iceGatheringState:{enumerable:true,get:function(){return this._isClosed?"complete":this._peerConnection.iceGatheringState}},localDescription:{enumerable:true,get:function(){return overwriteWithInitiallyNegotiatedDtlsRole(this._peerConnection.localDescription,this._initiallyNegotiatedDtlsRole)}},signalingState:{enumerable:true,get:function(){return this._isClosed?"closed":this._peerConnection.signalingState}}});var self=this;var previousSignalingState;peerConnection.addEventListener("signalingstatechange",function onsignalingstatechange(){if(!self._rollingBack&&self.signalingState!==previousSignalingState){previousSignalingState=self.signalingState;var dispatchEventToSelf=self.dispatchEvent.apply.bind(self.dispatchEvent,self,arguments);if(self._isClosed){setTimeout(dispatchEventToSelf)}else{dispatchEventToSelf()}}});util.proxyProperties(RTCPeerConnection.prototype,this,peerConnection)}inherits(FirefoxRTCPeerConnection,EventTarget);Object.defineProperty(FirefoxRTCPeerConnection.prototype,"peerIdentity",{enumerable:true,value:Promise.resolve({idp:"",name:""})});if(needsWorkaroundForBug1480277){FirefoxRTCPeerConnection.prototype.addTrack=function addTrack(){var track=arguments[0];var sender=this._peerConnection.addTrack.apply(this._peerConnection,arguments);sender.replaceTrack(track);return sender}}FirefoxRTCPeerConnection.prototype.createAnswer=function createAnswer(){var args=[].slice.call(arguments);var promise;var self=this;promise=this._peerConnection.createAnswer().then(function createAnswerSucceeded(answer){saveInitiallyNegotiatedDtlsRole(self,answer);return overwriteWithInitiallyNegotiatedDtlsRole(answer,self._initiallyNegotiatedDtlsRole)});return typeof args[0]==="function"?util.legacyPromise(promise,args[0],args[1]):promise};FirefoxRTCPeerConnection.prototype.createOffer=function createOffer(){var args=[].slice.call(arguments);var options=(args.length>1?args[2]:args[0])||{};var promise;var self=this;if(this.signalingState==="have-local-offer"||this.signalingState==="have-remote-offer"){var local=this.signalingState==="have-local-offer";promise=rollback(this,local,function rollbackSucceeded(){return self.createOffer(options)})}else{promise=self._peerConnection.createOffer(options)}promise=promise.then(function(offer){return new FirefoxRTCSessionDescription({type:offer.type,sdp:updateTracksToSSRCs(self._tracksToSSRCs,offer.sdp)})});return args.length>1?util.legacyPromise(promise,args[0],args[1]):promise};FirefoxRTCPeerConnection.prototype.setLocalDescription=function setLocalDescription(){var args=[].slice.call(arguments);var description=args[0];var promise;if(description&&description.type==="answer"&&this.signalingState==="have-local-offer"){promise=Promise.reject(new Error("Cannot set local answer in state have-local-offer"))}if(promise){return args.length>1?util.legacyPromise(promise,args[1],args[2]):promise}return this._peerConnection.setLocalDescription.apply(this._peerConnection,args)};FirefoxRTCPeerConnection.prototype.setRemoteDescription=function setRemoteDescription(){var args=[].slice.call(arguments);var description=args[0];var promise;var self=this;if(description&&this.signalingState==="have-remote-offer"){if(description.type==="answer"){promise=Promise.reject(new Error("Cannot set remote answer in state have-remote-offer"))}else if(description.type==="offer"){promise=rollback(this,false,function rollbackSucceeded(){return self._peerConnection.setRemoteDescription(description)})}}if(!promise){promise=this._peerConnection.setRemoteDescription(description)}promise=promise.then(function setRemoteDescriptionSucceeded(){saveInitiallyNegotiatedDtlsRole(self,description,true)});return args.length>1?util.legacyPromise(promise,args[1],args[2]):promise};FirefoxRTCPeerConnection.prototype.close=function close(){if(this.signalingState!=="closed"){this._isClosed=true;this._peerConnection.close()}};util.delegateMethods(RTCPeerConnection.prototype,FirefoxRTCPeerConnection.prototype,"_peerConnection");function rollback(peerConnection,local,onceRolledBack){var setLocalDescription=local?"setLocalDescription":"setRemoteDescription";peerConnection._rollingBack=true;return peerConnection._peerConnection[setLocalDescription](new FirefoxRTCSessionDescription({type:"rollback"})).then(onceRolledBack).then(function onceRolledBackSucceeded(result){peerConnection._rollingBack=false;return result},function rollbackOrOnceRolledBackFailed(error){peerConnection._rollingBack=false;throw error})}function saveInitiallyNegotiatedDtlsRole(peerConnection,description,remote){if(peerConnection._initiallyNegotiatedDtlsRole||description.type==="offer"){return}var match=description.sdp.match(/a=setup:([a-z]+)/);if(!match){return}var dtlsRole=match[1];peerConnection._initiallyNegotiatedDtlsRole=remote?{active:"passive",passive:"active"}[dtlsRole]:dtlsRole}function overwriteWithInitiallyNegotiatedDtlsRole(description,dtlsRole){if(description&&description.type==="answer"&&dtlsRole){return new FirefoxRTCSessionDescription({type:description.type,sdp:description.sdp.replace(/a=setup:[a-z]+/g,"a=setup:"+dtlsRole)})}return description}module.exports=FirefoxRTCPeerConnection},{"../rtcsessiondescription/firefox":172,"../util":175,"../util/eventtarget":174,"../util/sdp":177,util:183}],168:[function(require,module,exports){"use strict";var guessBrowser=require("../util").guessBrowser;switch(guessBrowser()){case"chrome":module.exports=require("./chrome");break;case"firefox":module.exports=require("./firefox");break;case"safari":module.exports=require("./safari");break;default:if(typeof RTCPeerConnection==="undefined"){break}module.exports=RTCPeerConnection}},{"../util":175,"./chrome":166,"./firefox":167,"./safari":169}],169:[function(require,module,exports){"use strict";var EventTarget=require("../util/eventtarget");var inherits=require("util").inherits;var Latch=require("../util/latch");var sdpUtils=require("../util/sdp");var util=require("../util");var isUnifiedPlan=sdpUtils.getSdpFormat()==="unified";var updateTrackIdsToSSRCs=isUnifiedPlan?sdpUtils.updateUnifiedPlanTrackIdsToSSRCs:sdpUtils.updatePlanBTrackIdsToSSRCs;function SafariRTCPeerConnection(configuration){if(!(this instanceof SafariRTCPeerConnection)){return new SafariRTCPeerConnection(configuration)}EventTarget.call(this);util.interceptEvent(this,"datachannel");util.interceptEvent(this,"iceconnectionstatechange");util.interceptEvent(this,"signalingstatechange");util.interceptEvent(this,"track");var peerConnection=new RTCPeerConnection(configuration);Object.defineProperties(this,{_audioTransceiver:{value:null,writable:true},_isClosed:{value:false,writable:true},_peerConnection:{value:peerConnection},_pendingLocalOffer:{value:null,writable:true},_pendingRemoteOffer:{value:null,writable:true},_signalingStateLatch:{value:new Latch},_tracksToSSRCs:{value:new Map},_videoTransceiver:{value:null,writable:true},localDescription:{enumerable:true,get:function(){return this._pendingLocalOffer||this._peerConnection.localDescription}},iceConnectionState:{enumerable:true,get:function(){return this._isClosed?"closed":this._peerConnection.iceConnectionState}},iceGatheringState:{enumerable:true,get:function(){return this._isClosed?"complete":this._peerConnection.iceGatheringState}},remoteDescription:{enumerable:true,get:function(){return this._pendingRemoteOffer||this._peerConnection.remoteDescription}},signalingState:{enumerable:true,get:function(){if(this._isClosed){return"closed"}else if(this._pendingLocalOffer){return"have-local-offer"}else if(this._pendingRemoteOffer){return"have-remote-offer"}return this._peerConnection.signalingState}}});var self=this;peerConnection.addEventListener("datachannel",function ondatachannel(event){shimDataChannel(event.channel);self.dispatchEvent(event)});peerConnection.addEventListener("iceconnectionstatechange",function oniceconnectionstatechange(){if(self._isClosed){return}self.dispatchEvent.apply(self,arguments)});peerConnection.addEventListener("signalingstatechange",function onsignalingstatechange(){if(self._isClosed){return}if(!self._pendingLocalOffer&&!self._pendingRemoteOffer){self.dispatchEvent.apply(self,arguments)}});peerConnection.addEventListener("track",function ontrack(event){self._pendingRemoteOffer=null;self.dispatchEvent(event)});util.proxyProperties(RTCPeerConnection.prototype,this,peerConnection)}inherits(SafariRTCPeerConnection,EventTarget);SafariRTCPeerConnection.prototype.addIceCandidate=function addIceCandidate(candidate){var self=this;if(this.signalingState==="have-remote-offer"){return this._signalingStateLatch.when("low").then(function signalingStatesResolved(){return self._peerConnection.addIceCandidate(candidate)})}return this._peerConnection.addIceCandidate(candidate)};SafariRTCPeerConnection.prototype.createOffer=function createOffer(options){options=Object.assign({},options);var self=this;if(options.offerToReceiveAudio&&!this._audioTransceiver&&!(isUnifiedPlan&&hasReceiversForTracksOfKind(this,"audio"))){delete options.offerToReceiveAudio;try{this._audioTransceiver=isUnifiedPlan?this.addTransceiver("audio",{direction:"recvonly"}):this.addTransceiver("audio")}catch(e){return Promise.reject(e)}}if(options.offerToReceiveVideo&&!this._videoTransceiver&&!(isUnifiedPlan&&hasReceiversForTracksOfKind(this,"video"))){delete options.offerToReceiveVideo;try{this._videoTransceiver=isUnifiedPlan?this.addTransceiver("video",{direction:"recvonly"}):this.addTransceiver("video")}catch(e){return Promise.reject(e)}}return this._peerConnection.createOffer(options).then(function(offer){return new RTCSessionDescription({type:offer.type,sdp:updateTrackIdsToSSRCs(self._tracksToSSRCs,offer.sdp)})})};SafariRTCPeerConnection.prototype.createAnswer=function createAnswer(options){var self=this;if(this._pendingRemoteOffer){return this._peerConnection.setRemoteDescription(this._pendingRemoteOffer).then(function setRemoteDescriptionSucceeded(){self._signalingStateLatch.lower();return self._peerConnection.createAnswer()}).then(function createAnswerSucceeded(answer){self._pendingRemoteOffer=null;return isUnifiedPlan?new RTCSessionDescription({type:answer.type,sdp:updateTrackIdsToSSRCs(self._tracksToSSRCs,answer.sdp)}):answer},function setRemoteDescriptionOrCreateAnswerFailed(error){self._pendingRemoteOffer=null;throw error})}return this._peerConnection.createAnswer(options).then(function(answer){return isUnifiedPlan?new RTCSessionDescription({type:answer.type,sdp:updateTrackIdsToSSRCs(self._tracksToSSRCs,answer.sdp)}):answer})};SafariRTCPeerConnection.prototype.createDataChannel=function createDataChannel(label,dataChannelDict){var dataChannel=this._peerConnection.createDataChannel(label,dataChannelDict);shimDataChannel(dataChannel);return dataChannel};SafariRTCPeerConnection.prototype.setLocalDescription=function setLocalDescription(description){return setDescription(this,true,description)};SafariRTCPeerConnection.prototype.setRemoteDescription=function setRemoteDescription(description){return setDescription(this,false,description)};SafariRTCPeerConnection.prototype.close=function close(){if(this._isClosed){return}this._isClosed=true;this._peerConnection.close();var self=this;setTimeout(function(){self.dispatchEvent(new Event("iceconnectionstatechange"));self.dispatchEvent(new Event("signalingstatechange"))})};SafariRTCPeerConnection.prototype.removeTrack=function removeTrack(sender){sender.replaceTrack(null);this._peerConnection.removeTrack(sender)};util.delegateMethods(RTCPeerConnection.prototype,SafariRTCPeerConnection.prototype,"_peerConnection");function setDescription(peerConnection,local,description){function setPendingLocalOffer(offer){if(local){peerConnection._pendingLocalOffer=offer}else{peerConnection._pendingRemoteOffer=offer}}function clearPendingLocalOffer(){if(local){peerConnection._pendingLocalOffer=null}else{peerConnection._pendingRemoteOffer=null}}var pendingLocalOffer=local?peerConnection._pendingLocalOffer:peerConnection._pendingRemoteOffer;var pendingRemoteOffer=local?peerConnection._pendingRemoteOffer:peerConnection._pendingLocalOffer;var intermediateState=local?"have-local-offer":"have-remote-offer";var setLocalDescription=local?"setLocalDescription":"setRemoteDescription";if(!local&&pendingRemoteOffer&&description.type==="answer"){return setRemoteAnswer(peerConnection,description)}else if(description.type==="offer"){if(peerConnection.signalingState!==intermediateState&&peerConnection.signalingState!=="stable"){return Promise.reject(new Error("Cannot set "+(local?"local":"remote")+" offer in state "+peerConnection.signalingState))}if(!pendingLocalOffer&&peerConnection._signalingStateLatch.state==="low"){peerConnection._signalingStateLatch.raise()}var previousSignalingState=peerConnection.signalingState;setPendingLocalOffer(description);if(peerConnection.signalingState!==previousSignalingState){return Promise.resolve().then(function dispatchSignalingStateChangeEvent(){peerConnection.dispatchEvent(new Event("signalingstatechange"))})}return Promise.resolve()}else if(description.type==="rollback"){if(peerConnection.signalingState!==intermediateState){return Promise.reject(new Error("Cannot rollback "+(local?"local":"remote")+" description in "+peerConnection.signalingState))}clearPendingLocalOffer();return Promise.resolve().then(function dispatchSignalingStateChangeEvent(){peerConnection.dispatchEvent(new Event("signalingstatechange"))})}return peerConnection._peerConnection[setLocalDescription](description)}function setRemoteAnswer(peerConnection,answer){var pendingLocalOffer=peerConnection._pendingLocalOffer;return peerConnection._peerConnection.setLocalDescription(pendingLocalOffer).then(function setLocalOfferSucceeded(){peerConnection._pendingLocalOffer=null;return peerConnection.setRemoteDescription(answer)}).then(function setRemoteAnswerSucceeded(){peerConnection._signalingStateLatch.lower()})}function hasReceiversForTracksOfKind(peerConnection,kind){return!!peerConnection.getTransceivers().find(function(transceiver){return transceiver.receiver&&transceiver.receiver.track&&transceiver.receiver.track.kind===kind})}function shimDataChannel(dataChannel){return Object.defineProperties(dataChannel,{maxPacketLifeTime:{value:dataChannel.maxPacketLifeTime===65535?null:dataChannel.maxPacketLifeTime},maxRetransmits:{value:dataChannel.maxRetransmits===65535?null:dataChannel.maxRetransmits}})}module.exports=SafariRTCPeerConnection},{"../util":175,"../util/eventtarget":174,"../util/latch":176,"../util/sdp":177,util:183}],170:[function(require,module,exports){"use strict";function RTCRtpSenderShim(track){Object.defineProperties(this,{track:{enumerable:true,value:track,writable:true}})}module.exports=RTCRtpSenderShim},{}],171:[function(require,module,exports){"use strict";function ChromeRTCSessionDescription(descriptionInitDict){if(!(this instanceof ChromeRTCSessionDescription)){return new ChromeRTCSessionDescription(descriptionInitDict)}var description=descriptionInitDict&&descriptionInitDict.type==="rollback"?null:new RTCSessionDescription(descriptionInitDict);Object.defineProperties(this,{_description:{get:function(){return description}},sdp:{enumerable:true,value:description?description.sdp:descriptionInitDict.sdp},type:{enumerable:true,value:description?description.type:descriptionInitDict.type}})}module.exports=ChromeRTCSessionDescription},{}],172:[function(require,module,exports){"use strict";module.exports=typeof RTCSessionDescription!=="undefined"?RTCSessionDescription:mozRTCSessionDescription},{}],173:[function(require,module,exports){"use strict";var guessBrowser=require("../util").guessBrowser;switch(guessBrowser()){case"chrome":module.exports=require("./chrome");break;case"firefox":module.exports=require("./firefox");break;default:if(typeof RTCSessionDescription==="undefined"){break}module.exports=RTCSessionDescription}},{"../util":175,"./chrome":171,"./firefox":172}],174:[function(require,module,exports){"use strict";var EventEmitter=require("events").EventEmitter;function EventTarget(){Object.defineProperties(this,{_eventEmitter:{value:new EventEmitter}})}EventTarget.prototype.dispatchEvent=function dispatchEvent(event){return this._eventEmitter.emit(event.type,event)};EventTarget.prototype.addEventListener=function addEventListener(){return this._eventEmitter.addListener.apply(this._eventEmitter,arguments)};EventTarget.prototype.removeEventListener=function removeEventListener(){return this._eventEmitter.removeListener.apply(this._eventEmitter,arguments)};module.exports=EventTarget},{events:179}],175:[function(require,module,exports){"use strict";function defer(){var deferred={};deferred.promise=new Promise(function(resolve,reject){deferred.resolve=resolve;deferred.reject=reject});return deferred}function delegateMethod(source,wrapper,target,methodName){if(methodName in wrapper){return}else if(methodName.match(/^on[a-z]+$/)){return}var type;try{type=typeof source[methodName]}catch(error){}if(type!=="function"){return}wrapper[methodName]=function(){return this[target][methodName].apply(this[target],arguments)}}function delegateMethods(source,wrapper,target){for(var methodName in source){delegateMethod(source,wrapper,target,methodName)}}function difference(list1,list2){list1=Array.isArray(list1)?new Set(list1):new Set(list1.values());list2=Array.isArray(list2)?new Set(list2):new Set(list2.values());var difference=new Set;list1.forEach(function(item){if(!list2.has(item)){difference.add(item)}});return difference}function flatMap(list,mapFn){var listArray=list instanceof Map||list instanceof Set?Array.from(list.values()):list;return listArray.reduce(function(flattened,item){var mapped=mapFn(item);return flattened.concat(mapped)},[])}function guessBrowser(){if(typeof navigator!=="undefined"&&typeof navigator.userAgent==="string"){if(/Chrome/.test(navigator.userAgent)){return"chrome"}if(/Firefox/.test(navigator.userAgent)){return"firefox"}if(/Safari/.test(navigator.userAgent)){return"safari"}}return null}function interceptEvent(target,type){var currentListener=null;Object.defineProperty(target,"on"+type,{get:function(){return currentListener},set:function(newListener){if(currentListener){this.removeEventListener(type,currentListener)}if(typeof newListener==="function"){currentListener=newListener;this.addEventListener(type,currentListener)}else{currentListener=null}}})}function legacyPromise(promise,onSuccess,onFailure){if(onSuccess){return promise.then(function(result){onSuccess(result)},function(error){onFailure(error)})}return promise}function makeUUID(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r=Math.random()*16|0;var v=c==="x"?r:r&3|8;return v.toString(16)})}function proxyProperties(source,wrapper,target){Object.getOwnPropertyNames(source).forEach(function(propertyName){proxyProperty(source,wrapper,target,propertyName)})}function proxyProperty(source,wrapper,target,propertyName){if(propertyName in wrapper){return}else if(propertyName.match(/^on[a-z]+$/)){Object.defineProperty(wrapper,propertyName,{value:null,writable:true});target.addEventListener(propertyName.slice(2),function(){wrapper.dispatchEvent.apply(wrapper,arguments)});return}Object.defineProperty(wrapper,propertyName,{enumerable:true,get:function(){return target[propertyName]}})}exports.defer=defer;exports.delegateMethods=delegateMethods;exports.difference=difference;exports.flatMap=flatMap;exports.guessBrowser=guessBrowser;exports.interceptEvent=interceptEvent;exports.legacyPromise=legacyPromise;exports.makeUUID=makeUUID;exports.proxyProperties=proxyProperties},{}],176:[function(require,module,exports){"use strict";var defer=require("./").defer;var states={high:new Set(["low"]),low:new Set(["high"])};function Latch(initialState){if(!(this instanceof Latch)){return new Latch(initialState)}var state=initialState||"low";Object.defineProperties(this,{_state:{set:function(_state){if(state!==_state){state=_state;var whenDeferreds=this._whenDeferreds.get(state);whenDeferreds.forEach(function(deferred){deferred.resolve(this)},this);whenDeferreds.clear()}},get:function(){return state}},_whenDeferreds:{value:new Map([["high",new Set],["low",new Set]])},state:{enumerable:true,get:function(){return this._state}}})}Latch.prototype.lower=function lower(){return this.transition("low")};Latch.prototype.raise=function raise(){return this.transition("high")};Latch.prototype.transition=function transition(newState){if(!states[this.state].has(newState)){throw createUnreachableStateError(this.state,newState)}this._state=newState;return this};Latch.prototype.when=function when(state){if(this.state===state){return Promise.resolve(this)}if(!states[this.state].has(state)){return Promise.reject(createUnreachableStateError(this.state,state))}var deferred=defer();this._whenDeferreds.get(state).add(deferred);return deferred.promise};function createUnreachableStateError(from,to){return new Error('Cannot transition from "'+from+'" to "'+to+'"')}module.exports=Latch},{"./":175}],177:[function(require,module,exports){"use strict";var flatMap=require("./").flatMap;var guessBrowser=require("./").guessBrowser;var chromeSdpFormat;function getChromeSdpFormat(){if(!chromeSdpFormat){if(typeof RTCPeerConnection!=="undefined"&&"addTransceiver"in RTCPeerConnection.prototype){try{(new RTCPeerConnection).addTransceiver("audio");chromeSdpFormat="unified"}catch(e){chromeSdpFormat="planb"}}else{chromeSdpFormat="planb"}}return chromeSdpFormat}function getSafariSdpFormat(){return typeof RTCRtpTransceiver!=="undefined"&&"currentDirection"in RTCRtpTransceiver.prototype?"unified":"planb"}function getSdpFormat(){return{chrome:getChromeSdpFormat(),firefox:"unified",safari:getSafariSdpFormat()}[guessBrowser()]||null}function getMatches(pattern,lines){var matches=lines.match(new RegExp(pattern,"gm"))||[];return matches.reduce(function(results,line){var match=line.match(new RegExp(pattern));return match?results.add(match[1]):results},new Set)}function getTrackIds(pattern,sdp){return getMatches(pattern,sdp)}function getPlanBTrackIds(sdp){return getTrackIds("^a=ssrc:[0-9]+ +msid:.+ +(.+) *$",sdp)}function getUnifiedPlanTrackIds(sdp){return getTrackIds("^a=msid:.+ +(.+) *$",sdp)}function getPlanBSSRCs(sdp,trackId){var pattern="^a=ssrc:([0-9]+) +msid:[^ ]+ +"+trackId+" *$";return getMatches(pattern,sdp)}function getMediaSections(sdp,kind,direction){kind=kind||".*";direction=direction||".*";return sdp.split("\r\nm=").slice(1).map(function(mediaSection){return"m="+mediaSection}).filter(function(mediaSection){var kindPattern=new RegExp("m="+kind,"gm");var directionPattern=new RegExp("a="+direction,"gm");return kindPattern.test(mediaSection)&&directionPattern.test(mediaSection)})}function getMediaSectionSSRCs(mediaSection){return Array.from(getMatches("^a=ssrc:([0-9]+) +.*$",mediaSection))}function getUnifiedPlanSSRCs(sdp,trackId){var mediaSections=getMediaSections(sdp);var msidAttrRegExp=new RegExp("^a=msid:[^ ]+ +"+trackId+" *$","gm");var matchingMediaSections=mediaSections.filter(function(mediaSection){return mediaSection.match(msidAttrRegExp)});return new Set(flatMap(matchingMediaSections,getMediaSectionSSRCs))}function getTrackIdsToSSRCs(getTrackIds,getSSRCs,sdp){return new Map(Array.from(getTrackIds(sdp)).map(function(trackId){return[trackId,getSSRCs(sdp,trackId)]}))}function getPlanBTrackIdsToSSRCs(sdp){return getTrackIdsToSSRCs(getPlanBTrackIds,getPlanBSSRCs,sdp)}function getUnifiedPlanTrackIdsToSSRCs(sdp){return getTrackIdsToSSRCs(getUnifiedPlanTrackIds,getUnifiedPlanSSRCs,sdp)}function updateTrackIdsToSSRCs(getTrackIdsToSSRCs,trackIdsToSSRCs,sdp){var newTrackIdsToSSRCs=getTrackIdsToSSRCs(sdp);var newSSRCsToOldSSRCs=new Map;newTrackIdsToSSRCs.forEach(function(ssrcs,trackId){if(!trackIdsToSSRCs.has(trackId)){trackIdsToSSRCs.set(trackId,ssrcs);return}var oldSSRCs=Array.from(trackIdsToSSRCs.get(trackId));var newSSRCs=Array.from(ssrcs);oldSSRCs.forEach(function(oldSSRC,i){var newSSRC=newSSRCs[i];newSSRCsToOldSSRCs.set(newSSRC,oldSSRC);var pattern="^a=ssrc:"+newSSRC+" (.*)$";var replacement="a=ssrc:"+oldSSRC+" $1";sdp=sdp.replace(new RegExp(pattern,"gm"),replacement)})});var pattern="^(a=ssrc-group:[^ ]+ +)(.*)$";var matches=sdp.match(new RegExp(pattern,"gm"))||[];matches.forEach(function(line){var match=line.match(new RegExp(pattern));if(!match){return}var prefix=match[1];var newSSRCs=match[2];var oldSSRCs=newSSRCs.split(" ").map(function(newSSRC){var oldSSRC=newSSRCsToOldSSRCs.get(newSSRC);return oldSSRC?oldSSRC:newSSRC}).join(" ");sdp=sdp.replace(match[0],prefix+oldSSRCs)});return sdp}function updatePlanBTrackIdsToSSRCs(trackIdsToSSRCs,sdp){return updateTrackIdsToSSRCs(getPlanBTrackIdsToSSRCs,trackIdsToSSRCs,sdp)}function updateUnifiedPlanTrackIdsToSSRCs(trackIdsToSSRCs,sdp){return updateTrackIdsToSSRCs(getUnifiedPlanTrackIdsToSSRCs,trackIdsToSSRCs,sdp)}exports.getSdpFormat=getSdpFormat;exports.getMediaSections=getMediaSections;exports.getPlanBTrackIds=getPlanBTrackIds;exports.getUnifiedPlanTrackIds=getUnifiedPlanTrackIds;exports.getPlanBSSRCs=getPlanBSSRCs;exports.getUnifiedPlanSSRCs=getUnifiedPlanSSRCs;exports.updatePlanBTrackIdsToSSRCs=updatePlanBTrackIdsToSSRCs;exports.updateUnifiedPlanTrackIdsToSSRCs=updateUnifiedPlanTrackIdsToSSRCs},{"./":175}],178:[function(require,module,exports){module.exports={_from:"@twilio/webrtc@2.4.0",_id:"@twilio/webrtc@2.4.0",_inBundle:false,_integrity:"sha512-o7Tm+5j+FYZn9t25cYHwTS87WXMkfubMFvmXtfFfrtSEJhQhxXwn7kWKjxnew/VmNm6hAVZbCrepPfTvQTyDuA==",_location:"/@twilio/webrtc",_phantomChildren:{},_requested:{type:"version",registry:true,raw:"@twilio/webrtc@2.4.0",name:"@twilio/webrtc",escapedName:"@twilio%2fwebrtc",scope:"@twilio",rawSpec:"2.4.0",saveSpec:null,fetchSpec:"2.4.0"},_requiredBy:["/"],_resolved:"https://registry.npmjs.org/@twilio/webrtc/-/webrtc-2.4.0.tgz",_shasum:"8757382ab49cc079c9c40ef507682cb082b25036",_spec:"@twilio/webrtc@2.4.0",_where:"/home/travis/build/twilio/twilio-video.js",author:{name:"Manjesh Malavalli",email:"mmalavalli@twilio.com"},bugs:{url:"https://github.com/twilio/twilio-webrtc.js/issues"},bundleDependencies:false,contributors:[{name:"Mark Roberts",email:"mroberts@twilio.com"},{name:"Ryan Rowland",email:"rrowland@twilio.com"}],deprecated:false,description:"WebRTC-related APIs and shims used by twilio-video.js",devDependencies:{browserify:"^14.4.0",envify:"^4.1.0",eslint:"^4.4.1",istanbul:"^0.4.5",karma:"^1.7.0","karma-browserify":"^5.1.1","karma-chrome-launcher":"^2.2.0","karma-firefox-launcher":"^1.0.1","karma-mocha":"^1.3.0","karma-safari-launcher":"^1.0.0","karma-spec-reporter":"0.0.31",mocha:"^3.5.0","npm-run-all":"^4.0.2","release-tool":"^0.2.2",rimraf:"^2.6.1","travis-multirunner":"^4.2.3",watchify:"^3.9.0",
            "webrtc-adapter":"^6.4.8"},homepage:"https://github.com/twilio/twilio-webrtc.js#readme",keywords:["shim","twilio","video","webrtc"],license:"BSD-3-Clause",main:"./lib/index.js",name:"@twilio/webrtc",repository:{type:"git",url:"git+https://github.com/twilio/twilio-webrtc.js.git"},scripts:{build:"npm-run-all clean lint test",clean:"rimraf coverage",lint:"eslint ./lib",test:"npm-run-all test:*","test:integration":"npm-run-all test:integration:*","test:integration:adapter":"karma start karma/integration.adapter.conf.js","test:integration:native":"karma start karma/integration.conf.js","test:unit":"istanbul cover node_modules/mocha/bin/_mocha -- ./test/unit/index.js"},version:"2.4.0"}},{}],179:[function(require,module,exports){function EventEmitter(){this._events=this._events||{};this._maxListeners=this._maxListeners||undefined}module.exports=EventEmitter;EventEmitter.EventEmitter=EventEmitter;EventEmitter.prototype._events=undefined;EventEmitter.prototype._maxListeners=undefined;EventEmitter.defaultMaxListeners=10;EventEmitter.prototype.setMaxListeners=function(n){if(!isNumber(n)||n<0||isNaN(n))throw TypeError("n must be a positive number");this._maxListeners=n;return this};EventEmitter.prototype.emit=function(type){var er,handler,len,args,i,listeners;if(!this._events)this._events={};if(type==="error"){if(!this._events.error||isObject(this._events.error)&&!this._events.error.length){er=arguments[1];if(er instanceof Error){throw er}else{var err=new Error('Uncaught, unspecified "error" event. ('+er+")");err.context=er;throw err}}}handler=this._events[type];if(isUndefined(handler))return false;if(isFunction(handler)){switch(arguments.length){case 1:handler.call(this);break;case 2:handler.call(this,arguments[1]);break;case 3:handler.call(this,arguments[1],arguments[2]);break;default:args=Array.prototype.slice.call(arguments,1);handler.apply(this,args)}}else if(isObject(handler)){args=Array.prototype.slice.call(arguments,1);listeners=handler.slice();len=listeners.length;for(i=0;i<len;i++)listeners[i].apply(this,args)}return true};EventEmitter.prototype.addListener=function(type,listener){var m;if(!isFunction(listener))throw TypeError("listener must be a function");if(!this._events)this._events={};if(this._events.newListener)this.emit("newListener",type,isFunction(listener.listener)?listener.listener:listener);if(!this._events[type])this._events[type]=listener;else if(isObject(this._events[type]))this._events[type].push(listener);else this._events[type]=[this._events[type],listener];if(isObject(this._events[type])&&!this._events[type].warned){if(!isUndefined(this._maxListeners)){m=this._maxListeners}else{m=EventEmitter.defaultMaxListeners}if(m&&m>0&&this._events[type].length>m){this._events[type].warned=true;console.error("(node) warning: possible EventEmitter memory "+"leak detected. %d listeners added. "+"Use emitter.setMaxListeners() to increase limit.",this._events[type].length);if(typeof console.trace==="function"){console.trace()}}}return this};EventEmitter.prototype.on=EventEmitter.prototype.addListener;EventEmitter.prototype.once=function(type,listener){if(!isFunction(listener))throw TypeError("listener must be a function");var fired=false;function g(){this.removeListener(type,g);if(!fired){fired=true;listener.apply(this,arguments)}}g.listener=listener;this.on(type,g);return this};EventEmitter.prototype.removeListener=function(type,listener){var list,position,length,i;if(!isFunction(listener))throw TypeError("listener must be a function");if(!this._events||!this._events[type])return this;list=this._events[type];length=list.length;position=-1;if(list===listener||isFunction(list.listener)&&list.listener===listener){delete this._events[type];if(this._events.removeListener)this.emit("removeListener",type,listener)}else if(isObject(list)){for(i=length;i-- >0;){if(list[i]===listener||list[i].listener&&list[i].listener===listener){position=i;break}}if(position<0)return this;if(list.length===1){list.length=0;delete this._events[type]}else{list.splice(position,1)}if(this._events.removeListener)this.emit("removeListener",type,listener)}return this};EventEmitter.prototype.removeAllListeners=function(type){var key,listeners;if(!this._events)return this;if(!this._events.removeListener){if(arguments.length===0)this._events={};else if(this._events[type])delete this._events[type];return this}if(arguments.length===0){for(key in this._events){if(key==="removeListener")continue;this.removeAllListeners(key)}this.removeAllListeners("removeListener");this._events={};return this}listeners=this._events[type];if(isFunction(listeners)){this.removeListener(type,listeners)}else if(listeners){while(listeners.length)this.removeListener(type,listeners[listeners.length-1])}delete this._events[type];return this};EventEmitter.prototype.listeners=function(type){var ret;if(!this._events||!this._events[type])ret=[];else if(isFunction(this._events[type]))ret=[this._events[type]];else ret=this._events[type].slice();return ret};EventEmitter.prototype.listenerCount=function(type){if(this._events){var evlistener=this._events[type];if(isFunction(evlistener))return 1;else if(evlistener)return evlistener.length}return 0};EventEmitter.listenerCount=function(emitter,type){return emitter.listenerCount(type)};function isFunction(arg){return typeof arg==="function"}function isNumber(arg){return typeof arg==="number"}function isObject(arg){return typeof arg==="object"&&arg!==null}function isUndefined(arg){return arg===void 0}},{}],180:[function(require,module,exports){var process=module.exports={};var cachedSetTimeout;var cachedClearTimeout;function defaultSetTimout(){throw new Error("setTimeout has not been defined")}function defaultClearTimeout(){throw new Error("clearTimeout has not been defined")}(function(){try{if(typeof setTimeout==="function"){cachedSetTimeout=setTimeout}else{cachedSetTimeout=defaultSetTimout}}catch(e){cachedSetTimeout=defaultSetTimout}try{if(typeof clearTimeout==="function"){cachedClearTimeout=clearTimeout}else{cachedClearTimeout=defaultClearTimeout}}catch(e){cachedClearTimeout=defaultClearTimeout}})();function runTimeout(fun){if(cachedSetTimeout===setTimeout){return setTimeout(fun,0)}if((cachedSetTimeout===defaultSetTimout||!cachedSetTimeout)&&setTimeout){cachedSetTimeout=setTimeout;return setTimeout(fun,0)}try{return cachedSetTimeout(fun,0)}catch(e){try{return cachedSetTimeout.call(null,fun,0)}catch(e){return cachedSetTimeout.call(this,fun,0)}}}function runClearTimeout(marker){if(cachedClearTimeout===clearTimeout){return clearTimeout(marker)}if((cachedClearTimeout===defaultClearTimeout||!cachedClearTimeout)&&clearTimeout){cachedClearTimeout=clearTimeout;return clearTimeout(marker)}try{return cachedClearTimeout(marker)}catch(e){try{return cachedClearTimeout.call(null,marker)}catch(e){return cachedClearTimeout.call(this,marker)}}}var queue=[];var draining=false;var currentQueue;var queueIndex=-1;function cleanUpNextTick(){if(!draining||!currentQueue){return}draining=false;if(currentQueue.length){queue=currentQueue.concat(queue)}else{queueIndex=-1}if(queue.length){drainQueue()}}function drainQueue(){if(draining){return}var timeout=runTimeout(cleanUpNextTick);draining=true;var len=queue.length;while(len){currentQueue=queue;queue=[];while(++queueIndex<len){if(currentQueue){currentQueue[queueIndex].run()}}queueIndex=-1;len=queue.length}currentQueue=null;draining=false;runClearTimeout(timeout)}process.nextTick=function(fun){var args=new Array(arguments.length-1);if(arguments.length>1){for(var i=1;i<arguments.length;i++){args[i-1]=arguments[i]}}queue.push(new Item(fun,args));if(queue.length===1&&!draining){runTimeout(drainQueue)}};function Item(fun,array){this.fun=fun;this.array=array}Item.prototype.run=function(){this.fun.apply(null,this.array)};process.title="browser";process.browser=true;process.env={};process.argv=[];process.version="";process.versions={};function noop(){}process.on=noop;process.addListener=noop;process.once=noop;process.off=noop;process.removeListener=noop;process.removeAllListeners=noop;process.emit=noop;process.prependListener=noop;process.prependOnceListener=noop;process.listeners=function(name){return[]};process.binding=function(name){throw new Error("process.binding is not supported")};process.cwd=function(){return"/"};process.chdir=function(dir){throw new Error("process.chdir is not supported")};process.umask=function(){return 0}},{}],181:[function(require,module,exports){if(typeof Object.create==="function"){module.exports=function inherits(ctor,superCtor){ctor.super_=superCtor;ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:false,writable:true,configurable:true}})}}else{module.exports=function inherits(ctor,superCtor){ctor.super_=superCtor;var TempCtor=function(){};TempCtor.prototype=superCtor.prototype;ctor.prototype=new TempCtor;ctor.prototype.constructor=ctor}}},{}],182:[function(require,module,exports){module.exports=function isBuffer(arg){return arg&&typeof arg==="object"&&typeof arg.copy==="function"&&typeof arg.fill==="function"&&typeof arg.readUInt8==="function"}},{}],183:[function(require,module,exports){(function(process,global){var formatRegExp=/%[sdj%]/g;exports.format=function(f){if(!isString(f)){var objects=[];for(var i=0;i<arguments.length;i++){objects.push(inspect(arguments[i]))}return objects.join(" ")}var i=1;var args=arguments;var len=args.length;var str=String(f).replace(formatRegExp,function(x){if(x==="%%")return"%";if(i>=len)return x;switch(x){case"%s":return String(args[i++]);case"%d":return Number(args[i++]);case"%j":try{return JSON.stringify(args[i++])}catch(_){return"[Circular]"}default:return x}});for(var x=args[i];i<len;x=args[++i]){if(isNull(x)||!isObject(x)){str+=" "+x}else{str+=" "+inspect(x)}}return str};exports.deprecate=function(fn,msg){if(isUndefined(global.process)){return function(){return exports.deprecate(fn,msg).apply(this,arguments)}}if(process.noDeprecation===true){return fn}var warned=false;function deprecated(){if(!warned){if(process.throwDeprecation){throw new Error(msg)}else if(process.traceDeprecation){console.trace(msg)}else{console.error(msg)}warned=true}return fn.apply(this,arguments)}return deprecated};var debugs={};var debugEnviron;exports.debuglog=function(set){if(isUndefined(debugEnviron))debugEnviron=process.env.NODE_DEBUG||"";set=set.toUpperCase();if(!debugs[set]){if(new RegExp("\\b"+set+"\\b","i").test(debugEnviron)){var pid=process.pid;debugs[set]=function(){var msg=exports.format.apply(exports,arguments);console.error("%s %d: %s",set,pid,msg)}}else{debugs[set]=function(){}}}return debugs[set]};function inspect(obj,opts){var ctx={seen:[],stylize:stylizeNoColor};if(arguments.length>=3)ctx.depth=arguments[2];if(arguments.length>=4)ctx.colors=arguments[3];if(isBoolean(opts)){ctx.showHidden=opts}else if(opts){exports._extend(ctx,opts)}if(isUndefined(ctx.showHidden))ctx.showHidden=false;if(isUndefined(ctx.depth))ctx.depth=2;if(isUndefined(ctx.colors))ctx.colors=false;if(isUndefined(ctx.customInspect))ctx.customInspect=true;if(ctx.colors)ctx.stylize=stylizeWithColor;return formatValue(ctx,obj,ctx.depth)}exports.inspect=inspect;inspect.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[33,39]};inspect.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"};function stylizeWithColor(str,styleType){var style=inspect.styles[styleType];if(style){return"\x1b["+inspect.colors[style][0]+"m"+str+"\x1b["+inspect.colors[style][1]+"m"}else{return str}}function stylizeNoColor(str,styleType){return str}function arrayToHash(array){var hash={};array.forEach(function(val,idx){hash[val]=true});return hash}function formatValue(ctx,value,recurseTimes){if(ctx.customInspect&&value&&isFunction(value.inspect)&&value.inspect!==exports.inspect&&!(value.constructor&&value.constructor.prototype===value)){var ret=value.inspect(recurseTimes,ctx);if(!isString(ret)){ret=formatValue(ctx,ret,recurseTimes)}return ret}var primitive=formatPrimitive(ctx,value);if(primitive){return primitive}var keys=Object.keys(value);var visibleKeys=arrayToHash(keys);if(ctx.showHidden){keys=Object.getOwnPropertyNames(value)}if(isError(value)&&(keys.indexOf("message")>=0||keys.indexOf("description")>=0)){return formatError(value)}if(keys.length===0){if(isFunction(value)){var name=value.name?": "+value.name:"";return ctx.stylize("[Function"+name+"]","special")}if(isRegExp(value)){return ctx.stylize(RegExp.prototype.toString.call(value),"regexp")}if(isDate(value)){return ctx.stylize(Date.prototype.toString.call(value),"date")}if(isError(value)){return formatError(value)}}var base="",array=false,braces=["{","}"];if(isArray(value)){array=true;braces=["[","]"]}if(isFunction(value)){var n=value.name?": "+value.name:"";base=" [Function"+n+"]"}if(isRegExp(value)){base=" "+RegExp.prototype.toString.call(value)}if(isDate(value)){base=" "+Date.prototype.toUTCString.call(value)}if(isError(value)){base=" "+formatError(value)}if(keys.length===0&&(!array||value.length==0)){return braces[0]+base+braces[1]}if(recurseTimes<0){if(isRegExp(value)){return ctx.stylize(RegExp.prototype.toString.call(value),"regexp")}else{return ctx.stylize("[Object]","special")}}ctx.seen.push(value);var output;if(array){output=formatArray(ctx,value,recurseTimes,visibleKeys,keys)}else{output=keys.map(function(key){return formatProperty(ctx,value,recurseTimes,visibleKeys,key,array)})}ctx.seen.pop();return reduceToSingleString(output,base,braces)}function formatPrimitive(ctx,value){if(isUndefined(value))return ctx.stylize("undefined","undefined");if(isString(value)){var simple="'"+JSON.stringify(value).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return ctx.stylize(simple,"string")}if(isNumber(value))return ctx.stylize(""+value,"number");if(isBoolean(value))return ctx.stylize(""+value,"boolean");if(isNull(value))return ctx.stylize("null","null")}function formatError(value){return"["+Error.prototype.toString.call(value)+"]"}function formatArray(ctx,value,recurseTimes,visibleKeys,keys){var output=[];for(var i=0,l=value.length;i<l;++i){if(hasOwnProperty(value,String(i))){output.push(formatProperty(ctx,value,recurseTimes,visibleKeys,String(i),true))}else{output.push("")}}keys.forEach(function(key){if(!key.match(/^\d+$/)){output.push(formatProperty(ctx,value,recurseTimes,visibleKeys,key,true))}});return output}function formatProperty(ctx,value,recurseTimes,visibleKeys,key,array){var name,str,desc;desc=Object.getOwnPropertyDescriptor(value,key)||{value:value[key]};if(desc.get){if(desc.set){str=ctx.stylize("[Getter/Setter]","special")}else{str=ctx.stylize("[Getter]","special")}}else{if(desc.set){str=ctx.stylize("[Setter]","special")}}if(!hasOwnProperty(visibleKeys,key)){name="["+key+"]"}if(!str){if(ctx.seen.indexOf(desc.value)<0){if(isNull(recurseTimes)){str=formatValue(ctx,desc.value,null)}else{str=formatValue(ctx,desc.value,recurseTimes-1)}if(str.indexOf("\n")>-1){if(array){str=str.split("\n").map(function(line){return"  "+line}).join("\n").substr(2)}else{str="\n"+str.split("\n").map(function(line){return"   "+line}).join("\n")}}}else{str=ctx.stylize("[Circular]","special")}}if(isUndefined(name)){if(array&&key.match(/^\d+$/)){return str}name=JSON.stringify(""+key);if(name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)){name=name.substr(1,name.length-2);name=ctx.stylize(name,"name")}else{name=name.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'");name=ctx.stylize(name,"string")}}return name+": "+str}function reduceToSingleString(output,base,braces){var numLinesEst=0;var length=output.reduce(function(prev,cur){numLinesEst++;if(cur.indexOf("\n")>=0)numLinesEst++;return prev+cur.replace(/\u001b\[\d\d?m/g,"").length+1},0);if(length>60){return braces[0]+(base===""?"":base+"\n ")+" "+output.join(",\n  ")+" "+braces[1]}return braces[0]+base+" "+output.join(", ")+" "+braces[1]}function isArray(ar){return Array.isArray(ar)}exports.isArray=isArray;function isBoolean(arg){return typeof arg==="boolean"}exports.isBoolean=isBoolean;function isNull(arg){return arg===null}exports.isNull=isNull;function isNullOrUndefined(arg){return arg==null}exports.isNullOrUndefined=isNullOrUndefined;function isNumber(arg){return typeof arg==="number"}exports.isNumber=isNumber;function isString(arg){return typeof arg==="string"}exports.isString=isString;function isSymbol(arg){return typeof arg==="symbol"}exports.isSymbol=isSymbol;function isUndefined(arg){return arg===void 0}exports.isUndefined=isUndefined;function isRegExp(re){return isObject(re)&&objectToString(re)==="[object RegExp]"}exports.isRegExp=isRegExp;function isObject(arg){return typeof arg==="object"&&arg!==null}exports.isObject=isObject;function isDate(d){return isObject(d)&&objectToString(d)==="[object Date]"}exports.isDate=isDate;function isError(e){return isObject(e)&&(objectToString(e)==="[object Error]"||e instanceof Error)}exports.isError=isError;function isFunction(arg){return typeof arg==="function"}exports.isFunction=isFunction;function isPrimitive(arg){return arg===null||typeof arg==="boolean"||typeof arg==="number"||typeof arg==="string"||typeof arg==="symbol"||typeof arg==="undefined"}exports.isPrimitive=isPrimitive;exports.isBuffer=require("./support/isBuffer");function objectToString(o){return Object.prototype.toString.call(o)}function pad(n){return n<10?"0"+n.toString(10):n.toString(10)}var months=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];function timestamp(){var d=new Date;var time=[pad(d.getHours()),pad(d.getMinutes()),pad(d.getSeconds())].join(":");return[d.getDate(),months[d.getMonth()],time].join(" ")}exports.log=function(){console.log("%s - %s",timestamp(),exports.format.apply(exports,arguments))};exports.inherits=require("inherits");exports._extend=function(origin,add){if(!add||!isObject(add))return origin;var keys=Object.keys(add);var i=keys.length;while(i--){origin[keys[i]]=add[keys[i]]}return origin};function hasOwnProperty(obj,prop){return Object.prototype.hasOwnProperty.call(obj,prop)}}).call(this,require("_process"),typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{"./support/isBuffer":182,_process:180,inherits:181}],184:[function(require,module,exports){module.exports={name:"twilio-video",title:"Twilio Video",description:"Twilio Video JavaScript library",version:"1.20.1",homepage:"https://twilio.com",author:"Mark Andrus Roberts <mroberts@twilio.com>",contributors:["Ryan Rowland <rrowland@twilio.com>","Manjesh Malavalli <mmalavalli@twilio.com>","Makarand Patwardhan <mpatwardhan@twilio.com>"],keywords:["twilio","webrtc","library","javascript","video","rooms"],repository:{type:"git",url:"https://github.com/twilio/twilio-video.js.git"},devDependencies:{"@types/express":"^4.11.0","@types/node":"^8.5.1","@types/selenium-webdriver":"^3.0.8","@types/ws":"^3.2.1","babel-cli":"^6.26.0","babel-preset-es2015":"^6.24.1",browserify:"^14.3.0",cheerio:"^0.22.0",chromedriver:"2.28.0",electron:"^5.0.1",envify:"^4.0.0",eslint:"^4.9.0",express:"^4.16.2",geckodriver:"1.4.0","ink-docstrap":"^1.3.2",inquirer:"^7.0.0","is-docker":"^2.0.0",istanbul:"^0.4.5",jsdoc:"^3.5.5","json-loader":"^0.5.7",karma:"^1.6.0","karma-browserify":"^5.1.1","karma-chrome-launcher":"^2.0.0","karma-electron":"^6.1.0","karma-firefox-launcher":"^1.0.1","karma-htmlfile-reporter":"^0.3.8","karma-junit-reporter":"^1.2.0","karma-mocha":"^1.3.0","karma-safari-launcher":"^1.0.0","karma-spec-reporter":"0.0.32",mocha:"^3.2.0","npm-run-all":"^4.0.2",puppeteer:"^1.12.2","release-tool":"^0.2.2",requirejs:"^2.3.3",rimraf:"^2.6.1","selenium-webdriver":"3.3.0","simple-git":"^1.126.0",sinon:"^4.0.1","travis-multirunner":"^4.0.0","ts-node":"4.0.1",tslint:"5.8.0",twilio:"^2.11.1",typescript:"2.6.2","uglify-js":"^2.8.22","vinyl-fs":"^2.4.4","vinyl-source-stream":"^1.1.0",watchify:"^3.11.1","webrtc-adapter":"^4.1.1"},engines:{node:">=0.12"},license:"BSD-3-Clause",main:"./es5/index.js",scripts:{lint:"eslint ./lib ./test/*.js ./test/framework/*.js ./test/lib/*.js ./test/integration/** ./test/unit/**","test:unit":"mocha ./test/unit/index.js","test:integration:adapter":"node ./scripts/karma.js karma/integration.adapter.conf.js","test:integration:travis":"node ./scripts/integration.js","test:integration":"node ./scripts/karma.js karma/integration.conf.js","test:umd":"mocha ./test/umd/index.js","test:crossbrowser:build:clean":"rimraf ./test/crossbrowser/lib ./test/crossbrowser/src/browser/index.js","test:crossbrowser:build:lint":"cd ./test/crossbrowser && tslint --project tsconfig.json","test:crossbrowser:build:tsc":"cd ./test/crossbrowser && tsc","test:crossbrowser:build:browser":"cd ./test/crossbrowser && browserify lib/crossbrowser/src/browser/index.js > src/browser/index.js","test:crossbrowser:build":"npm-run-all test:crossbrowser:build:*","test:crossbrowser:test":"cd ./test/crossbrowser && mocha --compilers ts:ts-node/register test/integration/spec/**/*.ts","test:crossbrowser":"npm-run-all test:crossbrowser:*","test:sdkdriver:build:clean":"rimraf ./test/lib/sdkdriver/lib ./test/lib/sdkdriver/test/integration/browser/index.js","test:sdkdriver:build:lint":"cd ./test/lib/sdkdriver && tslint --project tsconfig.json","test:sdkdriver:build:tsc":"cd ./test/lib/sdkdriver && tsc --rootDir src","test:sdkdriver:build":"npm-run-all test:sdkdriver:build:*","test:sdkdriver:test:unit":"cd ./test/lib/sdkdriver && mocha --compilers ts:ts-node/register test/unit/spec/**/*.ts","test:sdkdriver:test:integration:browser":"cd ./test/lib/sdkdriver/test/integration && browserify browser/browser.js > browser/index.js","test:sdkdriver:test:integration:run":"cd ./test/lib/sdkdriver && mocha --compilers ts:ts-node/register test/integration/spec/**/*.ts","test:sdkdriver:test:integration":"npm-run-all test:sdkdriver:test:integration:*","test:sdkdriver:test":"npm-run-all test:sdkdriver:test:*","test:sdkdriver":"npm-run-all test:sdkdriver:*","test:framework:angular:install":"cd ./test/framework/twilio-video-angular && rimraf ./node_modules package-lock.json && npm install","test:framework:angular:run":"mocha ./test/framework/twilio-video-angular.js","test:framework:angular":"npm-run-all test:framework:angular:*","test:framework:no-framework:run":"mocha ./test/framework/twilio-video-no-framework.js","test:framework:no-framework":"npm-run-all test:framework:no-framework:*","test:framework:react:install":"cd ./test/framework/twilio-video-react && rimraf ./node_modules package-lock.json && npm install","test:framework:react:test":"node ./scripts/framework.js twilio-video-react","test:framework:react:build":"cd ./test/framework/twilio-video-react && npm run build","test:framework:react:run":"mocha ./test/framework/twilio-video-react.js","test:framework:react":"npm-run-all test:framework:react:*","test:framework":"npm-run-all test:framework:angular test:framework:no-framework test:framework:react",test:"npm-run-all test:unit test:integration","build:es5":"rimraf ./es5 && babel lib -d es5","build:js":"node ./scripts/build.js ./src/twilio-video.js ./LICENSE.md ./dist/twilio-video.js","build:min.js":'uglifyjs ./dist/twilio-video.js -o ./dist/twilio-video.min.js --comments "/^! twilio-video.js/" -b beautify=false,ascii_only=true',build:"npm-run-all clean lint docs cover test:integration build:es5 build:js build:min.js test:umd","build:travis":"npm-run-all clean lint docs cover test:integration:travis build:es5 build:js build:min.js test:umd test:framework","build:quick":"npm-run-all clean lint docs build:es5 build:js build:min.js",docs:"node ./scripts/docs.js ./dist/docs",clean:"rimraf ./coverage ./es5 ./dist",cover:"istanbul cover node_modules/mocha/bin/_mocha -- ./test/unit/index.js"},dependencies:{"@twilio/sip.js":"^0.7.7","@twilio/webrtc":"2.4.0",ws:"^3.3.1",xmlhttprequest:"^1.8.0"},browser:{ws:"./src/ws.js",xmlhttprequest:"./src/xmlhttprequest.js"}}},{}],185:[function(require,module,exports){module.exports=WebSocket},{}],186:[function(require,module,exports){exports.XMLHttpRequest=XMLHttpRequest},{}]},{},[13]);var Video=bundle(13);if(typeof define==="function"&&define.amd){define([],function(){return Video})}else{var Twilio=root.Twilio=root.Twilio||{};Twilio.Video=Twilio.Video||Video}})(typeof window!=="undefined"?window:typeof global!=="undefined"?global:this);